package PVS.polyhedra.stellation;
/**
TO-DO 
- edges at 3D view - really difficult 
- Mathematica style ligthting - done
- possibility to save and restore particular cells combinations - done
- special marking for intresting points and lines on diagramm. - done
- possibility to select all cells beneath current to make it "fully supported" - done
- printing to Windows printer 
- saving to image file (?)
- export to POV and VRML. done 
- color highlighting of cells - done
*/

import java.io.*;
import java.util.Vector;
import java.util.Hashtable;
import java.awt.*;
import java.awt.event.*;
import java.net.URL;
import java.applet.*;

import PVS.polyhedra.Stellation;
import PVS.polyhedra.Polyhedron;
import PVS.polyhedra.Vector3D;
import PVS.polyhedra.SSCell;
import PVS.polyhedra.SFace;
import PVS.polyhedra.StellationCanvas;
import PVS.polyhedra.Plane;
import PVS.polyhedra.Symmetry;

import PVS.Utils.WindowOutputStream;
import PVS.Utils.PVSObserver;
import PVS.Utils.WindowUtils;
import PVS.Utils.BorderPanel;
import PVS.Utils.LabelBitmap;
import PVS.Utils.QSort;
import PVS.Utils.Comparator;
import PVS.Utils.Fmt;
import PVS.Utils.Arrays;
import PVS.Expression.VectorCalculator;

import PVS.g3d.Model3D;
import PVS.g3d.Canvas3D;

public class Main implements Runnable , PVSObserver, ActionListener{

  int currentCategory = 0;
  int currentPoly = 3;
  String polySymmetry = "Ih";
  String stellationSymmetry = "I";

  boolean usingPlanes = false;

  Stellation stellation = null;      
  Polyhedron polyhedron;
  Vector3D polyhedronPlanes[];
  Vector3D canonicalPlanes[];
  String polyhedronName;
  Vector allcells = null; // current Stellation cells 
  Vector subcells = null; // current Stellation subcells 
  SSCell[] currentCells; // currently selected cells 
  int [][] cellsIndex;   // indices of currently selected cells

  String outType = "none"; // what format to write Vrml2, POV, OFF
  String fname = null; // file with polyhedron
  String vname = null; // file with vectors
  String prefix = "s";
  boolean hasOutput = false;
  boolean printToWindow = false;
  boolean bShowDiagram = false;
  boolean bMakeCells = false, bShowCells = false;
  boolean doVrmlWriteScene = false;

  int maxIntersection = -1; // limit of intersections 
  int maxLayer = 1000; // limit number of layers
  int vertexUp = 0;
  int faceToShow = 0;
  int nFaces = 0;

  boolean bWriteCells = false, bWriteLayers = false;
  
  static PrintStream Out = System.out;
  
  
  static String MakeStellation = "Start";
  Button btnStart = new Button(MakeStellation);
  Button btnTest = new Button("test");
  Button btnTest1 = new Button("test1");
  //Button buttonQuit = new Button("Quit");    
  //Button buttonExport = new Button("Export...");
  //Button buttonLoad = new Button("Load...");

  // Menu File  
  MenuItem miSaveAsPOV =  new MenuItem("Povray");
  MenuItem miSaveAsVRML = new MenuItem("VRML");
  MenuItem miSaveAsDXF = new MenuItem("DXF");
  MenuItem miMakePlanes = new MenuItem("Make Planes");
  MenuItem miUndo = new MenuItem("Undo");
  MenuItem miClearAll = new MenuItem("Clear All");
  MenuItem miPrefereces = new MenuItem("Preferences");
  MenuItem miPrint3DModel = new MenuItem("Print 3D Model");
  MenuItem miVectorCalculator = new MenuItem("Vector Calculator");

  MenuItem miPrintDiagram = new MenuItem("Print Diagram");
  MenuItem miSelectPolyhedron = new MenuItem("Select Polyhedron");  

  boolean viewCells = true, viewOutput = true, viewDiagram = true, view3D = true;

  CheckboxMenuItem miViewOutput = new CheckboxMenuItem("Output",viewOutput);
  CheckboxMenuItem miViewDiagram = new CheckboxMenuItem("Diagram", viewDiagram);
  CheckboxMenuItem miView3D = new CheckboxMenuItem("3D", view3D);
  CheckboxMenuItem miViewCells = new CheckboxMenuItem("Cells", viewCells);

  Button btnSelectPoly = new Button("Select...");


  MenuItem miConnectivityGraph = new MenuItem("Print Connectivity Graph");
  MenuItem miQuit = new MenuItem("Quit");

  Label polyName = new Label();

  Label polyInfoFaces = new Label();
  Label polyInfoVertices = new Label();
  Label polyInfoSymmetry = new Label();

  Image icon; 

  Choice choice_symmetry = new Choice();
  Choice choice_face = new Choice();
  TextField tfPolyName = new TextField(20);
  //Choice choice_category = new Choice();
  //Choice choice_poly = new Choice();
  Choice choice_vertexUp = new Choice();
  TextField tfMaxLayer = new TextField(5);

  StellationCanvas diagram = null;
  Frame frameDiagram = null;

  SelectionPanel selection = null;
  Frame frameSelection = null;

  Canvas3D canvas3D = null;
  Frame frame3D = null;
  Model3D model3D = null;

  Frame frameOutput;
  WindowOutputStream winStream;

  FrameClosingListener frameClosingListener = new FrameClosingListener();
  ViewListener viewListener = new ViewListener();

  LabelBitmap polyImage;
  
  Frame mainFrame;

  Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();

  Thread thread = null;

  // set of currently visible cells
  int[][] cellIndex = new int[0][0];

  static String symnames[] = DlgPlanes.symnames;//new String[] {"T","Th","Td","I","Ih","O","Oh"};
  PolyNames polyNames = new PolyNames();

  Applet applet;
  /**

    Main 

   */
  public Main( String fname, String stellationSymmetry, Applet applet){

    this.fname = fname;    
    this.stellationSymmetry = stellationSymmetry;
    this.applet = applet;

    mainFrame = new Frame("stellation");
    Toolkit toolkit = Toolkit.getDefaultToolkit();
    try {
      icon = loadImageFromJar("/images/stellation_main.jpg");//toolkit.getImage(getClass().getResource(""));
    } catch(Exception e){
    }
    if(icon != null)
      mainFrame.setIconImage(icon);

    mainFrame.addWindowListener(new WindowListenerClass());
    initUI();
    mainFrame.pack();
    String jvendor = System.getProperty("java.vendor");
    String jversion = System.getProperty("java.version");
    System.err.println("java vendor: " + jvendor);
    System.err.println("java version: " + jversion);
    if(jvendor.indexOf("Microsoft") != -1){
      Dimension size = mainFrame.getPreferredSize();
      mainFrame.setBounds(0,0,size.width, size.height + 20);
      mainFrame.validate();
    }

    mainFrame.show();
    
    thread = new Thread(this);
    thread.setPriority(Thread.MIN_PRIORITY); 
    thread.start();
    
  }

  /**
    initUI

   */
  void initUI(){

    //Font font = new Font("Courier", Font.PLAIN, 14);
    mainFrame.setFont(new Font("Helvetica",Font.PLAIN,12));    
    mainFrame.setBackground(Color.lightGray);

    GridBagLayout gridbag = new GridBagLayout();

    mainFrame.setLayout(gridbag);

    //buttonLoad.addActionListener(this);
    btnStart.addActionListener(this);
    btnTest.addActionListener(this);
    btnTest1.addActionListener(this);
    //stopButton.addActionListener(this);
    //buttonExport.addActionListener(this);
    //buttonQuit.addActionListener(this);

    polyImage = new LabelBitmap(80,80);

    
    Font sfont = new Font("Serif",Font.BOLD,16);
    choice_symmetry.setFont(sfont);
    choice_face.setFont(sfont);
    choice_vertexUp.setFont(sfont);

    for(int i = 0; i < 10; i++){
      choice_face.addItem(Integer.toString(i,10));
      choice_vertexUp.addItem(Integer.toString(i,10));
    }

    choice_face.addItemListener(new FaceListener());
    choice_vertexUp.addItemListener(new VertexListener());

    /*
    String cat[] = polyNames.getCategories();
    for(int i = 0; i < cat.length; i++){
      choice_category.addItem(cat[i]);
    }
    choice_category.addItemListener(new CategoryListener());    

    for(int i = 0; i < polyNames.length(); i++){
      choice_poly.addItem(polyNames.name(i));
    }
    choice_poly.select(3);// this is icosahedron 
    choice_poly.addItemListener(new PolyListener());
    */
    btnSelectPoly.addActionListener(new SelectPolyhedron());

    updatePolyImage();

    choice_symmetry.addItemListener(new SymmetryListener());
    choice_symmetry.select(getSymmetryIndex(stellationSymmetry));

    Panel polyInfo = new   Panel();polyInfo.setLayout(gridbag);
    Panel polyInfo_1 = new BorderPanel();//polyInfo_1.setLayout(gridbag);
    Panel polyInfo_2 = new BorderPanel();polyInfo_2.setLayout(gridbag);

    //WindowUtils.constrain(polyInfo_1,polyImage,        0,0,1,1, gbc.NONE, gbc.CENTER,0.,0.,5,5,5,5);
    polyInfo_1.add("Center", polyImage);
    int c = 0;
    WindowUtils.constrain(polyInfo_2,polyInfoFaces,    1,c++,1,1, gbc.HORIZONTAL, gbc.CENTER,1.,0.);
    WindowUtils.constrain(polyInfo_2,polyInfoVertices, 1,c++,1,1, gbc.HORIZONTAL, gbc.CENTER,1.,0.);
    WindowUtils.constrain(polyInfo_2,polyInfoSymmetry, 1,c++,1,1, gbc.HORIZONTAL, gbc.CENTER,1.,0.);
    WindowUtils.constrain(polyInfo_2,btnSelectPoly,    1,c++,1,1, gbc.NONE, gbc.WEST,0.,0.);
    WindowUtils.constrain(polyInfo,polyInfo_1,0,0,1,1,gbc.BOTH, gbc.CENTER,0.,0.,0,0,2,2);
    WindowUtils.constrain(polyInfo,polyInfo_2,1,0,1,1,gbc.BOTH, gbc.CENTER,1.,0.,0,0,0,2);

    Panel buttons = new Panel();
    buttons.setLayout(new GridLayout(1,2,5,5));
    buttons.add(btnStart);
    //buttons.add(btnTest);
    //buttons.add(btnTest1);
    //buttons.add(stopButton);

    Panel panelMI = new Panel();
    panelMI.setLayout(gridbag);


    Panel panel_1 = new BorderPanel(); panel_1.setLayout(gridbag);
    Panel panel_2 = new BorderPanel(); panel_2.setLayout(gridbag);

    int count = 0;
    //WindowUtils.constrain(panel_1,new Label("Polyhedron"),    0,count++,1,1, gbc.HORIZONTAL, gbc.CENTER,1.,0.);
    //WindowUtils.constrain(panel_1,choice_poly,    0,count++,1,1, gbc.HORIZONTAL, gbc.CENTER,1.,0.,0,0,0,0);
    WindowUtils.constrain(panel_1,tfPolyName,    0,0,1,1, gbc.HORIZONTAL, gbc.CENTER,1.,0.,0,0,0,0);
    //WindowUtils.constrain(panel_1,btnSelectPoly,    0,1,1,1, gbc.NONE, gbc.WEST,0.,0.,0,5,0,0);


    //WindowUtils.constrain(panel_2,new Label("Stellation"),  0,0,2,1, gbc.NONE, gbc.CENTER,1.,0.);
    //WindowUtils.constrain(panel_2,new Label("Max Layers:",Label.RIGHT), 
    //                                                        0,1,1,1, gbc.HORIZONTAL, gbc.EAST,1.,0.,0,2,0,0);
    //WindowUtils.constrain(panel_2,tfMaxLayer,               1,1,1,1, gbc.HORIZONTAL, gbc.EAST,0.5,0.,0,2,0,0);    
    WindowUtils.constrain(panel_2,new Label("Symmetry ",Label.CENTER),  
                                                            0,1,1,1, gbc.HORIZONTAL, gbc.EAST,1.,0.,0,2,0,0);
    WindowUtils.constrain(panel_2,choice_symmetry,          0,2,1,1, gbc.HORIZONTAL, gbc.NORTH,1.,1.,0,2,0,0);
    WindowUtils.constrain(panel_2,new Label("Face ",Label.CENTER), 
			                                    1,1,1,1, gbc.HORIZONTAL, gbc.EAST,0.5,0.,0,2,0,0);
    WindowUtils.constrain(panel_2,choice_face,              1,2,1,1, gbc.HORIZONTAL, gbc.NORTH,0.5,1.,0,2,0,0);

    WindowUtils.constrain(panel_2,new Label("Vertex Up",Label.CENTER), 
			                                    2,1,1,1, gbc.HORIZONTAL, gbc.EAST,0.5,0.,0,2,0,0);
    WindowUtils.constrain(panel_2,choice_vertexUp,              2,2,1,1, gbc.HORIZONTAL, gbc.NORTH,0.5,1.,0,2,0,0);

    c = 0;
    WindowUtils.constrain(mainFrame, polyInfo, 0,c++,1,1, gbc.HORIZONTAL, gbc.NORTH,1.,0.);
    WindowUtils.constrain(mainFrame, panel_1, 0,c++,1,1, gbc.HORIZONTAL, gbc.CENTER,1.,0.);
    WindowUtils.constrain(mainFrame, panel_2, 0,c++,1,1, gbc.BOTH, gbc.CENTER,1.,1.);
    WindowUtils.constrain(mainFrame, buttons, 0,c++,1,1, gbc.NONE, gbc.CENTER,0.,1.,5,5,5,5);

    mainFrame.setMenuBar(makeMenuBar());

    createSelectionFrame();
    createOutputStream();    


    //createMenu();

  }

  void initSymChoice(){

    choice_symmetry.removeAll();
    symnames = Symmetry.getSubgroups(polySymmetry);
    for(int i = 0; i < symnames.length; i++){
      choice_symmetry.addItem(symnames[i]);
    }
  }

  MenuBar makeMenuBar(){
    MenuBar mb = new MenuBar();

    Menu mExport = new Menu("Export");
    mExport.add(miSaveAsVRML);    
    mExport.add(miSaveAsPOV);
    mExport.add(miSaveAsDXF);

    Menu mFile = new Menu("File");        
    mFile.add(mExport);
    //mFile.add(miPreferences);
    mFile.addSeparator();

    mFile.add(miMakePlanes);
    mFile.add(miConnectivityGraph);
    mFile.addSeparator();
    mFile.add(miSelectPolyhedron);
    mFile.add(miPrintDiagram);
    mFile.add(miPrint3DModel);
    mFile.addSeparator();
    mFile.add(miVectorCalculator);

    mFile.addSeparator();
    mFile.add(miQuit);
    
    miSaveAsVRML.addActionListener(this);
    miSaveAsPOV.addActionListener(this);
    miSaveAsDXF.addActionListener(this);
    miMakePlanes.addActionListener(this);
    //miPreferences.addActionListener(this);
    miConnectivityGraph.addActionListener(this);
    miQuit.addActionListener(this);
    miPrintDiagram.addActionListener(new PrintDiagram());
    miPrint3DModel.addActionListener(new Print3DModel());
    miVectorCalculator.addActionListener(new onVectorCalculator());
    miSelectPolyhedron.addActionListener(new SelectPolyhedron());

    Menu mEdit = new Menu("Edit");
    mEdit.add(miUndo);
    mEdit.add(miClearAll);
    miUndo.addActionListener(this);
    miClearAll.addActionListener(this);


    Menu mView = new Menu("View");

    mView.add(miViewDiagram);
    mView.add(miView3D);
    mView.add(miViewCells);
    mView.add(miViewOutput);

    miViewDiagram.addItemListener(viewListener);
    miView3D.addItemListener(viewListener);
    miViewCells.addItemListener(viewListener);
    miViewOutput.addItemListener(viewListener);
        
    mb.add(mFile);
    mb.add(mEdit);
    mb.add(mView);

    return mb;
  }



  /**
     
   */
  void createOutputStream(){

    winStream = new WindowOutputStream();
    Out = new PrintStream(winStream);
    frameOutput = winStream.getFrame();
    frameOutput.setVisible(viewOutput);
    frameOutput.addWindowListener(frameClosingListener);
    frameOutput.setLocation(0,screen.height/2);
    frameOutput.setSize(screen.width - screen.height/2,screen.height/2-30);
    frameOutput.validate();
    frameOutput.setTitle("output");
    if(icon != null)
      frameOutput.setIconImage(icon);

    Polyhedron.Out = Stellation.Out = Out;
    try {
      System.setOut(Out);
      System.setErr(Out);
    } catch (Exception e){
      System.out.println("failed call System.setOut()");
    }

  }

  /**
     create selection canvas 
   */
  void createSelectionFrame(){

    selection = new SelectionPanel(this);
    frameSelection = new Frame("Cells");
    frameSelection.addWindowListener(frameClosingListener);
    frameSelection.setBackground(Color.white);
    frameSelection.setLayout(new GridLayout(1,1));
    frameSelection.add(selection);
    frameSelection.setBounds(screen.width - screen.height,
			0,screen.height/2,screen.height/2);
    frameSelection.validate();
    frameSelection.show();
    if(icon != null)
      frameSelection.setIconImage(icon);
    
  }

  /**
    update PVSObserver's interface 
    
     callback function to inform, that something happens in cells or diagram panels 
   */
  public void update(Object who, Object what){

    if(who == selection) { // cell was selected in cells frame

      cellsIndex = (int [][]) what;
      showDiagram(cellsIndex);

    } else if (who == canvas3D){ // cell was selected from 3D model

     
      Object obj[] = (Object[])what;
      double center[] = (double[])obj[0];
      int options = ((Integer) obj[1]).intValue();
      double normal[] =  (double[])obj[2];
      //System.out.println("center: " + center[0]+ ","+center[1]+ ","+center[2]+ ", opt: " + options);
      if((options & InputEvent.CTRL_MASK) == 0 && 
	 (options & InputEvent.SHIFT_MASK) == 0 &&
	 (options & InputEvent.ALT_MASK) == 0
	 ){ // it was simple click 
	Out.println("normal: " + chop(normal[0]) + "," + chop(normal[1]) + "," + chop(normal[2]));
	return;
      }
      boolean addCell = true;
      if((options & InputEvent.CTRL_MASK) != 0){
	 addCell = true;
      }
      if((options & InputEvent.SHIFT_MASK) != 0){
	 addCell = false;
      }
      int[] cindex = stellation.findCell(currentCells, new Vector3D(center), addCell); 

      if(cindex != null){	

	int[][] cellsIndex = selection.modifySelection(cindex, StellationCanvas.TOGGLE_TOP_CELL);
	showDiagram(cellsIndex);
	selection.initCellField();

      }

    } else {

      // face was selected from diagramm ??

      // face[0] will contain facet being clicked
      // face[1] contais combination InputEvent.CTRL_MASK InputEvent.ALT_MASK InputEvent.SHIFT_MASK 
      int [] face = (int [])what;
      int action = face[1];
      int[] cindex = null;
      //System.out.println(face[0] + " " + face[1]);

      switch (action){

      case StellationCanvas.TOGGLE_BOTTOM_CELL:
      case StellationCanvas.TOGGLE_SUPPORTING_CELLS:
      case StellationCanvas.ADD_SUPPORTING_CELLS:
      case StellationCanvas.SUB_SUPPORTING_CELLS:
	// 1 if we want it to be top face
	cindex = stellation.findCell(subcells, faceToShow, face[0], 1);	
	break;
      case StellationCanvas.TOGGLE_TOP_CELL:
	// 0 if we want it to be bottom face
	cindex = stellation.findCell(subcells, faceToShow, face[0], 0);		
	break;
      }
      
      if(cindex != null){
	
	int[][] cellsIndex = selection.modifySelection(cindex, action);
	showDiagram(cellsIndex);

	/*
	cellsIndex = makeNewCellIndex(cindex);
	selection.setSelection(cellsIndex);
	showDiagram(cellsIndex);
	*/
	selection.initCellField();
      }
    }
  }
  
  /**
    makeNewCellIndex
    
    */
  int[][] makeNewCellIndex(int[] cindex){

    for(int i = 0; i <  cellIndex.length; i++){
      if((cellIndex[i][0] == cindex[0]) && 
	 (cellIndex[i][1] == cindex[1])){
	// remove given cell from array
	int[][] nindex = new int[cellIndex.length - 1][];
	for(int k = 0; k < i; k++){
	  nindex[k] = cellIndex[k];
	}
	for(int k = i; k < cellIndex.length-1; k++){
	  nindex[k] = cellIndex[k+1];
	}
	return nindex;
      }
    }
    
    // add new cell to array    
    int[][] nindex = new int[cellIndex.length+1][];
    for(int k = 0; k < cellIndex.length; k++){
      nindex[k] = cellIndex[k];
    }
    nindex[cellIndex.length] = cindex;
    return nindex;
  }

  /**
    run

   */
  public void run(){

    btnStart.setLabel("Stop");
    
    winStream.clear();

    
    Out.println("stellationSymmetry: " + stellationSymmetry);
    int mi = 0;
    try {
      mi = Integer.valueOf(tfMaxLayer.getText()).intValue();
    } catch (Exception e){
    }
    if(mi > 0){
      maxLayer = mi;
    }
    //readFile(fname);
    //Out.println();
    
    if(usingPlanes) {
      stellation = new Stellation(canonicalPlanes,polySymmetry,maxIntersection);
      nFaces = stellation.faces.length;
      //stellation = new Stellation(polyhedronPlanes,maxIntersection);
      //nFaces = polyhedronPlanes.length;
    } else if(polyhedron != null){
      stellation = new Stellation(canonicalPlanes,polySymmetry,maxIntersection);
      nFaces = stellation.faces.length;
      /*
      stellation = new Stellation(polyhedron,maxIntersection);
      nFaces = polyhedron.ifaces.length;
      */
    }

    allcells = stellation.makeCells2( polySymmetry, stellationSymmetry, maxLayer);

    initSubcells();

    btnStart.setLabel(MakeStellation);
  }

  public void doTest(){

    stellation = new Stellation(canonicalPlanes,polySymmetry,maxIntersection);
    nFaces = stellation.faces.length;
    allcells = stellation.makeCells2( polySymmetry, stellationSymmetry, maxLayer);

    initSubcells();

  }

  public void doTest1(){

    for(int l = 0; l < allcells.size(); l++){    
      Out.print(Fmt.fmt(l,2));
      Out.print(":");
      Vector layer = (Vector)allcells.elementAt(l);
      
      SSCell array[] = new SSCell[layer.size()];
      layer.copyInto(array);
      Arrays.sort(array, 0,array.length, (Comparator)array[0]);
      
      //QSort.quickSort(layer,0,layer.size()-1,(SSCell)layer.elementAt(0));
      //for(int i=0; i < layer.size(); i++){    
      for(int i=0; i < array.length; i++){
	
	//SSCell scell = (SSCell)layer.elementAt(i);
	SSCell scell = array[i];
	Out.print(scell.cells.length + ".");
	Out.print(scell.getNFacets() + ".");
	Out.print(scell.getNVertices() + " ");
      }
      Out.println();
    }
  }


  void createSubcells(Vector cells, String symmetry){
    
    for(int l = 0; l < cells.size(); l++){
      Vector layer = (Vector)cells.elementAt(l);
      for(int c = 0; c < layer.size(); c++){
	SSCell cell = (SSCell)layer.elementAt(c);
	cell.setSubCells(Stellation.makeSymmetricalSubCells(cell, symmetry));	
      }
    }    
  }

  void initSubcells(){

    subcells = makeSubcells(allcells);
    stellation.makeConnectivityGraph(subcells);
    /*
    int[] layers = new int[allcells.size()];
    for(int i =0; i < allcells.size(); i++){
      layers[i] = ((Vector)allcells.elementAt(i)).size();
    }
    */
    selection.setArray(allcells, subcells);

    showDiagram(new int[0][0]);
    diagram.init();

    choice_face.removeAll();
    if(stellation.getFaces().length > 0) {
      Integer [] findex = stellation.getNonEquivalentFaces(stellationSymmetry);
      if(findex.length > 1){
	for(int i = 0; i < findex.length; i++){
	  choice_face.addItem(findex[i].toString());
	}
	choice_face.setEnabled(true);
      } else {
	choice_face.setEnabled(false);
      }
    }
  }

  /**
    createMenu
    
    */
  void createMenu(){

    MenuBar menubar = new MenuBar();
    
    Menu file = new Menu("File", true);
    file.add("Load...");
    file.add("Quit");
    
    Menu help = new Menu("Help", true);
    help.add("About...");
    
    menubar.add(file);
    menubar.add(help);
    
    //setMenuBar(menubar);

  }

  /**
    doLoad 

    load new file dialog
   */
  FileDialog file_load_dialog;

  void doLoad(){

    if(file_load_dialog == null){
      file_load_dialog = new FileDialog(WindowUtils.getMainWindow(mainFrame), 
                                        "Load polyhedron", FileDialog.LOAD);
    }

    file_load_dialog.pack();
    file_load_dialog.show(); 
    
    String name = file_load_dialog.getFile();
    String path = file_load_dialog.getDirectory();
    
    if(name != null && path != null){  // user had selected something
      fname = path + name;
      doStart();
    }
  }

  /**
    printHelp 

   */
  static void printHelp(PrintStream out){
    
  }

  /**
     Polyhedron readOffFile(String fname)
   */
  Polyhedron readOffFile(String fname){
    
    Polyhedron poly = new Polyhedron();
    try {
      //Class cl = getClass();
      //ClassLoader cll = cl.getClassLoader();
      //System.out.println("CLASS: " + cl + " LOADER: " + cll);     
      //URL url = getClass().getResource("/images/off/" + fname+".off");
      //System.out.println("URL: " + url);
      //InputStream f = url.openStream();

      //String fullname = "/images/off/" + fname+".off";
      String fullname = "/images/off/" + fname+".gif";
      InputStream f = null;
      try {
	f = getClass().getResourceAsStream(fullname);
      } catch (Exception e){
	System.out.println("getClass().getResourceAsStream("+ fullname +") failed");
      }
      try {
	if(f == null && applet != null){	  
	  InputStream ff = getClass().getResourceAsStream("/images/poly/"+fname+"_tmb.gif");
	  if(ff != null){
	    //System.out.println("/images/poly/"+fname+"_tmb.gif opened");
	  }
	  fullname = "images/off/" + fname+".off";
	  URL url = new URL(applet.getDocumentBase(), fullname);
	  System.out.println("opening: " + url);
	  f = url.openStream();
	}
      } catch (Exception e){
	System.out.println("URL.openStream(" + fullname +") failed");	
      }
      if(f != null) {
	//System.out.println("resource: "+ fullname +" opened");
	poly.readOFF(f);
	poly.makeCCW();
	f.close();
      }
    } catch(Exception e){
      e.printStackTrace(System.out);
    }
    return poly;

  }


  /**
    readFile

   */
  void readFile(String fname){
    
    Polyhedron poly = new Polyhedron();
    if(fname.endsWith(".off")){
      try {
	FileInputStream f = new FileInputStream(fname);
	poly.readOFF(f);
	poly.makeCCW();
	f.close();
      } catch(Exception e){
	e.printStackTrace(Out);
	return;
      }        
      Out.println("read " + fname + " OK");Out.flush();    
      stellation = new Stellation(poly,maxIntersection);
      nFaces = poly.ifaces.length;
    } else {      
      Vector3D[] vectors = Stellation.readVectors(fname);
      nFaces = vectors.length;
      Out.println(fname+" read OK");Out.flush();
      stellation = new Stellation(vectors,maxIntersection);      
    }
  }
   
  /**
    showDiagram

   */
  void showDiagram(int [][] st){

    try {
      cellIndex = st;
      SSCell[] cells = stellation.getStellation(subcells,st);
      Object[][] facets = stellation.getStellationDiagram(cells, faceToShow);
      
      if(stellation.getFaces().length == 0){
        Out.println("Can't make stellation!");
        return; // something wrong
      }
      
      diagram = stellation.showStellationDiagram(facets,
                                                 Stellation.makeStellationName(st),
                                                 faceToShow, vertexUp, stellationSymmetry, diagram);
      if(frameDiagram == null){
        
        diagram.addObserver(this);    
        frameDiagram = diagram.getFrame();
        frameDiagram.addWindowListener(frameClosingListener);
        frameDiagram.setBounds(screen.width - screen.height/2,
                               screen.height/2,screen.height/2,screen.height/2-30);
        frameDiagram.validate();
        frameDiagram.setTitle("Diagram");
        if(icon != null)
          frameDiagram.setIconImage(icon);
      }
      showModel(cells);
    } catch(Exception e){
      e.printStackTrace();
    }
  }

  /**
     displays 
   */
  void showModel(SSCell[] cells){
    
    currentCells = cells;
    Polyhedron poly = stellation.getPolyhedron(cells);
    double[] vert = new double[poly.vertices.length*3];
    for(int i = 0, j =0; i < poly.vertices.length; i++){
      Vector3D v = poly.vertices[i]; 
      vert[j++] = v.x;
      vert[j++] = v.y;
      vert[j++] = v.z;
    }
    
    int[][] faces = new int[poly.ifaces.length][];
    for(int i = 0; i < faces.length; i++){
      faces[i] = new int[poly.ifaces[i].length];
      for(int j = 0; j < faces[i].length; j++){
	faces[i][j] = poly.ifaces[i][j]*3;  
      }
    }
    //int[][] edges = new int[poly.edges.length][2];
    int[][] edges = new int[0][2];
    for(int i = 0; i < edges.length; i++){
      edges[i][0] = poly.edges[i][0]*3;
      edges[i][1] = poly.edges[i][1]*3;
    }

    //Out.println("poly has edges: " + poly.edges.length);

//    VB!
    //Model3D model = new Model3D(vert,faces,edges,poly.colors,poly.icolor);
    model3D = new PVS.g3d.Stellation3D(vert,faces,edges,poly.colors,poly.icolor,
                                       stellationSymmetry, polyhedronPlanes);
//    end VB!

//    PB! added symmetry parameter
    //      Model3D model = new Model3D(vert,faces,edges,poly.colors,poly.icolor,stellationSymmetry);
//    end PB!
    if(canvas3D == null){
      frame3D = new Frame("3D view");
      frame3D.addWindowListener(frameClosingListener);
      frame3D.setBackground(Color.white);
      canvas3D = new Canvas3D(model3D);
      canvas3D.Out = Out;
      canvas3D.setObserver(this);
      frame3D.add("Center",canvas3D);
      //frame3D.validate();
      //frame3D.pack();
      frame3D.setBounds(screen.width - screen.height/2,
			0,screen.height/2,screen.height/2);
      frame3D.validate();
      frame3D.show();
      if(icon != null)
	frame3D.setIconImage(icon);
    } else {      
      canvas3D.setModel(model3D);
    }
    
  }


  public void doStop(){

    if(thread.isAlive()){
      thread.stop();
    }
    btnStart.setLabel(MakeStellation);

  }
        
  public void doStart(){

    thread = new Thread(this);
    thread.setPriority(Thread.MIN_PRIORITY); 
    thread.start();

  }

  public void doAbout(){

    AboutDialog d = new AboutDialog(mainFrame,"Stellation",true);
    d.pack();
    d.show();

  }

  void updatePolyImage(){

    if(usingPlanes){
      polyImage.setImage(loadImageFromJar("/images/stellation_main.jpg"));  

      polyInfoFaces.setText(   "faces:    " + polyhedronPlanes.length);
      polyInfoVertices.setText("symmetry: " + polySymmetry);
      polyInfoSymmetry.setText("");
      tfPolyName.setText("user defined planes");

      initSymChoice();
      
    } else {
      polyhedronName = polyNames.name(currentCategory,currentPoly);
      String fname = polyNames.fname(currentCategory,currentPoly);
      Image image = null;
      try {
	image = loadImageFromJar("/images/poly/"+fname+"_tmb.gif");
      } catch (Exception e){
	e.printStackTrace(Out);
      }
      polyImage.setImage(image);  
      
      polyhedron = readOffFile(fname);
      polySymmetry = polyNames.symmetry(currentCategory,currentPoly);
      stellationSymmetry = polySymmetry;
      

      initSymChoice();
      
      makePolyhedronPlanes(polyhedron);

      polyInfoFaces.setText(   "faces:    " + polyhedron.ifaces.length);
      polyInfoVertices.setText("vertices: " + polyhedron.vertices.length);
      polyInfoSymmetry.setText("symmetry: " + polySymmetry);
      tfPolyName.setText(polyhedronName);

    }

  }
  
  public void doQuit(){
    //frame.close();
    mainFrame.dispose();
    //frame3D.close();
    frame3D.dispose();
    //frameOutput.close();
    frameOutput.dispose();
    //frameSelection.close();
    frameSelection.dispose();
    //frameDiagram.close();
    frameDiagram.dispose();      
    try{
      if(applet == null){
	System.exit(0);
      }
    } catch(Exception ex){
    }
  }

  FileDialog fileDialog;
  public void doExport(String outType){

    try {

      OutputStream f = null;

      try{
	if(fileDialog == null){
	  fileDialog = new FileDialog(WindowUtils.getFrame(mainFrame), "export polyhedron as", FileDialog.SAVE);
	}
	
	fileDialog.setTitle("Export Polyhedron as " + outType);
	
	if(outType.equals("VRML")){
	  fileDialog.setFile("poly.wrl");
	} else if(outType.equals("POVRAY")){
	  fileDialog.setFile("poly.pov");
	} else if(outType.equals("DXF")){
	  fileDialog.setFile("poly.dxf");
	}
	fileDialog.show();

	if(fileDialog.getFile() == null)
	  return;
	String fName = fileDialog.getFile();
	String dName = fileDialog.getDirectory();
	
	String fileName = dName + fName;
	
	File file = new File(fileName);
	f = new FileOutputStream(file);
	Stellation.Out.println("saving polyhedron to " + fileName);
      } catch(Exception e){
	f = System.out;
	System.out.println("---------start of polyhedron");
	Stellation.Out.println("printing file into java console" );
      }
      
      // save to stream 
      Polyhedron poly = stellation.getPolyhedron(currentCells);
      
      String[] desc;
      if(usingPlanes) {
	desc = new String[]{
	  "polyhedron stellation generated from set of planes", 
	  "  planes: " + dlgPlanes.getSourceVectorsAsString(),
	  "  symmetry: " + polySymmetry + " / " + stellationSymmetry,
	  "  cells: " + selection.cellField.getText(),
	  "  exported from Stellation Program by Vladimir Bulatov", 
	  "  http://www.physics.orst.edu/~bulatov/polyhedra/stellation_applet/index.html" 
	};
      } else {
	desc = new String[]{"polyhedron: " + polyhedronName, 
                            "  symmetry: " + polySymmetry + " / " + stellationSymmetry,
			    "  cells: " + selection.cellField.getText(), 
			    "  exported from Stellation Program by Vladimir Bulatov", 
			    "  http://www.physics.orst.edu/~bulatov/polyhedra/stellation_applet/index.html" 
	};
      }
      poly.setDescription(desc);
      poly.outFaces = true;
      poly.outEdges = true;
      poly.outVertices = true;
      poly.outColor = false;
      PrintStream ps = new PrintStream(f);
      if(outType.equals("POVRAY")){
	poly.writePOV(ps);
      } else if(outType.equals("VRML")){
	poly.writeVrml(ps);	
      } else if(outType.equals("DXF")){
	poly.writeDXF(ps);	
      }
      ps.close();
      if(f != System.out){
	f.close();
      } else {
	System.out.println("---------end of polyhedron");
      }
    } catch (Exception e){
      //System.out.printStackTrace("Can't print diagram");
    }
    
  }

  /**
     action Listener 

   */
  public void actionPerformed(ActionEvent e){

    String what = e.getActionCommand();
    
    if(what.equals("Load...")){
      doLoad();
    } else if(what.equals("Quit")){
      doQuit();
    } else if(what.equals("About...")){
      doAbout();
    } else if(what.equals(miSaveAsVRML.getLabel())){
      doExport("VRML");      
    } else if(what.equals(miSaveAsPOV.getLabel())){
      doExport("POVRAY");
    } else if(what.equals(miSaveAsDXF.getLabel())){
      doExport("DXF");
    } else if(what.equals(miUndo.getLabel())){
      selection.doUndo();
    } else if(what.equals(miClearAll.getLabel())){
      selection.doClearAll();
    } else if(what.equals(miMakePlanes.getLabel())){
      doMakePlanes(); 
    } else if(what.equals(miConnectivityGraph.getLabel())){
      printConnectivityGraph();
    } else if(what.equals("Stop")){
      doStop();
    } else if(what.equals(MakeStellation)){
      doStart();
    } else if(what.equals(btnTest.getLabel())){
      doTest();
    } else if(what.equals(btnTest1.getLabel())){
      doTest1();
    }
  }

  DlgPlanes dlgPlanes;

  /**
   *  doMakePlanes()
   */
  void doMakePlanes(){

    if(dlgPlanes == null){
      dlgPlanes = new DlgPlanes(canonicalPlanes, polySymmetry);
    }
    if(!dlgPlanes.edit(mainFrame))
      return;
    polyhedronPlanes = dlgPlanes.getPlanes();
    polySymmetry = dlgPlanes.getSymmetry();
    stellationSymmetry = polySymmetry;
    makeCanonicalPlanes();

    initSymChoice();
    usingPlanes = true;
    updatePolyImage();
    // TO-DO - change image;
  }

  void printConnectivityGraph(){

    Out.println("\nConnectivity Graph:");

    for(int layer = 0; layer < subcells.size(); layer++){

      Vector slayer = (Vector)subcells.elementAt(layer);
      
      for(int ind = 0; ind < slayer.size(); ind++){
	SSCell cell = (SSCell)slayer.elementAt(ind);
	Out.print(layer + "." + ind +": (");
	for(int i = 0; i < cell.bottom.size(); i++){
	  SSCell c = (SSCell)cell.bottom.elementAt(i);
	  Out.print(c.layer + "." + c.index + " ");
	}
	Out.print(") (");
	for(int i = 0; i < cell.top.size(); i++){
	  SSCell c = (SSCell)cell.top.elementAt(i);
	  Out.print(c.layer + "." + c.index + " ");
	}
	Out.println(")");
      }      
    }
  }

  Vector makeSubcells(Vector cells){

    subcells = new Vector();    
    int nlayers = cells.size();
    for(int l = 0; l < nlayers; l++){
      Vector layer = (Vector)cells.elementAt(l);
      Vector sublayer = new Vector();
      for(int c = 0; c < layer.size();c++){
	SSCell cell = (SSCell)layer.elementAt(c);
	if(cell.subCells != null){
	  for(int s = 0; s < cell.subCells.length; s++){
	    sublayer.addElement(cell.subCells[s]);
	  }
	}
      }
      subcells.addElement(sublayer);
    }
    return subcells;
  }

  class SymmetryListener implements ItemListener {
    
    public void itemStateChanged(ItemEvent e){
      
      if(e.getStateChange()== ItemEvent.SELECTED){	
	stellationSymmetry = (String)choice_symmetry.getSelectedItem();
	createSubcells(allcells,stellationSymmetry);
	initSubcells();
	Out.println("symmetry changed: " + stellationSymmetry);
      }
    }
  }
  /*
  class CategoryListener implements ItemListener {
    
    public void itemStateChanged(ItemEvent e){
      
      if(e.getStateChange()== ItemEvent.SELECTED){

	polyNames.setCategory((String)choice_category.getSelectedItem());
	choice_poly.removeAll();
	for(int i =0; i < polyNames.length(); i++){
	  choice_poly.addItem(polyNames.name(i));
	}	
	choice_poly.select(0);
	updatePolyImage();
      }
    }
  }
  */
  /*
  class PolyListener implements ItemListener {
    
    public void itemStateChanged(ItemEvent e){
      
      if(e.getStateChange()== ItemEvent.SELECTED){

	updatePolyImage();
      }
    }
  }
  */
  class FaceListener implements ItemListener {

    public void itemStateChanged(ItemEvent e){

      if(e.getStateChange()== ItemEvent.SELECTED){
	faceToShow = Integer.parseInt(choice_face.getSelectedItem());
	showDiagram(cellIndex); 
      }
    }
  }

  class VertexListener implements ItemListener {

    public void itemStateChanged(ItemEvent e){

      if(e.getStateChange()== ItemEvent.SELECTED){
	vertexUp = Integer.parseInt(choice_vertexUp.getSelectedItem());
	showDiagram(cellIndex); 
      }
    }
  }

  class WindowListenerClass extends WindowAdapter {

    public void windowClosing(WindowEvent e){
      doQuit();
    }    

    public void windowIconified(WindowEvent e){
      frame3D.hide();
      frameSelection.hide();
      frameOutput.hide();
      frameDiagram.hide();
    }

    public void windowDeiconified(WindowEvent e){
      frame3D.show(view3D);
      frameSelection.setVisible(viewCells);
      frameOutput.show(viewOutput);
      frameDiagram.show(viewDiagram);
    }
  }

  /**
   */
  Image loadImageFromJar(String imageName) {
    
    Toolkit tk = Toolkit.getDefaultToolkit();
    byte bytebuf[] = null;


    bytebuf = null;
    int n;
    try {
      InputStream is = getClass().getResourceAsStream(imageName);
      if (is == null) {
	Out.println("ImageLoader.loadFromJar getResourceAsStream failed on " + imageName);
	return null; // BAD
      }
      BufferedInputStream bis = new BufferedInputStream(is);
      ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
      bytebuf = new byte[1024];
      while (true) {
	n = bis.read(bytebuf);
	if (n <= 0) break;
	out.write(bytebuf, 0, n);
      }
      bis.close();
      out.flush();
      bytebuf = out.toByteArray();
    } catch (IOException e) {
      System.err.println("ImageLoader.loadFromJar IOException: " + e);
      return null; // BAD
    }
    if (bytebuf == null) {
      Out.println("ImageLoader.loadFromJar: " + imageName + " not found.");
      return null;
    }
    if (bytebuf.length == 0) {
      Out.println("ImageLoader.loadFromJar: " + imageName + " is zero-length");
      return null;
    }
    //System.out.println("loadFromJar: " + imageName + " loaded");
    return tk.createImage(bytebuf);
  }

  /**

   */
  public static void main(String args[]){

    String fname = "off/u27.off";
    String stellationSymmetry = "I";
    
    if(args.length == 0){
      System.out.println("usage: ");
      System.out.println(" -i <input file>");
      System.out.println(" -y <stellationSymmetry>");
    }
    for(int i = 0; i < args.length; i++){
      if(args[i].charAt(0) == '-'){
	
	switch ( args[i].charAt(1) ){
	case 'i':
	  fname = args[++i];
	  break;
	case 'y':
	  stellationSymmetry = args[++i];
	  break;
	}	
      }
    }
    
    new Main(fname,stellationSymmetry, null);

  }  
  /*
  public SSCell getSSCell(int layer, int cell){

    Vector v = (Vector)allcells.elementAt(layer);
    SSCell ssc = (SSCell)v.elementAt(cell);
    return ssc;
    
  }
  */
  class PrintDiagram implements ActionListener{

    public void actionPerformed(ActionEvent e){
      PrintJob pj = Toolkit.getDefaultToolkit().getPrintJob(mainFrame,"Print Diagram",null);
      if(pj == null)
	return;
      Graphics gr = pj.getGraphics();
      Dimension dim = pj.getPageDimension();
      System.out.println("printing diagram");
      diagram.drawContent(gr,dim.width, dim.height);
      pj.end();
    }
  }

  class onVectorCalculator implements ActionListener{

    public void actionPerformed(ActionEvent e){

      new VectorCalculator().show();

    }

  }
    
  class Print3DModel implements ActionListener{

    public void actionPerformed(ActionEvent e){

      PrintJob pj = Toolkit.getDefaultToolkit().getPrintJob(mainFrame,"Print Diagram",null);
      if(pj == null)
	return;
      Graphics gr = pj.getGraphics();
      Dimension dim = pj.getPageDimension();
      System.out.println("printing 3d model");
      canvas3D.paint(gr,dim.width, dim.height);
      pj.end();

    }
  }

  DlgSelectPoly dialogSelectPoly = null;

  class SelectPolyhedron implements ActionListener{

    public void actionPerformed(ActionEvent e){

      if(dialogSelectPoly == null){
	dialogSelectPoly = new DlgSelectPoly();
      }

      int[] result = dialogSelectPoly.getPolyhedron(mainFrame, currentCategory, currentPoly);
      if(result != null){
	currentCategory = result[0];
	currentPoly = result[1];
	usingPlanes = false;
	updatePolyImage();
      }
    }
  }

  int getSymmetryIndex(String symmetry){

    for(int i =0; i < symnames.length; i++){
      if(symmetry.equals(symnames[i]))
	return i;
    }
    return 0;
  }

  /**
     calculates nonequivalent faces of polyhedron and select few "canonical" vectotrs
   */
  void makePolyhedronPlanes(Polyhedron poly){

    polyhedronPlanes = new Vector3D[poly.ifaces.length];

    for(int i = 0; i < poly.ifaces.length; i++){

      Plane plane = Stellation.getPlane(poly,i);
      polyhedronPlanes[i] = plane.v.mul(plane.d);

    }
    
    makeCanonicalPlanes();

  }

  /**
     calculates nonequivalent faces of polyhedron and select few "canonical" vectotrs
     uses polyhedronPlanes 
     creates canonical planes 
   */
  void makeCanonicalPlanes(){
    
    Symmetry.CanonicalTester tester = Symmetry.getCanonicalTester(polySymmetry);
    Vector cv = new Vector();
    Hashtable ht = new Hashtable();
    for(int i=0; i < polyhedronPlanes.length; i++){
      
      if(tester.test(polyhedronPlanes[i])){
	
	Vector3D v = new Vector3D(chop(polyhedronPlanes[i].x),
				  chop(polyhedronPlanes[i].y),
				  chop(polyhedronPlanes[i].z));
	if(ht.get(v) == null){
	  
	  ht.put(v,v);
	  cv.addElement(v);
	  Out.println(i + ": " + PVS.Utils.Fmt.fmt(v.x,17,14) + 
		      PVS.Utils.Fmt.fmt(v.y,17,14) + 
		      PVS.Utils.Fmt.fmt(v.z,17,14) + " canonical vector");
	} else {
	  Out.println(i + ": " + PVS.Utils.Fmt.fmt(v.x,17,14) + 
		      PVS.Utils.Fmt.fmt(v.y,17,14) + 
		      PVS.Utils.Fmt.fmt(v.z,17,14) + 
		      " duplicated canonical vector, ignored");	  
	}
      } else {

      }
    }   
    canonicalPlanes = new Vector3D[cv.size()];
    if(canonicalPlanes.length != 0)
      cv.copyInto(canonicalPlanes);

    if(dlgPlanes != null){
      dlgPlanes.setPlanes(canonicalPlanes, polySymmetry);
    }

  }



  static final double EPS = 1.e-12;

  static double chop(double v){
    if(v < -EPS || v > EPS)
      return v;
    else 
      return 0;    
  }

  class FrameClosingListener extends WindowAdapter{

    public void  windowClosing(WindowEvent e){
      
      Component comp = e.getComponent();
      System.out.println(comp);

      if(comp == frameDiagram){

	frameDiagram.setVisible(false);
	miViewDiagram.setState(false);
	viewDiagram = false;

      } else if(comp == frameSelection){

	frameSelection.setVisible(false);
	miViewCells.setState(false);
	viewCells = false;

      } else if(comp == frame3D){

	frame3D.setVisible(false);
	view3D = false;
	miView3D.setState(false);

      } else if(comp == frameOutput){

	frameOutput.setVisible(false);
	viewOutput = false;	
	miViewOutput.setState(false);
      }      
    }    
  }

  class ViewListener implements ItemListener {

    public void itemStateChanged(ItemEvent e){

      ItemSelectable comp = e.getItemSelectable();
      System.out.println(comp);
      if(comp == miViewDiagram){

	viewDiagram = !viewDiagram;
	frameDiagram.setVisible(viewDiagram);
	miViewDiagram.setState(viewDiagram);

      } else if(comp == miViewCells){

	viewCells = !viewCells;
	frameSelection.setVisible(viewCells);
	miViewCells.setState(viewCells);

      } else if(comp == miView3D){

	view3D = !view3D;
	frame3D.setVisible(view3D);
	miView3D.setState(view3D);

      } else if(comp == miViewOutput){

	viewOutput = !viewOutput;	
	frameOutput.setVisible(viewOutput);
	miViewOutput.setState(viewOutput);
      }      
    }    

  }
  

  static private GridBagConstraints gbc = new GridBagConstraints();
}

