package PVS.polyhedra.stellation;

import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.net.URL;
import java.applet.*;


import PVS.polyhedra.*;
import PVS.Utils.*;
import PVS.Expression.*;


public class DlgPlanes {

  Vector3D[] canonicalPlanes;
  String polySymmetry = "";

  public DlgPlanes(Vector3D[] canonicalPlanes, String polySymmetry){

    // this is to initialize planes with initial values
    this.canonicalPlanes = canonicalPlanes;
    this.polySymmetry = polySymmetry;    

  }

  Dialog dialog; 

  public boolean edit(Frame frame){
    if(dialog == null)
      makeDialog(frame);
    btnOK.setEnabled(false);
    dialog.show();

    return result;
    
  }
  
  public String getSymmetry(){
    return polySymmetry;
  }

  public Vector3D[] getPlanes(){
    return planes;
  }

  Vector3D[] planes = new Vector3D[0];
  boolean result;
  static final int MAXPLANES = 6;

  TextArea textArea = new TextArea();
  TextField planesX[] = new TextField[MAXPLANES];
  TextField planesY[] = new TextField[MAXPLANES];
  TextField planesZ[] = new TextField[MAXPLANES];
  Choice choiceSymmetry = new Choice();

  Button btnOK = new Button("OK");
  Button btnCancel = new Button("Cancel");
  Button btnGenerate = new Button("Generate");

  static String symnames[] = Symmetry.getSymmetryNames();
  /*
new String[] {"T","Th","Td",
                                           "Td","T","D3_T","D2d","C2","Ci","Cs","E",
					   "Ih","I","Th","T","D5d(I)","D5(I)","C5v(I)","C5(I)","D3d(I)","D3(I)",
					   "C3v(I)","C3(I)", "D2h","D2","C2",
					   "Oh","O","Th","Td","T","D4h","D4d","D4","D3d(O)","D3(O)","C3v(O)","C3(O)",
					   "D2h","D2d","D2","C2","D2h(O)","D2(O)","C2(O)",
					   
					   "D3d","D4d","D5d","D6d","D7d",
					   "D3h","D4h","D5h","D6h","D7h",
					   "D3","D4","D5","D6","D7"};
  */


  void makeDialog(Frame frame){

    dialog = new Dialog(frame);


    GridBagLayout gb = new GridBagLayout();
    dialog.setLayout(gb);

    Panel panel1 = new Panel();
    panel1.setLayout(gb);

    WindowUtils.constrain(panel1,new Label("plane "),    0,0,1,1, gbc.NONE, gbc.CENTER,0.,0.);
    WindowUtils.constrain(panel1,new Label("X "),        1,0,1,1, gbc.NONE, gbc.CENTER,1.,0.);
    WindowUtils.constrain(panel1,new Label("Y "),        2,0,1,1, gbc.NONE, gbc.CENTER,1.,0.);
    WindowUtils.constrain(panel1,new Label("Z "),        3,0,1,1, gbc.NONE, gbc.CENTER,1.,0.);

    for(int k = 0; k < symnames.length; k++){
      choiceSymmetry.addItem(symnames[k]);
    }

    for(int i =0; i < MAXPLANES; i++){

      planesX[i] = new TextField(17);
      planesY[i] = new TextField(17);
      planesZ[i] = new TextField(17);

      WindowUtils.constrain(panel1,new Label(""+(i+1)),0,i+1,1,1, gbc.NONE, gbc.CENTER,0.,0.);
      WindowUtils.constrain(panel1,planesX[i], 1,i+1,1,1, gbc.HORIZONTAL, gbc.NORTH,1.,0.);
      WindowUtils.constrain(panel1,planesY[i], 2,i+1,1,1, gbc.HORIZONTAL, gbc.NORTH,1.,0.);
      WindowUtils.constrain(panel1,planesZ[i], 3,i+1,1,1, gbc.HORIZONTAL, gbc.NORTH,1.,0.);
      
    }
    

    
    Panel panelBtn = new Panel();
    btnOK.setEnabled(false);
    panelBtn.setLayout(new GridLayout(1,3,3,3));
    panelBtn.add(btnGenerate);
    panelBtn.add(btnOK);
    panelBtn.add(btnCancel);
    btnOK.addActionListener(new OnOK());
    btnCancel.addActionListener(new OnCancel());
    btnGenerate.addActionListener(new OnGenerate());

    Panel symPanel = new Panel();    symPanel.setLayout(gb);
    WindowUtils.constrain(symPanel,new Label("Symmetry "), 0,0,1,1, gbc.NONE, gbc.CENTER,0.,0.);
    WindowUtils.constrain(symPanel,choiceSymmetry,1,0,1,1, gbc.NONE, gbc.CENTER,0.,0.);
    
    Panel panel2 = new Panel();panel2.setLayout(gb);
    WindowUtils.constrain(panel2,symPanel, 0,0,1,1,   gbc.NONE, gbc.CENTER,0.,0.,0,0,10,0);
    WindowUtils.constrain(panel2,panelBtn, 1,0,1,1, gbc.NONE, gbc.CENTER,0.,0.);
    
    WindowUtils.constrain(dialog,panel1,0,0,1,1,gbc.HORIZONTAL, gbc.NORTH,1.,0.);
    WindowUtils.constrain(dialog,textArea,0,1,1,1,gbc.BOTH, gbc.NORTH,1.,1.);    
    WindowUtils.constrain(dialog,panel2,0,2,1,1,gbc.NONE, gbc.CENTER,0.,0.,3,3,3,3);    
    
    setPlanes(canonicalPlanes, polySymmetry);

    dialog.addWindowListener(new CloseWindowListener());
    
    dialog.pack();
    dialog.validate();
    dialog.setModal(true);
        
  }

  Parser parser;

  void writeVector(Vector3D v){

      textArea.append(Fmt.fmt(v.x,17,14));      
      textArea.append(Fmt.fmt(v.y,17,14));
      textArea.append(Fmt.fmt(v.z,17,14));

  }

  public void setPlanes(Vector3D[] planes, String sym){

    if(planesX[0]== null)
      return;
    polySymmetry = sym;
    choiceSymmetry.select(sym);
    for(int i=0; i < planes.length; i++){
      if(i < planesX.length){
	//System.out.println("" + i + " ," + planes[i] + ", " + planesX[i]);
	planesX[i].setText(Fmt.fmt(chop(planes[i].x),17,14));
	planesY[i].setText(Fmt.fmt(chop(planes[i].y),17,14));
	planesZ[i].setText(Fmt.fmt(chop(planes[i].z),17,14));
      }
    }
    for(int i=planes.length; i <planesX.length; i++){
	planesX[i].setText("");
	planesY[i].setText("");
	planesZ[i].setText("");
    }
    
  }

  static final double EPS = 1.e-12;

  static double chop(double v){
    if(v < -EPS || v > EPS)
      return v;
    else 
      return 0;    
  }

  public String getSourceVectorsAsString(){

    StringBuffer ba = new StringBuffer();
    ba.append("[");
    for(int i =0; i < MAXPLANES; i++){      
      String tx = planesX[i].getText();
      String ty = planesY[i].getText();
      String tz = planesZ[i].getText();
      if(tx.length()>0 && ty.length()>0 && tz.length() > 0){
	ba.append("(");
	ba.append(tx);
	ba.append(",");
	ba.append(ty);
	ba.append(",");
	ba.append(tz);
	ba.append(")");
      }
    }
    ba.append("]");
    return ba.toString();
  }

  /**
     generate(){
     
   */
  public void generate(){

    parser = new Parser();

    polySymmetry = choiceSymmetry.getSelectedItem();

    Vector vectors = new Vector();
    for(int i =0; i < MAXPLANES; i++){      
      String tx = planesX[i].getText();
      String ty = planesY[i].getText();
      String tz = planesZ[i].getText();
      if(tx.length()>0 && ty.length()>0 && tz.length() > 0){
	double x = calculate(tx);
	double y = calculate(ty);
	double z = calculate(tz);
        vectors.addElement(new Vector3D(x,y,z));
      }
    }
    textArea.append("\n");
    textArea.append("source vectors\n");
    for(int i = 0; i < vectors.size(); i++){
      Vector3D v = (Vector3D)vectors.elementAt(i);
      writeVector(v);

      textArea.append("\n");
    }
    
    //textArea.append("transformed vectors\n");
    Hashtable ht = new Hashtable();
    for(int i = 0; i < vectors.size(); i++){
      Vector3D v = (Vector3D)vectors.elementAt(i);
      Matrix3D[] matr = Symmetry.getMatrices(polySymmetry);
      for(int k =0; k < matr.length; k++){
	Vector3D v1 = v.mul(matr[k]);
	//textArea.append(v1.toString());
	//textArea.append("\n");
	if(ht.get(v1) == null)
	  ht.put(v1,v1);
      }
    }
    
    textArea.append("sorted vectors\n");
    int count = 0;
    planes = new Vector3D[ht.size()];
    for(Enumeration e = ht.keys(); e.hasMoreElements();){
      Vector3D v = (Vector3D)e.nextElement();      
      textArea.append(v.toString());
      textArea.append("\n");
      planes[count++] = v;
    }
    textArea.append("count:" + ht.size());    
    textArea.append("\n");

    double dot[][] = new double[planes.length][2];
    for(int i = 0; i < planes.length; i++){
      dot[i][0] = planes[0].dot(planes[i]);
      dot[i][1] = planes[0].cross(planes[i]).length();
    }
    QSort.quickSort(dot,0,planes.length-1,new MyComparator());
    
    for(int i = 0; i < planes.length; i++){
      textArea.append(Fmt.fmt(dot[i][0],17,14));
      textArea.append(Fmt.fmt(dot[i][1],17,14));
      textArea.append("\n");
    }

    btnOK.setEnabled(true);
    
  }

  class MyComparator implements PVS.Utils.Comparator {

    public int compare(Object o1, Object o2){
      double [] a1 = (double[] )o1;
      double [] a2 = (double[] )o2;
      if(a1[0] > a2[0])
	return 1;
      else if(a1[0] < a2[0])
	return -1;
      return 0;	      
    }
  }

  public double calculate(String s){

    double result = 0;
    try {
      Expr expr = parser.parse (s);
      Variable g = expr.getVariable ("g");
      g.setValue((Math.sqrt(5)+1)/2);

      Variable pi = expr.getVariable ("pi");
      pi.setValue(Math.PI);

      result = expr.value();

    } catch(Exception e){
      System.out.println("Exception during calculating " + s);
    }

    return result;
  }

  class OnGenerate implements java.awt.event.ActionListener{

    public void actionPerformed(ActionEvent e){
      
      textArea.setText("Generating vectors");
      generate();
    }    
  }

  class OnOK implements java.awt.event.ActionListener{

    public void actionPerformed(ActionEvent e){
      dialog.setVisible(false);
      dialog.dispose();
      result = true;
    }    
  }

  class OnCancel implements java.awt.event.ActionListener{

    public void actionPerformed(ActionEvent e){
      dialog.setVisible(false);
      dialog.dispose();
      result = false;
   }    
  }

  class CloseWindowListener extends WindowAdapter {
    
    public void  windowClosing(WindowEvent e){
      dialog.setVisible(false);
      dialog.dispose();
      result = false;      
    }
  }

  static private GridBagConstraints gbc = new GridBagConstraints();

  static void main(String args[]){
    Frame fr = new Frame();
    //new DlgPlanes().getPlanes(fr);
    System.exit(0);
  }

}
