package PVS.polyhedra;
 

import java.awt.event.*;
import java.awt.*;
import java.io.*;

import PVS.Utils.Point2;
import PVS.Utils.Graphics2D;
import PVS.Utils.Viewport;
import PVS.Utils.ViewRect;
import PVS.Utils.GraphicsPS;
import PVS.Utils.PVSObserver;
import PVS.Utils.WindowUtils;
import PVS.Utils.EventCallback;
import PVS.Utils.TimeoutCallback;
import PVS.Utils.Timeout;
 
public class StellationCanvas extends Panel implements Runnable{

  PVSObserver observer;
  int maxlevel = -1;
  Point2 [][][] levels = null;
  PVS.Utils.Graphics2D g2d = new PVS.Utils.Graphics2D();
  double Width = 0;
  Point2 [][] fpoly = new Point2[0][0];
  Point2[] centers = new Point2[0];
  Point2[][] symLines; // intersections of symmetry planes
  Point2[] symAxes;    // intersections of symmetry axes
  int[] symAxesOrder;    // orders of symmetry axes

  SCanvas canvas;
  Checkbox cbSymAxes, cbSymLines;
  PopupMenu cellSelectionPopup;
  boolean drawSymmetryLines = false;
  boolean drawSymmetryAxes = false;
  double centerX = 0;
  double centerY = 0;
  double polyDiameter = 1; // diameter of face diagram 

  int sbMaximum = 100000;
  int sbVisible = 100000;
  Scrollbar sbVertical = new Scrollbar(Scrollbar.VERTICAL,0,sbVisible,0,sbMaximum);
  Scrollbar sbHorizontal = new Scrollbar(Scrollbar.HORIZONTAL,0,sbVisible,0,sbMaximum);

  double Angle = 0;


  /**
    constructor 

   */
  public StellationCanvas(SFace[] faces, SFace[] ffaces, Axis[] axes, Vector3D[][] planes){
    
    this.setBackground(Color.white);
    this.setLayout(new GridBagLayout());
    
    Panel buttonsPanel = new Panel();
    buttonsPanel.setLayout(new GridBagLayout());
    buttonsPanel.setBackground(Color.lightGray);
    Button btnZoomIn = new Button("+");
    btnZoomIn.addMouseListener(new ZoomInListener());
    Button btnZoomOut = new Button("-");
    btnZoomOut.addMouseListener(new ZoomOutListener());
    Button btnUp = new Button("^");
    btnUp.addMouseListener(new UpListener());
    Button btnDown = new Button("v");
    btnDown.addMouseListener(new DownListener());
    Button btnLeft = new Button("<");
    btnLeft.addMouseListener(new LeftListener());
    Button btnRight = new Button(">");
    btnRight.addMouseListener(new RightListener());
    Button btnRotateRight = new Button("R");
    btnRotateRight.addMouseListener(new RotateRightListener());
    Button btnRotateLeft = new Button("L");
    btnRotateLeft.addMouseListener(new RotateLeftListener());
    
    cbSymLines = new Checkbox("Sym. Lines",drawSymmetryLines);
    cbSymLines.addItemListener(new SymLinesListener());
    cbSymAxes = new Checkbox("Axes",drawSymmetryAxes);
    cbSymAxes.addItemListener(new SymAxesListener());
    sbVertical.addAdjustmentListener(new SBVerticalAdjustmentListener());
    sbHorizontal.addAdjustmentListener(new SBHorizontalAdjustmentListener());

    int c= 0;
    WindowUtils.constrain(buttonsPanel,cbSymLines, c++,0,1,1, gbc.NONE, gbc.WEST,0.,0.);
    WindowUtils.constrain(buttonsPanel,cbSymAxes,  c++,0,1,1, gbc.NONE, gbc.WEST,1.,0.);
    WindowUtils.constrain(buttonsPanel,btnZoomIn,  c++,0,1,1, gbc.NONE, gbc.WEST,0.,0.);
    WindowUtils.constrain(buttonsPanel,btnZoomOut, c++,0,1,1, gbc.NONE, gbc.WEST,0.,0.);
    WindowUtils.constrain(buttonsPanel,btnUp,      c++,0,1,1, gbc.NONE, gbc.WEST,0.,0.);
    WindowUtils.constrain(buttonsPanel,btnDown,    c++,0,1,1, gbc.NONE, gbc.WEST,0.,0.);
    WindowUtils.constrain(buttonsPanel,btnLeft,    c++,0,1,1, gbc.NONE, gbc.WEST,0.,0.);
    WindowUtils.constrain(buttonsPanel,btnRight,   c++,0,1,1, gbc.NONE, gbc.WEST,0.,0.);
    WindowUtils.constrain(buttonsPanel,btnRotateLeft,  c++,0,1,1, gbc.NONE, gbc.WEST,0.,0.);
    WindowUtils.constrain(buttonsPanel,btnRotateRight, c++,0,1,1, gbc.NONE, gbc.WEST,0.,0.);

    canvas = new SCanvas();

    WindowUtils.constrain(this,buttonsPanel, 0,0,2,1, gbc.HORIZONTAL, gbc.WEST,1.,0.);
    WindowUtils.constrain(this,canvas, 0,1,1,1, gbc.BOTH, gbc.CENTER,1.,1.);
    WindowUtils.constrain(this,sbVertical, 1,1,1,1, gbc.VERTICAL, gbc.CENTER,0.,1.);
    WindowUtils.constrain(this,sbHorizontal, 0,2,1,1, gbc.HORIZONTAL, gbc.CENTER,1.,0.);
    
    cellSelectionPopup = makeCellSelectionPopup();
    canvas.add(cellSelectionPopup);
    setFaces(faces, ffaces, axes, planes);
    canvas.addMouseListener(new CanvasMouseListener());
    canvas.addMouseMotionListener(new CanvasMouseMotionListener());
    canvas.addKeyListener(new KeyListenerClass());
    init();
  }

  public void init(){
    findWidth();    
    buildCenters();    
    canvas.repaint();
  }

  /**
    addObserver

   */
  public void addObserver(PVSObserver _observer){
    observer = _observer;
  }

  static Color[] stepColors = new Color[100];
  static {
    float c = 0.0f;
    for(int i = 0; i < stepColors.length; i++){
      //stepColors[i] = Color.getHSBColor(c, 0.8f,1.0f);
      stepColors[i] = Color.getHSBColor(c, 0.5f,1.0f);
      c += 0.1534f;
      if(c > 1.0f)
	c -= 1.0;
    }
  }

  /**
    getColor

   */
  static Color getColor(int i){
    i = (i < 0)? -1 : i; 
    return stepColors[i%100];
  }

  public Dimension getPreferredSize(){
    return new Dimension(300,300);
  }

  /**
    setFaces

   */
  public void setFaces(SFace[] faces){
    maxlevel = -1;
    for(int i = 0; i < faces.length; i++){
      if(faces[i].layer > maxlevel){
	maxlevel = faces[i].layer;
      }
    }
    int[] lcount = new int[maxlevel+1];

    for(int i = 0; i < faces.length; i++){
      lcount[faces[i].layer]++;
    }

    levels = new Point2[maxlevel+1][][];
    for(int i = 0; i < lcount.length; i++){
      levels[i] = new Point2[lcount[i]][];
    }
    
    int[] counter = new int[maxlevel+1];

    for(int i=0; i < faces.length; i++){
      int level = faces[i].layer;
      Point2[] points = new Point2[faces[i].vertices.length];
      transform(faces[i].vertices,points);
      levels[level][counter[level]++] = points;
    }
    initCurrentMatrix();
    rotate(current_matrix);
    //init();
    canvas.repaint();
  }

  /**
    setFaces

   */
  public void setFaces(SFace[] faces, SFace[] ffaces, Axis[] axes, Vector3D[][] planes){

    maxlevel = -1;
    for(int i = 0; i < faces.length; i++){
      if(faces[i].layer > maxlevel){
	maxlevel = faces[i].layer;
      }
    }
    int[] lcount = new int[maxlevel+1];

    for(int i = 0; i < faces.length; i++){
      lcount[faces[i].layer]++;
    }

    levels = new Point2[maxlevel+1][][];
    for(int i = 0; i < lcount.length; i++){
      levels[i] = new Point2[lcount[i]][];
    }
    
    int[] counter = new int[maxlevel+1];

    for(int i=0; i < faces.length; i++){
      int level = faces[i].layer;
      Point2[] points = new Point2[faces[i].vertices.length];
      transform(faces[i].vertices,points);
      levels[level][counter[level]++] = points;
    }

    // these will be drawn as outline
    fpoly = new Point2[ffaces.length][];
    for(int i=0; i < ffaces.length; i++){
      Point2[] points = new Point2[ffaces[i].vertices.length];
      transform(ffaces[i].vertices,points);
      fpoly[i] = points;
    }

    if(axes != null){
      symAxes = new Point2[axes.length];
      symAxesOrder = new int[axes.length];
      for(int i = 0; i < axes.length; i++){
	if(axes[i] != null){
	  symAxes[i] = new Point2(axes[i].vector.x,axes[i].vector.y);
	  symAxesOrder[i] = axes[i].order;
	}
      }
    }
    if(planes != null){
      symLines = new Point2[planes.length][];
      for(int i = 0; i < planes.length; i++){
	if(planes[i] != null){
	  symLines[i] = new Point2[]{new Point2(planes[i][0].x,planes[i][0].y),
				      new Point2(planes[i][1].x,planes[i][1].y)};
	}
      }
    }

    initCurrentMatrix();
    rotate(current_matrix);

    buildCenters();
    //init();
    canvas.repaint();
    
  }

  void initCurrentMatrix(){
    //System.out.println("CurrentAngle: " + (Angle/Math.PI*180));
    double fi = Angle;
    current_matrix[0][0] = Math.cos(fi);
    current_matrix[1][1] = Math.cos(fi);
    current_matrix[0][1] = Math.sin(fi);
    current_matrix[1][0] = -Math.sin(fi);    
    
  }


  /**
    findWidth

   */
  void findWidth(){

    double r = 0;
    //double xmin=100, xmax=-100, ymin=100, ymax=-100;
    for(int i=0; i < fpoly.length; i++){
      Point2[] poly = fpoly[i];
      for(int j = 0; j < poly.length; j++){
	Point2 v = poly[j];
	double v2 = v.length2();
	if(v2 > r)
	  r = v2;
	//if(v.x > xmax)
	//  xmax = v.x;
	//if(v.x < xmin)
	//  xmin = v.x;
	//if(v.y > ymax)
	//  ymax = v.y;
	//if(v.y < ymin)
	//  ymin = v.y;
      }
    } 
    polyDiameter = 2*Math.sqrt(r);
    Width = polyDiameter;
    
    centerX = 0;
    centerY = 0;
    //Stellation.Out.println("face radius: " + (Width/2));
  }

  /**
    
   */
  void buildCenters(){

    centers = new Point2[fpoly.length];
    for(int i=0; i < fpoly.length; i++){
      Point2[] poly = fpoly[i];
      Point2 center = new Point2(0,0);
      for(int j = 0; j < poly.length; j++){
	center.addSet(poly[j]);
      }
      center.mulSet(1./poly.length);
      centers[i] = center;
    } 
  }

  /**
    reduces 3D to 2D
   */
  void transform(Vector3D[] vect, Point2[] point){
    for(int i=0; i < vect.length; i++){
      Vector3D v = vect[i];
      point[i] = new Point2(v.x,v.y);
    }    
  }

  
  /**
    paint 

   */
  public void paintCanvas(Graphics g){
    Dimension size = canvas.getSize();
    if(size.width == 0)
      return;
    paintCanvas(g,size.width, size.height);

    if(eventCallback != null){
      // if user is holding down a mouse button
      // this will repeat repeated action 
      EventCallback ec = eventCallback;
      eventCallback = null;
      ec.processEventCallback(null,null);
    }
    // this is to init rendering of selected polygon 
    oldPolyIndex = -1;
  }

  EventCallback eventCallback = null;
  Viewport viewport;
  ViewRect screenRectangle;

  int oldWidth = -1, oldHeight = -1;
  Image backImage = null;
  Graphics backGraphics;

  /**
    paint 

   */
  public void paintCanvas(Graphics g, int width, int height){

    if(width != oldWidth || height != oldHeight || backImage == null){
      oldWidth = width;
      oldHeight = height;
      backImage = createImage(width,height);      
      backGraphics = backImage.getGraphics();
    }    

    backGraphics.setColor(Color.white);
    backGraphics.fillRect(0,0,width,height);

    drawContent(backGraphics, width, height);

    g.drawImage(backImage,0,0,this);
    adjustScrollbars();
  }

  public void drawContent(Graphics g, int width, int height){

    g2d.setGraphics(g);
    initViewport(width, height);

    drawContent(g2d);
    
  }

  void initViewport(int width, int height){

    int d = ((width > height) ? height:width);
    int borderWidth = 4;
    double wx = Width*(width-2*borderWidth)/(d-2*borderWidth);
    double wy = Width*(height-2*borderWidth)/(d-2*borderWidth);
    g2d.setViewport(new Viewport(centerX - wx/2, centerY + wy/2,centerX + wx/2, centerY - wy/2));
    g2d.setScreenRectangle(new ViewRect(borderWidth,borderWidth,width-borderWidth,height-borderWidth));
    
  }

  public void drawSelectionPoly(Graphics g, int polyIndex){

    g2d.setGraphics(g);
    g2d.fillPolygon(fpoly[polyIndex]);
    
  }

  /**
    paint 

   */
  public void drawContent(Graphics2D g){
    
    if(levels == null)
      return;
    for(int i=0; i < levels.length; i++){
      g.setColor(getColor(i));
      Point2[][] poly = levels[i];
      for(int j=0; j < poly.length; j++){
	g.fillPolygon(poly[j]);
      }
    }

    // lines
    if(drawSymmetryLines) {
      g.setColor(Color.gray); 
    } else {
      g.setColor(Color.black);    
    }
    // polygon's outline 
    for(int j = 0; j < fpoly.length; j++){
      g.drawPolygon(fpoly[j]);
    }        
    
    if(drawSymmetryLines) {
      // symmetry planes 
      //g.setXORMode(Color.white);
      g.setColor(Color.black);
      if(symLines != null){
	for(int i =0; i < symLines.length; i++){
	  if(symLines[i] != null)
	    g.drawLine(symLines[i][0].x,symLines[i][0].y,symLines[i][1].x,symLines[i][1].y);
	}
      }
    }
      // symmetry axes 
    if(drawSymmetryAxes) {      
      if(symAxes != null){
	for(int i =0; i < symAxes.length; i++){
	  if(symAxes[i] != null)
	    drawAxis(g,symAxes[i],symAxesOrder[i]);
	}
      }
    }
    
  }

  void drawAxis(Graphics2D g, Point2 p, int order) {

    int x = (int)(g.x2screen(p.x) + 0.5);
    int y = (int)(g.y2screen(p.y) + 0.5);
    
    int size = 4;
    
    g.setColor(axisColor[order]);
    g.getGraphics().fillOval(x-size,y-size,2*size,2*size+1);    
    
  }

  
  void adjustScrollbars(){

    sbVisible = (int)(sbMaximum * Width/polyDiameter);
    sbVertical.setVisibleAmount(sbVisible);
    int y = (int)((sbMaximum - sbVisible)*0.5*(1+2*centerY/polyDiameter));
    sbVertical.setValue(y);

    int unitInc = (int)((sbMaximum - sbVisible)*( 0.01*Width/polyDiameter));
    if(unitInc < 1)
      unitInc = 1;
    sbVertical.setUnitIncrement(unitInc);
    sbHorizontal.setUnitIncrement(unitInc);
    sbVertical.setBlockIncrement(unitInc*50);
    sbHorizontal.setBlockIncrement(unitInc*50);

    int x = (int)((sbMaximum - sbVisible)*0.5*(1-2*centerX/polyDiameter));
    sbHorizontal.setVisibleAmount(sbVisible);
    sbHorizontal.setValue(x);

  }

  static Color axisColor[] = {Color.gray, Color.gray, 
			      
			      new Color(200,0,200),
			      new Color(0,0,250), 
			      new Color(0,200,250), 
			      new Color(50,250,50), 
			      };

  double[][] current_matrix = {{1,0},{0,1}};

  static double[][] matrix_ccw0 = new double[2][2];
  static double[][] matrix_ccw1 = new double[2][2];
  static double[][] matrix_ccw2 = new double[2][2];
  static double[][] matrix_cw0 = new double[2][2];
  static double[][] matrix_cw1 = new double[2][2];
  static double[][] matrix_cw2 = new double[2][2];

  static double AngleFast = Math.PI/18;
  static double AngleNormal = Math.PI/180;
  static double AngleSlow = Math.PI/1800;

  static {
    double fi = AngleNormal;
    matrix_ccw1[0][0] = Math.cos(fi);
    matrix_ccw1[1][1] = Math.cos(fi);
    matrix_ccw1[0][1] = -Math.sin(fi);
    matrix_ccw1[1][0] = Math.sin(fi);

    matrix_cw1[0][0] = Math.cos(fi);
    matrix_cw1[1][1] = Math.cos(fi);
    matrix_cw1[0][1] = Math.sin(fi);
    matrix_cw1[1][0] = -Math.sin(fi);

    fi = AngleSlow;

    matrix_ccw0[0][0] = Math.cos(fi);
    matrix_ccw0[1][1] = Math.cos(fi);
    matrix_ccw0[0][1] = -Math.sin(fi);
    matrix_ccw0[1][0] = Math.sin(fi);

    matrix_cw0[0][0] = Math.cos(fi);
    matrix_cw0[1][1] = Math.cos(fi);
    matrix_cw0[0][1] = Math.sin(fi);
    matrix_cw0[1][0] = -Math.sin(fi);
    
    fi = AngleFast;

    matrix_ccw2[0][0] = Math.cos(fi);
    matrix_ccw2[1][1] = Math.cos(fi);
    matrix_ccw2[0][1] = -Math.sin(fi);
    matrix_ccw2[1][0] = Math.sin(fi);

    matrix_cw2[0][0] = Math.cos(fi);
    matrix_cw2[1][1] = Math.cos(fi);
    matrix_cw2[0][1] = Math.sin(fi);
    matrix_cw2[1][0] = -Math.sin(fi);   

  }

  /**
    rotate 

   */
  void rotate(double [][]matrix){
    // modify current matrix to remember total rotation 
    //rotate_matrix(matrix);

    double m00 = matrix[0][0];
    double m01 = matrix[0][1];
    double m10 = matrix[1][0];
    double m11 = matrix[1][1];
    

    for(int i = 0; i < levels.length; i++){
      Point2[][] poly = levels[i];
      for(int j = 0; j < poly.length; j++){
	Point2[] points = poly[j];
	for(int k = 0; k < points.length; k++){
	  Point2 point = points[k];
	  double t = m00*point.x + m01*point.y;
	  point.y = m10*point.x + m11*point.y;
	  point.x = t;
	}	
      }
    }    

    for(int j = 0; j < fpoly.length; j++){
      Point2[] points = fpoly[j];
      for(int k = 0; k < points.length; k++){
	Point2 point = points[k];
	double t = m00*point.x + m01*point.y;
	point.y = m10*point.x + m11*point.y;
	point.x = t;
      }	
    }    

    for(int i =0; i < symLines.length; i++){
      if(symLines[i] != null){
	Point2 p = symLines[i][0];
	double t = m00*p.x + m01*p.y;
	p.y = m10*p.x + m11*p.y;
	p.x = t;
	p = symLines[i][1];
	t = m00*p.x + m01*p.y;
	p.y = m10*p.x + m11*p.y;
	p.x = t;
      }
    }

    if(symAxes != null){
      for(int i =0; i < symAxes.length; i++){
	if(symAxes[i] != null){
	  Point2 p = symAxes[i];
	  double t = m00*p.x + m01*p.y;
	  p.y = m10*p.x + m11*p.y;
	  p.x = t;
	}
      }
    }    
  }

  
  /**
    rotateMatrix

   */
  void rotate_matrix(double [][]matrix){
    
    double m00 = matrix[0][0];
    double m01 = matrix[0][1];
    double m10 = matrix[1][0];
    double m11 = matrix[1][1];
    double cm00 = current_matrix[0][0];
    double cm01 = current_matrix[0][1];
    double cm10 = current_matrix[1][0];
    double cm11 = current_matrix[1][1];

    current_matrix[0][0] = m00*cm00 + m01*cm10;
    current_matrix[0][1] = m00*cm01 + m01*cm11;
    current_matrix[1][0] = m10*cm00 + m11*cm10;
    current_matrix[1][1] = m10*cm01 + m11*cm11;
  }


  PopupMenu makeCellSelectionPopup(){
    //Font mf = new Font("Monospaced",Font.PLAIN,10);
    PopupMenu menu = new PopupMenu("Select Cell");
    //menu.setFont(mf);    
    MenuItem mi;
    mi = new MenuItem("toggle bottom cell     (Click)");   
    //mi.setFont(mf);
    mi.addActionListener(new ToggleBottomCellAction());
    menu.add(mi); 

    mi = new MenuItem("toggle top cell          (Alt+Click)");   
    mi.addActionListener(new ToggleTopCellAction());
    //mi.setFont(mf);
    menu.add(mi);
    mi = new MenuItem("toggle supp. cells    (Ctrl+Click)");   
    mi.addActionListener(new ToggleSupportingCellsAction());
    //mi.setFont(mf);
    menu.add(mi);
    mi = new MenuItem("add supp. cells        (Shift+Click) ");   
    mi.addActionListener(new AddSupportingCellsAction());
    //mi.setFont(mf);
    menu.add(mi);
    mi = new MenuItem("subtract supp. cells (Ctrl+Shift+Click) ");   
    mi.addActionListener(new SubSupportingCellsAction());
    //mi.setFont(mf);
    menu.add(mi);    
    return menu;
  }

  class SubSupportingCellsAction implements ActionListener {
    public void actionPerformed(ActionEvent e){
	if(oldPolyIndex  >=0 ){
	  int[] arg = new int[2];	
	  arg[0] = oldPolyIndex;
	  arg[1] = SUB_SUPPORTING_CELLS;
	  observer.update(this,arg);
	}
    }
  }
  public static final int SUB_SUPPORTING_CELLS=0,ADD_SUPPORTING_CELLS=1,TOGGLE_SUPPORTING_CELLS=2,
    TOGGLE_TOP_CELL=3,TOGGLE_BOTTOM_CELL=4;

  class AddSupportingCellsAction implements ActionListener {
    public void actionPerformed(ActionEvent e){
	if(menuActionPoly  >=0 ){
	  int[] arg = new int[2];	
	  arg[0] = menuActionPoly;
	  arg[1] = ADD_SUPPORTING_CELLS;
	  observer.update(this,arg);
	}
    }
  }
  class ToggleSupportingCellsAction implements ActionListener {
    public void actionPerformed(ActionEvent e){
	if(menuActionPoly  >=0 ){
	  int[] arg = new int[2];	
	  arg[0] = menuActionPoly;
	  arg[1] = TOGGLE_SUPPORTING_CELLS;
	  observer.update(this,arg);
	}
    }
  }
  class ToggleTopCellAction implements ActionListener {
    public void actionPerformed(ActionEvent e){
	if(menuActionPoly  >=0 ){
	  int[] arg = new int[2];	
	  arg[0] = menuActionPoly;
	  arg[1] = TOGGLE_TOP_CELL;
	  observer.update(this,arg);
	}
    }
  }
  class ToggleBottomCellAction implements ActionListener {
    public void actionPerformed(ActionEvent e){
	if(menuActionPoly  >=0 ){
	  int[] arg = new int[2];	
	  arg[0] = menuActionPoly;
	  arg[1] = TOGGLE_BOTTOM_CELL;
	  observer.update(this,arg);
	}
    }
  }

  int oldPolyIndex = -1;
  int menuActionPoly = -1;

  class CanvasMouseMotionListener extends MouseMotionAdapter {

    public void mouseMoved(MouseEvent e){
      /*
      int x = e.getX();
      int y = e.getY();
      Point2 point = g2d.screen2world( x, y); 
      //int polyIndex = findPoly(point);

      //System.out.println(polyIndex);
      
      //Graphics g = canvas.getGraphics();
      //g.setXORMode(Color.white);
      //g.setXORMode(Color.green);
      //g.setColor(Color.lightGray);
      if(polyIndex == oldPolyIndex)
	return;
      if(oldPolyIndex >= 0){
	// remove old poly
	//drawSelectionPoly(g,oldPolyIndex);
      }
      if(polyIndex  >=0 ){
	// draw new poly 
	//drawSelectionPoly(g,polyIndex);
      }
      oldPolyIndex = polyIndex;      
      */
    }
    
  }

  class CanvasMouseListener extends MouseAdapter {

    public void mouseReleased(MouseEvent e){
      //System.out.println(e);
      if((e.getModifiers() & e.BUTTON3_MASK) == 0){
	return;
      }
      
      int x = e.getX();
      int y = e.getY();
      Point2 point = g2d.screen2world( x, y); 
      int poly = findPoly(point);
      if(poly < 0)
	return;
      menuActionPoly = poly;
      cellSelectionPopup.show(canvas,x,y);
    }
    
    public void mousePressed(MouseEvent e){
      
      if ((e.getModifiers() & e.BUTTON1_MASK) == 0)
	return;
      
      int x = e.getX();
      int y = e.getY();
    
      if(observer != null){
	Point2 point = g2d.screen2world( x, y); 
	int poly = findPoly(point);
	if(poly  >=0 ){
	  int[] arg = new int[2];	
	  arg[0] = poly;
	  if((e.getModifiers() & e.CTRL_MASK) != 0){
	    if((e.getModifiers() & e.SHIFT_MASK) != 0){
	      arg[1] = SUB_SUPPORTING_CELLS;
	    } else {
	      arg[1] = TOGGLE_SUPPORTING_CELLS;	      
	    }
	  } else if((e.getModifiers() & e.SHIFT_MASK) != 0){
	      arg[1] = ADD_SUPPORTING_CELLS;	      	    
	  } else {
	    if((e.getModifiers() & e.ALT_MASK) != 0){
	      arg[1] = TOGGLE_TOP_CELL; 
	    } else {
	      arg[1] = TOGGLE_BOTTOM_CELL; 
	    }
	  }
	  observer.update(this,arg);
	}
      }
      return ;
    }
  }
  
  double shiftSpeed = 0.025;
  double zoomSpeed = 1.025;

  public void zoomIn(){
    Width /= zoomSpeed;    
    canvas.repaint();
  }

  public void zoomIn(double zoom){
    Width /= zoom;    
    canvas.repaint();
  }

  public void zoomOut(){
    Width *= zoomSpeed;    
    canvas.repaint();
  }

  public void zoomOut(double zoom){
    Width *= zoom;    
    canvas.repaint();
  }

  public void shiftLeft(){
    centerX += Width*shiftSpeed;
    canvas.repaint();
    
  }

  public void shiftRight(){
    centerX -= Width*shiftSpeed;
    canvas.repaint();
  }

  public void shiftUp(){
    centerY -= Width*shiftSpeed;
    canvas.repaint();
    
  }

  public void shiftDown(){
    centerY += Width*shiftSpeed;
    canvas.repaint();
  }

  /**
    findPoly 
    
    search for polygon, which has center nearest to the point
   */
  int findPoly(Point2 point){
    
    // first we need to test old selected oldPolyIndex
    if(oldPolyIndex >= 0 && oldPolyIndex < fpoly.length){
      if(isInsidePolygon(fpoly[oldPolyIndex],point)){
        return oldPolyIndex;
      }
    }
    for(int i=0; i < fpoly.length; i++){
      if(isInsidePolygon(fpoly[i],point)){
	//oldPolyIndex = i;
	return i;
      }	
    }
    return -1;
    /*
    int index = 0;
    if(centers.length <= 0)
      return -1;
    double dist = centers[0].distance2(point);
    for(int i = 1; i < centers.length; i++){
      double d = centers[i].distance2(point);
      //System.out.println("point: " + centers[i].x + "," + centers[i].y + ": " + d);
      if( d < dist ){
	index = i;
	dist = d;
      }
    }
    //System.out.println("index: " + index);
    return index;
    */
  }

  public Frame getFrame(){
    Component comp = this;
    while(comp != null){
      comp = comp.getParent();
      if(comp instanceof Frame)
	return (Frame)comp;
    }
    return null;
  }

  class KeyListenerClass extends KeyAdapter {

    /**
       keyUp
       
    */
    public void keyTyped(KeyEvent e){

      switch(e.getKeyChar()){
      case 'P':
      case 'p':
	doPrint();
	break;
      }
      
      return;
    }
  }

  Thread thread;

  FileDialog fileDialog; 
  String psName = "stellation.ps";

  public void run(){

    try {

      OutputStream f = null;
      try{
	if(fileDialog == null){
	  fileDialog = new FileDialog(WindowUtils.getFrame(this), psName, FileDialog.SAVE);
	}
	fileDialog.show();
	if(fileDialog.getFile() == null)
	  return;
	psName = fileDialog.getFile();
	String psDir = fileDialog.getDirectory();
	
	String fileName = psDir + psName;

	File file = new File(fileName);
	f = new FileOutputStream(file);
	Stellation.Out.println("printing diagram to file " + fileName);
      } catch(Exception e){
	f = System.out;
	System.out.println("---------start of PS");
	Stellation.Out.println("printing diagram to java console" );
      }
      GraphicsPS ps = new GraphicsPS(f, getGraphics());
      // paint our canvas
      this.paintCanvas(ps, ps.getWidth(), ps.getHeight());
      ps.flush(); // important - adds showpage to end of file      
      if(f != System.out){
	f.close();
      } else {
	System.out.println("---------end of PS");
      }
    } catch (Exception e){
      //System.out.printStackTrace("Can't print diagram");
    }
  }

  void doPrint(){
    if(thread != null && thread.isAlive()){
      //thread.stop();
    }
    thread = new Thread(this);
    thread.setPriority(Thread.MIN_PRIORITY); 
    thread.start();  
  }    

  class SCanvas extends Canvas {

    public void update(Graphics g){
      paint(g);
    }
    public void paint(Graphics g){
      paintCanvas(g);
    }
    public Dimension getPreferredSize(){
      return new Dimension(300,300);
    }
  }
  
  class SymLinesListener implements ItemListener {

    public void itemStateChanged(ItemEvent e){
      if(e.getStateChange() == ItemEvent.SELECTED){
	drawSymmetryLines = true;
      } else {
	drawSymmetryLines = false;	
      }
      canvas.repaint();
    }
  }

  class SymAxesListener implements ItemListener {

    public void itemStateChanged(ItemEvent e){
      if(e.getStateChange() == ItemEvent.SELECTED){
	drawSymmetryAxes = true;
      } else {
	drawSymmetryAxes = false;	
      }
      canvas.repaint();
    }
  }

  class ZoomInListener extends MouseAdapter implements EventCallback, TimeoutCallback{

    boolean mouseDown = false;
    Timeout timeout;

    public void mousePressed(MouseEvent e){

      mouseDown = true;
      zoomIn();
      // make delay before autorepeat 
      timeout = new Timeout(300, this, null);

    }

    public void mouseReleased(MouseEvent e){

      mouseDown = false;
      eventCallback = null;
      timeout.stop();
    }

    public void processEventCallback(Object who, Object what){
      if(mouseDown){
	eventCallback = this;       
	zoomIn();
      }
    }

    public void timeoutCallback(Object userData){

      if(mouseDown){

	eventCallback = this;       
	zoomIn();
      }
    }


  }

  class ZoomOutListener extends MouseAdapter  implements EventCallback, TimeoutCallback {

    boolean mouseDown = false;
    Timeout timeout;

    public void mousePressed(MouseEvent e){
      mouseDown = true;
      zoomOut();
      // make delay before autorepeat 
      timeout = new Timeout(300, this, null);

    }

    public void mouseReleased(MouseEvent e){

      mouseDown = false;
      eventCallback = null;
      timeout.stop();

    }

    public void timeoutCallback(Object userData){

      if(mouseDown){

	eventCallback = this;       
	zoomOut();
      }
    }

    public void processEventCallback(Object who, Object what){
      if(mouseDown){
	eventCallback = this;       
	zoomOut();
      }
    }

  }

  class UpListener extends MouseAdapter   implements EventCallback, TimeoutCallback {

    boolean mouseDown = false;
    Timeout timeout;

    public void mousePressed(MouseEvent e){
      mouseDown = true;
      shiftUp();
      // make delay before autorepeat 
      timeout = new Timeout(300, this, null);

    }

    public void mouseReleased(MouseEvent e){

      mouseDown = false;
      eventCallback = null;
      timeout.stop();

    }

    public void timeoutCallback(Object userData){

      if(mouseDown){

	eventCallback = this;       
	shiftUp();
      }
    }

    public void processEventCallback(Object who, Object what){
      if(mouseDown){
	eventCallback = this;       
	shiftUp();
      }
    }

  }

  class DownListener extends MouseAdapter    implements EventCallback, TimeoutCallback {

    boolean mouseDown = false;
    Timeout timeout;

    public void mousePressed(MouseEvent e){
      mouseDown = true;
      shiftDown();
      // make delay before autorepeat 
      timeout = new Timeout(300, this, null);

    }

    public void mouseReleased(MouseEvent e){

      mouseDown = false;
      eventCallback = null;
      timeout.stop();

    }

    public void timeoutCallback(Object userData){

      if(mouseDown){

	eventCallback = this;       
	shiftDown();
      }
    }

    public void processEventCallback(Object who, Object what){
      if(mouseDown){
	eventCallback = this;       
	shiftDown();
      }
    }
  }

  class LeftListener extends MouseAdapter   implements EventCallback, TimeoutCallback{
    boolean mouseDown = false;
    Timeout timeout;

    public void mousePressed(MouseEvent e){
      mouseDown = true;
      shiftLeft();
      // make delay before autorepeat 
      timeout = new Timeout(300, this, null);

    }

    public void mouseReleased(MouseEvent e){

      mouseDown = false;
      eventCallback = null;
      timeout.stop();

    }

    public void timeoutCallback(Object userData){

      if(mouseDown){

	eventCallback = this;       
	shiftLeft();
      }
    }

    public void processEventCallback(Object who, Object what){
      if(mouseDown){
	eventCallback = this;       
	shiftLeft();
      }
    }

  }

  class RightListener extends MouseAdapter   implements EventCallback, TimeoutCallback{

    boolean mouseDown = false;
    Timeout timeout;

    public void mousePressed(MouseEvent e){
      mouseDown = true;
      shiftRight();
      // make delay before autorepeat 
      timeout = new Timeout(300, this, null);

    }

    public void mouseReleased(MouseEvent e){

      mouseDown = false;
      eventCallback = null;
      timeout.stop();

    }

    public void timeoutCallback(Object userData){

      if(mouseDown){

	eventCallback = this;       
	shiftRight();
      }
    }

    public void processEventCallback(Object who, Object what){
      if(mouseDown){
	eventCallback = this;       
	shiftRight();
      }
    }
  }

  /**
   *  class RotateLeftListener
   *
   */
  class RotateLeftListener extends MouseAdapter  implements EventCallback, TimeoutCallback{

    boolean mouseDown = false;
    Timeout timeout;
    int rotationSpeed = 0;

    public void mousePressed(MouseEvent e){

      mouseDown = true;
      if(e.isShiftDown()){
	rotationSpeed = 2;
      } else if(e.isControlDown()){
	rotationSpeed = 0;
      } else {
	rotationSpeed = 1;
      }
      doRotation();
      // make delay before autorepeat 
      timeout = new Timeout(300, this, null);
    }

    public void mouseReleased(MouseEvent e){

      mouseDown = false;
      eventCallback = null;
      timeout.stop();

    }

    public void timeoutCallback(Object userData){

      if(mouseDown){
	eventCallback = this;  
	doRotation();
      }
    }

    public void processEventCallback(Object who, Object what){
      if(mouseDown){
	eventCallback = this;       
	doRotation();
      }
    }

    void doRotation(){
      
      switch(rotationSpeed){
	case 2: 
	rotate(matrix_ccw2); // fast
	Angle -= AngleFast;
	break;
      case 0:
	rotate(matrix_ccw0); // slow
	Angle -= AngleSlow;
	break;
      case 1: 
	rotate(matrix_ccw1); // normal 
	Angle -= AngleNormal;
	break;
      }
      canvas.repaint();
    } 
  }

  /**
   *   class RotateRightListener
   *
   */
  class RotateRightListener extends MouseAdapter  implements EventCallback, TimeoutCallback{

    boolean mouseDown = false;
    Timeout timeout;
    int rotationSpeed = 0;

    public void mousePressed(MouseEvent e){

      mouseDown = true;
      if(e.isShiftDown()){
	rotationSpeed = 2;
      } else if(e.isControlDown()){
	rotationSpeed = 0;
      } else {
	rotationSpeed = 1;
      }
      doRotation();
      // make delay before autorepeat 
      timeout = new Timeout(300, this, null);

    }

    public void mouseReleased(MouseEvent e){

      mouseDown = false;
      eventCallback = null;
      timeout.stop();

    }

    public void timeoutCallback(Object userData){

      if(mouseDown){
	eventCallback = this;  
	doRotation();
      }
    }

    public void processEventCallback(Object who, Object what){
      if(mouseDown){
	eventCallback = this;       
	doRotation();
      }
    }

    void doRotation(){
      
      switch(rotationSpeed){
	case 2: 
	rotate(matrix_cw2); // fast
	Angle += AngleFast;
	break;
      case 0:
	rotate(matrix_cw0); // slow
	Angle += AngleSlow;
	break;
      case 1: 
	rotate(matrix_cw1); // normal 
	Angle += AngleNormal;
	break;
      }
      canvas.repaint();
    } 

  }


  class SBHorizontalAdjustmentListener implements AdjustmentListener {

    public void adjustmentValueChanged(AdjustmentEvent e){

      
      int x = e.getValue();
      centerX = 0.5*polyDiameter*(1 - 2. * x / (sbMaximum - sbVisible));
      canvas.repaint();      
      //System.out.println("centerX " + centerX);

    }
  }

  class SBVerticalAdjustmentListener implements AdjustmentListener {

    public void adjustmentValueChanged(AdjustmentEvent e){

      int y = e.getValue();

      centerY  = 0.5*polyDiameter*(2.*y/(sbMaximum - sbVisible) -1);      
      //centerY = 0.5*polyDiameter*(1 - 2. * (sbMaximum-y) / (sbMaximum - sbVisible));
      canvas.repaint();
      //System.out.println("centerY " + centerY);

    }
  }

  static private GridBagConstraints gbc = new GridBagConstraints();


  static double MIN(double x,double y) {
    return (x < y ? x : y);
  }

  static double MAX(double x, double y) {
    return (x > y ? x : y);
  }

  
  // determines if point p lies inside of polygon 
  // for selfintersection polygons it will use 
  // even-od rule
  static boolean isInsidePolygon(Point2 [] polygon, Point2 p) {
    
    int cnt = 0;
    
    Point2 pnt1 = polygon[polygon.length-1];
    
    for (int i=0; i < polygon.length;i++) {
      
      Point2 pnt2 = polygon[i];    
      if (p.y > MIN(pnt1.y,pnt2.y)) {
	if (p.y <= MAX(pnt1.y,pnt2.y)) {
	  if (p.x <= MAX(pnt1.x,pnt2.x)) {
	    if (pnt1.y != pnt2.y) {
	      double xinters = 
		(p.y-pnt1.y)*(pnt2.x-pnt1.x)/(pnt2.y-pnt1.y)+pnt1.x;
	      if (pnt1.x == pnt2.x || p.x <= xinters)
		cnt++;
	    }
	  }
	}
      }   
      pnt1 = pnt2;
      
    }
    
    if (cnt % 2 == 0)
      return false; //(OUTSIDE);
    else
      return true; //(INSIDE);
  }  


}
