/**
 *
 * Author: Daeron Meyer
 * Copyright (c) 1995 by The Geometry Center, University of Minnesota
 * Distributed under the terms of the GNU Library General Public License
 * 12-14-95
 *
 */

import java.applet.Applet;
import java.awt.Image;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Event;
import java.lang.*;
import java.io.InputStream;
import java.net.URL;

/**
 *  Viewer3D: An applet that displays and rotates a 3D OFF object
 *            interactively, in response to user mouse events.
 */

public class Viewer3D extends Applet {

  OOGL_OFF	obj;
  boolean	painted = true;
  String	objname = null,
		message = null;
  double		xfac, scaleval = 0.1f;
  Matrix3D	amat = new Matrix3D(),
		tmat = new Matrix3D();

  Image		bbuffer;
  Graphics	bgc;
  int		prevx, prevy;
  

  public void init() {

    objname = null;
    objname = getParameter("model");			// get the object name
    if (objname == null) objname = "models/chemi.off";

    try {
      scaleval = Float.valueOf(getParameter("scale")).doubleValue() * 0.1f;
    } catch (Exception e) { };

    amat.yrot(20);					// set initial rotation
    amat.xrot(20);

    resize(size().width <=20 ? 400 : size().width,
	   size().height <= 20 ? 400 : size().height);

  }
  
  public void start() {

    try {

      OOGL_OFF x = new OOGL_OFF (new URL(getDocumentBase(), objname));
							// read object from URL
      obj = x;
      obj.findBB();					// find bounding box
      double xw = obj.xmax - obj.xmin;			// so we can scale
      double yw = obj.ymax - obj.ymin;			// the object to fit
      double zw = obj.zmax - obj.zmin;			// in our window
      if (yw > xw) xw = yw;
      if (zw > xw) xw = zw;
      double f1 = 250 / xw;
      double f2 = 250 / xw;
      xfac = 0.7f * (f1 < f2 ? f1 : f2) * scaleval;

    } catch(Exception e) {
      obj = null;
      message = e.toString();
    }

    repaint();

  }


/* handle mouse events */

  public boolean mouseDown(Event e, int x, int y) {

    prevx = x;
    prevy = y;
    return true;

  }

  public boolean mouseDrag(Event e, int x, int y) {

    tmat.unit();
    double xtheta = (prevy - y) * 360.0f / size().width;
    double ytheta = (prevx - x) * 360.0f / size().height;
    tmat.xrot(xtheta);
    tmat.yrot(ytheta);
    amat.mul(tmat);

    //if (painted) {

    //  painted = false;
      repaint();

    //}

    prevx = x; prevy = y;
    return true;

  }

  public void update(Graphics g) {

    if (bbuffer == null)
      g.clearRect(0, 0, size().width, size().height);

    paint(g);

  }

  void allocBBuffer(){
    bbuffer = createImage(size().width, size().height);
    bgc = bbuffer.getGraphics();			// create image to do
							// double buffering
  }
/* transform and paint the object to the graphics context */

  public void paint(Graphics g) {
    if(bbuffer == null || 
       bbuffer.getHeight(null) != size().height || 
       bbuffer.getWidth(null) != size().width){
      allocBBuffer();      
    }


    if (obj != null) {

      obj.mat.unit();
      obj.mat.translate(-(obj.xmin + obj.xmax) / 2,
			-(obj.ymin + obj.ymax) / 2,
			-(obj.zmin + obj.zmax) / 2);
      obj.mat.mul(amat);

      int scale = (int)( xfac * size().width / 25 );

//      obj.mat.scale(scale, scale, 16 * xfac / size().width);
      obj.mat.scale(scale, scale, scale);
      obj.mat.translate(size().width / 2, size().height / 2, 0);
      obj.transformed = false;

      if (bbuffer != null) {

        bgc.setColor(getBackground());
        bgc.fillRect(0,0,size().width,size().height);
        obj.paint(bgc);
        g.drawImage(bbuffer, 0, 0, this);

      } else
          obj.paint(g);

      //setPainted();

    } else if (message != null)
      g.drawString("Error reading OFF file", 3, 20);

  }

  private synchronized void setPainted() {

    painted = true;
    notifyAll();

  }

}
