package PVS.g3d;

import java.awt.Graphics;
import java.awt.Color;
import java.lang.*;

/**
 *  class IndexedFaceSet: a class for rendering IndexedFaceSet
 */

public class IndexedFaceSet implements Cloneable{

  Vector faces;	   // array of faces
  Vector vert;     // array of vertices
  
  public double	xmin, xmax,			// bounding box parameters
		ymin, ymax,
		zmin, zmax;


  public IndexedFaceSet() {
  }

  void initNormals(){
    normals = new Vec3[nfaces];    
    tnormals = new Vec3[nfaces];
    

    for (int f = 0; f < nfaces; f++) {

      Face facei = face[f];
      int nv = facei.nverts;
       
      int [] index = facei.index;

      int v0 = index[0], v1 = index[1], v2 = index[2];
      Vec3 vec0 = new Vec3(vert[v1]-vert[v0], 
			   vert[v1+1]-vert[v0+1], vert[v1+2]-vert[v0+2]);
      Vec3 vec1 = new Vec3(vert[v2]-vert[v1], 
			   vert[v2+1]-vert[v1+1], vert[v2+2]-vert[v1+2]);
      Vec3 norm = Vec3.cross(vec1,vec0);
      norm.normalize();
      normals[f] = norm;
      tnormals[f] = new Vec3();
    }    
  }
    

/* transform all points in model */

  public void transform() {

    if (transformed || nverts <= 0)
      return;

    if (tvert == null)
      tvert = new int[nverts*3];

    mat.transform(vert, tvert, nverts);
    mat.transform(normals, tnormals, nfaces);
    //    System.out.println(mat);

    for(int i=0; i<nfaces; i++){
      tnormals[i].normalize();
    }

    transformed = true;
  }


/**
 *  The quick sort algorithm in this method is used for sorting faces
 *  from back to front by z depth values.
 */

  void qs(int left, int right) {

    int		i, j, x, y;

    i = left; j = right;
    x = face[findex[(left+right)/2]].zdepth;

    do {

      while (face[findex[i]].zdepth > x && i < right) i++;
      while (x > face[findex[j]].zdepth && j > left) j--;

      if (i <= j) {
	y = findex[i];
	findex[i] = findex[j];
	findex[j] = y;
	i++; j--;
      }

    } while (i <= j);

    if (left < j) qs(left, j);
    if (i < right) qs(i, right);

  }

  /** 
    Make shadow color
    */
  
  public Color makeColor(Color c,Vec3 normal){
    double dot = Vec3.dot(light,normal);
    //System.out.println(light + "," + normal + ", "+ dot );
    if(dot < 0.){ // we are looking from opposite side
      return c;
    } else {
      dot *= dot;//dot *= dot;
      Color col = 
	new Color(Math.min(255,(int)(c.getRed()+
				     dot*light_color.getRed())),
		  Math.min(255,(int)(c.getGreen()+
				     dot*light_color.getGreen())),
		  Math.min(255,(int)(c.getBlue()+
				     dot*light_color.getBlue())));
      //System.out.println(dot + ":"+col);
      return col;
    }
  }

  /**
    Paint myself to the graphics context. 
    */
  
  public void paint(Graphics g) {

    if (vert == null || nverts <= 0)
      return;
    transform();
    if (gr == null) {  // allocate colors if they haven't been allocated already
      gr = new Color[nfaces];		     
      for (int i = 0; i < nfaces; i++) {
 	gr[i] = new Color(face[i].cr, face[i].cg, face[i].cb);
      }
    }

/**
 *  Calculate the average z depth of faces and use this to sort them.
 *  This is called the "Painter's algorithm" and although it works in
 *  some case, does *not* always provide a correct ordering. Sometimes
 *  a correct ordering is impossible, especially in the case of mutually
 *  overlapping polygons.
 */

    for (int i = 0; i < nfaces; i++) {

      face[i].zdepth = 0;
      Face facei = face[i];
      int nv = facei.nverts;    
      int[] index = facei.index;
      for (int c = 0; c < nv; c++) {
	facei.zdepth += tvert[index[c]+2];
      }
      facei.zdepth /=  facei.nverts;
    }

    qs(0, nfaces-1);					// quick sort the faces

    for (int f = 0; f < nfaces; f++) {

      int i = findex[f];
      int v = 0;
      
      Face facei = face[i];
      int nv = facei.nverts;
      
      int [] index = facei.index;
      
      for (int c = 0; c < nv; c++) {
	int vi = index[c]; vx[c] = tvert[vi++]; vy[c] = tvert[vi];
      }

      Color c = makeColor(gr[i],tnormals[i]);

      g.setColor(c);
      g.fillPolygon(vx, vy, nv);		// draw each face
      
      g.setColor(Color.black);
      nv -= 1;
      for (v = 0; v < nv; v++) { // each line is drawn usually twice 
	g.drawLine(vx[v], vy[v], vx[v+1], vy[v+1]);	// draw the face edges
      }
      g.drawLine(vx[v], vy[v], vx[0], vy[0]);
      
    }

  }

  /** 
    calculate the bounding box of our object: 
    */

  void findBB() {
    
    if (nverts <= 0)
      return;
    
    double v[] = vert;
    double xmin = v[0], xmax = xmin;
    double ymin = v[1], ymax = ymin;
    double zmin = v[2], zmax = zmin;
    
    for (int i = nverts * 3; (i -= 3) > 0;) {
      
      double x = v[i];
      if (x < xmin)
	xmin = x;
      if (x > xmax)
	xmax = x;
      double y = v[i + 1];
      if (y < ymin)
	ymin = y;
      if (y > ymax)
	ymax = y;
      double z = v[i + 2];
      if (z < zmin)
	zmin = z;
      if (z > zmax)
	zmax = z;
      
    }

    this.xmax = xmax;
    this.xmin = xmin;
    this.ymax = ymax;
    this.ymin = ymin;
    this.zmax = zmax;
    this.zmin = zmin;

  }


  public Object clone(){

  }
}
