package PVS.Utils;


import java.io.*;
import java.awt.*;
import java.awt.event.*;


/**
 * 
 */
class MyFrame extends Frame {

  public MyFrame(String title) { 
    super(title); 
  }

  protected void processEvent(AWTEvent e){

    switch (e.getID()) {
    case Event.WINDOW_DESTROY: 
      this.setVisible(false);  
      break;
    }
    super.processEvent(e);
  }
}

/**
 * 
 */
public class WindowOutputStream extends OutputStream {
  
   Frame myFrame;
   TextArea ta;
   StringBuffer sb = new StringBuffer();

  public WindowOutputStream() {
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int swidth = d.width;
    int sheight = d.height;
    
    int width = swidth/3;
    int height = sheight/3;
    myFrame = new MyFrame("Debug Output");      
    Font f = new Font("Courier", Font.PLAIN, 12);
    myFrame.setFont(f);
    ta = new TextArea(24, 80);
    ta.setEditable(true);
    myFrame.add("Center", ta);
    Button btnClear = new Button("Clear");
    btnClear.addActionListener(new ClearListener());
    myFrame.add("South", btnClear);
    myFrame.pack();
    /*
    myFrame.setSize(width, height);
    myFrame.setLocation(swidth-width, sheight-height-20);
    */
    myFrame.show();  
  }
  
    public WindowOutputStream(TextArea textarea) {
      ta = textarea;
    }

    public void write(int b) throws IOException {

        sb.append((char) b);
        if (b == '\n') {
            ta.append(sb.toString());
            sb.setLength(0);
        }
    }

    public void write(byte b[], int off, int len) throws IOException {

        for (int i = 0; i < len; i++) {
            write((char) b[i+off]);
        }
    }

    public void write(byte b[]) throws IOException {
        for (int i = 0; i < b.length; i++) {
            write((char) b[i]);
        }
    }

  public void flush(){
    ta.append(sb.toString());
    sb.setLength(0);    
  }

  public void clear(){
    ta.setText("");
  }
  
  public void shutdown(){
    myFrame.setVisible(false);  
    myFrame.dispose();
  }
  
  public Frame getFrame(){
    return myFrame;
  }

  class ClearListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      clear();
    }
  }

}
