package PVS.Expression;


import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.net.URL;
import java.applet.*;


import PVS.polyhedra.Vector3D;
import PVS.Utils.*;
import PVS.Expression.*;


public class VectorCalculator {
  

  public VectorCalculator(){

    makeUI();
    
  }

  public void show(){
    frame.show();
  }

  Frame frame;

  static final int MAXVECTORS = 2;

  TextField tfVectors[] = new TextField[MAXVECTORS];

  TextArea textArea = new TextArea(24,80);

  WindowOutputStream winStream ;
  PrintStream out;
  TextField tfAngle = new TextField(17);
  Choice cDegree = new Choice();

  Parser parser;

  double angle;
  Vector3D vectors[] = new Vector3D[MAXVECTORS];

  /**
     
   */
  void makeUI(){

    frame = new Frame("Vector Calculator");
    frame.setBackground(Color.lightGray);

    winStream = new WindowOutputStream(textArea);
    out = new PrintStream(winStream);

    GridBagLayout gb = new GridBagLayout();
    frame.setLayout(gb);

    Panel panel1 = new Panel();
    panel1.setLayout(gb);

    for(int i =0; i < MAXVECTORS; i++){

      tfVectors[i] = new TextField(17);

      WindowUtils.constrain(panel1,new Label("v"+(i+1)),0,i,1,1, gbc.NONE, gbc.CENTER,0.,0.);
      WindowUtils.constrain(panel1,tfVectors[i],        1,i,2,1, gbc.HORIZONTAL, gbc.NORTH,1.,0.);
      
    }

    cDegree.addItem("degree");
    cDegree.addItem("radians");
    
    WindowUtils.constrain(panel1,new Label("angle"), 0,MAXVECTORS+1,1,1, gbc.HORIZONTAL, gbc.NORTH,0.,0.);
    WindowUtils.constrain(panel1,tfAngle,            1,MAXVECTORS+1,1,1, gbc.HORIZONTAL, gbc.NORTH,1.,0.);
    WindowUtils.constrain(panel1,cDegree,            2,MAXVECTORS+1,1,1, gbc.NONE, gbc.WEST,0.,0.);    

    
    Panel panelBtn = new Panel();
    
    Button btnDot = new Button("Dot(v1.v2)"); 
    btnDot.addActionListener(new onDot());
    Button btnCross = new Button("Cross(v1, v2)");
    btnCross.addActionListener(new onCross());
    Button btnAngle = new Button("Angle(v1, v2)");
    btnAngle.addActionListener(new onAngle());
    Button btnNormal = new Button("Normalize(v)");
    btnNormal.addActionListener(new onNormal());
    Button btnRotate = new Button("Rot(v1,v2,angle)");
    btnRotate.addActionListener(new onRotate());
    Button btnLength = new Button("Length(v)");
    btnLength.addActionListener(new onLength());
    Button btnClear = new Button("Clear");
    btnClear.addActionListener(new onClear());

    panelBtn.setLayout(gb);
    int c = 0;
    WindowUtils.constrain(panelBtn,btnDot,    c++,0,1,1,gbc.HORIZONTAL, gbc.NORTH,1.,0.,3,3,3,3);
    WindowUtils.constrain(panelBtn,btnCross,  c++,0,1,1,gbc.HORIZONTAL, gbc.NORTH,1.,0.,3,3,3,3);
    WindowUtils.constrain(panelBtn,btnAngle,  c++,0,1,1,gbc.HORIZONTAL, gbc.NORTH,1.,0.,3,3,3,3);
    WindowUtils.constrain(panelBtn,btnNormal, c++,0,1,1,gbc.HORIZONTAL, gbc.NORTH,1.,0.,3,3,3,3);
    WindowUtils.constrain(panelBtn,btnRotate, c++,0,1,1,gbc.HORIZONTAL, gbc.NORTH,1.,0.,3,3,3,3);
    WindowUtils.constrain(panelBtn,btnLength, c++,0,1,1,gbc.HORIZONTAL, gbc.NORTH,1.,0.,3,3,3,3);
    WindowUtils.constrain(panelBtn,btnClear,  c++,0,1,1,gbc.HORIZONTAL, gbc.NORTH,1.,0.,3,3,3,3);


    WindowUtils.constrain(frame,panel1,0,0,1,1,gbc.HORIZONTAL, gbc.NORTH,1.,0.);
    WindowUtils.constrain(frame,textArea,0,1,1,1,gbc.BOTH, gbc.NORTH,1.,1.,3,6,3,0);    
    WindowUtils.constrain(frame,panelBtn,0,2,1,1,gbc.NONE, gbc.CENTER,0.,0.,3,3,3,3);    
    
    frame.addWindowListener(new CloseWindowListener());
    
    frame.pack();
    frame.validate();

    textArea.setEditable(true);
    
  }


  public double calculate(String s){

    double result = 0;
    try {
      Expr expr = parser.parse (s);
      Variable g = expr.getVariable ("g");
      g.setValue((Math.sqrt(5)+1)/2);

      Variable pi = expr.getVariable ("pi");
      pi.setValue(Math.PI);

      result = expr.value();

    } catch(Exception e){
      System.out.println("Exception during calculating " + s);
    }

    return result;
  }

  void getData(){

    parser = new Parser();

    for(int i =0; i < MAXVECTORS; i++){      
      
      String txt = tfVectors[i].getText();
      StringTokenizer st= new StringTokenizer(txt,",");
      int cnt = 0;
      String[] tt = new String[3];
      while(st.hasMoreTokens()){
	tt[cnt++] = st.nextToken();
      }
      double x = 0, y = 0, z = 0;
      if(tt[0] != null)
	x = calculate(tt[0]);
      if(tt[1] != null)
	y = calculate(tt[1]);
      if(tt[2] != null)
	z = calculate(tt[2]);
      vectors[i] = new Vector3D(x,y,z);
      out.println("v"+(i+1)+": " + vectors[i].x + ", "+vectors[i].y +", "+vectors[i].z);
    }

    boolean degree = cDegree.getSelectedIndex() == 0;    
    angle = 0;
    String ta = tfAngle.getText();
    if(ta.length() > 0){
      double a = calculate(ta);
      if(degree)
	angle = a *(Math.PI/180);
      else 
	angle = a;
    }
    out.println("angle:" + angle);

  }

  class onDot implements ActionListener {

    public void actionPerformed(ActionEvent e){
      getData();
      double dot = vectors[0].dot(vectors[1]);
      out.println("Dot(v1,v2) = " + round(dot));
    }
  }
  class onCross implements ActionListener {

    public void actionPerformed(ActionEvent e){
      getData();
      Vector3D v = vectors[0].cross(vectors[1]);
      out.println("Cross(v1,v2) = " + round(v.x) + ", "  + round(v.y) + ", "  + round(v.z) );
      
    }
  }
  class onAngle implements ActionListener {

    public void actionPerformed(ActionEvent e){
      
      getData();
      vectors[0].normalize();
      vectors[1].normalize();
      double cos = vectors[0].dot(vectors[1]);
      double sin = vectors[0].cross(vectors[1]).length();
      double a = Math.atan2(sin,cos);
      double deg = (int)(a*1800/Math.PI + 0.5)/10.0;
      out.println("Angle(v1, v2) = " + round(a) + " ( " + deg + " degree)");
      
    }
  }
  class onNormal implements ActionListener {

    public void actionPerformed(ActionEvent e){

      getData();
      Vector3D v = vectors[0].normalize();
      out.println("Normalize(v1) = " + round(v.x) + ", "  + round(v.y) + ", "  + round(v.z) );
      v = vectors[1].normalize();
      out.println("Normalize(v2) = " + round(v.x) + ", "  + round(v.y) + ", "  + round(v.z) );
      
    }
  }
  class onRotate implements ActionListener {

    public void actionPerformed(ActionEvent e){

      getData();
      Vector3D v = vectors[0].rotate(vectors[1].normalize(),angle);
      out.println("Rotate(v1,v2,angle) = " + round(v.x) + ", "  + round(v.y) + ", "  + round(v.z) );
      
    }
  }
 
  class onClear implements ActionListener {

    public void actionPerformed(ActionEvent e){

      textArea.setText("");
      
    }
  }
 
  class onLength implements ActionListener {

    public void actionPerformed(ActionEvent e){

      getData();

      out.println("Length(v1)" + round(vectors[0].length()) );
      out.println("Length(v2)" + round(vectors[1].length()) );
      
    }
  }
 
  class CloseWindowListener extends WindowAdapter {
    
    public void  windowClosing(WindowEvent e){
      frame.setVisible(false);
      frame.dispose();
    }
  }

  static double round(double v){
           
    int i = (int)(v + 0.5);
    if(v < 0)
      i -= 1;
    if( Math.abs(i - v) < EPS)
      return i;
    else 
      return chop(v);
  } 

  static final double EPS = 1.e-14;

  static double chop(double v){
    if(v < -EPS || v > EPS)
      return v;
    else 
      return 0;    
  }
  static private GridBagConstraints gbc = new GridBagConstraints();

  static void main(String args[]){

    new VectorCalculator().show();

  }    
}
