package PVS.Expression;

import PVS.Utils.SpecialFunction;

/**
  a little bit ridiculos class which dispatches its call to other functions
 */
public class FunctionSpec implements UserFunction {

  /**
    this function should be called to register all functions
    contained in this functions container
   */
  public void registerFunctions(Parser parser){
    parser.registerFunction(new UserFunctionData(this,new FunctionLog10()));
    parser.registerFunction(new UserFunctionData(this,new FunctionJ0()));
    parser.registerFunction(new UserFunctionData(this,new FunctionJ1()));
    parser.registerFunction(new UserFunctionData(this,new FunctionY0()));
    parser.registerFunction(new UserFunctionData(this,new FunctionY1()));
    parser.registerFunction(new UserFunctionData(this,new FunctionFac()));
    parser.registerFunction(new UserFunctionData(this,new FunctionGamma()));
    parser.registerFunction(new UserFunctionData(this,new FunctionSinh()));
    parser.registerFunction(new UserFunctionData(this,new FunctionCosh()));
    parser.registerFunction(new UserFunctionData(this,new FunctionTanh()));
    parser.registerFunction(new UserFunctionData(this,new FunctionAsinh()));
    parser.registerFunction(new UserFunctionData(this,new FunctionAcosh()));
    parser.registerFunction(new UserFunctionData(this,new FunctionAtanh()));
    parser.registerFunction(new UserFunctionData(this,new FunctionErf()));
    parser.registerFunction(new UserFunctionData(this,new FunctionErfc()));
    parser.registerFunction(new UserFunctionData(this,new FunctionNormal()));
    parser.registerFunction(new UserFunctionData(this,new FunctionPoisson()));
    parser.registerFunction(new UserFunctionData(this,new FunctionPoissonc()));
    parser.registerFunction(new UserFunctionData(this,new FunctionChiSq()));
    parser.registerFunction(new UserFunctionData(this,new FunctionChiSqc()));
    parser.registerFunction(new UserFunctionData(this,new FunctionIgam()));
    parser.registerFunction(new UserFunctionData(this,new FunctionIgamc()));
    parser.registerFunction(new UserFunctionData(this,new FunctionJn()));
    parser.registerFunction(new UserFunctionData(this,new FunctionYn()));
  }
  public String getName(Object o){
    return ((UserFunction)o).getName(null);
  }
  public int getNumVariables(Object o){
    return ((UserFunction)o).getNumVariables(null);
  }  
  public double compute(double var[], Object o){
    return ((UserFunction)o).compute(var,null);
  }			    
}

class FunctionLog10 implements  UserFunction{
  public String getName(Object o){return "log10";}
  public int getNumVariables(Object o){return 1;}  
  public double compute(double var[], Object o){
      return Math.log(var[0])/ Math.E;
  }
}

class FunctionJ0 implements  UserFunction{
  public String getName(Object o){return "J0";}
  public int getNumVariables(Object o){return 1;}  
  public double compute(double var[], Object o){
      return SpecialFunction.j0(var[0]);
  }
}

class FunctionJ1 implements  UserFunction{
  public String getName(Object o){return "J1";}
  public int getNumVariables(Object o){return 1;}  
  public double compute(double var[], Object o){
      return SpecialFunction.j1(var[0]);
  }
}

class FunctionY0 implements  UserFunction{
  public String getName(Object o){return "Y0";}
  public int getNumVariables(Object o){return 1;}  
  public double compute(double var[], Object o){
      return SpecialFunction.y0(var[0]);
  }
}

class FunctionY1 implements  UserFunction{
  public String getName(Object o){return "Y1";}
  public int getNumVariables(Object o){return 1;}  
  public double compute(double var[], Object o){
      return SpecialFunction.y1(var[0]);
  }
}

class FunctionFac implements  UserFunction{
  public String getName(Object o){return "fac";}
  public int getNumVariables(Object o){return 1;}  
  public double compute(double var[], Object o){
      return SpecialFunction.fac(var[0]);
  }
}

class FunctionGamma implements  UserFunction{
  public String getName(Object o){return "gamma";}
  public int getNumVariables(Object o){return 1;}  
  public double compute(double var[], Object o){
      return SpecialFunction.gamma(var[0]);
  }
}

class FunctionSinh implements  UserFunction{
  public String getName(Object o){return "sinh";}
  public int getNumVariables(Object o){return 1;}  
  public double compute(double var[], Object o){
      return SpecialFunction.sinh(var[0]);
  }
}

class FunctionCosh implements  UserFunction{
  public String getName(Object o){return "cosh";}
  public int getNumVariables(Object o){return 1;}  
  public double compute(double var[], Object o){
      return SpecialFunction.cosh(var[0]);
  }
}

class FunctionTanh implements  UserFunction{
  public String getName(Object o){return "tanh";}
  public int getNumVariables(Object o){return 1;}  
  public double compute(double var[], Object o){
      return SpecialFunction.tanh(var[0]);
  }
}


class FunctionAsinh implements  UserFunction{
  public String getName(Object o){return "asinh";}
  public int getNumVariables(Object o){return 1;}  
  public double compute(double var[], Object o){
      return SpecialFunction.asinh(var[0]);
  }
}

class FunctionAcosh implements  UserFunction{
  public String getName(Object o){return "acosh";}
  public int getNumVariables(Object o){return 1;}  
  public double compute(double var[], Object o){
      return SpecialFunction.acosh(var[0]);
  }
}

class FunctionAtanh implements  UserFunction{
  public String getName(Object o){return "atanh";}
  public int getNumVariables(Object o){return 1;}  
  public double compute(double var[], Object o){
      return SpecialFunction.atanh(var[0]);
  }
}

class FunctionErf implements  UserFunction{
  public String getName(Object o){return "Erf";}
  public int getNumVariables(Object o){return 1;}  
  public double compute(double var[], Object o){
      return SpecialFunction.erf(var[0]);
  }
}

class FunctionErfc implements  UserFunction{
  public String getName(Object o){return "Erfc";}
  public int getNumVariables(Object o){return 1;}  
  public double compute(double var[], Object o){
      return SpecialFunction.erfc(var[0]);
  }
}

class FunctionNormal implements  UserFunction{
  public String getName(Object o){return "Normal";}
  public int getNumVariables(Object o){return 1;}  
  public double compute(double var[], Object o){
      return SpecialFunction.normal(var[0]);
  }
}

class FunctionPoisson implements  UserFunction{
  public String getName(Object o){return "Poisson";}
  public int getNumVariables(Object o){return 2;}  
  public double compute(double var[], Object o){
      return SpecialFunction.poisson((int)(var[0]+0.1),var[1]);
  }
}

class FunctionPoissonc implements  UserFunction{
  public String getName(Object o){return "Poissonc";}
  public int getNumVariables(Object o){return 2;}  
  public double compute(double var[], Object o){
      return SpecialFunction.poissonc((int)(var[0]+0.1),var[1]);
  }
}

class FunctionChiSq implements  UserFunction{
  public String getName(Object o){return "ChiSq";}
  public int getNumVariables(Object o){return 2;}  
  public double compute(double var[], Object o){
      return SpecialFunction.chisq(var[0], var[1]);
  }
}

class FunctionChiSqc implements  UserFunction{
  public String getName(Object o){return "ChiSqc";}
  public int getNumVariables(Object o){return 2;}  
  public double compute(double var[], Object o){
      return SpecialFunction.chisqc(var[0], var[1]);
  }
}

class FunctionIgam implements  UserFunction{
  public String getName(Object o){return "IGam";}
  public int getNumVariables(Object o){return 2;}  
  public double compute(double var[], Object o){
      return SpecialFunction.igam(var[0], var[1]);
  }
}

class FunctionIgamc implements  UserFunction{
  public String getName(Object o){return "IGamc";}
  public int getNumVariables(Object o){return 2;}  
  public double compute(double var[], Object o){
      return SpecialFunction.igamc(var[0], var[1]);
  }
}

class FunctionJn implements  UserFunction{
  public String getName(Object o){return "Jn";}
  public int getNumVariables(Object o){return 2;}  
  public double compute(double var[], Object o){
      return SpecialFunction.jn((int)(var[0]+0.01), var[1]);
  }
}

class FunctionYn implements  UserFunction{
  public String getName(Object o){return "Yn";}
  public int getNumVariables(Object o){return 2;}  
  public double compute(double var[], Object o){
      return SpecialFunction.yn((int)(var[0]+0.01),var[1]);    
  }
}
