
package PVS.Expression;

import PVS.Utils.FileClassLoader;
import PVS.Utils.Fmt;

public class Calculator {
  static void usage(){
      System.err.println
	("Calculator: calculates simple expressions in C-like sintax\n"+
	 "expression can contain\n"+
	 " numerical terms, variables, operationms (+,-,/,*,^), \n"+
	 " functions (abs(x), acos(x), asin(x), atan(x), ceil(x), cos(x),\n"+
	 "            exp(x), floor(x), log(x), round(x), sin(x), sqrt(x),\n"+
	 "            tan(x), atan2(x,y), log10(x), J0(x),J1(x),Y0(x),Y1(x),\n"+
	 "            Fac(x), Gamma(x), sinh(x), cosh(x), tanh(x), asinh(x),\n"+
	 "            acosh(x),atanh(x),Erf(x),Erfc(x),Normal(x),\n"+
	 "            poisson(n,x),Poissonc(n,x), ChiSq(x,y), ChiSqc(x,y), \n"+
	 "            Igam(x,y), Igamc(x,y), Jn(n,x), Yn(n,x)\n"+
	 " if(cond){expr},  if(cond){expr1}else{espr2}, while(cond){expr}\n"+
	 "\nusage:\n"+
	 "Calculator <expression> [-s start] [-e end] [-i increment] [-c class]"+
	 "                        [-p precision]"+
	 "  where: start - initial value of special variable x\n"+
	 "         end - final value of special variable x\n"+
	 "         increment - increment of variable x\n"+
	 "         class - class implementing UserFunction interface\n"+
	 "         precision - number of decimal digits used for output\n"+
	 "z\nprints a table:  <x> <expression(x)>\n\n"+
	 " example:\n > Calculator 'if(x-1) {sin(x);} else {0;}' -s 0 -e 4 -i 1\n"+
	 " will print: \n 0 0 \n 1 0\n 2 0.909297\n 3 0.14112\n 4 -0.756802\n");
  }

  public static void main (String[] args) throws Exception{
    if(args.length == 0){
      usage();
      System.exit(-1);
    }    

    Parser parser = new Parser();
    parser.registerFunction(new UserFunctionData(new FunctionMin(),null));
    parser.registerFunction(new UserFunctionData(new FunctionSin(),null));
    FunctionSpec fs = new FunctionSpec();
    fs.registerFunctions(parser);
    double start = 0,  end = 0, increment = 1;
    int precision = 10;

    for(int i=1;i<args.length;i++){
      if(args[i].equals("-s")){
	start = Double.valueOf (args [++i]).doubleValue ();
      } else if(args[i].equals("-e")){
	end = Double.valueOf (args [++i]).doubleValue ();
      } else if(args[i].equals("-i")){
	increment = Double.valueOf (args [++i]).doubleValue ();
      } else if(args[i].equals("-p")){
	precision = Integer.valueOf (args [++i]).intValue ();
      } else if(args[i].equals("-c")){
	try{
	  UserFunction uf = 
	    (UserFunction)(new FileClassLoader().loadClass(args[++i],true)).newInstance();
	  parser.registerFunction(new UserFunctionData(uf,null));	  
	} catch(Exception e){
	  e.printStackTrace(System.out);
	}	
      } else {
	System.out.println("wrong option: " + args[i]);
	usage();
	System.exit(-1);
      }
    }    
    
    Expr expr = null;
    expr = parser.parse (args [0]);
    
    Variable x = expr.getVariable ("x");
    
    for (double xval = start; xval <= end; xval += increment) {
      x.setValue (xval);
      System.out.println (Fmt.fmt(xval,precision,precision) +" "+
			  Fmt.fmt(expr.value(),precision,precision));
    }
  }
}
