/*
 * Decompiled with CFR 0.152.
 */
package PVS.polyhedra.stellation;

import PVS.Utils.Fmt;
import PVS.Utils.PVSObserver;
import PVS.Utils.WindowUtils;
import PVS.polyhedra.SSCell;
import PVS.polyhedra.stellation.Main;
import PVS.polyhedra.stellation.Selection;
import PVS.polyhedra.stellation.SelectionCell;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.StringTokenizer;
import java.util.Vector;

public class SelectionPanel
extends Panel
implements PVSObserver {
    private Selection canvas;
    TextField cellField = new TextField();
    TextField infoField = new TextField();
    Button cellsButton = new Button("Set");
    Button clearButton = new Button("Clear");
    int sbMaximum = 100000;
    int sbVisible = 100000;
    Scrollbar sbVertical = new Scrollbar(1, 0, this.sbVisible, 0, this.sbMaximum);
    Scrollbar sbHorizontal = new Scrollbar(0, 0, this.sbVisible, 0, this.sbMaximum);
    boolean sbVerticalVisible = false;
    boolean sbHorizontalVisible = false;
    Vector cellHistory = new Vector();
    Main main;
    Panel cpanel;
    int oldLayer = -1;
    int oldCell = -1;
    private static GridBagConstraints gbc = new GridBagConstraints();

    public SelectionPanel(Main main) {
        this.main = main;
        this.setBackground(Color.lightGray);
        this.infoField.setBackground(Color.lightGray);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.canvas = new Selection(this);
        this.canvas.addMouseMotionListener(new CanvasMouseMotion());
        this.sbVertical.addAdjustmentListener(new SBVerticalAdjustmentListener());
        this.sbHorizontal.addAdjustmentListener(new SBHorizontalAdjustmentListener());
        this.cpanel = new Panel();
        this.cpanel.setLayout(gridBagLayout);
        this.cpanel.addComponentListener(new CPanelListener());
        WindowUtils.constrain((Container)this.cpanel, (Component)this.canvas, 0, 1, 1, 1, 1, 10, 1.0, 1.0);
        this.setLayout(gridBagLayout);
        this.cellsButton.addActionListener(new CellsButtonListener());
        this.clearButton.addActionListener(new ClearButtonListener());
        WindowUtils.constrain(this, this.cpanel, 0, 0, 3, 1, 1, 10, 1.0, 1.0, 2, 2, 2, 2);
        WindowUtils.constrain((Container)this, (Component)this.infoField, 0, 1, 3, 1, 2, 10, 1.0, 0.0);
        WindowUtils.constrain((Container)this, (Component)this.cellField, 0, 2, 1, 1, 2, 10, 1.0, 0.0);
        WindowUtils.constrain(this, this.cellsButton, 1, 2, 1, 1, 0, 10, 0.0, 0.0, 2, 2, 2, 2);
        WindowUtils.constrain(this, this.clearButton, 2, 2, 1, 1, 0, 10, 0.0, 0.0, 2, 2, 2, 2);
    }

    public void setSelection(int[][] nArray) {
        this.canvas.setSelection(nArray);
    }

    public int[][] modifySelection(int[] nArray, int n) {
        return this.canvas.modifySelection(nArray, n);
    }

    public void setArray(Vector vector, Vector vector2) {
        this.canvas.setArray(vector, vector2);
        this.canvas.setOffsetY(0);
        this.canvas.setOffsetX(0);
        this.adjustScrollbars();
    }

    public void adjustScrollbars() {
        Dimension dimension = this.canvas.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        if (this.canvas.preferedWidth > dimension.width) {
            this.sbHorizontal.setMaximum(this.canvas.preferedWidth);
            this.sbHorizontal.setVisibleAmount(dimension.width);
            this.sbHorizontal.setUnitIncrement(this.canvas.gridX);
            this.sbHorizontal.setBlockIncrement(10 * this.canvas.gridX);
            this.sbHorizontal.setEnabled(true);
            if (!this.sbHorizontalVisible) {
                this.sbHorizontalVisible = true;
                WindowUtils.constrain((Container)this.cpanel, (Component)this.sbHorizontal, 0, 2, 1, 1, 2, 10, 1.0, 0.0);
                this.cpanel.validate();
            }
        } else {
            this.canvas.setOffsetX(0);
            this.sbHorizontal.setEnabled(false);
            this.cpanel.remove(this.sbHorizontal);
            if (this.sbHorizontalVisible) {
                this.sbHorizontalVisible = false;
                this.cpanel.remove(this.sbHorizontal);
                this.cpanel.validate();
            }
        }
        if (this.canvas.preferedHeight > dimension.height) {
            this.sbVertical.setMaximum(this.canvas.preferedHeight);
            this.sbVertical.setVisibleAmount(dimension.height);
            this.sbVertical.setUnitIncrement(this.canvas.gridY);
            this.sbVertical.setBlockIncrement(10 * this.canvas.gridY);
            this.sbVertical.setEnabled(true);
            if (!this.sbVerticalVisible) {
                this.sbVerticalVisible = true;
                WindowUtils.constrain((Container)this.cpanel, (Component)this.sbVertical, 1, 1, 1, 1, 3, 10, 0.0, 1.0);
                this.cpanel.validate();
            }
        } else {
            this.sbVertical.setEnabled(false);
            this.canvas.setOffsetY(0);
            if (this.sbVerticalVisible) {
                this.sbVerticalVisible = false;
                this.cpanel.remove(this.sbVertical);
                this.cpanel.validate();
            }
        }
    }

    public void update(Object object, Object object2) {
        this.main.update(this, object2);
        this.initCellField();
    }

    public void initCellField() {
        SelectionCell[][][] selectionCellArray = this.canvas.getSelectionIndex_v2();
        String string = SelectionPanel.makeStellationName_v2(selectionCellArray);
        String string2 = this.cellField.getText();
        this.cellHistory.addElement(string2);
        this.cellField.setText(string);
    }

    public void doUndo() {
        int n = this.cellHistory.size() - 1;
        if (n < 0) {
            return;
        }
        String string = (String)this.cellHistory.elementAt(n);
        this.cellHistory.removeElementAt(n);
        this.cellField.setText(string);
        this.doParseCells();
    }

    public static String makeStellationName_v2(SelectionCell[][][] selectionCellArray) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        stringBuffer.append('{');
        boolean bl4 = false;
        int n = 0;
        while (n < selectionCellArray.length) {
            String string = SelectionPanel.writeLayer_v2(selectionCellArray[n]);
            if (!string.equals("()")) {
                if (bl4) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(n);
                if (string.equals("(*)")) {
                    bl4 = true;
                } else {
                    stringBuffer.append(string);
                    bl4 = false;
                }
            }
            ++n;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    static String writeLayer_v2(SelectionCell[][] selectionCellArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        while (n < selectionCellArray.length) {
            String string = SelectionPanel.writeCell_v2(selectionCellArray[n]);
            if (string.equals("[]")) {
                bl = true;
            } else {
                if (bl3) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(n);
                if (string.equals("[*]")) {
                    bl3 = true;
                } else {
                    bl2 = true;
                    stringBuffer.append(string);
                    bl3 = false;
                }
            }
            ++n;
        }
        stringBuffer.append(')');
        if (!bl && !bl2) {
            return "(*)";
        }
        return stringBuffer.toString();
    }

    static String writeCell_v2(SelectionCell[] selectionCellArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < selectionCellArray.length) {
            if (selectionCellArray[n].getSelected() == 1) {
                bl = true;
            } else {
                bl2 = true;
            }
            ++n;
        }
        if (!bl2) {
            stringBuffer.append('*');
        } else {
            boolean bl3 = false;
            int n2 = 0;
            while (n2 < selectionCellArray.length) {
                if (selectionCellArray[n2].getSelected() == 1) {
                    if (bl3) {
                        stringBuffer.append(',');
                        bl3 = false;
                    }
                    stringBuffer.append(n2);
                    bl3 = true;
                }
                ++n2;
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String makeStellationName_v1(SelectionCell[][] selectionCellArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < selectionCellArray.length) {
            boolean bl = false;
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < selectionCellArray[n].length) {
                if (selectionCellArray[n][n2].getSelected() == 0) {
                    bl2 = true;
                } else {
                    bl = true;
                }
                ++n2;
            }
            if (bl) {
                stringBuffer.append(n);
                stringBuffer.append('(');
                if (!bl2) {
                    stringBuffer.append('*');
                } else {
                    boolean bl3 = false;
                    int n3 = 0;
                    while (n3 < selectionCellArray[n].length) {
                        if (selectionCellArray[n][n3].getSelected() != 0) {
                            if (bl3) {
                                stringBuffer.append(',');
                            }
                            stringBuffer.append(n3);
                            int n4 = SelectionPanel.countAdjacentCells(selectionCellArray[n], n3);
                            if (n4 > 2) {
                                stringBuffer.append('-');
                                stringBuffer.append(n3 + n4 - 1);
                                n3 += n4 - 1;
                            }
                            bl3 = true;
                        }
                        ++n3;
                    }
                }
                stringBuffer.append(')');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static int countAdjacentCells(SelectionCell[] selectionCellArray, int n) {
        int n2 = 0;
        int n3 = n;
        while (n3 < selectionCellArray.length) {
            if (selectionCellArray[n3].getSelected() == 0) {
                return n2;
            }
            ++n2;
            ++n3;
        }
        return n2;
    }

    static int[][] parseCells(String string, SelectionCell[][][] selectionCellArray) throws Throwable {
        int[][] nArrayArray = new int[selectionCellArray.length][];
        int n = 0;
        while (n < selectionCellArray.length) {
            nArrayArray[n] = new int[selectionCellArray[n].length];
            ++n;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "(),-", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n2 = Integer.valueOf(string2);
                if (n2 < 0 || n2 >= nArrayArray.length) {
                    throw new Throwable("illegal layer number: " + n2);
                }
                SelectionPanel.parseLayer(stringTokenizer, nArrayArray, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return nArrayArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int[][][] parseCells_v2(String string, SelectionCell[][][] selectionCellArray) throws Throwable {
        int[][][] nArrayArray = new int[selectionCellArray.length][][];
        int n = 0;
        while (n < selectionCellArray.length) {
            nArrayArray[n] = new int[selectionCellArray[n].length][];
            int n2 = 0;
            while (n2 < selectionCellArray[n].length) {
                nArrayArray[n][n2] = new int[selectionCellArray[n][n2].length];
                ++n2;
            }
            ++n;
        }
        try {
            int n3;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "(),-{}[]", true);
            if (!stringTokenizer.hasMoreTokens()) {
                throw new Throwable("wrong cell notation");
            }
            String string2 = stringTokenizer.nextToken();
            if (!string2.equals("{")) {
                throw new Throwable("wrong start of cell: '" + string2 + "'");
            }
            do {
                if (!stringTokenizer.hasMoreTokens()) {
                    return nArrayArray;
                }
                string2 = stringTokenizer.nextToken();
                if ("}".equals(string2)) {
                    return nArrayArray;
                }
                if (!SelectionPanel.isNumber(string2)) {
                    throw new Throwable("wrong expression of layer: '" + string2 + "'");
                }
                n3 = Integer.valueOf(string2);
                if (n3 < 0) throw new Throwable("layer number: " + n3 + " is out of bounds");
                if (n3 < nArrayArray.length) continue;
                throw new Throwable("layer number: " + n3 + " is out of bounds");
            } while (!"}".equals(string2 = SelectionPanel.parseLayer_v2(stringTokenizer, nArrayArray, n3)));
            return nArrayArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return nArrayArray;
    }

    /*
     * Unable to fully structure code
     */
    private static String parseLayer_v2(StringTokenizer var0, int[][][] var1_1, int var2_2) throws Throwable {
        var3_3 = var0.nextToken();
        if (",".equals(var3_3) || "}".equals(var3_3)) {
            var4_4 = 0;
            while (var4_4 < var1_1[var2_2].length) {
                var5_6 = 0;
                while (var5_6 < var1_1[var2_2][var4_4].length) {
                    var1_1[var2_2][var4_4][var5_6] = 1;
                    ++var5_6;
                }
                ++var4_4;
            }
            return var3_3;
        }
        if ("(".equals(var3_3)) ** GOTO lbl26
        throw new Throwable("illegal start of cell: '" + var3_3 + "' in layer " + var2_2);
lbl-1000:
        // 1 sources

        {
            var4_5 = var0.nextToken();
            if (")".equals(var4_5)) {
                return var4_5;
            }
            if (!SelectionPanel.isNumber(var4_5)) {
                throw new Throwable("illegal cell expression '" + var4_5 + "' in layer " + var2_2);
            }
            var5_7 = Integer.valueOf(var4_5);
            if (var5_7 >= 0 && var5_7 < var1_1[var2_2].length) {
                var6_8 = SelectionPanel.parseCell_v2(var0, var1_1, var2_2, var5_7);
                if (!")".equals(var6_8)) continue;
                return var6_8;
            }
            throw new Throwable("cell number: " + var5_7 + " in layer " + var2_2 + " is out of bounds");
lbl26:
            // 2 sources

            ** while (var0.hasMoreTokens())
        }
lbl27:
        // 1 sources

        return "";
    }

    /*
     * Unable to fully structure code
     */
    private static String parseCell_v2(StringTokenizer var0, int[][][] var1_1, int var2_2, int var3_3) throws Throwable {
        var4_4 = var0.nextToken();
        if (",".equals(var4_4) || ")".equals(var4_4)) {
            var5_5 = 0;
            while (var5_5 < var1_1[var2_2].length) {
                var6_7 = 0;
                while (var6_7 < var1_1[var2_2][var3_3].length) {
                    var1_1[var2_2][var3_3][var6_7] = 1;
                    ++var6_7;
                }
                ++var5_5;
            }
            return var4_4;
        }
        if ("[".equals(var4_4)) ** GOTO lbl23
        throw new Throwable("illegal start of subcell: '" + var4_4 + "'" + " in layer " + var2_2 + " cell " + var3_3);
lbl-1000:
        // 1 sources

        {
            var4_4 = var0.nextToken();
            if ("]".equals(var4_4)) {
                return "]";
            }
            if (",".equals(var4_4)) continue;
            if (!SelectionPanel.isNumber(var4_4)) {
                throw new Throwable("illegal cell expression: '" + var4_4 + "' in layer " + var2_2);
            }
            var5_6 = Integer.valueOf(var4_4);
            var1_1[var2_2][var3_3][var5_6] = 1;
lbl23:
            // 3 sources

            ** while (var0.hasMoreTokens())
        }
lbl24:
        // 1 sources

        return "";
    }

    private static boolean isNumber(String string) {
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) < '0' || string.charAt(n) > '9') {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static void parseLayer(StringTokenizer stringTokenizer, int[][] nArray, int n) throws Throwable {
        String string = stringTokenizer.nextToken();
        if (!"(".equals(string)) {
            throw new Throwable("illegal start of layer: " + string);
        }
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (")".equals(string2)) {
                return;
            }
            if (string2.equals(",") || string2.equals(" ")) continue;
            if (string2.equals("*")) {
                int n3 = 0;
                while (n3 < nArray[n].length) {
                    nArray[n][n3] = 1;
                    ++n3;
                }
                continue;
            }
            if (string2.equals("-")) {
                String string3 = stringTokenizer.nextToken();
                int n4 = Integer.valueOf(string3);
                if (n4 < 0 || n4 >= nArray[n].length) {
                    throw new Throwable("illegal cell number: " + n4 + " in layer " + n);
                }
                int n5 = n2;
                while (n5 <= n4) {
                    nArray[n][n5] = 1;
                    ++n5;
                }
                continue;
            }
            n2 = Integer.valueOf(string2);
            if (n2 >= 0 && n2 < nArray[n].length) {
                nArray[n][n2] = 1;
                continue;
            }
            throw new Throwable("illegal cell number: " + n2 + " in layer " + n);
        }
    }

    void doParseCells() {
        try {
            SelectionCell[][][] selectionCellArray = this.canvas.getSelectionIndex_v2();
            String string = this.cellField.getText();
            if (string.length() == 0) {
                string = "{}";
            }
            int[][][] nArray = SelectionPanel.parseCells_v2(string, selectionCellArray);
            this.canvas.setSelectedSubCells(nArray);
            int[][] nArray2 = this.canvas.getCells();
            if (this.main != null) {
                this.main.update(this, nArray2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(Main.Out);
        }
    }

    void doClearAll() {
        this.canvas.clearAll();
        this.cellField.setText("");
        int[][] nArray = this.canvas.getCells();
        if (this.main != null) {
            this.main.update(this, nArray);
        }
    }

    private static int getIndex(Object[] objectArray, Object object) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == object) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    class SBVerticalAdjustmentListener
    implements AdjustmentListener {
        SBVerticalAdjustmentListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            int n = adjustmentEvent.getValue();
            SelectionPanel.this.canvas.setOffsetY(-n);
        }
    }

    class SBHorizontalAdjustmentListener
    implements AdjustmentListener {
        SBHorizontalAdjustmentListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            int n = adjustmentEvent.getValue();
            SelectionPanel.this.canvas.setOffsetX(-n);
        }
    }

    class CPanelListener
    extends ComponentAdapter {
        CPanelListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            Component component = componentEvent.getComponent();
            SelectionPanel.this.adjustScrollbars();
        }
    }

    class CanvasMouseMotion
    extends MouseMotionAdapter {
        CanvasMouseMotion() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int[] nArray = SelectionPanel.this.canvas.getCellUnderMouse(mouseEvent.getX(), mouseEvent.getY());
            if (nArray == null) {
                if (SelectionPanel.this.oldLayer != -1) {
                    SelectionPanel.this.canvas.setCursor(Cursor.getPredefinedCursor(0));
                    SelectionPanel.this.oldLayer = -1;
                }
            } else if (SelectionPanel.this.oldLayer != nArray[0] || SelectionPanel.this.oldCell != nArray[1]) {
                SSCell sSCell = SelectionPanel.this.canvas.getCellAt(nArray[0], nArray[1]);
                if (sSCell == null) {
                    return;
                }
                int n = nArray[0];
                int n2 = nArray[1];
                Vector vector = (Vector)((SelectionPanel)SelectionPanel.this).canvas.allcells.elementAt(n);
                String string = "";
                string = sSCell.superCell != null ? "" + n + "(" + vector.indexOf(sSCell.superCell) + "[" + SelectionPanel.getIndex(sSCell.superCell.subCells, sSCell) + "]), " + sSCell.getCellsCount() + " elem. cells" : "" + n + "(" + vector.indexOf(sSCell) + ")" + ", " + sSCell.getCellsCount() + " elem. cells";
                string = string + "[" + sSCell.getNFacets() + "," + sSCell.getNVertices() + "," + Fmt.fmt(sSCell.getVolume(), 6, 8) + "]";
                SelectionPanel.this.infoField.setText(string);
                SelectionPanel.this.canvas.setCursor(Cursor.getPredefinedCursor(12));
                SelectionPanel.this.oldLayer = nArray[0];
                SelectionPanel.this.oldCell = nArray[1];
            }
        }
    }

    class ClearButtonListener
    implements ActionListener {
        ClearButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SelectionPanel.this.doClearAll();
        }
    }

    class CellsButtonListener
    implements ActionListener {
        CellsButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SelectionPanel.this.doParseCells();
        }
    }
}

