/*
 * Decompiled with CFR 0.152.
 */
package PVS.polyhedra.stellation;

import PVS.Utils.DestroyableFrame;
import PVS.Utils.Fmt;
import PVS.Utils.PVSObserver;
import PVS.polyhedra.SSCell;
import PVS.polyhedra.stellation.SelectionCell;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Selection
extends Canvas {
    Vector allcells;
    Vector subcells;
    SelectionCell[][] selection = new SelectionCell[0][0];
    SelectionCell[][] selectableCells = new SelectionCell[0][0];
    SelectionCell[][][] selectableSubCells = new SelectionCell[0][0][0];
    int offsetX = 0;
    int offsetY = 0;
    int preferedWidth = 100;
    int preferedHeight = 100;
    int fontHeight = 16;
    int fontHeightSub = 12;
    int fontHeightSub3 = 10;
    Font font = new Font("SansSerif", 1, this.fontHeight);
    Font fontSub = new Font("SansSerif", 0, this.fontHeightSub);
    Font fontSub3 = new Font("SansSerif", 0, this.fontHeightSub3);
    static int yspace = 8;
    static int xspace = 8;
    static int ypad = 2;
    static int xpad = 2;
    static int xpad2 = 2 * xpad;
    Color symCellColor = new Color(230, 230, 255);
    PVSObserver observer = null;
    Frame frame;
    Color[] cellColors;
    static Color[] color = new Color[2];
    int gridX = 10;
    int gridY = 10;
    Image memImage = null;
    Dimension dim = new Dimension(0, 0);

    public Selection(PVSObserver pVSObserver) {
        this.observer = pVSObserver;
        this.addMouseListener(new MouseListenerClass());
    }

    public Selection(Vector vector, Vector vector2, PVSObserver pVSObserver) {
        this.observer = pVSObserver;
        this.addMouseListener(new MouseListenerClass());
        this.setArray(vector, vector2);
        this.frame = new DestroyableFrame("Stellation Cells");
        this.frame.setLayout(new GridLayout(1, 1));
        this.frame.add(this);
        this.frame.pack();
        this.frame.show();
    }

    void init() {
        int n;
        int n2;
        Serializable serializable;
        int n3 = this.allcells.size();
        this.selection = new SelectionCell[n3][];
        this.selectableCells = new SelectionCell[n3][];
        this.selectableSubCells = new SelectionCell[n3][][];
        int n4 = 0;
        while (n4 < n3) {
            serializable = (Vector)this.allcells.elementAt(n4);
            this.selectableSubCells[n4] = new SelectionCell[((Vector)serializable).size()][];
            n2 = 0;
            n = 0;
            int n5 = 0;
            while (n5 < ((Vector)serializable).size()) {
                SSCell sSCell = (SSCell)((Vector)serializable).elementAt(n5);
                this.selectableSubCells[n4][n5] = new SelectionCell[sSCell.subCells.length];
                if (sSCell.subCells.length > 1) {
                    n2 += sSCell.subCells.length + 1;
                    n += sSCell.subCells.length;
                } else {
                    ++n2;
                    ++n;
                }
                ++n5;
            }
            this.selection[n4] = new SelectionCell[n2];
            this.selectableCells[n4] = new SelectionCell[n];
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            while (n8 < ((Vector)serializable).size()) {
                SSCell sSCell = (SSCell)((Vector)serializable).elementAt(n8);
                if (sSCell.subCells.length > 1) {
                    this.selection[n4][n6] = new SelectionCell(sSCell, 0);
                    ++n6;
                    int n9 = 0;
                    while (n9 < sSCell.subCells.length) {
                        SelectionCell selectionCell;
                        this.selectableSubCells[n4][n8][n9] = selectionCell = new SelectionCell(sSCell.subCells[n9], n7);
                        this.selection[n4][n6] = selectionCell;
                        this.selectableCells[n4][n7] = selectionCell;
                        ++n7;
                        ++n6;
                        ++n9;
                    }
                } else {
                    SelectionCell selectionCell;
                    this.selectableSubCells[n4][n8][0] = selectionCell = new SelectionCell(sSCell.subCells[0], n7);
                    this.selection[n4][n6] = selectionCell;
                    this.selectableCells[n4][n7] = selectionCell;
                    ++n7;
                    ++n6;
                }
                ++n8;
            }
            ++n4;
        }
        serializable = this.getFontMetrics(this.font);
        this.gridY = this.fontHeight + yspace;
        this.gridX = ((FontMetrics)serializable).charWidth('W') + xspace;
        n2 = 0;
        n = 0;
        while (n < this.selection.length) {
            if (n2 < this.selection[n].length) {
                n2 = this.selection[n].length;
            }
            ++n;
        }
        this.preferedHeight = this.gridY * this.selection.length;
        this.preferedWidth = this.gridX * (n2 + 3);
        this.cellColors = this.makeColors();
    }

    Color getOutlineColor(SSCell sSCell) {
        int n = sSCell.cells.length;
        if (this.cellColors[n] == null) {
            int n2 = this.cellColors.length - 1;
            int n3 = 0;
            int n4 = n - 1;
            while (n4 >= 0) {
                if (this.cellColors[n4] != null) {
                    n3 = n4;
                    break;
                }
                --n4;
            }
            int n5 = n + 1;
            while (n5 < this.cellColors.length) {
                if (this.cellColors[n5] != null) {
                    n2 = n5;
                    break;
                }
                ++n5;
            }
            Color color = this.cellColors[n2];
            Color color2 = this.cellColors[n3];
            int n6 = n2 - n3;
            int n7 = n - n3;
            int n8 = n2 - n;
            int n9 = (n7 * color.getRed() + n8 * color2.getRed()) / n6;
            int n10 = (n7 * color.getGreen() + n8 * color2.getGreen()) / n6;
            int n11 = (n7 * color.getBlue() + n8 * color2.getBlue()) / n6;
            this.cellColors[n] = new Color(n9, n10, n11);
        }
        return this.cellColors[n];
    }

    Color[] makeColors() {
        Color[] colorArray;
        Object object;
        int n;
        Vector vector = this.allcells;
        Hashtable<Color[], Color[]> hashtable = new Hashtable<Color[], Color[]>();
        int n2 = 0;
        while (n2 < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n2);
            n = 0;
            while (n < vector2.size()) {
                object = (SSCell)vector2.elementAt(n);
                colorArray = new Integer(((SSCell)object).cells.length);
                hashtable.put(colorArray, colorArray);
                ++n;
            }
            ++n2;
        }
        int n3 = hashtable.size();
        n = 0;
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            colorArray = (Color[])object.nextElement();
            if (colorArray.intValue() <= n) continue;
            n = colorArray.intValue();
        }
        colorArray = new Color[n + 1];
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n4 = (Integer)enumeration.nextElement();
            colorArray[n4.intValue()] = Color.black;
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < colorArray.length) {
            if (colorArray[n6] != null) {
                float f = (float)((double)n5 / (double)n3);
                float f2 = 0.9f;
                float f3 = 0.8f;
                colorArray[n6] = Color.getHSBColor(f, f3, f2);
                ++n5;
            }
            ++n6;
        }
        return colorArray;
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    public void setArray(Vector vector, Vector vector2) {
        this.allcells = vector;
        this.subcells = vector2;
        this.init();
        this.repaint();
    }

    public void setSelection(int[][] nArray) {
        this.clearAll();
        int n = 0;
        while (n < nArray.length) {
            this.selectableCells[nArray[n][0]][nArray[n][1]].setSelected(1);
            ++n;
        }
        this.repaint();
    }

    public int[][] modifySelection(int[] nArray, int n) {
        switch (n) {
            case 3: 
            case 4: {
                SelectionCell selectionCell = this.selectableCells[nArray[0]][nArray[1]];
                selectionCell.invertSelection();
                break;
            }
            case 1: {
                int[][] nArray2 = this.getSupportCells(nArray[0], nArray[1]);
                int n2 = 0;
                while (n2 < nArray2.length) {
                    int n3 = 0;
                    while (n3 < nArray2[n2].length) {
                        if (nArray2[n2][n3] == 1) {
                            this.selectableCells[n2][n3].setSelected(1);
                        }
                        ++n3;
                    }
                    ++n2;
                }
                break;
            }
            case 0: {
                int[][] nArray3 = this.getSupportCells(nArray[0], nArray[1]);
                int n4 = 0;
                while (n4 < nArray3.length) {
                    int n5 = 0;
                    while (n5 < nArray3[n4].length) {
                        if (nArray3[n4][n5] == 1) {
                            this.selectableCells[n4][n5].setSelected(0);
                        }
                        ++n5;
                    }
                    ++n4;
                }
                break;
            }
            case 2: {
                int[][] nArray4 = this.getSupportCells(nArray[0], nArray[1]);
                int n6 = 0;
                while (n6 < nArray4.length) {
                    int n7 = 0;
                    while (n7 < nArray4[n6].length) {
                        if (nArray4[n6][n7] == 1) {
                            this.selectableCells[n6][n7].invertSelection();
                        }
                        ++n7;
                    }
                    ++n6;
                }
                break;
            }
        }
        this.repaint();
        return this.getCells();
    }

    public void clearAll() {
        int n = 0;
        while (n < this.selection.length) {
            int n2 = 0;
            while (n2 < this.selection[n].length) {
                this.selection[n][n2].setSelected(0);
                ++n2;
            }
            ++n;
        }
        this.repaint();
    }

    public void setSelectionIndex(int[][] nArray) {
        int n = 0;
        while (n < this.selectableCells.length) {
            int n2 = 0;
            while (n2 < this.selectableCells[n].length) {
                this.selectableCells[n][n2].setSelected(nArray[n][n2]);
                ++n2;
            }
            ++n;
        }
        this.repaint();
    }

    public void setSelectedSubCells(int[][][] nArray) {
        int n = 0;
        while (n < this.selectableSubCells.length) {
            int n2 = 0;
            while (n2 < this.selectableSubCells[n].length) {
                int n3 = 0;
                while (n3 < this.selectableSubCells[n][n2].length) {
                    this.selectableSubCells[n][n2][n3].setSelected(nArray[n][n2][n3]);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        this.repaint();
    }

    int getSubcellsIndex(int n, SSCell sSCell) {
        int n2 = 0;
        while (n2 < this.selection.length) {
            if (this.selection[n][n2].cell == sSCell.subCells[0]) {
                return n2;
            }
            ++n2;
        }
        return 0;
    }

    public SelectionCell[][] getSelectionIndex() {
        return this.selectableCells;
    }

    public SelectionCell[][][] getSelectionIndex_v2() {
        return this.selectableSubCells;
    }

    public void update(Graphics graphics) {
        graphics.setColor(Color.lightGray);
        this.paint(graphics);
    }

    SSCell getCellAt(int n, int n2) {
        if (n < 0 || n >= this.subcells.size()) {
            return null;
        }
        if (n2 < 0 || n2 >= this.selection[n].length) {
            return null;
        }
        SelectionCell selectionCell = this.selection[n][n2];
        return selectionCell.cell;
    }

    double getVolume(int n, int n2) {
        SSCell sSCell = this.getCellAt(n, n2);
        return sSCell.getVolume();
    }

    int getHandedness(int n, int n2) {
        SSCell sSCell = this.getCellAt(n, n2);
        return sSCell.getHandedness();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (dimension.width != this.dim.width || dimension.height != this.dim.height || this.memImage == null) {
            this.dim = dimension;
            this.memImage = this.createImage(this.dim.width, this.dim.height);
        }
        Graphics graphics2 = this.memImage.getGraphics();
        graphics2.setColor(Color.white);
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        graphics2.setColor(Color.black);
        graphics2.setFont(this.font);
        int n = 1;
        int n2 = 1 + this.offsetY;
        char[] cArray = new char[1];
        int n3 = 0;
        while (n3 < this.selection.length) {
            int n4 = n = 1 + this.offsetX;
            int n5 = (n3 + 1) * this.gridY - yspace - 2 + this.offsetY;
            graphics2.setColor(Color.black);
            graphics2.setFont(this.font);
            graphics2.drawRect(n + 1, n2, 2 * this.gridX - 3, this.gridY);
            graphics2.drawString(Fmt.fmt(n3, 3), n4 + 4, n5 + 3);
            n4 += 2 * this.gridX;
            Vector vector = (Vector)this.allcells.elementAt(n3);
            int n6 = 0;
            int n7 = 0;
            while (n7 < vector.size()) {
                String string;
                SSCell sSCell = (SSCell)vector.elementAt(n7);
                int n8 = sSCell.subCells.length;
                int n9 = n4;
                if (n8 > 1) {
                    graphics2.setColor(this.symCellColor);
                    graphics2.fillRect(n9 + xpad - 1, n2 + ypad - 1, this.gridX - xpad2 - 1, this.gridY - 2 * ypad - 1);
                    graphics2.setColor(Color.gray);
                    graphics2.drawRect(n9 + xpad - 2, n2 + ypad - 2, this.gridX - xpad2, this.gridY - 2 * ypad);
                    graphics2.setFont(this.font);
                    graphics2.setColor(Color.black);
                    string = String.valueOf(n7);
                    if (string.length() == 1) {
                        graphics2.drawString(string, n4 + 5, n5 + 3);
                    } else {
                        graphics2.drawString(string, n4 + 1, n5 + 3);
                    }
                    ++n6;
                    graphics2.setColor(Color.gray);
                    graphics2.fillRect(n9 + this.gridX - 3, n2 + this.gridY / 2 - 4, 3, 3);
                    graphics2.fillRect(n9 + this.gridX - 3, n2 + this.gridY / 2 + 2, 3, 3);
                    int n10 = 0;
                    while (n10 < sSCell.subCells.length) {
                        if (this.selection[n3][n6].getSelected() == 1) {
                            graphics2.setColor(Color.lightGray);
                            graphics2.fillRect(n9 + this.gridX + xpad - 1, n2 + ypad - 2, this.gridX - xpad2 - 1, this.gridY - 2 * ypad);
                        } else {
                            graphics2.setColor(Color.lightGray);
                            graphics2.drawRect(n9 + this.gridX + xpad - 2, n2 + ypad - 2, this.gridX - xpad2, this.gridY - 2 * ypad);
                        }
                        ++n6;
                        Color color = this.getOutlineColor(sSCell.subCells[n10]);
                        if (color != null) {
                            graphics2.setColor(color);
                            graphics2.fillRect(n9 + xpad + this.gridX - 2, n2 + ypad - 2, this.gridX - xpad2 + 1, 3);
                        }
                        graphics2.setFont(this.fontSub);
                        graphics2.setColor(Color.black);
                        String string2 = String.valueOf(n10);
                        int n11 = 0;
                        switch (string2.length()) {
                            case 1: {
                                n11 = 6;
                                break;
                            }
                            case 2: {
                                n11 = 3;
                                break;
                            }
                            case 3: {
                                graphics2.setFont(this.fontSub3);
                                n11 = 1;
                            }
                        }
                        graphics2.drawString(string2, n9 + this.gridX + n11, n5 + 3);
                        n9 += this.gridX;
                        ++n10;
                    }
                    graphics2.setColor(this.getOutlineColor(sSCell));
                    graphics2.fillRect(n4 + this.gridX + xpad - 2, n2 + this.gridY - ypad - 3, this.gridX * n8 - xpad2 + 1, 3);
                    n4 += (n8 + 1) * this.gridX;
                } else {
                    if (this.selection[n3][n6].getSelected() == 1) {
                        graphics2.setColor(Color.lightGray);
                        graphics2.fillRect(n9 + xpad - 1, n2 + ypad - 2, this.gridX - xpad2 - 1, this.gridY - 2 * ypad);
                    }
                    graphics2.setColor(Color.black);
                    string = String.valueOf(n7);
                    if (string.length() == 1) {
                        graphics2.drawString(string, n4 + 5, n5 + 3);
                    } else {
                        graphics2.drawString(string, n4 + 1, n5 + 3);
                    }
                    graphics2.setColor(Color.gray);
                    graphics2.drawRect(n9 + xpad - 2, n2 + ypad - 2, this.gridX - xpad2, this.gridY - 2 * ypad);
                    graphics2.setColor(this.getOutlineColor(sSCell));
                    graphics2.fillRect(n4 + xpad - 2, n2 + this.gridY - ypad - 3, this.gridX * n8 - xpad2 + 1, 3);
                    n4 += n8 * this.gridX;
                    ++n6;
                }
                ++n7;
            }
            n2 += this.gridY;
            ++n3;
        }
        graphics.drawImage(this.memImage, 0, 0, null);
    }

    void processSelection(int[][] nArray, boolean bl, boolean bl2) {
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray[n].length) {
                if (nArray[n][n2] == 1) {
                    if (bl2 && bl) {
                        this.selectableCells[n][n2].setSelected(0);
                    } else if (bl2) {
                        this.selectableCells[n][n2].setSelected(1);
                    } else {
                        this.selectableCells[n][n2].invertSelection();
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    int[] getCellUnderMouse(int n, int n2) {
        int n3 = (n - this.offsetX) / this.gridX - 2;
        int n4 = (n2 - this.offsetY) / this.gridY;
        if (n4 < this.selection.length && n4 >= 0 && n3 >= -2 && n3 < this.selection[n4].length) {
            return new int[]{n4, n3};
        }
        return null;
    }

    void updateObserver() {
        if (this.observer != null) {
            int[][] nArray = this.getCells();
            this.observer.update(this, nArray);
        }
    }

    int[][] getCells() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.selectableCells.length) {
            int n3 = 0;
            while (n3 < this.selectableCells[n2].length) {
                n += this.selectableCells[n2][n3].getSelected();
                ++n3;
            }
            ++n2;
        }
        int[][] nArray = new int[n][2];
        n = 0;
        int n4 = 0;
        while (n4 < this.selectableCells.length) {
            int n5 = 0;
            while (n5 < this.selectableCells[n4].length) {
                if (this.selectableCells[n4][n5].getSelected() == 1) {
                    nArray[n][0] = n4;
                    nArray[n][1] = n5;
                }
                n += this.selectableCells[n4][n5].getSelected();
                ++n5;
            }
            ++n4;
        }
        return nArray;
    }

    int[][] getSupportCells(int n, int n2) {
        int[][] nArrayArray = new int[n + 1][];
        int n3 = 0;
        while (n3 < nArrayArray.length) {
            nArrayArray[n3] = new int[this.selectableCells[n3].length];
            ++n3;
        }
        nArrayArray[n][n2] = 1;
        int n4 = n;
        while (n4 > 0) {
            int n5 = 0;
            while (n5 < nArrayArray[n4].length) {
                if (nArrayArray[n4][n5] != 0) {
                    SSCell sSCell = this.selectableCells[n4][n5].cell;
                    Vector vector = sSCell.bottom;
                    int n6 = 0;
                    while (n6 < vector.size()) {
                        SSCell sSCell2 = (SSCell)vector.elementAt(n6);
                        nArrayArray[sSCell2.layer][sSCell2.index] = 1;
                        ++n6;
                    }
                }
                ++n5;
            }
            --n4;
        }
        return nArrayArray;
    }

    public static void main(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            nArray[n] = Integer.parseInt(stringArray[n]);
            ++n;
        }
        DestroyableFrame destroyableFrame = new DestroyableFrame("Stellation Cells");
        destroyableFrame.add("Center", new Selection(null));
        destroyableFrame.pack();
        destroyableFrame.show();
    }

    public void setOffsetX(int n) {
        this.offsetX = n;
        this.repaint();
    }

    public void setOffsetY(int n) {
        this.offsetY = n;
        this.repaint();
    }

    static {
        Selection.color[0] = Color.white;
        Selection.color[1] = new Color(192, 192, 192);
    }

    class MouseListenerClass
    extends MouseAdapter {
        MouseListenerClass() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int[] nArray = Selection.this.getCellUnderMouse(mouseEvent.getX(), mouseEvent.getY());
            if (nArray == null) {
                return;
            }
            int n = nArray[1];
            int n2 = nArray[0];
            boolean bl = mouseEvent.isShiftDown();
            boolean bl2 = mouseEvent.isControlDown();
            if (n2 < Selection.this.selection.length && n2 >= 0) {
                if (n >= 0 && n < Selection.this.selection[n2].length) {
                    SSCell sSCell = Selection.this.getCellAt(nArray[0], nArray[1]);
                    if (sSCell.subCells != null) {
                        if (bl2 || bl) {
                            int[][] nArray2 = null;
                            int n3 = 0;
                            while (n3 < sSCell.subCells.length) {
                                int[][] nArray3 = Selection.this.getSupportCells(n2, Selection.this.selection[n2][n + 1 + n3].getIndex());
                                if (nArray2 == null) {
                                    nArray2 = nArray3;
                                } else {
                                    int n4 = 0;
                                    while (n4 < nArray2.length) {
                                        int n5 = 0;
                                        while (n5 < nArray2[n4].length) {
                                            if (nArray3[n4][n5] != 0) {
                                                nArray2[n4][n5] = 1;
                                            }
                                            ++n5;
                                        }
                                        ++n4;
                                    }
                                }
                                ++n3;
                            }
                            Selection.this.processSelection(nArray2, bl2, bl);
                        } else {
                            int n6 = 0;
                            while (n6 < sSCell.subCells.length) {
                                Selection.this.selection[n2][n + 1 + n6].invertSelection();
                                ++n6;
                            }
                        }
                    } else if (bl2 || bl) {
                        int[][] nArray4 = Selection.this.getSupportCells(n2, Selection.this.selection[n2][n].getIndex());
                        Selection.this.processSelection(nArray4, bl2, bl);
                    } else {
                        Selection.this.selection[n2][n].setSelected(1 - Selection.this.selection[n2][n].getSelected());
                    }
                    Selection.this.repaint();
                    Selection.this.updateObserver();
                } else if (n < 0) {
                    if (mouseEvent.isShiftDown()) {
                        int n7 = 0;
                        while (n7 < Selection.this.selection[n2].length) {
                            if (Selection.this.selection[n2][n7].cell.subCells == null) {
                                Selection.this.selection[n2][n7].setSelected(1);
                            }
                            ++n7;
                        }
                    } else {
                        int n8 = 0;
                        while (n8 < Selection.this.selection[n2].length) {
                            if (Selection.this.selection[n2][n8].cell.subCells == null) {
                                Selection.this.selection[n2][n8].invertSelection();
                            }
                            ++n8;
                        }
                    }
                    Selection.this.updateObserver();
                    Selection.this.repaint();
                }
            }
        }
    }
}

