/*
 * Decompiled with CFR 0.152.
 */
package PVS.polyhedra.stellation;

import PVS.Expression.VectorCalculator;
import PVS.Utils.Arrays;
import PVS.Utils.BorderPanel;
import PVS.Utils.Comparator;
import PVS.Utils.Fmt;
import PVS.Utils.LabelBitmap;
import PVS.Utils.PVSObserver;
import PVS.Utils.WindowOutputStream;
import PVS.Utils.WindowUtils;
import PVS.g3d.Canvas3D;
import PVS.g3d.Model3D;
import PVS.g3d.Stellation3D;
import PVS.polyhedra.Plane;
import PVS.polyhedra.Polyhedron;
import PVS.polyhedra.SSCell;
import PVS.polyhedra.Stellation;
import PVS.polyhedra.StellationCanvas;
import PVS.polyhedra.Symmetry;
import PVS.polyhedra.Vector3D;
import PVS.polyhedra.stellation.AboutDialog;
import PVS.polyhedra.stellation.DlgPlanes;
import PVS.polyhedra.stellation.DlgPrint;
import PVS.polyhedra.stellation.DlgSelectPoly;
import PVS.polyhedra.stellation.PolyNames;
import PVS.polyhedra.stellation.SelectionPanel;
import java.applet.Applet;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

public class Main
implements Runnable,
PVSObserver,
ActionListener {
    int currentCategory = 0;
    int currentPoly = 3;
    String polySymmetry = "Ih";
    String stellationSymmetry = "I";
    boolean usingPlanes = false;
    Stellation stellation = null;
    Polyhedron polyhedron;
    Vector3D[] polyhedronPlanes;
    Vector3D[] canonicalPlanes;
    String polyhedronName;
    Vector allcells = null;
    Vector subcells = null;
    SSCell[] currentCells;
    int[][] cellsIndex;
    String outType = "none";
    String fname = null;
    String vname = null;
    String prefix = "s";
    boolean hasOutput = false;
    boolean printToWindow = false;
    boolean bShowDiagram = false;
    boolean bMakeCells = false;
    boolean bShowCells = false;
    boolean doVrmlWriteScene = false;
    int maxIntersection = -1;
    int maxLayer = 1000;
    int vertexUp = 0;
    int faceToShow = 0;
    int nFaces = 0;
    boolean bWriteCells = false;
    boolean bWriteLayers = false;
    static PrintStream Out = System.out;
    static String MakeStellation = "Start";
    Button btnStart = new Button(MakeStellation);
    Button btnTest = new Button("test");
    Button btnTest1 = new Button("test1");
    MenuItem miSaveAsPOV = new MenuItem("Povray");
    MenuItem miSaveAsVRML = new MenuItem("VRML");
    MenuItem miSaveAsDXF = new MenuItem("DXF");
    MenuItem miMakePlanes = new MenuItem("Make Planes");
    MenuItem miUndo = new MenuItem("Undo");
    MenuItem miClearAll = new MenuItem("Clear All");
    MenuItem miPrefereces = new MenuItem("Preferences");
    MenuItem miPrint3DModel = new MenuItem("Print 3D Model");
    MenuItem miVectorCalculator = new MenuItem("Vector Calculator");
    MenuItem miPrintDiagram = new MenuItem("Print Diagram");
    MenuItem miSelectPolyhedron = new MenuItem("Select Polyhedron");
    boolean viewCells = true;
    boolean viewOutput = true;
    boolean viewDiagram = true;
    boolean view3D = true;
    CheckboxMenuItem miViewOutput = new CheckboxMenuItem("Output", this.viewOutput);
    CheckboxMenuItem miViewDiagram = new CheckboxMenuItem("Diagram", this.viewDiagram);
    CheckboxMenuItem miView3D = new CheckboxMenuItem("3D", this.view3D);
    CheckboxMenuItem miViewCells = new CheckboxMenuItem("Cells", this.viewCells);
    Button btnSelectPoly = new Button("Select...");
    MenuItem miConnectivityGraph = new MenuItem("Print Connectivity Graph");
    MenuItem miQuit = new MenuItem("Quit");
    Label polyName = new Label();
    Label polyInfoFaces = new Label();
    Label polyInfoVertices = new Label();
    Label polyInfoSymmetry = new Label();
    Image icon;
    Choice choice_symmetry = new Choice();
    Choice choice_face = new Choice();
    TextField tfPolyName = new TextField(20);
    Choice choice_vertexUp = new Choice();
    TextField tfMaxLayer = new TextField(5);
    StellationCanvas diagram = null;
    Frame frameDiagram = null;
    SelectionPanel selection = null;
    Frame frameSelection = null;
    Canvas3D canvas3D = null;
    Frame frame3D = null;
    Model3D model3D = null;
    Frame frameOutput;
    WindowOutputStream winStream;
    FrameClosingListener frameClosingListener = new FrameClosingListener();
    ViewListener viewListener = new ViewListener();
    LabelBitmap polyImage;
    Frame mainFrame;
    Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
    Thread thread = null;
    int[][] cellIndex = new int[0][0];
    static String[] symnames = DlgPlanes.symnames;
    PolyNames polyNames = new PolyNames();
    Applet applet;
    FileDialog file_load_dialog;
    FileDialog fileDialog;
    DlgPlanes dlgPlanes;
    DlgPrint dlgPrint;
    DlgSelectPoly dialogSelectPoly = null;
    static final double EPS = 1.0E-12;
    private static GridBagConstraints gbc = new GridBagConstraints();

    public Main(String string, String string2, Applet applet) {
        this.fname = string;
        this.stellationSymmetry = string2;
        this.applet = applet;
        this.mainFrame = new Frame("stellation");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            this.icon = this.loadImageFromJar("/images/stellation_main.jpg");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.icon != null) {
            this.mainFrame.setIconImage(this.icon);
        }
        this.mainFrame.addWindowListener(new WindowListenerClass());
        this.initUI();
        this.mainFrame.pack();
        String string3 = System.getProperty("java.vendor");
        String string4 = System.getProperty("java.version");
        System.err.println("java vendor: " + string3);
        System.err.println("java version: " + string4);
        if (string3.indexOf("Microsoft") != -1) {
            Dimension dimension = this.mainFrame.getPreferredSize();
            ((Component)this.mainFrame).setBounds(0, 0, dimension.width, dimension.height + 20);
            this.mainFrame.validate();
        }
        this.mainFrame.show();
        this.thread = new Thread(this);
        this.thread.setPriority(1);
        this.thread.start();
    }

    void initUI() {
        this.mainFrame.setFont(new Font("Helvetica", 0, 12));
        ((Component)this.mainFrame).setBackground(Color.lightGray);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.mainFrame.setLayout(gridBagLayout);
        this.btnStart.addActionListener(this);
        this.btnTest.addActionListener(this);
        this.btnTest1.addActionListener(this);
        this.polyImage = new LabelBitmap(80, 80);
        Font font = new Font("Serif", 1, 16);
        this.choice_symmetry.setFont(font);
        this.choice_face.setFont(font);
        this.choice_vertexUp.setFont(font);
        int n = 0;
        while (n < 10) {
            this.choice_face.addItem(Integer.toString(n, 10));
            this.choice_vertexUp.addItem(Integer.toString(n, 10));
            ++n;
        }
        this.choice_face.addItemListener(new FaceListener());
        this.choice_vertexUp.addItemListener(new VertexListener());
        this.btnSelectPoly.addActionListener(new SelectPolyhedron());
        this.updatePolyImage();
        this.choice_symmetry.addItemListener(new SymmetryListener());
        this.choice_symmetry.select(this.getSymmetryIndex(this.stellationSymmetry));
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        BorderPanel borderPanel = new BorderPanel();
        BorderPanel borderPanel2 = new BorderPanel();
        borderPanel2.setLayout(gridBagLayout);
        borderPanel.add("Center", this.polyImage);
        int n2 = 0;
        WindowUtils.constrain((Container)borderPanel2, (Component)this.polyInfoFaces, 1, n2++, 1, 1, 2, 10, 1.0, 0.0);
        WindowUtils.constrain((Container)borderPanel2, (Component)this.polyInfoVertices, 1, n2++, 1, 1, 2, 10, 1.0, 0.0);
        WindowUtils.constrain((Container)borderPanel2, (Component)this.polyInfoSymmetry, 1, n2++, 1, 1, 2, 10, 1.0, 0.0);
        WindowUtils.constrain((Container)borderPanel2, (Component)this.btnSelectPoly, 1, n2++, 1, 1, 0, 17, 0.0, 0.0);
        WindowUtils.constrain(panel, borderPanel, 0, 0, 1, 1, 1, 10, 0.0, 0.0, 0, 0, 2, 2);
        WindowUtils.constrain(panel, borderPanel2, 1, 0, 1, 1, 1, 10, 1.0, 0.0, 0, 0, 0, 2);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 2, 5, 5));
        panel2.add(this.btnStart);
        Panel panel3 = new Panel();
        panel3.setLayout(gridBagLayout);
        BorderPanel borderPanel3 = new BorderPanel();
        borderPanel3.setLayout(gridBagLayout);
        BorderPanel borderPanel4 = new BorderPanel();
        borderPanel4.setLayout(gridBagLayout);
        boolean bl = false;
        WindowUtils.constrain(borderPanel3, this.tfPolyName, 0, 0, 1, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        WindowUtils.constrain(borderPanel4, new Label("Symmetry ", 1), 0, 1, 1, 1, 2, 13, 1.0, 0.0, 0, 2, 0, 0);
        WindowUtils.constrain(borderPanel4, this.choice_symmetry, 0, 2, 1, 1, 2, 11, 1.0, 1.0, 0, 2, 0, 0);
        WindowUtils.constrain(borderPanel4, new Label("Face ", 1), 1, 1, 1, 1, 2, 13, 0.5, 0.0, 0, 2, 0, 0);
        WindowUtils.constrain(borderPanel4, this.choice_face, 1, 2, 1, 1, 2, 11, 0.5, 1.0, 0, 2, 0, 0);
        WindowUtils.constrain(borderPanel4, new Label("Vertex Up", 1), 2, 1, 1, 1, 2, 13, 0.5, 0.0, 0, 2, 0, 0);
        WindowUtils.constrain(borderPanel4, this.choice_vertexUp, 2, 2, 1, 1, 2, 11, 0.5, 1.0, 0, 2, 0, 0);
        n2 = 0;
        WindowUtils.constrain((Container)this.mainFrame, (Component)panel, 0, n2++, 1, 1, 2, 11, 1.0, 0.0);
        WindowUtils.constrain((Container)this.mainFrame, (Component)borderPanel3, 0, n2++, 1, 1, 2, 10, 1.0, 0.0);
        WindowUtils.constrain((Container)this.mainFrame, (Component)borderPanel4, 0, n2++, 1, 1, 1, 10, 1.0, 1.0);
        WindowUtils.constrain(this.mainFrame, panel2, 0, n2++, 1, 1, 0, 10, 0.0, 1.0, 5, 5, 5, 5);
        this.mainFrame.setMenuBar(this.makeMenuBar());
        this.createSelectionFrame();
        this.createOutputStream();
    }

    void initSymChoice() {
        this.choice_symmetry.removeAll();
        symnames = Symmetry.getSubgroups(this.polySymmetry);
        int n = 0;
        while (n < symnames.length) {
            this.choice_symmetry.addItem(symnames[n]);
            ++n;
        }
    }

    MenuBar makeMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("Export");
        menu.add(this.miSaveAsVRML);
        menu.add(this.miSaveAsPOV);
        menu.add(this.miSaveAsDXF);
        Menu menu2 = new Menu("File");
        menu2.add(menu);
        menu2.addSeparator();
        menu2.add(this.miMakePlanes);
        menu2.add(this.miConnectivityGraph);
        menu2.addSeparator();
        menu2.add(this.miSelectPolyhedron);
        menu2.add(this.miPrintDiagram);
        menu2.add(this.miPrint3DModel);
        menu2.addSeparator();
        menu2.add(this.miVectorCalculator);
        menu2.addSeparator();
        menu2.add(this.miQuit);
        this.miSaveAsVRML.addActionListener(this);
        this.miSaveAsPOV.addActionListener(this);
        this.miSaveAsDXF.addActionListener(this);
        this.miMakePlanes.addActionListener(this);
        this.miConnectivityGraph.addActionListener(this);
        this.miQuit.addActionListener(this);
        this.miPrintDiagram.addActionListener(new PrintDiagram());
        this.miPrint3DModel.addActionListener(new Print3DModel());
        this.miVectorCalculator.addActionListener(new onVectorCalculator());
        this.miSelectPolyhedron.addActionListener(new SelectPolyhedron());
        Menu menu3 = new Menu("Edit");
        menu3.add(this.miUndo);
        menu3.add(this.miClearAll);
        this.miUndo.addActionListener(this);
        this.miClearAll.addActionListener(this);
        Menu menu4 = new Menu("View");
        menu4.add(this.miViewDiagram);
        menu4.add(this.miView3D);
        menu4.add(this.miViewCells);
        menu4.add(this.miViewOutput);
        this.miViewDiagram.addItemListener(this.viewListener);
        this.miView3D.addItemListener(this.viewListener);
        this.miViewCells.addItemListener(this.viewListener);
        this.miViewOutput.addItemListener(this.viewListener);
        menuBar.add(menu2);
        menuBar.add(menu3);
        menuBar.add(menu4);
        return menuBar;
    }

    void createOutputStream() {
        this.winStream = new WindowOutputStream();
        Out = new PrintStream(this.winStream);
        this.frameOutput = this.winStream.getFrame();
        ((Component)this.frameOutput).setVisible(this.viewOutput);
        this.frameOutput.addWindowListener(this.frameClosingListener);
        ((Component)this.frameOutput).setLocation(0, this.screen.height / 2);
        ((Component)this.frameOutput).setSize(this.screen.width - this.screen.height / 2, this.screen.height / 2 - 30);
        this.frameOutput.validate();
        this.frameOutput.setTitle("output");
        if (this.icon != null) {
            this.frameOutput.setIconImage(this.icon);
        }
        Polyhedron.Out = Stellation.Out = Out;
        try {
            System.setOut(Out);
            System.setErr(Out);
        }
        catch (Exception exception) {
            System.out.println("failed call System.setOut()");
        }
    }

    void createSelectionFrame() {
        this.selection = new SelectionPanel(this);
        this.frameSelection = new Frame("Cells");
        this.frameSelection.addWindowListener(this.frameClosingListener);
        ((Component)this.frameSelection).setBackground(Color.white);
        this.frameSelection.setLayout(new GridLayout(1, 1));
        this.frameSelection.add(this.selection);
        ((Component)this.frameSelection).setBounds(this.screen.width - this.screen.height, 0, this.screen.height / 2, this.screen.height / 2);
        this.frameSelection.validate();
        this.frameSelection.show();
        if (this.icon != null) {
            this.frameSelection.setIconImage(this.icon);
        }
    }

    public void update(Object object, Object object2) {
        if (object == this.selection) {
            this.cellsIndex = (int[][])object2;
            this.showDiagram(this.cellsIndex);
        } else if (object == this.canvas3D) {
            int[] nArray;
            Object[] objectArray = (Object[])object2;
            double[] dArray = (double[])objectArray[0];
            int n = (Integer)objectArray[1];
            double[] dArray2 = (double[])objectArray[2];
            if ((n & 2) == 0 && (n & 1) == 0 && (n & 8) == 0) {
                Out.println("normal: " + Main.chop(dArray2[0]) + "," + Main.chop(dArray2[1]) + "," + Main.chop(dArray2[2]));
                return;
            }
            boolean bl = true;
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((nArray = this.stellation.findCell(this.currentCells, new Vector3D(dArray), bl)) != null) {
                int[][] nArray2 = this.selection.modifySelection(nArray, 3);
                this.showDiagram(nArray2);
                this.selection.initCellField();
            }
        } else {
            int[] nArray = (int[])object2;
            int n = nArray[1];
            int[] nArray3 = null;
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 4: {
                    nArray3 = this.stellation.findCell(this.subcells, this.faceToShow, nArray[0], 1);
                    break;
                }
                case 3: {
                    nArray3 = this.stellation.findCell(this.subcells, this.faceToShow, nArray[0], 0);
                }
            }
            if (nArray3 != null) {
                int[][] nArray4 = this.selection.modifySelection(nArray3, n);
                this.showDiagram(nArray4);
                this.selection.initCellField();
            }
        }
    }

    int[][] makeNewCellIndex(int[] nArray) {
        int n = 0;
        while (n < this.cellIndex.length) {
            if (this.cellIndex[n][0] == nArray[0] && this.cellIndex[n][1] == nArray[1]) {
                int[][] nArrayArray = new int[this.cellIndex.length - 1][];
                int n2 = 0;
                while (n2 < n) {
                    nArrayArray[n2] = this.cellIndex[n2];
                    ++n2;
                }
                int n3 = n;
                while (n3 < this.cellIndex.length - 1) {
                    nArrayArray[n3] = this.cellIndex[n3 + 1];
                    ++n3;
                }
                return nArrayArray;
            }
            ++n;
        }
        int[][] nArrayArray = new int[this.cellIndex.length + 1][];
        int n4 = 0;
        while (n4 < this.cellIndex.length) {
            nArrayArray[n4] = this.cellIndex[n4];
            ++n4;
        }
        nArrayArray[this.cellIndex.length] = nArray;
        return nArrayArray;
    }

    public void run() {
        this.btnStart.setLabel("Stop");
        this.winStream.clear();
        Out.println("stellationSymmetry: " + this.stellationSymmetry);
        int n = 0;
        try {
            n = Integer.valueOf(this.tfMaxLayer.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n > 0) {
            this.maxLayer = n;
        }
        if (this.usingPlanes) {
            this.stellation = new Stellation(this.canonicalPlanes, this.polySymmetry, this.maxIntersection);
            this.nFaces = this.stellation.faces.length;
        } else if (this.polyhedron != null) {
            this.stellation = new Stellation(this.canonicalPlanes, this.polySymmetry, this.maxIntersection);
            this.nFaces = this.stellation.faces.length;
        }
        this.allcells = this.stellation.makeCells2(this.polySymmetry, this.stellationSymmetry, this.maxLayer);
        this.initSubcells();
        this.btnStart.setLabel(MakeStellation);
    }

    public void doTest() {
        this.stellation = new Stellation(this.canonicalPlanes, this.polySymmetry, this.maxIntersection);
        this.nFaces = this.stellation.faces.length;
        this.allcells = this.stellation.makeCells2(this.polySymmetry, this.stellationSymmetry, this.maxLayer);
        this.initSubcells();
    }

    public void doTest1() {
        int n = 0;
        while (n < this.allcells.size()) {
            Out.print(Fmt.fmt(n, 2));
            Out.print(":");
            Vector vector = (Vector)this.allcells.elementAt(n);
            Object[] objectArray = new SSCell[vector.size()];
            vector.copyInto(objectArray);
            Arrays.sort(objectArray, 0, objectArray.length, (Comparator)objectArray[0]);
            int n2 = 0;
            while (n2 < objectArray.length) {
                Object object = objectArray[n2];
                Out.print(((SSCell)object).cells.length + ".");
                Out.print(((SSCell)object).getNFacets() + ".");
                Out.print(((SSCell)object).getNVertices() + " ");
                ++n2;
            }
            Out.println();
            ++n;
        }
    }

    void createSubcells(Vector vector, String string) {
        int n = 0;
        while (n < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n);
            int n2 = 0;
            while (n2 < vector2.size()) {
                SSCell sSCell = (SSCell)vector2.elementAt(n2);
                sSCell.setSubCells(Stellation.makeSymmetricalSubCells(sSCell, string));
                ++n2;
            }
            ++n;
        }
    }

    void initSubcells() {
        this.subcells = this.makeSubcells(this.allcells);
        Stellation.makeConnectivityGraph(this.subcells);
        this.selection.setArray(this.allcells, this.subcells);
        this.showDiagram(new int[0][0]);
        this.diagram.init();
        this.choice_face.removeAll();
        if (this.stellation.getFaces().length > 0) {
            Integer[] integerArray = this.stellation.getNonEquivalentFaces(this.stellationSymmetry);
            if (integerArray.length > 1) {
                int n = 0;
                while (n < integerArray.length) {
                    this.choice_face.addItem(integerArray[n].toString());
                    ++n;
                }
                this.choice_face.setEnabled(true);
            } else {
                this.choice_face.setEnabled(false);
            }
        }
    }

    void createMenu() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File", true);
        menu.add("Load...");
        menu.add("Quit");
        Menu menu2 = new Menu("Help", true);
        menu2.add("About...");
        menuBar.add(menu);
        menuBar.add(menu2);
    }

    void doLoad() {
        if (this.file_load_dialog == null) {
            this.file_load_dialog = new FileDialog(WindowUtils.getMainWindow(this.mainFrame), "Load polyhedron", 0);
        }
        this.file_load_dialog.pack();
        this.file_load_dialog.show();
        String string = this.file_load_dialog.getFile();
        String string2 = this.file_load_dialog.getDirectory();
        if (string != null && string2 != null) {
            this.fname = string2 + string;
            this.doStart();
        }
    }

    static void printHelp(PrintStream printStream) {
    }

    Polyhedron readOffFile(String string) {
        Polyhedron polyhedron = new Polyhedron();
        try {
            String string2 = "/images/off/" + string + ".gif";
            InputStream inputStream = null;
            try {
                inputStream = this.getClass().getResourceAsStream(string2);
            }
            catch (Exception exception) {
                System.out.println("getClass().getResourceAsStream(" + string2 + ") failed");
            }
            try {
                if (inputStream == null && this.applet != null) {
                    InputStream inputStream2 = this.getClass().getResourceAsStream("/images/poly/" + string + "_tmb.gif");
                    if (inputStream2 != null) {
                        // empty if block
                    }
                    string2 = "images/off/" + string + ".off";
                    URL uRL = new URL(this.applet.getDocumentBase(), string2);
                    System.out.println("opening: " + uRL);
                    inputStream = uRL.openStream();
                }
            }
            catch (Exception exception) {
                System.out.println("URL.openStream(" + string2 + ") failed");
            }
            if (inputStream != null) {
                polyhedron.readOFF(inputStream);
                polyhedron.makeCCW();
                inputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return polyhedron;
    }

    void readFile(String string) {
        Polyhedron polyhedron = new Polyhedron();
        if (string.endsWith(".off")) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                polyhedron.readOFF(fileInputStream);
                polyhedron.makeCCW();
                fileInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace(Out);
                return;
            }
            Out.println("read " + string + " OK");
            Out.flush();
            this.stellation = new Stellation(polyhedron, this.maxIntersection);
            this.nFaces = polyhedron.ifaces.length;
        } else {
            Vector3D[] vector3DArray = Stellation.readVectors(string);
            this.nFaces = vector3DArray.length;
            Out.println(string + " read OK");
            Out.flush();
            this.stellation = new Stellation(vector3DArray, this.maxIntersection);
        }
    }

    void showDiagram(int[][] nArray) {
        try {
            this.cellIndex = nArray;
            SSCell[] sSCellArray = this.stellation.getStellation(this.subcells, nArray);
            Object[][] objectArray = Stellation.getStellationDiagram(sSCellArray, this.faceToShow);
            if (this.stellation.getFaces().length == 0) {
                Out.println("Can't make stellation!");
                return;
            }
            this.diagram = this.stellation.showStellationDiagram(objectArray, Stellation.makeStellationName(nArray), this.faceToShow, this.vertexUp, this.stellationSymmetry, this.diagram);
            if (this.frameDiagram == null) {
                this.diagram.addObserver(this);
                this.frameDiagram = this.diagram.getFrame();
                this.frameDiagram.addWindowListener(this.frameClosingListener);
                ((Component)this.frameDiagram).setBounds(this.screen.width - this.screen.height / 2, this.screen.height / 2, this.screen.height / 2, this.screen.height / 2 - 30);
                this.frameDiagram.validate();
                this.frameDiagram.setTitle("Diagram");
                if (this.icon != null) {
                    this.frameDiagram.setIconImage(this.icon);
                }
            }
            this.showModel(sSCellArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void showModel(SSCell[] sSCellArray) {
        Object object;
        this.currentCells = sSCellArray;
        Polyhedron polyhedron = this.stellation.getPolyhedron(sSCellArray);
        double[] dArray = new double[polyhedron.vertices.length * 3];
        int n = 0;
        int n2 = 0;
        while (n < polyhedron.vertices.length) {
            object = polyhedron.vertices[n];
            dArray[n2++] = object.x;
            dArray[n2++] = object.y;
            dArray[n2++] = object.z;
            ++n;
        }
        object = new int[polyhedron.ifaces.length][];
        int n3 = 0;
        while (n3 < ((int[][])object).length) {
            object[n3] = new int[polyhedron.ifaces[n3].length];
            int n4 = 0;
            while (n4 < object[n3].length) {
                object[n3][n4] = polyhedron.ifaces[n3][n4] * 3;
                ++n4;
            }
            ++n3;
        }
        int[][] nArray = new int[0][2];
        int n5 = 0;
        while (n5 < nArray.length) {
            nArray[n5][0] = polyhedron.edges[n5][0] * 3;
            nArray[n5][1] = polyhedron.edges[n5][1] * 3;
            ++n5;
        }
        this.model3D = new Stellation3D(dArray, (int[][])object, nArray, polyhedron.colors, polyhedron.icolor, this.stellationSymmetry, this.polyhedronPlanes);
        if (this.canvas3D == null) {
            this.frame3D = new Frame("3D view");
            this.frame3D.addWindowListener(this.frameClosingListener);
            ((Component)this.frame3D).setBackground(Color.white);
            this.canvas3D = new Canvas3D(this.model3D);
            Canvas3D.Out = Out;
            this.canvas3D.setObserver(this);
            this.frame3D.add("Center", this.canvas3D);
            ((Component)this.frame3D).setBounds(this.screen.width - this.screen.height / 2, 0, this.screen.height / 2, this.screen.height / 2);
            this.frame3D.validate();
            this.frame3D.show();
            if (this.icon != null) {
                this.frame3D.setIconImage(this.icon);
            }
        } else {
            this.canvas3D.setModel(this.model3D);
        }
    }

    public void doStop() {
        if (this.thread.isAlive()) {
            this.thread.stop();
        }
        this.btnStart.setLabel(MakeStellation);
    }

    public void doStart() {
        this.thread = new Thread(this);
        this.thread.setPriority(1);
        this.thread.start();
    }

    public void doAbout() {
        AboutDialog aboutDialog = new AboutDialog(this.mainFrame, "Stellation", true);
        aboutDialog.pack();
        aboutDialog.show();
    }

    void updatePolyImage() {
        if (this.usingPlanes) {
            this.polyImage.setImage(this.loadImageFromJar("/images/stellation_main.jpg"));
            this.polyInfoFaces.setText("faces:    " + this.polyhedronPlanes.length);
            this.polyInfoVertices.setText("symmetry: " + this.polySymmetry);
            this.polyInfoSymmetry.setText("");
            this.tfPolyName.setText("user defined planes");
            this.initSymChoice();
        } else {
            this.polyhedronName = this.polyNames.name(this.currentCategory, this.currentPoly);
            String string = this.polyNames.fname(this.currentCategory, this.currentPoly);
            Image image = null;
            try {
                image = this.loadImageFromJar("/images/poly/" + string + "_tmb.gif");
            }
            catch (Exception exception) {
                exception.printStackTrace(Out);
            }
            this.polyImage.setImage(image);
            this.polyhedron = this.readOffFile(string);
            this.stellationSymmetry = this.polySymmetry = this.polyNames.symmetry(this.currentCategory, this.currentPoly);
            this.initSymChoice();
            this.makePolyhedronPlanes(this.polyhedron);
            this.polyInfoFaces.setText("faces:    " + this.polyhedron.ifaces.length);
            this.polyInfoVertices.setText("vertices: " + this.polyhedron.vertices.length);
            this.polyInfoSymmetry.setText("symmetry: " + this.polySymmetry);
            this.tfPolyName.setText(this.polyhedronName);
        }
    }

    public void doQuit() {
        this.mainFrame.dispose();
        this.frame3D.dispose();
        this.frameOutput.dispose();
        this.frameSelection.dispose();
        this.frameDiagram.dispose();
        try {
            if (this.applet == null) {
                System.exit(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doExport(String string) {
        try {
            Object object;
            String[] stringArray;
            Object object2;
            OutputStream outputStream = null;
            try {
                if (this.fileDialog == null) {
                    this.fileDialog = new FileDialog(WindowUtils.getFrame(this.mainFrame), "export polyhedron as", 1);
                }
                ((Dialog)this.fileDialog).setTitle("Export Polyhedron as " + string);
                if (string.equals("VRML")) {
                    this.fileDialog.setFile("poly.wrl");
                } else if (string.equals("POVRAY")) {
                    this.fileDialog.setFile("poly.pov");
                } else if (string.equals("DXF")) {
                    this.fileDialog.setFile("poly.dxf");
                }
                this.fileDialog.show();
                if (this.fileDialog.getFile() == null) {
                    return;
                }
                object2 = this.fileDialog.getFile();
                stringArray = this.fileDialog.getDirectory();
                object = (String)stringArray + (String)object2;
                File file = new File((String)object);
                outputStream = new FileOutputStream(file);
                Stellation.Out.println("saving polyhedron to " + (String)object);
            }
            catch (Exception exception) {
                outputStream = System.out;
                System.out.println("---------start of polyhedron");
                Stellation.Out.println("printing file into java console");
            }
            object2 = this.stellation.getPolyhedron(this.currentCells);
            stringArray = this.usingPlanes ? new String[]{"polyhedron stellation generated from set of planes", "  planes: " + this.dlgPlanes.getSourceVectorsAsString(), "  symmetry: " + this.polySymmetry + " / " + this.stellationSymmetry, "  cells: " + this.selection.cellField.getText(), "  exported from Stellation Program by Vladimir Bulatov", "  http://www.physics.orst.edu/~bulatov/polyhedra/stellation_applet/index.html"} : new String[]{"polyhedron: " + this.polyhedronName, "  symmetry: " + this.polySymmetry + " / " + this.stellationSymmetry, "  cells: " + this.selection.cellField.getText(), "  exported from Stellation Program by Vladimir Bulatov", "  http://www.physics.orst.edu/~bulatov/polyhedra/stellation_applet/index.html"};
            ((Polyhedron)object2).setDescription(stringArray);
            Polyhedron.outFaces = true;
            Polyhedron.outEdges = true;
            Polyhedron.outVertices = true;
            Polyhedron.outColor = false;
            object = new PrintStream(outputStream);
            if (string.equals("POVRAY")) {
                ((Polyhedron)object2).writePOV((PrintStream)object);
            } else if (string.equals("VRML")) {
                ((Polyhedron)object2).writeVrml((PrintStream)object);
            } else if (string.equals("DXF")) {
                ((Polyhedron)object2).writeDXF((OutputStream)object);
            }
            ((PrintStream)object).close();
            if (outputStream != System.out) {
                outputStream.close();
            } else {
                System.out.println("---------end of polyhedron");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Load...")) {
            this.doLoad();
        } else if (string.equals("Quit")) {
            this.doQuit();
        } else if (string.equals("About...")) {
            this.doAbout();
        } else if (string.equals(this.miSaveAsVRML.getLabel())) {
            this.doExport("VRML");
        } else if (string.equals(this.miSaveAsPOV.getLabel())) {
            this.doExport("POVRAY");
        } else if (string.equals(this.miSaveAsDXF.getLabel())) {
            this.doExport("DXF");
        } else if (string.equals(this.miUndo.getLabel())) {
            this.selection.doUndo();
        } else if (string.equals(this.miClearAll.getLabel())) {
            this.selection.doClearAll();
        } else if (string.equals(this.miMakePlanes.getLabel())) {
            this.doMakePlanes();
        } else if (string.equals(this.miConnectivityGraph.getLabel())) {
            this.printConnectivityGraph();
        } else if (string.equals("Stop")) {
            this.doStop();
        } else if (string.equals(MakeStellation)) {
            this.doStart();
        } else if (string.equals(this.btnTest.getLabel())) {
            this.doTest();
        } else if (string.equals(this.btnTest1.getLabel())) {
            this.doTest1();
        }
    }

    void doMakePlanes() {
        if (this.dlgPlanes == null) {
            this.dlgPlanes = new DlgPlanes(this.canonicalPlanes, this.polySymmetry);
        }
        if (!this.dlgPlanes.edit(this.mainFrame)) {
            return;
        }
        this.polyhedronPlanes = this.dlgPlanes.getPlanes();
        this.stellationSymmetry = this.polySymmetry = this.dlgPlanes.getSymmetry();
        this.makeCanonicalPlanes();
        this.initSymChoice();
        this.usingPlanes = true;
        this.updatePolyImage();
    }

    void printConnectivityGraph() {
        Out.println("\nConnectivity Graph:");
        int n = 0;
        while (n < this.subcells.size()) {
            Vector vector = (Vector)this.subcells.elementAt(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                SSCell sSCell = (SSCell)vector.elementAt(n2);
                Out.print(n + "." + n2 + ": (");
                int n3 = 0;
                while (n3 < sSCell.bottom.size()) {
                    SSCell sSCell2 = (SSCell)sSCell.bottom.elementAt(n3);
                    Out.print(sSCell2.layer + "." + sSCell2.index + " ");
                    ++n3;
                }
                Out.print(") (");
                int n4 = 0;
                while (n4 < sSCell.top.size()) {
                    SSCell sSCell3 = (SSCell)sSCell.top.elementAt(n4);
                    Out.print(sSCell3.layer + "." + sSCell3.index + " ");
                    ++n4;
                }
                Out.println(")");
                ++n2;
            }
            ++n;
        }
    }

    Vector makeSubcells(Vector vector) {
        this.subcells = new Vector();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Vector vector2 = (Vector)vector.elementAt(n2);
            Vector<SSCell> vector3 = new Vector<SSCell>();
            int n3 = 0;
            while (n3 < vector2.size()) {
                SSCell sSCell = (SSCell)vector2.elementAt(n3);
                if (sSCell.subCells != null) {
                    int n4 = 0;
                    while (n4 < sSCell.subCells.length) {
                        vector3.addElement(sSCell.subCells[n4]);
                        ++n4;
                    }
                }
                ++n3;
            }
            this.subcells.addElement(vector3);
            ++n2;
        }
        return this.subcells;
    }

    Image loadImageFromJar(String string) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        byte[] byArray = null;
        byArray = null;
        try {
            int n;
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                Out.println("ImageLoader.loadFromJar getResourceAsStream failed on " + string);
                return null;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byArray = new byte[1024];
            while ((n = bufferedInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            System.err.println("ImageLoader.loadFromJar IOException: " + iOException);
            return null;
        }
        if (byArray == null) {
            Out.println("ImageLoader.loadFromJar: " + string + " not found.");
            return null;
        }
        if (byArray.length == 0) {
            Out.println("ImageLoader.loadFromJar: " + string + " is zero-length");
            return null;
        }
        return toolkit.createImage(byArray);
    }

    public static void main(String[] stringArray) {
        String string = "off/u27.off";
        String string2 = "I";
        if (stringArray.length == 0) {
            System.out.println("usage: ");
            System.out.println(" -i <input file>");
            System.out.println(" -y <stellationSymmetry>");
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) == '-') {
                switch (stringArray[n].charAt(1)) {
                    case 'i': {
                        string = stringArray[++n];
                        break;
                    }
                    case 'y': {
                        string2 = stringArray[++n];
                    }
                }
            }
            ++n;
        }
        new Main(string, string2, null);
    }

    int getSymmetryIndex(String string) {
        int n = 0;
        while (n < symnames.length) {
            if (string.equals(symnames[n])) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    void makePolyhedronPlanes(Polyhedron polyhedron) {
        this.polyhedronPlanes = new Vector3D[polyhedron.ifaces.length];
        int n = 0;
        while (n < polyhedron.ifaces.length) {
            Plane plane = Stellation.getPlane(polyhedron, n);
            this.polyhedronPlanes[n] = plane.v.mul(plane.d);
            ++n;
        }
        this.makeCanonicalPlanes();
    }

    void makeCanonicalPlanes() {
        Symmetry.CanonicalTester canonicalTester = Symmetry.getCanonicalTester(this.polySymmetry);
        Vector<Vector3D> vector = new Vector<Vector3D>();
        Hashtable<Vector3D, Vector3D> hashtable = new Hashtable<Vector3D, Vector3D>();
        int n = 0;
        while (n < this.polyhedronPlanes.length) {
            if (canonicalTester.test(this.polyhedronPlanes[n])) {
                Vector3D vector3D = new Vector3D(Main.chop(this.polyhedronPlanes[n].x), Main.chop(this.polyhedronPlanes[n].y), Main.chop(this.polyhedronPlanes[n].z));
                if (hashtable.get(vector3D) == null) {
                    hashtable.put(vector3D, vector3D);
                    vector.addElement(vector3D);
                    Out.println(n + ": " + Fmt.fmt(vector3D.x, 17, 14) + Fmt.fmt(vector3D.y, 17, 14) + Fmt.fmt(vector3D.z, 17, 14) + " canonical vector");
                } else {
                    Out.println(n + ": " + Fmt.fmt(vector3D.x, 17, 14) + Fmt.fmt(vector3D.y, 17, 14) + Fmt.fmt(vector3D.z, 17, 14) + " duplicated canonical vector, ignored");
                }
            }
            ++n;
        }
        this.canonicalPlanes = new Vector3D[vector.size()];
        if (this.canonicalPlanes.length != 0) {
            vector.copyInto(this.canonicalPlanes);
        }
        if (this.dlgPlanes != null) {
            this.dlgPlanes.setPlanes(this.canonicalPlanes, this.polySymmetry);
        }
    }

    static double chop(double d) {
        if (d < -1.0E-12 || d > 1.0E-12) {
            return d;
        }
        return 0.0;
    }

    class ViewListener
    implements ItemListener {
        ViewListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            System.out.println(itemSelectable);
            if (itemSelectable == Main.this.miViewDiagram) {
                Main.this.viewDiagram = !Main.this.viewDiagram;
                ((Component)Main.this.frameDiagram).setVisible(Main.this.viewDiagram);
                Main.this.miViewDiagram.setState(Main.this.viewDiagram);
            } else if (itemSelectable == Main.this.miViewCells) {
                Main.this.viewCells = !Main.this.viewCells;
                ((Component)Main.this.frameSelection).setVisible(Main.this.viewCells);
                Main.this.miViewCells.setState(Main.this.viewCells);
            } else if (itemSelectable == Main.this.miView3D) {
                Main.this.view3D = !Main.this.view3D;
                ((Component)Main.this.frame3D).setVisible(Main.this.view3D);
                Main.this.miView3D.setState(Main.this.view3D);
            } else if (itemSelectable == Main.this.miViewOutput) {
                Main.this.viewOutput = !Main.this.viewOutput;
                ((Component)Main.this.frameOutput).setVisible(Main.this.viewOutput);
                Main.this.miViewOutput.setState(Main.this.viewOutput);
            }
        }
    }

    class FrameClosingListener
    extends WindowAdapter {
        FrameClosingListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Component component = windowEvent.getComponent();
            System.out.println(component);
            if (component == Main.this.frameDiagram) {
                ((Component)Main.this.frameDiagram).setVisible(false);
                Main.this.miViewDiagram.setState(false);
                Main.this.viewDiagram = false;
            } else if (component == Main.this.frameSelection) {
                ((Component)Main.this.frameSelection).setVisible(false);
                Main.this.miViewCells.setState(false);
                Main.this.viewCells = false;
            } else if (component == Main.this.frame3D) {
                ((Component)Main.this.frame3D).setVisible(false);
                Main.this.view3D = false;
                Main.this.miView3D.setState(false);
            } else if (component == Main.this.frameOutput) {
                ((Component)Main.this.frameOutput).setVisible(false);
                Main.this.viewOutput = false;
                Main.this.miViewOutput.setState(false);
            }
        }
    }

    class SelectPolyhedron
    implements ActionListener {
        SelectPolyhedron() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray;
            if (Main.this.dialogSelectPoly == null) {
                Main.this.dialogSelectPoly = new DlgSelectPoly();
            }
            if ((nArray = Main.this.dialogSelectPoly.getPolyhedron(Main.this.mainFrame, Main.this.currentCategory, Main.this.currentPoly)) != null) {
                Main.this.currentCategory = nArray[0];
                Main.this.currentPoly = nArray[1];
                Main.this.usingPlanes = false;
                Main.this.updatePolyImage();
            }
        }
    }

    class Print3DModel
    implements ActionListener {
        Print3DModel() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(Main.this.mainFrame, "Print Diagram", null);
            if (printJob == null) {
                return;
            }
            Graphics graphics = printJob.getGraphics();
            Dimension dimension = printJob.getPageDimension();
            System.out.println("printing 3d model");
            Main.this.canvas3D.paint(graphics, dimension.width, dimension.height);
            printJob.end();
        }
    }

    class onVectorCalculator
    implements ActionListener {
        onVectorCalculator() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new VectorCalculator().show();
        }
    }

    class PrintDiagram
    implements ActionListener {
        PrintDiagram() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            if (Main.this.dlgPrint == null) {
                Main.this.dlgPrint = new DlgPrint();
            }
            if (bl = Main.this.dlgPrint.edit(Main.this.mainFrame, Main.this.diagram.getRenderingShapes())) {
                // empty if block
            }
        }
    }

    class WindowListenerClass
    extends WindowAdapter {
        WindowListenerClass() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Main.this.doQuit();
        }

        public void windowIconified(WindowEvent windowEvent) {
            Main.this.frame3D.hide();
            Main.this.frameSelection.hide();
            Main.this.frameOutput.hide();
            Main.this.frameDiagram.hide();
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            Main.this.frame3D.show(Main.this.view3D);
            ((Component)Main.this.frameSelection).setVisible(Main.this.viewCells);
            Main.this.frameOutput.show(Main.this.viewOutput);
            Main.this.frameDiagram.show(Main.this.viewDiagram);
        }
    }

    class VertexListener
    implements ItemListener {
        VertexListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                Main.this.vertexUp = Integer.parseInt(Main.this.choice_vertexUp.getSelectedItem());
                Main.this.showDiagram(Main.this.cellIndex);
            }
        }
    }

    class FaceListener
    implements ItemListener {
        FaceListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                Main.this.faceToShow = Integer.parseInt(Main.this.choice_face.getSelectedItem());
                Main.this.showDiagram(Main.this.cellIndex);
            }
        }
    }

    class SymmetryListener
    implements ItemListener {
        SymmetryListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                Main.this.stellationSymmetry = Main.this.choice_symmetry.getSelectedItem();
                Main.this.createSubcells(Main.this.allcells, Main.this.stellationSymmetry);
                Main.this.initSubcells();
                Out.println("symmetry changed: " + Main.this.stellationSymmetry);
            }
        }
    }
}

