/*
 * Decompiled with CFR 0.152.
 */
package PVS.polyhedra.stellation;

import PVS.Utils.BorderPanel;
import PVS.Utils.WindowUtils;
import PVS.polyhedra.stellation.PolyNames;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class DlgSelectPoly {
    Dialog dialog;
    PolyNames polyNames = new PolyNames();
    int[] selection = new int[2];
    int currentCategory;
    int currentPoly;
    PolyCanvas polyCanvas;
    int sbPolyMaximum = 1000;
    int sbPolyVisible = 1000;
    Scrollbar sbPoly = new Scrollbar(1, 0, this.sbPolyVisible, 0, this.sbPolyMaximum);
    boolean result;
    Button btnOK = new Button("OK");
    Button btnCancel = new Button("Cancel");
    TextField tfPolyName = new TextField(30);
    Label lbCurPolyName = new Label("polyhedron name");
    private static GridBagConstraints gbc = new GridBagConstraints();

    public int[] getPolyhedron(Frame frame, int n, int n2) {
        this.currentCategory = n;
        this.currentPoly = n2;
        if (this.dialog == null) {
            this.makeDialog(frame);
        }
        this.dialog.show();
        if (this.result) {
            return this.selection;
        }
        return null;
    }

    void makeDialog(Frame frame) {
        this.dialog = new Dialog(frame);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.dialog.setLayout(gridBagLayout);
        this.dialog.addComponentListener(new DlgSizeListener());
        this.polyCanvas = new PolyCanvas();
        BorderPanel borderPanel = new BorderPanel();
        borderPanel.setLayout(gridBagLayout);
        this.sbPoly.addAdjustmentListener(new SBAdjustmentListener());
        BorderPanel borderPanel2 = new BorderPanel();
        borderPanel2.setLayout(gridBagLayout);
        WindowUtils.constrain((Container)borderPanel2, (Component)this.polyCanvas, 0, 0, 1, 1, 1, 11, 1.0, 1.0);
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        WindowUtils.constrain(panel, this.tfPolyName, 0, 0, 1, 1, 2, 11, 1.0, 0.0, 0, 5, 0, 5);
        WindowUtils.constrain(panel, this.lbCurPolyName, 1, 0, 1, 1, 2, 11, 1.0, 0.0, 10, 5, 0, 5);
        WindowUtils.constrain((Container)borderPanel, (Component)borderPanel2, 0, 0, 1, 1, 1, 11, 1.0, 1.0);
        WindowUtils.constrain((Container)borderPanel, (Component)this.sbPoly, 1, 0, 1, 1, 3, 11, 0.0, 1.0);
        WindowUtils.constrain(borderPanel, panel, 0, 1, 1, 1, 2, 11, 1.0, 0.0, 0, 5, 0, 5);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 3, 5, 5));
        panel2.add(this.btnOK);
        panel2.add(this.btnCancel);
        this.btnOK.addActionListener(new OnOK());
        this.btnCancel.addActionListener(new OnCancel());
        WindowUtils.constrain((Container)this.dialog, (Component)borderPanel, 0, 0, 1, 1, 1, 11, 1.0, 1.0);
        WindowUtils.constrain(this.dialog, panel2, 0, 1, 1, 1, 0, 11, 1.0, 0.0, 5, 5, 5, 5);
        this.dialog.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        ((Component)this.dialog).setSize(dimension.width, dimension.height - 30);
        this.dialog.setModal(true);
    }

    void adjustSB() {
        this.sbPoly.setVisibleAmount(this.polyCanvas.visibleRows * this.sbPolyMaximum / this.polyCanvas.numberRows);
        this.sbPoly.setBlockIncrement(this.sbPolyMaximum / this.polyCanvas.numberRows);
        this.sbPoly.setUnitIncrement(this.sbPolyMaximum / this.polyCanvas.numberRows);
    }

    class DlgSizeListener
    extends ComponentAdapter {
        DlgSizeListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            DlgSelectPoly.this.polyCanvas.moveIcons();
        }
    }

    class PolyCanvas
    extends Panel {
        int cellSizeX = 90;
        int cellSizeY = 90;
        int iconSizeX = 86;
        int iconSizeY = 86;
        int offsetX = 2;
        int offsetY = 2;
        Color color1;
        Color color2;
        Image[][] images;
        PolyLabel[][] polyLabels;
        int visibleRows = 1;
        int numberRows = 1;
        int globalOffsetY = 0;
        Panel scrollPanel;
        int oldWidth = -1;

        PolyCanvas() {
            this.createImages();
            this.scrollPanel = new Panel();
            this.scrollPanel.setLayout(null);
            this.setLayout(null);
            this.add(this.scrollPanel);
            int n = 0;
            while (n < this.images.length) {
                int n2 = 0;
                while (n2 < this.images[n].length) {
                    this.images[n][n2] = this.loadImage(n, n2);
                    this.polyLabels[n][n2] = new PolyLabel(n, n2, this.images[n][n2]);
                    this.scrollPanel.add(this.polyLabels[n][n2]);
                    this.polyLabels[n][n2].setSize(this.iconSizeX, this.iconSizeY);
                    int n3 = n2 * this.cellSizeX + this.offsetX;
                    int n4 = n * this.cellSizeY + this.offsetY;
                    this.polyLabels[n][n2].setLocation(n3, n4);
                    ++n2;
                }
                ++n;
            }
            this.polyLabels[DlgSelectPoly.this.currentCategory][DlgSelectPoly.this.currentPoly].setState(true);
        }

        void processMouseClicked(int n, int n2) {
            this.polyLabels[DlgSelectPoly.this.currentCategory][DlgSelectPoly.this.currentPoly].setState(false);
            this.polyLabels[n][n2].setState(true);
            DlgSelectPoly.this.currentCategory = n;
            DlgSelectPoly.this.currentPoly = n2;
            DlgSelectPoly.this.selection[0] = DlgSelectPoly.this.currentCategory;
            DlgSelectPoly.this.selection[1] = DlgSelectPoly.this.currentPoly;
            DlgSelectPoly.this.tfPolyName.setText(DlgSelectPoly.this.polyNames.name(DlgSelectPoly.this.currentCategory, DlgSelectPoly.this.currentPoly));
        }

        void processMouseEntered(int n, int n2) {
            DlgSelectPoly.this.lbCurPolyName.setText(DlgSelectPoly.this.polyNames.name(n, n2));
        }

        public void paint(Graphics graphics) {
        }

        void moveIcons() {
            int n;
            Dimension dimension = this.getSize();
            int n2 = dimension.width / this.cellSizeX;
            if (n2 < 1) {
                n2 = 1;
            }
            this.visibleRows = n = dimension.height / this.cellSizeY;
            this.scrollPanel.setLocation(0, -this.globalOffsetY);
            if (dimension.width != this.oldWidth) {
                this.oldWidth = dimension.width;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                while (n5 < this.images.length) {
                    n3 = 0;
                    int n6 = 0;
                    while (n6 < this.images[n5].length) {
                        if (n3 == n2) {
                            n3 = 0;
                            ++n4;
                        }
                        int n7 = n3 * this.cellSizeX + this.offsetX;
                        int n8 = n4 * this.cellSizeY + this.offsetY;
                        this.polyLabels[n5][n6].setLocation(n7, n8);
                        ++n3;
                        ++n6;
                    }
                    ++n4;
                    ++n5;
                }
                this.numberRows = n4;
                this.scrollPanel.setSize(dimension.width, (n4 + 1) * this.cellSizeY);
                DlgSelectPoly.this.adjustSB();
            }
        }

        Image loadImage(int n, int n2) {
            return this.loadImageFromJar("/images/poly/" + DlgSelectPoly.this.polyNames.fname(n, n2) + "_tmb.gif");
        }

        void createImages() {
            String[] stringArray = DlgSelectPoly.this.polyNames.getCategories();
            this.images = new Image[stringArray.length][];
            this.polyLabels = new PolyLabel[stringArray.length][];
            int n = 0;
            while (n < stringArray.length) {
                int n2 = DlgSelectPoly.this.polyNames.getCategoryLength(n);
                this.images[n] = new Image[n2];
                this.polyLabels[n] = new PolyLabel[n2];
                ++n;
            }
        }

        Image loadImageFromJar(String string) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            byte[] byArray = null;
            byArray = null;
            try {
                int n;
                InputStream inputStream = this.getClass().getResourceAsStream(string);
                if (inputStream == null) {
                    System.out.println("ImageLoader.loadFromJar getResourceAsStream failed on " + string);
                    return null;
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                byArray = new byte[1024];
                while ((n = bufferedInputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                bufferedInputStream.close();
                byteArrayOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                System.err.println("ImageLoader.loadFromJar IOException: " + iOException);
                return null;
            }
            if (byArray == null) {
                System.out.println("ImageLoader.loadFromJar: " + string + " not found.");
                return null;
            }
            if (byArray.length == 0) {
                System.out.println("ImageLoader.loadFromJar: " + string + " is zero-length");
                return null;
            }
            return toolkit.createImage(byArray);
        }

        class PolyLabel
        extends Canvas
        implements MouseListener {
            int offsetX = 3;
            int offsetY = 3;
            int imageSizeX = 80;
            int imageSizeY = 80;
            int cat;
            int poly;
            Image image;
            boolean state = false;
            Color color1;
            Color color2;

            PolyLabel(int n, int n2, Image image) {
                this.cat = n;
                this.poly = n2;
                this.image = image;
                this.addMouseListener(this);
            }

            void setState(boolean bl) {
                this.state = bl;
                this.repaint();
            }

            public void paint(Graphics graphics) {
                Color color = this.getBackground();
                this.color2 = color.darker();
                this.color1 = color.brighter();
                Dimension dimension = this.getSize();
                this.drawRect3D(graphics, 0, 0, dimension.width - 1, dimension.height - 1);
                Dimension dimension2 = this.getSize();
                graphics.drawImage(this.image, this.offsetX, this.offsetY, this);
                if (this.state) {
                    graphics.setColor(Color.blue);
                    graphics.drawRect(this.offsetX - 1, this.offsetY - 1, this.imageSizeX + 2, this.imageSizeY + 2);
                    graphics.drawRect(this.offsetX, this.offsetY, this.imageSizeX, this.imageSizeY);
                }
            }

            void drawRect3D(Graphics graphics, int n, int n2, int n3, int n4) {
                graphics.setColor(this.color1);
                graphics.drawLine(n, n2, n + n3, n2);
                graphics.drawLine(n, n2, n, n2 + n4);
                graphics.setColor(this.color2);
                graphics.drawLine(n + n3, n2 + n4, n + n3, n2);
                graphics.drawLine(n + n3, n2 + n4, n, n2 + n4);
            }

            public Dimension getPreferredSize() {
                return new Dimension(10, 10);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                PolyCanvas.this.processMouseEntered(this.cat, this.poly);
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                PolyCanvas.this.processMouseClicked(this.cat, this.poly);
            }
        }
    }

    class SBAdjustmentListener
    implements AdjustmentListener {
        SBAdjustmentListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            int n = adjustmentEvent.getValue();
            DlgSelectPoly.this.polyCanvas.globalOffsetY = n * DlgSelectPoly.this.polyCanvas.numberRows * DlgSelectPoly.this.polyCanvas.cellSizeY / DlgSelectPoly.this.sbPolyMaximum;
            DlgSelectPoly.this.polyCanvas.moveIcons();
        }
    }

    class OnCancel
    implements ActionListener {
        OnCancel() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((Component)DlgSelectPoly.this.dialog).setVisible(false);
            DlgSelectPoly.this.dialog.dispose();
            DlgSelectPoly.this.result = false;
        }
    }

    class OnOK
    implements ActionListener {
        OnOK() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((Component)DlgSelectPoly.this.dialog).setVisible(false);
            DlgSelectPoly.this.dialog.dispose();
            DlgSelectPoly.this.result = true;
        }
    }
}

