/*
 * Decompiled with CFR 0.152.
 */
package PVS.polyhedra.stellation;

import PVS.Expression.Parser;
import PVS.Utils.Dlg_Preferences;
import PVS.Utils.Parameter;
import PVS.Utils.ParameterDouble;
import PVS.Utils.WindowUtils;
import PVS.polyhedra.PolyShape;
import java.awt.BasicStroke;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.Vector;

public class DlgPrint {
    Dialog dialog;
    Vector shapes;
    boolean result;
    PrintCanvas canvas = new PrintCanvas();
    TextField[] tfEditors;
    static ParameterDouble Scale = new ParameterDouble("Scale", 1.0);
    static ParameterDouble Xoffset = new ParameterDouble("Xoffset", 0.0);
    static ParameterDouble Yoffset = new ParameterDouble("Yoffset", 0.0);
    static ParameterDouble PrintWidth = new ParameterDouble("PrintWidth", 20.0);
    static ParameterDouble PrintHeight = new ParameterDouble("PrintHeight", 25.0);
    static ParameterDouble CorrectionHeight = new ParameterDouble("CorrectionHeight", 1.0);
    static ParameterDouble CorrectionWidth = new ParameterDouble("CorrectionWidth", 1.0);
    static Parameter[] Parameters = new Parameter[]{Scale, Xoffset, Yoffset, PrintWidth, PrintHeight, CorrectionHeight, CorrectionWidth};
    String filePath = "stellation_print.ini";
    static final double INCHES = 2.54;
    Parser parser;
    private static GridBagConstraints gbc = new GridBagConstraints();

    public boolean edit(Frame frame, Vector vector) {
        if (this.dialog == null) {
            this.makeDialog(frame);
        }
        this.shapes = vector;
        this.dialog.show();
        return this.result;
    }

    void makeDialog(Frame frame) {
        Dlg_Preferences.readPreferences(this.filePath, Parameters);
        this.dialog = new Dialog(frame);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.dialog.setLayout(gridBagLayout);
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        this.tfEditors = new TextField[Parameters.length];
        int n = 0;
        while (n < Parameters.length) {
            this.tfEditors[n] = new TextField(10);
            WindowUtils.constrain((Container)panel, (Component)new Label(Parameters[n].getName()), 0, n, 1, 1, 0, 10, 0.0, 0.0);
            WindowUtils.constrain((Container)panel, (Component)this.tfEditors[n], 1, n, 1, 1, 0, 10, 0.0, 0.0);
            this.tfEditors[n].setText(Parameters[n].getValue());
            ++n;
        }
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 3, 3, 3));
        Button button = new Button("Apply");
        Button button2 = new Button("Print");
        Button button3 = new Button("Cancel");
        panel2.add(button);
        panel2.add(button2);
        panel2.add(button3);
        button.addActionListener(new OnApply());
        button3.addActionListener(new OnCancel());
        button2.addActionListener(new OnPrint());
        WindowUtils.constrain(this.dialog, panel, 0, 0, 1, 1, 2, 11, 0.0, 0.0, 5, 5, 5, 5);
        WindowUtils.constrain(this.dialog, panel2, 0, 1, 1, 1, 0, 11, 0.0, 0.0, 5, 5, 5, 5);
        WindowUtils.constrain(this.dialog, this.canvas, 1, 0, 1, 2, 1, 10, 1.0, 1.0, 5, 5, 5, 5);
        this.dialog.addWindowListener(new CloseWindowListener());
        this.dialog.pack();
        this.dialog.validate();
        this.dialog.setModal(true);
    }

    void updateValues() {
        int n = 0;
        while (n < Parameters.length) {
            Parameters[n].setValue(this.tfEditors[n].getText());
            ++n;
        }
    }

    class PrintCanvas
    extends Canvas
    implements Printable {
        int inset = 5;

        PrintCanvas() {
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public Dimension getPreferredSize() {
            return new Dimension(300, 300);
        }

        public void paint(Graphics graphics) {
            double d;
            double d2;
            graphics.setColor(Color.white);
            Dimension dimension = this.getSize();
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            int n = dimension.height - 2 * this.inset;
            int n2 = dimension.width - 2 * this.inset;
            if ((double)n2 * DlgPrint.PrintHeight.value / DlgPrint.PrintWidth.value > (double)n) {
                d2 = n;
                d = d2 * DlgPrint.PrintWidth.value / DlgPrint.PrintHeight.value;
            } else {
                d = n2;
                d2 = d * DlgPrint.PrintHeight.value / DlgPrint.PrintWidth.value;
            }
            double d3 = d2 / DlgPrint.PrintHeight.value;
            graphics.setColor(Color.gray);
            graphics.drawRect((int)((double)dimension.width - d) / 2, (int)((double)dimension.height - d2) / 2, (int)d, (int)d2);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setTransform(new AffineTransform());
            graphics2D.translate(dimension.width / 2, dimension.height / 2);
            graphics2D.scale(d3, d3);
            graphics2D.translate(DlgPrint.Xoffset.value, -DlgPrint.Yoffset.value);
            graphics2D.scale(DlgPrint.Scale.value, -DlgPrint.Scale.value);
            this.renderShapes(graphics2D);
        }

        void drawContent(Graphics graphics, int n, int n2, int n3) {
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            if (n != 0) {
                return 1;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(new BasicStroke(0.0f));
            double d = pageFormat.getWidth() * 2.54 / 72.0;
            double d2 = pageFormat.getHeight() * 2.54 / 72.0;
            graphics2D.translate(pageFormat.getWidth() / 2.0, pageFormat.getHeight() / 2.0);
            graphics2D.scale(DlgPrint.CorrectionWidth.value * 72.0 / 2.54, DlgPrint.CorrectionHeight.value * 72.0 / 2.54);
            Rectangle2D.Double double_ = new Rectangle2D.Double(-DlgPrint.PrintWidth.value / 2.0, -DlgPrint.PrintHeight.value / 2.0, DlgPrint.PrintWidth.value, DlgPrint.PrintHeight.value);
            graphics2D.draw(double_);
            graphics.setClip(double_);
            graphics2D.translate(DlgPrint.Xoffset.value, -DlgPrint.Yoffset.value);
            graphics2D.scale(DlgPrint.Scale.value, -DlgPrint.Scale.value);
            this.renderShapes(graphics2D);
            return 0;
        }

        void renderShapes(Graphics2D graphics2D) {
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHints(renderingHints);
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(new BasicStroke(0.0f));
            int n = 0;
            while (n < DlgPrint.this.shapes.size()) {
                PolyShape polyShape = (PolyShape)DlgPrint.this.shapes.elementAt(n);
                switch (polyShape.type) {
                    case 0: {
                        graphics2D.setColor(polyShape.color);
                        graphics2D.fill(polyShape.path);
                        break;
                    }
                    case 1: {
                        graphics2D.setColor(polyShape.color);
                        graphics2D.draw(polyShape.path);
                    }
                }
                ++n;
            }
        }

        void renderTest(Graphics2D graphics2D) {
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(new BasicStroke(0.0f));
            GeneralPath generalPath = new GeneralPath();
            int n = 360;
            double d = 0.1;
            double d2 = 1.0;
            int n2 = 0;
            while (n2 < n) {
                double d3 = Math.PI * 2 * (double)n2 / (double)n;
                double d4 = Math.sin(d3);
                double d5 = Math.cos(d3);
                generalPath.moveTo((float)(d * d5), (float)(d * d4));
                generalPath.lineTo((float)(d2 * d5), (float)(d2 * d4));
                generalPath.closePath();
                ++n2;
            }
            graphics2D.draw(generalPath);
        }
    }

    class CloseWindowListener
    extends WindowAdapter {
        CloseWindowListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ((Component)DlgPrint.this.dialog).setVisible(false);
            DlgPrint.this.dialog.dispose();
            DlgPrint.this.result = false;
        }
    }

    class OnCancel
    implements ActionListener {
        OnCancel() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((Component)DlgPrint.this.dialog).setVisible(false);
            DlgPrint.this.dialog.dispose();
            DlgPrint.this.result = false;
        }
    }

    class OnPrint
    implements ActionListener {
        OnPrint() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((Component)DlgPrint.this.dialog).setVisible(false);
            DlgPrint.this.dialog.dispose();
            Dlg_Preferences.savePreferences(DlgPrint.this.filePath, Parameters);
            DlgPrint.this.result = true;
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat = printerJob.defaultPage();
            Paper paper = pageFormat.getPaper();
            paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
            pageFormat.setPaper(paper);
            printerJob.setPrintable(DlgPrint.this.canvas, pageFormat);
            try {
                printerJob.print();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class OnApply
    implements ActionListener {
        OnApply() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DlgPrint.this.updateValues();
            DlgPrint.this.canvas.repaint();
        }
    }
}

