/*
 * Decompiled with CFR 0.152.
 */
package PVS.polyhedra.stellation;

import PVS.Expression.Expr;
import PVS.Expression.Parser;
import PVS.Expression.Variable;
import PVS.Utils.Comparator;
import PVS.Utils.Fmt;
import PVS.Utils.QSort;
import PVS.Utils.WindowUtils;
import PVS.polyhedra.Matrix3D;
import PVS.polyhedra.Symmetry;
import PVS.polyhedra.Vector3D;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Vector;

public class DlgPlanes {
    Vector3D[] canonicalPlanes;
    String polySymmetry = "";
    Dialog dialog;
    Vector3D[] planes = new Vector3D[0];
    boolean result;
    static final int MAXPLANES = 6;
    TextArea textArea = new TextArea();
    TextField[] planesX = new TextField[6];
    TextField[] planesY = new TextField[6];
    TextField[] planesZ = new TextField[6];
    Choice choiceSymmetry = new Choice();
    Button btnOK = new Button("OK");
    Button btnCancel = new Button("Cancel");
    Button btnGenerate = new Button("Generate");
    static String[] symnames = Symmetry.getSymmetryNames();
    Parser parser;
    static final double EPS = 1.0E-12;
    private static GridBagConstraints gbc = new GridBagConstraints();

    public DlgPlanes(Vector3D[] vector3DArray, String string) {
        this.canonicalPlanes = vector3DArray;
        this.polySymmetry = string;
    }

    public boolean edit(Frame frame) {
        if (this.dialog == null) {
            this.makeDialog(frame);
        }
        this.btnOK.setEnabled(false);
        this.dialog.show();
        return this.result;
    }

    public String getSymmetry() {
        return this.polySymmetry;
    }

    public Vector3D[] getPlanes() {
        return this.planes;
    }

    void makeDialog(Frame frame) {
        this.dialog = new Dialog(frame);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.dialog.setLayout(gridBagLayout);
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        WindowUtils.constrain((Container)panel, (Component)new Label("plane "), 0, 0, 1, 1, 0, 10, 0.0, 0.0);
        WindowUtils.constrain((Container)panel, (Component)new Label("X "), 1, 0, 1, 1, 0, 10, 1.0, 0.0);
        WindowUtils.constrain((Container)panel, (Component)new Label("Y "), 2, 0, 1, 1, 0, 10, 1.0, 0.0);
        WindowUtils.constrain((Container)panel, (Component)new Label("Z "), 3, 0, 1, 1, 0, 10, 1.0, 0.0);
        int n = 0;
        while (n < symnames.length) {
            this.choiceSymmetry.addItem(symnames[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < 6) {
            this.planesX[n2] = new TextField(17);
            this.planesY[n2] = new TextField(17);
            this.planesZ[n2] = new TextField(17);
            WindowUtils.constrain((Container)panel, (Component)new Label("" + (n2 + 1)), 0, n2 + 1, 1, 1, 0, 10, 0.0, 0.0);
            WindowUtils.constrain((Container)panel, (Component)this.planesX[n2], 1, n2 + 1, 1, 1, 2, 11, 1.0, 0.0);
            WindowUtils.constrain((Container)panel, (Component)this.planesY[n2], 2, n2 + 1, 1, 1, 2, 11, 1.0, 0.0);
            WindowUtils.constrain((Container)panel, (Component)this.planesZ[n2], 3, n2 + 1, 1, 1, 2, 11, 1.0, 0.0);
            ++n2;
        }
        Panel panel2 = new Panel();
        this.btnOK.setEnabled(false);
        panel2.setLayout(new GridLayout(1, 3, 3, 3));
        panel2.add(this.btnGenerate);
        panel2.add(this.btnOK);
        panel2.add(this.btnCancel);
        this.btnOK.addActionListener(new OnOK());
        this.btnCancel.addActionListener(new OnCancel());
        this.btnGenerate.addActionListener(new OnGenerate());
        Panel panel3 = new Panel();
        panel3.setLayout(gridBagLayout);
        WindowUtils.constrain((Container)panel3, (Component)new Label("Symmetry "), 0, 0, 1, 1, 0, 10, 0.0, 0.0);
        WindowUtils.constrain((Container)panel3, (Component)this.choiceSymmetry, 1, 0, 1, 1, 0, 10, 0.0, 0.0);
        Panel panel4 = new Panel();
        panel4.setLayout(gridBagLayout);
        WindowUtils.constrain(panel4, panel3, 0, 0, 1, 1, 0, 10, 0.0, 0.0, 0, 0, 10, 0);
        WindowUtils.constrain((Container)panel4, (Component)panel2, 1, 0, 1, 1, 0, 10, 0.0, 0.0);
        WindowUtils.constrain((Container)this.dialog, (Component)panel, 0, 0, 1, 1, 2, 11, 1.0, 0.0);
        WindowUtils.constrain((Container)this.dialog, (Component)this.textArea, 0, 1, 1, 1, 1, 11, 1.0, 1.0);
        WindowUtils.constrain(this.dialog, panel4, 0, 2, 1, 1, 0, 10, 0.0, 0.0, 3, 3, 3, 3);
        this.setPlanes(this.canonicalPlanes, this.polySymmetry);
        this.dialog.addWindowListener(new CloseWindowListener());
        this.dialog.pack();
        this.dialog.validate();
        this.dialog.setModal(true);
    }

    void writeVector(Vector3D vector3D) {
        this.textArea.append(Fmt.fmt(vector3D.x, 17, 14));
        this.textArea.append(Fmt.fmt(vector3D.y, 17, 14));
        this.textArea.append(Fmt.fmt(vector3D.z, 17, 14));
    }

    public void setPlanes(Vector3D[] vector3DArray, String string) {
        if (this.planesX[0] == null) {
            return;
        }
        this.polySymmetry = string;
        this.choiceSymmetry.select(string);
        int n = 0;
        while (n < vector3DArray.length) {
            if (n < this.planesX.length) {
                this.planesX[n].setText(Fmt.fmt(DlgPlanes.chop(vector3DArray[n].x), 17, 14));
                this.planesY[n].setText(Fmt.fmt(DlgPlanes.chop(vector3DArray[n].y), 17, 14));
                this.planesZ[n].setText(Fmt.fmt(DlgPlanes.chop(vector3DArray[n].z), 17, 14));
            }
            ++n;
        }
        int n2 = vector3DArray.length;
        while (n2 < this.planesX.length) {
            this.planesX[n2].setText("");
            this.planesY[n2].setText("");
            this.planesZ[n2].setText("");
            ++n2;
        }
    }

    static double chop(double d) {
        if (d < -1.0E-12 || d > 1.0E-12) {
            return d;
        }
        return 0.0;
    }

    public String getSourceVectorsAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        while (n < 6) {
            String string = this.planesX[n].getText();
            String string2 = this.planesY[n].getText();
            String string3 = this.planesZ[n].getText();
            if (string.length() > 0 && string2.length() > 0 && string3.length() > 0) {
                stringBuffer.append("(");
                stringBuffer.append(string);
                stringBuffer.append(",");
                stringBuffer.append(string2);
                stringBuffer.append(",");
                stringBuffer.append(string3);
                stringBuffer.append(")");
            }
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void generate() {
        Object object;
        Object object2;
        this.parser = new Parser();
        this.polySymmetry = this.choiceSymmetry.getSelectedItem();
        Vector<Vector3D> vector = new Vector<Vector3D>();
        int n = 0;
        while (n < 6) {
            String string = this.planesX[n].getText();
            object2 = this.planesY[n].getText();
            String string2 = this.planesZ[n].getText();
            if (string.length() > 0 && ((String)object2).length() > 0 && string2.length() > 0) {
                double d = this.calculate(string);
                double d2 = this.calculate((String)object2);
                double d3 = this.calculate(string2);
                vector.addElement(new Vector3D(d, d2, d3));
            }
            ++n;
        }
        this.textArea.append("\n");
        this.textArea.append("source vectors\n");
        int n2 = 0;
        while (n2 < vector.size()) {
            object2 = (Vector3D)vector.elementAt(n2);
            this.writeVector((Vector3D)object2);
            this.textArea.append("\n");
            ++n2;
        }
        object2 = new Hashtable();
        int n3 = 0;
        while (n3 < vector.size()) {
            Vector3D vector3D = (Vector3D)vector.elementAt(n3);
            object = Symmetry.getMatrices(this.polySymmetry);
            int n4 = 0;
            while (n4 < ((Matrix3D[])object).length) {
                Vector3D vector3D2 = vector3D.mul((Matrix3D)object[n4]);
                if (((Hashtable)object2).get(vector3D2) == null) {
                    ((Hashtable)object2).put(vector3D2, vector3D2);
                }
                ++n4;
            }
            ++n3;
        }
        this.textArea.append("sorted vectors\n");
        int n5 = 0;
        this.planes = new Vector3D[((Hashtable)object2).size()];
        object = ((Hashtable)object2).keys();
        while (object.hasMoreElements()) {
            Vector3D vector3D = (Vector3D)object.nextElement();
            this.textArea.append(vector3D.toString());
            this.textArea.append("\n");
            this.planes[n5++] = vector3D;
        }
        this.textArea.append("count:" + ((Hashtable)object2).size());
        this.textArea.append("\n");
        double[][] dArray = new double[this.planes.length][2];
        int n6 = 0;
        while (n6 < this.planes.length) {
            dArray[n6][0] = this.planes[0].dot(this.planes[n6]);
            dArray[n6][1] = this.planes[0].cross(this.planes[n6]).length();
            ++n6;
        }
        QSort.quickSort((Object[])dArray, 0, this.planes.length - 1, (Comparator)new MyComparator());
        int n7 = 0;
        while (n7 < this.planes.length) {
            this.textArea.append(Fmt.fmt(dArray[n7][0], 17, 14));
            this.textArea.append(Fmt.fmt(dArray[n7][1], 17, 14));
            this.textArea.append("\n");
            ++n7;
        }
        this.btnOK.setEnabled(true);
    }

    public double calculate(String string) {
        double d = 0.0;
        try {
            Expr expr = this.parser.parse(string);
            Variable variable = expr.getVariable("g");
            variable.setValue((Math.sqrt(5.0) + 1.0) / 2.0);
            Variable variable2 = expr.getVariable("pi");
            variable2.setValue(Math.PI);
            d = expr.value();
        }
        catch (Exception exception) {
            System.out.println("Exception during calculating " + string);
        }
        return d;
    }

    static void main(String[] stringArray) {
        Frame frame = new Frame();
        System.exit(0);
    }

    class CloseWindowListener
    extends WindowAdapter {
        CloseWindowListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ((Component)DlgPlanes.this.dialog).setVisible(false);
            DlgPlanes.this.dialog.dispose();
            DlgPlanes.this.result = false;
        }
    }

    class OnCancel
    implements ActionListener {
        OnCancel() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((Component)DlgPlanes.this.dialog).setVisible(false);
            DlgPlanes.this.dialog.dispose();
            DlgPlanes.this.result = false;
        }
    }

    class OnOK
    implements ActionListener {
        OnOK() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((Component)DlgPlanes.this.dialog).setVisible(false);
            DlgPlanes.this.dialog.dispose();
            DlgPlanes.this.result = true;
        }
    }

    class OnGenerate
    implements ActionListener {
        OnGenerate() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DlgPlanes.this.textArea.setText("Generating vectors");
            DlgPlanes.this.generate();
        }
    }

    class MyComparator
    implements Comparator {
        MyComparator() {
        }

        public int compare(Object object, Object object2) {
            double[] dArray = (double[])object;
            double[] dArray2 = (double[])object2;
            if (dArray[0] > dArray2[0]) {
                return 1;
            }
            if (dArray[0] < dArray2[0]) {
                return -1;
            }
            return 0;
        }
    }
}

