/*
 * Decompiled with CFR 0.152.
 */
package PVS.polyhedra;

import PVS.Utils.Fmt;
import PVS.polyhedra.Matrix3D;

public class Vector3D {
    public double x;
    public double y;
    public double z;
    static final double tolerance = 1.0E-6;
    int hashCode = 0;
    static double TOL = 1.0E-10;

    public Vector3D() {
    }

    public Vector3D(Vector3D vector3D) {
        this.x = vector3D.x;
        this.y = vector3D.y;
        this.z = vector3D.z;
    }

    public Vector3D(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vector3D(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
    }

    public Vector3D set(Vector3D vector3D) {
        this.x = vector3D.x;
        this.y = vector3D.y;
        this.z = vector3D.z;
        this.hashCode = 0;
        return this;
    }

    public Vector3D add(Vector3D vector3D) {
        return new Vector3D(this.x + vector3D.x, this.y + vector3D.y, this.z + vector3D.z);
    }

    public Vector3D addSet(Vector3D vector3D) {
        this.x += vector3D.x;
        this.y += vector3D.y;
        this.z += vector3D.z;
        this.hashCode = 0;
        return this;
    }

    public Vector3D sub(Vector3D vector3D) {
        return new Vector3D(this.x - vector3D.x, this.y - vector3D.y, this.z - vector3D.z);
    }

    public Vector3D subSet(Vector3D vector3D) {
        this.x -= vector3D.x;
        this.y -= vector3D.y;
        this.z -= vector3D.z;
        this.hashCode = 0;
        return this;
    }

    public Vector3D mul(double d) {
        return new Vector3D(this.x * d, this.y * d, this.z * d);
    }

    public Vector3D mulSet(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
        this.hashCode = 0;
        return this;
    }

    public Vector3D mul(Matrix3D matrix3D) {
        double[][] dArray = matrix3D.m;
        double d = dArray[0][0];
        double d2 = dArray[0][1];
        double d3 = dArray[0][2];
        double d4 = dArray[1][0];
        double d5 = dArray[1][1];
        double d6 = dArray[1][2];
        double d7 = dArray[2][0];
        double d8 = dArray[2][1];
        double d9 = dArray[2][2];
        return new Vector3D(this.x * d + this.y * d2 + this.z * d3, this.x * d4 + this.y * d5 + this.z * d6, this.x * d7 + this.y * d8 + this.z * d9);
    }

    public Vector3D cross(Vector3D vector3D) {
        return new Vector3D(this.y * vector3D.z - this.z * vector3D.y, this.z * vector3D.x - this.x * vector3D.z, this.x * vector3D.y - this.y * vector3D.x);
    }

    public double dot(Vector3D vector3D) {
        return this.x * vector3D.x + this.y * vector3D.y + this.z * vector3D.z;
    }

    public Vector3D getCoord(float[] fArray) {
        fArray[0] = (float)this.x;
        fArray[1] = (float)this.y;
        fArray[2] = (float)this.z;
        this.hashCode = 0;
        return this;
    }

    public Vector3D normalize() {
        double d = this.length();
        if (d != 0.0) {
            this.mulSet(1.0 / d);
        }
        this.hashCode = 0;
        return this;
    }

    public double length() {
        return Math.sqrt(this.length2());
    }

    public double length2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3D rotate(Vector3D vector3D, double d) {
        return this.rotate(vector3D, Math.sin(d), Math.cos(d));
    }

    public Vector3D rotate(Vector3D vector3D, double d, double d2) {
        Vector3D vector3D2 = vector3D.mul(this.dot(vector3D));
        vector3D2.addSet(this.sub(vector3D2).mulSet(d2));
        vector3D2.addSet(vector3D.cross(this).mulSet(d));
        return vector3D2;
    }

    public Vector3D rotateSet(Vector3D vector3D, double d, double d2) {
        Vector3D vector3D2 = this.rotate(vector3D, d, d2);
        this.x = vector3D2.x;
        this.y = vector3D2.y;
        this.z = vector3D2.z;
        this.hashCode = 0;
        return this;
    }

    public Vector3D rotateSet(Vector3D vector3D, double d) {
        Vector3D vector3D2 = this.rotate(vector3D, Math.sin(d), Math.cos(d));
        this.x = vector3D2.x;
        this.y = vector3D2.y;
        this.z = vector3D2.z;
        this.hashCode = 0;
        return this;
    }

    public void rotateSet(Vector3D vector3D, Vector3D vector3D2) {
        Vector3D vector3D3 = vector3D.cross(vector3D2);
        double d = vector3D3.length();
        double d2 = vector3D.dot(vector3D2);
        if (d > TOL || d < -TOL) {
            vector3D3.normalize();
            this.rotateSet(vector3D3, d, d2);
        }
    }

    public Vector3D reflect(Vector3D vector3D, double d) {
        Vector3D vector3D2 = new Vector3D(this);
        vector3D2 = vector3D2.subSet(vector3D.mul(2.0 * (vector3D2.dot(vector3D.normalize()) + d)));
        return vector3D2;
    }

    public boolean collinear(Vector3D vector3D) {
        return this.cross(vector3D).length() < 1.0E-6;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        Vector3D vector3D = (Vector3D)object;
        double d = vector3D.x - this.x;
        double d2 = vector3D.y - this.y;
        double d3 = vector3D.z - this.z;
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d3 < 0.0) {
            d3 = -d3;
        }
        return d < 1.0E-6 && d2 < 1.0E-6 && d3 < 1.0E-6;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int n = (int)(331345.563 * this.x) + (int)(412345.891 * this.y) + (int)(71341.678 * this.z);
        return n;
    }

    static double chop(double d) {
        if (d < TOL && d > -TOL) {
            return 0.0;
        }
        return d;
    }

    public String toString() {
        return "{" + Fmt.fmt(Vector3D.chop(this.x), 8, 5) + " " + Fmt.fmt(Vector3D.chop(this.y), 8, 5) + " " + Fmt.fmt(Vector3D.chop(this.z), 8, 5) + "}";
    }

    public static void main(String[] stringArray) {
        int n = 0;
        Vector3D vector3D = new Vector3D(Double.valueOf(stringArray[n++]), Double.valueOf(stringArray[n++]), Double.valueOf(stringArray[n++]));
        Vector3D vector3D2 = new Vector3D(Double.valueOf(stringArray[n++]), Double.valueOf(stringArray[n++]), Double.valueOf(stringArray[n++]));
        Vector3D vector3D3 = new Vector3D(Double.valueOf(stringArray[n++]), Double.valueOf(stringArray[n++]), Double.valueOf(stringArray[n++]));
        System.out.println(vector3D3);
        vector3D3.rotateSet(vector3D.normalize(), vector3D2.normalize());
        System.out.println(vector3D3);
    }
}

