/*
 * Decompiled with CFR 0.152.
 */
package PVS.polyhedra;

import PVS.Utils.Comparator;
import PVS.Utils.QSort;
import PVS.Utils.StringComparator;
import PVS.polyhedra.Axis;
import PVS.polyhedra.Matrix3D;
import PVS.polyhedra.Plane;
import PVS.polyhedra.Vector3D;
import PVS.polyhedra.Vector3Dsym;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Symmetry {
    static final double PI = Math.PI;
    static Matrix3D[] O = null;
    static Matrix3D[] T = null;
    static Matrix3D[] I = null;
    static Matrix3D[] E = null;
    static Matrix3D[] S2 = null;
    static Matrix3D[] C2 = null;
    static Matrix3D[] C2v = null;
    static Matrix3D[] Cs = null;
    static Matrix3D[] Th;
    static Matrix3D[] Td;
    static Matrix3D[] Ih;
    static Matrix3D[] Oh;
    static Matrix3D[] D2h;
    static Matrix3D[] D2d;
    static Matrix3D[] D5d_I;
    static Matrix3D[] D5_I;
    static Matrix3D[] C5_I;
    static Matrix3D[] C5v_I;
    static Matrix3D[] C3_I;
    static Matrix3D[] C3v_I;
    static Matrix3D[] D3d_O;
    static Matrix3D[] D3_O;
    static Matrix3D[] C3v_O;
    static Matrix3D[] C3_O;
    static Matrix3D[] C2_O;
    static Matrix3D[] C2v_O;
    static Matrix3D[] D2h_O;
    static Matrix3D[] D2_O;
    static Matrix3D[] S6_O;
    static Matrix3D[] S10_I;
    static Matrix3D[] S6_I;
    static Axis[] axesO;
    static Axis[] axesT;
    static double g;
    static double g1;
    static double gg1;
    static double gg;
    static Axis[] axesI;
    static Vector3D[] planes_Ih;
    static Vector3D[] planes_Oh;
    static Vector3D[] planes_Th;
    static Vector3D[] planes_Td;
    static double tau;
    static String[][] symNames;
    static String[] allgroups;
    static String[][][] subgroups;
    static double gam;
    static final double TOL;

    public static Axis[] getAxes(String string) {
        if (string.equals("O")) {
            return Symmetry.getAxesO();
        }
        if (string.equals("Oh")) {
            return Symmetry.getAxesO();
        }
        if (string.equals("I")) {
            return Symmetry.getAxesI();
        }
        if (string.equals("Ih")) {
            return Symmetry.getAxesI();
        }
        if (string.equals("T")) {
            return Symmetry.getAxesT();
        }
        if (string.equals("Th")) {
            return Symmetry.getAxesT();
        }
        if (string.equals("Td")) {
            return Symmetry.getAxesT();
        }
        return new Axis[0];
    }

    public static Matrix3D[] getMatrices(String string) {
        if (string.equals("E") || string.equals("C1")) {
            return Symmetry.getE();
        }
        if (string.equals("Ci") || string.equals("S2")) {
            return Symmetry.getS2();
        }
        if (string.equals("C2")) {
            return Symmetry.getC2();
        }
        if (string.equals("C2v")) {
            return Symmetry.getC2v();
        }
        if (string.equals("Cs")) {
            return Symmetry.getCs();
        }
        if (string.equals("O")) {
            return Symmetry.getO();
        }
        if (string.equals("Oh")) {
            return Symmetry.getOh();
        }
        if (string.equals("D3d(O)")) {
            return Symmetry.getD3d_O();
        }
        if (string.equals("D3(O)")) {
            return Symmetry.getD3_O();
        }
        if (string.equals("C3v(O)")) {
            return Symmetry.getC3v_O();
        }
        if (string.equals("C3(O)")) {
            return Symmetry.getC3_O();
        }
        if (string.equals("D2(O)")) {
            return Symmetry.getD2_O();
        }
        if (string.equals("D2h(O)")) {
            return Symmetry.getD2h_O();
        }
        if (string.equals("C2(O)")) {
            return Symmetry.getC2_O();
        }
        if (string.equals("C2v(O)")) {
            return Symmetry.getC2v_O();
        }
        if (string.equals("I")) {
            return Symmetry.getI();
        }
        if (string.equals("D5d(I)")) {
            return Symmetry.getD5d_I();
        }
        if (string.equals("D5(I)")) {
            return Symmetry.getD5_I();
        }
        if (string.equals("C5(I)")) {
            return Symmetry.getC5_I();
        }
        if (string.equals("C5v(I)")) {
            return Symmetry.getC5v_I();
        }
        if (string.equals("D3d(I)")) {
            return Symmetry.getD3d_I();
        }
        if (string.equals("D3(I)")) {
            return Symmetry.getD3_I();
        }
        if (string.equals("C3(I)")) {
            return Symmetry.getC3_I();
        }
        if (string.equals("C3v(I)")) {
            return Symmetry.getC3v_I();
        }
        if (string.equals("Ih")) {
            return Symmetry.getIh();
        }
        if (string.equals("T")) {
            return Symmetry.getT();
        }
        if (string.equals("Th")) {
            return Symmetry.getTh();
        }
        if (string.equals("Td")) {
            return Symmetry.getTd();
        }
        if (string.equals("D2h")) {
            return Symmetry.getDnh(2);
        }
        if (string.equals("D3h")) {
            return Symmetry.getDnh(3);
        }
        if (string.equals("D4h")) {
            return Symmetry.getDnh(4);
        }
        if (string.equals("D5h")) {
            return Symmetry.getDnh(5);
        }
        if (string.equals("D6h")) {
            return Symmetry.getDnh(6);
        }
        if (string.equals("D7h")) {
            return Symmetry.getDnh(7);
        }
        if (string.equals("D2d")) {
            return Symmetry.getDnd(2);
        }
        if (string.equals("D3d")) {
            return Symmetry.getDnd(3);
        }
        if (string.equals("D4d")) {
            return Symmetry.getDnd(4);
        }
        if (string.equals("D5d")) {
            return Symmetry.getDnd(5);
        }
        if (string.equals("D6d")) {
            return Symmetry.getDnd(6);
        }
        if (string.equals("D7d")) {
            return Symmetry.getDnd(7);
        }
        if (string.equals("D2")) {
            return Symmetry.getDn(2);
        }
        if (string.equals("D3")) {
            return Symmetry.getDn(3);
        }
        if (string.equals("D4")) {
            return Symmetry.getDn(4);
        }
        if (string.equals("D5")) {
            return Symmetry.getDn(5);
        }
        if (string.equals("D6")) {
            return Symmetry.getDn(6);
        }
        if (string.equals("D7")) {
            return Symmetry.getDn(7);
        }
        if (string.equals("C2")) {
            return Symmetry.getCn(2);
        }
        if (string.equals("C3")) {
            return Symmetry.getCn(3);
        }
        if (string.equals("C4")) {
            return Symmetry.getCn(4);
        }
        if (string.equals("C5")) {
            return Symmetry.getCn(5);
        }
        if (string.equals("C6")) {
            return Symmetry.getCn(6);
        }
        if (string.equals("C7")) {
            return Symmetry.getCn(7);
        }
        if (string.equals("C2v")) {
            return Symmetry.getCnv(2);
        }
        if (string.equals("C3v")) {
            return Symmetry.getCnv(3);
        }
        if (string.equals("C4v")) {
            return Symmetry.getCnv(4);
        }
        if (string.equals("C5v")) {
            return Symmetry.getCnv(5);
        }
        if (string.equals("C6v")) {
            return Symmetry.getCnv(6);
        }
        if (string.equals("C7v")) {
            return Symmetry.getCnv(7);
        }
        if (string.equals("C2h")) {
            return Symmetry.getCnh(2);
        }
        if (string.equals("C3h")) {
            return Symmetry.getCnh(3);
        }
        if (string.equals("C4h")) {
            return Symmetry.getCnh(4);
        }
        if (string.equals("C5h")) {
            return Symmetry.getCnh(5);
        }
        if (string.equals("C6h")) {
            return Symmetry.getCnh(6);
        }
        if (string.equals("C7h")) {
            return Symmetry.getCnh(7);
        }
        if (string.equals("S4")) {
            return Symmetry.getSn(4);
        }
        if (string.equals("S6")) {
            return Symmetry.getSn(6);
        }
        if (string.equals("S8")) {
            return Symmetry.getSn(8);
        }
        if (string.equals("S10")) {
            return Symmetry.getSn(10);
        }
        if (string.equals("S12")) {
            return Symmetry.getSn(12);
        }
        if (string.equals("S14")) {
            return Symmetry.getSn(14);
        }
        if (string.equals("S6(O)")) {
            return Symmetry.getS6_O();
        }
        if (string.equals("S10(I)")) {
            return Symmetry.getS10_I();
        }
        if (string.equals("S6(I)")) {
            return Symmetry.getS6_I();
        }
        if (string.equals("C2v(D)")) {
            return Symmetry.getC2v_D();
        }
        if (string.equals("C2h(D)")) {
            return Symmetry.getC2h_D();
        }
        if (string.equals("C2(D)")) {
            return Symmetry.getC2_D();
        }
        if (string.equals("Cs(D2d)")) {
            return Symmetry.getCs_Dd(2);
        }
        if (string.equals("Cs(D3d)")) {
            return Symmetry.getCs_Dd(3);
        }
        if (string.equals("Cs(D4d)")) {
            return Symmetry.getCs_Dd(4);
        }
        if (string.equals("Cs(D5d)")) {
            return Symmetry.getCs_Dd(5);
        }
        if (string.equals("Cs(D6d)")) {
            return Symmetry.getCs_Dd(6);
        }
        if (string.equals("Cs(D7d)")) {
            return Symmetry.getCs_Dd(7);
        }
        if (string.equals("Cs(D2h)") || string.equals("Cs(C2v)")) {
            return Symmetry.getCs_Dh(2);
        }
        if (string.equals("Cs(D3h)") || string.equals("Cs(C3v)")) {
            return Symmetry.getCs_Dh(3);
        }
        if (string.equals("Cs(D4h)") || string.equals("Cs(C4v)")) {
            return Symmetry.getCs_Dh(4);
        }
        if (string.equals("Cs(D5h)") || string.equals("Cs(C5v)")) {
            return Symmetry.getCs_Dh(5);
        }
        if (string.equals("Cs(D6h)") || string.equals("Cs(C6v)")) {
            return Symmetry.getCs_Dh(6);
        }
        if (string.equals("Cs(D7h)") || string.equals("Cs(C7v)")) {
            return Symmetry.getCs_Dh(7);
        }
        System.out.println("Can't find symmetry [" + string + "]");
        return new Matrix3D[0];
    }

    static Matrix3D[] getE() {
        if (E == null) {
            E = new Matrix3D[1];
        }
        Symmetry.E[0] = new Matrix3D();
        return E;
    }

    static Matrix3D[] getS2() {
        if (S2 == null) {
            S2 = new Matrix3D[2];
        }
        Symmetry.S2[0] = new Matrix3D();
        Symmetry.S2[1] = new Matrix3D(-1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, -1.0);
        return S2;
    }

    static Matrix3D[] getC2() {
        if (C2 == null) {
            C2 = new Matrix3D[2];
            Symmetry.C2[0] = new Matrix3D();
            Symmetry.C2[1] = new Matrix3D(-1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0);
        }
        return C2;
    }

    static Matrix3D[] getC2v() {
        if (C2v == null) {
            C2v = new Matrix3D[4];
            Symmetry.C2v[0] = new Matrix3D();
            Symmetry.C2v[1] = new Matrix3D(-1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0);
            Symmetry.C2v[2] = new Matrix3D(-1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
            Symmetry.C2v[3] = new Matrix3D(1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0);
        }
        return C2v;
    }

    static Matrix3D[] getCs() {
        if (Cs == null) {
            Cs = new Matrix3D[2];
        }
        Symmetry.Cs[0] = new Matrix3D();
        Symmetry.Cs[1] = new Matrix3D(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, -1.0);
        return Cs;
    }

    static Matrix3D[] getO() {
        if (O == null) {
            O = new Matrix3D[24];
            Symmetry.O[0] = new Matrix3D();
            Symmetry.O[1] = Matrix3D.rotation(new Vector3D(1.0, 0.0, 0.0), 1.5707963267948966);
            Symmetry.O[2] = Matrix3D.rotation(new Vector3D(1.0, 0.0, 0.0), Math.PI);
            Symmetry.O[3] = Matrix3D.rotation(new Vector3D(1.0, 0.0, 0.0), 4.71238898038469);
            Symmetry.O[4] = Matrix3D.rotation(new Vector3D(0.0, 1.0, 0.0), 1.5707963267948966);
            Symmetry.O[5] = Matrix3D.rotation(new Vector3D(0.0, 1.0, 0.0), Math.PI);
            Symmetry.O[6] = Matrix3D.rotation(new Vector3D(0.0, 1.0, 0.0), 4.71238898038469);
            Symmetry.O[7] = Matrix3D.rotation(new Vector3D(0.0, 0.0, 1.0), 1.5707963267948966);
            Symmetry.O[8] = Matrix3D.rotation(new Vector3D(0.0, 0.0, 1.0), Math.PI);
            Symmetry.O[9] = Matrix3D.rotation(new Vector3D(0.0, 0.0, 1.0), 4.71238898038469);
            Symmetry.O[10] = Matrix3D.rotation(new Vector3D(1.0, 1.0, 1.0), 2.0943951023931953);
            Symmetry.O[11] = Matrix3D.rotation(new Vector3D(1.0, 1.0, 1.0), -2.0943951023931953);
            Symmetry.O[12] = Matrix3D.rotation(new Vector3D(-1.0, 1.0, 1.0), 2.0943951023931953);
            Symmetry.O[13] = Matrix3D.rotation(new Vector3D(-1.0, 1.0, 1.0), -2.0943951023931953);
            Symmetry.O[14] = Matrix3D.rotation(new Vector3D(1.0, -1.0, 1.0), 2.0943951023931953);
            Symmetry.O[15] = Matrix3D.rotation(new Vector3D(1.0, -1.0, 1.0), -2.0943951023931953);
            Symmetry.O[16] = Matrix3D.rotation(new Vector3D(-1.0, -1.0, 1.0), 2.0943951023931953);
            Symmetry.O[17] = Matrix3D.rotation(new Vector3D(-1.0, -1.0, 1.0), -2.0943951023931953);
            Symmetry.O[18] = Matrix3D.rotation(new Vector3D(1.0, 1.0, 0.0), Math.PI);
            Symmetry.O[19] = Matrix3D.rotation(new Vector3D(-1.0, 1.0, 0.0), Math.PI);
            Symmetry.O[20] = Matrix3D.rotation(new Vector3D(1.0, 0.0, 1.0), Math.PI);
            Symmetry.O[21] = Matrix3D.rotation(new Vector3D(-1.0, 0.0, 1.0), Math.PI);
            Symmetry.O[22] = Matrix3D.rotation(new Vector3D(0.0, 1.0, 1.0), Math.PI);
            Symmetry.O[23] = Matrix3D.rotation(new Vector3D(0.0, -1.0, 1.0), Math.PI);
        }
        return O;
    }

    static Matrix3D[] getT() {
        if (T == null) {
            T = new Matrix3D[12];
            Symmetry.T[0] = new Matrix3D();
            Symmetry.T[1] = Matrix3D.rotation(new Vector3D(1.0, 0.0, 0.0), Math.PI);
            Symmetry.T[2] = Matrix3D.rotation(new Vector3D(0.0, 1.0, 0.0), Math.PI);
            Symmetry.T[3] = Matrix3D.rotation(new Vector3D(0.0, 0.0, 1.0), Math.PI);
            Symmetry.T[4] = Matrix3D.rotation(new Vector3D(1.0, 1.0, 1.0), 2.0943951023931953);
            Symmetry.T[5] = Matrix3D.rotation(new Vector3D(1.0, 1.0, 1.0), -2.0943951023931953);
            Symmetry.T[6] = Matrix3D.rotation(new Vector3D(-1.0, 1.0, 1.0), 2.0943951023931953);
            Symmetry.T[7] = Matrix3D.rotation(new Vector3D(-1.0, 1.0, 1.0), -2.0943951023931953);
            Symmetry.T[8] = Matrix3D.rotation(new Vector3D(1.0, -1.0, 1.0), 2.0943951023931953);
            Symmetry.T[9] = Matrix3D.rotation(new Vector3D(1.0, -1.0, 1.0), -2.0943951023931953);
            Symmetry.T[10] = Matrix3D.rotation(new Vector3D(-1.0, -1.0, 1.0), 2.0943951023931953);
            Symmetry.T[11] = Matrix3D.rotation(new Vector3D(-1.0, -1.0, 1.0), -2.0943951023931953);
        }
        return T;
    }

    static Matrix3D[] getTh() {
        if (Th == null) {
            Th = new Matrix3D[24];
            Matrix3D[] matrix3DArray = Symmetry.getT();
            int n = 0;
            while (n < 12) {
                Symmetry.Th[n] = matrix3DArray[n];
                ++n;
            }
            Matrix3D matrix3D = new Matrix3D(-1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
            int n2 = 0;
            while (n2 < 12) {
                Symmetry.Th[12 + n2] = matrix3D.mul(matrix3DArray[n2]);
                ++n2;
            }
        }
        return Th;
    }

    static Matrix3D[] getTd() {
        if (Td == null) {
            Td = new Matrix3D[24];
            Matrix3D[] matrix3DArray = Symmetry.getT();
            int n = 0;
            while (n < 12) {
                Symmetry.Td[n] = matrix3DArray[n];
                ++n;
            }
            Matrix3D matrix3D = new Matrix3D(0.0, -1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            int n2 = 0;
            while (n2 < 12) {
                Symmetry.Td[12 + n2] = matrix3D.mul(matrix3DArray[n2]);
                ++n2;
            }
        }
        return Td;
    }

    static Matrix3D[] getI() {
        if (I == null) {
            double d = (Math.sqrt(5.0) + 1.0) / 2.0;
            double d2 = 1.0 / d;
            I = new Matrix3D[60];
            Symmetry.I[0] = new Matrix3D();
            Symmetry.I[1] = Matrix3D.rotation(new Vector3D(0.0, d, 1.0), 1.2566370614359172);
            Symmetry.I[2] = Matrix3D.rotation(new Vector3D(0.0, d, 1.0), -1.2566370614359172);
            Symmetry.I[3] = Matrix3D.rotation(new Vector3D(0.0, d, 1.0), 2.5132741228718345);
            Symmetry.I[4] = Matrix3D.rotation(new Vector3D(0.0, d, 1.0), -2.5132741228718345);
            Symmetry.I[5] = Matrix3D.rotation(new Vector3D(0.0, d, -1.0), 1.2566370614359172);
            Symmetry.I[6] = Matrix3D.rotation(new Vector3D(0.0, d, -1.0), -1.2566370614359172);
            Symmetry.I[7] = Matrix3D.rotation(new Vector3D(0.0, d, -1.0), 2.5132741228718345);
            Symmetry.I[8] = Matrix3D.rotation(new Vector3D(0.0, d, -1.0), -2.5132741228718345);
            Symmetry.I[9] = Matrix3D.rotation(new Vector3D(d, 1.0, 0.0), 1.2566370614359172);
            Symmetry.I[10] = Matrix3D.rotation(new Vector3D(d, 1.0, 0.0), -1.2566370614359172);
            Symmetry.I[11] = Matrix3D.rotation(new Vector3D(d, 1.0, 0.0), 2.5132741228718345);
            Symmetry.I[12] = Matrix3D.rotation(new Vector3D(d, 1.0, 0.0), -2.5132741228718345);
            Symmetry.I[13] = Matrix3D.rotation(new Vector3D(d, -1.0, 0.0), 1.2566370614359172);
            Symmetry.I[14] = Matrix3D.rotation(new Vector3D(d, -1.0, 0.0), -1.2566370614359172);
            Symmetry.I[15] = Matrix3D.rotation(new Vector3D(d, -1.0, 0.0), 2.5132741228718345);
            Symmetry.I[16] = Matrix3D.rotation(new Vector3D(d, -1.0, 0.0), -2.5132741228718345);
            Symmetry.I[17] = Matrix3D.rotation(new Vector3D(1.0, 0.0, d), 1.2566370614359172);
            Symmetry.I[18] = Matrix3D.rotation(new Vector3D(1.0, 0.0, d), -1.2566370614359172);
            Symmetry.I[19] = Matrix3D.rotation(new Vector3D(1.0, 0.0, d), 2.5132741228718345);
            Symmetry.I[20] = Matrix3D.rotation(new Vector3D(1.0, 0.0, d), -2.5132741228718345);
            Symmetry.I[21] = Matrix3D.rotation(new Vector3D(-1.0, 0.0, d), 1.2566370614359172);
            Symmetry.I[22] = Matrix3D.rotation(new Vector3D(-1.0, 0.0, d), -1.2566370614359172);
            Symmetry.I[23] = Matrix3D.rotation(new Vector3D(-1.0, 0.0, d), 2.5132741228718345);
            Symmetry.I[24] = Matrix3D.rotation(new Vector3D(-1.0, 0.0, d), -2.5132741228718345);
            Symmetry.I[25] = Matrix3D.rotation(new Vector3D(d2, d, 0.0), 2.0943951023931953);
            Symmetry.I[26] = Matrix3D.rotation(new Vector3D(d2, d, 0.0), -2.0943951023931953);
            Symmetry.I[27] = Matrix3D.rotation(new Vector3D(-d2, d, 0.0), 2.0943951023931953);
            Symmetry.I[28] = Matrix3D.rotation(new Vector3D(-d2, d, 0.0), -2.0943951023931953);
            Symmetry.I[29] = Matrix3D.rotation(new Vector3D(d, 0.0, d2), 2.0943951023931953);
            Symmetry.I[30] = Matrix3D.rotation(new Vector3D(d, 0.0, d2), -2.0943951023931953);
            Symmetry.I[31] = Matrix3D.rotation(new Vector3D(d, 0.0, -d2), 2.0943951023931953);
            Symmetry.I[32] = Matrix3D.rotation(new Vector3D(d, 0.0, -d2), -2.0943951023931953);
            Symmetry.I[33] = Matrix3D.rotation(new Vector3D(0.0, d2, d), 2.0943951023931953);
            Symmetry.I[34] = Matrix3D.rotation(new Vector3D(0.0, d2, d), -2.0943951023931953);
            Symmetry.I[35] = Matrix3D.rotation(new Vector3D(0.0, -d2, d), 2.0943951023931953);
            Symmetry.I[36] = Matrix3D.rotation(new Vector3D(0.0, -d2, d), -2.0943951023931953);
            Symmetry.I[37] = Matrix3D.rotation(new Vector3D(1.0, 1.0, 1.0), 2.0943951023931953);
            Symmetry.I[38] = Matrix3D.rotation(new Vector3D(1.0, 1.0, 1.0), -2.0943951023931953);
            Symmetry.I[39] = Matrix3D.rotation(new Vector3D(1.0, -1.0, 1.0), 2.0943951023931953);
            Symmetry.I[40] = Matrix3D.rotation(new Vector3D(1.0, -1.0, 1.0), -2.0943951023931953);
            Symmetry.I[41] = Matrix3D.rotation(new Vector3D(-1.0, -1.0, 1.0), 2.0943951023931953);
            Symmetry.I[42] = Matrix3D.rotation(new Vector3D(-1.0, -1.0, 1.0), -2.0943951023931953);
            Symmetry.I[43] = Matrix3D.rotation(new Vector3D(-1.0, 1.0, 1.0), 2.0943951023931953);
            Symmetry.I[44] = Matrix3D.rotation(new Vector3D(-1.0, 1.0, 1.0), -2.0943951023931953);
            Symmetry.I[45] = Matrix3D.rotation(new Vector3D(1.0, 0.0, 0.0), Math.PI);
            Symmetry.I[46] = Matrix3D.rotation(new Vector3D(0.0, 1.0, 0.0), Math.PI);
            Symmetry.I[47] = Matrix3D.rotation(new Vector3D(0.0, 0.0, 1.0), Math.PI);
            double d3 = 1.0 + d2;
            double d4 = 1.0 + d;
            Symmetry.I[48] = Matrix3D.rotation(new Vector3D(1.0, d3, d4), Math.PI);
            Symmetry.I[49] = Matrix3D.rotation(new Vector3D(-1.0, d3, d4), Math.PI);
            Symmetry.I[50] = Matrix3D.rotation(new Vector3D(1.0, -d3, d4), Math.PI);
            Symmetry.I[51] = Matrix3D.rotation(new Vector3D(-1.0, -d3, d4), Math.PI);
            Symmetry.I[52] = Matrix3D.rotation(new Vector3D(d4, 1.0, d3), Math.PI);
            Symmetry.I[53] = Matrix3D.rotation(new Vector3D(d4, -1.0, d3), Math.PI);
            Symmetry.I[54] = Matrix3D.rotation(new Vector3D(d4, 1.0, -d3), Math.PI);
            Symmetry.I[55] = Matrix3D.rotation(new Vector3D(d4, -1.0, -d3), Math.PI);
            Symmetry.I[56] = Matrix3D.rotation(new Vector3D(d3, d4, 1.0), Math.PI);
            Symmetry.I[57] = Matrix3D.rotation(new Vector3D(d3, d4, -1.0), Math.PI);
            Symmetry.I[58] = Matrix3D.rotation(new Vector3D(-d3, d4, 1.0), Math.PI);
            Symmetry.I[59] = Matrix3D.rotation(new Vector3D(-d3, d4, -1.0), Math.PI);
        }
        return I;
    }

    static Matrix3D[] getIh() {
        if (Ih == null) {
            Ih = new Matrix3D[120];
            Matrix3D[] matrix3DArray = Symmetry.getI();
            int n = 0;
            while (n < 60) {
                Symmetry.Ih[n] = matrix3DArray[n];
                ++n;
            }
            Matrix3D matrix3D = new Matrix3D(-1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
            int n2 = 0;
            while (n2 < 60) {
                Symmetry.Ih[60 + n2] = matrix3D.mul(matrix3DArray[n2]);
                ++n2;
            }
        }
        return Ih;
    }

    static Matrix3D[] getOh() {
        if (Oh == null) {
            Oh = new Matrix3D[48];
            Matrix3D[] matrix3DArray = Symmetry.getO();
            int n = 0;
            while (n < 24) {
                Symmetry.Oh[n] = matrix3DArray[n];
                ++n;
            }
            Matrix3D matrix3D = new Matrix3D(-1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
            int n2 = 0;
            while (n2 < 24) {
                Symmetry.Oh[24 + n2] = matrix3D.mul(matrix3DArray[n2]);
                ++n2;
            }
        }
        return Oh;
    }

    static Matrix3D[] getD2h() {
        if (D2h == null) {
            D2h = new Matrix3D[8];
            Symmetry.D2h[0] = new Matrix3D();
            Symmetry.D2h[1] = Matrix3D.rotation(new Vector3D(1.0, 0.0, 0.0), Math.PI);
            Symmetry.D2h[2] = Matrix3D.rotation(new Vector3D(0.0, 1.0, 0.0), Math.PI);
            Symmetry.D2h[3] = Matrix3D.rotation(new Vector3D(0.0, 0.0, 1.0), Math.PI);
            Matrix3D matrix3D = new Matrix3D(-1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
            int n = 0;
            while (n < 4) {
                Symmetry.D2h[4 + n] = matrix3D.mul(D2h[n]);
                ++n;
            }
        }
        return D2h;
    }

    static Matrix3D[] getD2d() {
        if (D2d == null) {
            D2d = new Matrix3D[8];
            Symmetry.D2d[0] = new Matrix3D();
            Symmetry.D2d[1] = Matrix3D.rotation(new Vector3D(1.0, 1.0, 0.0), Math.PI);
            Symmetry.D2d[2] = Matrix3D.rotation(new Vector3D(-1.0, 1.0, 0.0), Math.PI);
            Symmetry.D2d[3] = Matrix3D.rotation(new Vector3D(0.0, 0.0, 1.0), Math.PI);
            Matrix3D matrix3D = new Matrix3D(-1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
            int n = 0;
            while (n < 4) {
                Symmetry.D2d[4 + n] = matrix3D.mul(D2d[n]);
                ++n;
            }
        }
        return D2d;
    }

    static Matrix3D[] getD5d_I() {
        if (D5d_I != null) {
            return D5d_I;
        }
        double d = (Math.sqrt(5.0) + 1.0) / 2.0;
        int n = 5;
        Matrix3D[] matrix3DArray = new Matrix3D[4 * n];
        Vector3D vector3D = new Vector3D(1.0, 0.0, 0.0);
        Vector3D vector3D2 = new Vector3D(0.0, d, 1.0).normalize();
        int n2 = 0;
        while (n2 < n) {
            matrix3DArray[n2] = Matrix3D.rotation(vector3D2, (double)(n2 * 2) * Math.PI / 5.0);
            double d2 = (double)n2 * Math.PI / (double)n;
            matrix3DArray[n2 + n] = Matrix3D.rotation(vector3D.mul(matrix3DArray[n2]), Math.PI);
            ++n2;
        }
        Matrix3D matrix3D = new Matrix3D(-1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        int n3 = 0;
        while (n3 < 2 * n) {
            matrix3DArray[2 * n + n3] = matrix3D.mul(matrix3DArray[n3]);
            ++n3;
        }
        D5d_I = matrix3DArray;
        return D5d_I;
    }

    static Matrix3D[] getD5_I() {
        if (D5_I != null) {
            return D5_I;
        }
        double d = (Math.sqrt(5.0) + 1.0) / 2.0;
        int n = 5;
        Matrix3D[] matrix3DArray = new Matrix3D[2 * n];
        Vector3D vector3D = new Vector3D(1.0, 0.0, 0.0);
        Vector3D vector3D2 = new Vector3D(0.0, d, 1.0).normalize();
        int n2 = 0;
        while (n2 < n) {
            matrix3DArray[n2] = Matrix3D.rotation(vector3D2, (double)(n2 * 2) * Math.PI / 5.0);
            double d2 = (double)n2 * Math.PI / (double)n;
            matrix3DArray[n2 + n] = Matrix3D.rotation(vector3D.mul(matrix3DArray[n2]), Math.PI);
            ++n2;
        }
        D5_I = matrix3DArray;
        return D5_I;
    }

    static Matrix3D[] getC5_I() {
        if (C5_I != null) {
            return C5_I;
        }
        double d = (Math.sqrt(5.0) + 1.0) / 2.0;
        int n = 5;
        Matrix3D[] matrix3DArray = new Matrix3D[n];
        Vector3D vector3D = new Vector3D(0.0, d, 1.0).normalize();
        int n2 = 0;
        while (n2 < n) {
            matrix3DArray[n2] = Matrix3D.rotation(vector3D, (double)(n2 * 2) * Math.PI / 5.0);
            ++n2;
        }
        C5_I = matrix3DArray;
        return C5_I;
    }

    static Matrix3D[] getC5v_I() {
        if (C5v_I != null) {
            return C5v_I;
        }
        double d = (Math.sqrt(5.0) + 1.0) / 2.0;
        int n = 5;
        Matrix3D[] matrix3DArray = new Matrix3D[2 * n];
        Vector3D vector3D = new Vector3D(0.0, d, 1.0).normalize();
        int n2 = 0;
        while (n2 < n) {
            matrix3DArray[n2] = Matrix3D.rotation(vector3D, (double)(n2 * 2) * Math.PI / 5.0);
            ++n2;
        }
        Matrix3D matrix3D = new Matrix3D(-1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        int n3 = 0;
        while (n3 < n) {
            matrix3DArray[n + n3] = matrix3D.mul(matrix3DArray[n3]);
            ++n3;
        }
        C5v_I = matrix3DArray;
        return C5v_I;
    }

    static Matrix3D[] getD3d_I() {
        double d = (Math.sqrt(5.0) + 1.0) / 2.0;
        int n = 3;
        Matrix3D[] matrix3DArray = new Matrix3D[4 * n];
        Vector3D vector3D = new Vector3D(1.0, 0.0, 0.0).normalize();
        Vector3D vector3D2 = new Vector3D(0.0, 1.0 / d, d).normalize();
        int n2 = 0;
        while (n2 < n) {
            matrix3DArray[n2] = Matrix3D.rotation(vector3D2, (double)(n2 * 2) * Math.PI / 3.0);
            matrix3DArray[n2 + n] = Matrix3D.rotation(vector3D.mul(matrix3DArray[n2]), Math.PI);
            ++n2;
        }
        Matrix3D matrix3D = new Matrix3D(-1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        int n3 = 0;
        while (n3 < 2 * n) {
            matrix3DArray[2 * n + n3] = matrix3D.mul(matrix3DArray[n3]);
            ++n3;
        }
        return matrix3DArray;
    }

    static Matrix3D[] getD3_I() {
        double d = (Math.sqrt(5.0) + 1.0) / 2.0;
        int n = 3;
        Matrix3D[] matrix3DArray = new Matrix3D[2 * n];
        Vector3D vector3D = new Vector3D(1.0, 0.0, 0.0).normalize();
        Vector3D vector3D2 = new Vector3D(0.0, 1.0 / d, d).normalize();
        int n2 = 0;
        while (n2 < n) {
            matrix3DArray[n2] = Matrix3D.rotation(vector3D2, (double)(n2 * 2) * Math.PI / 3.0);
            matrix3DArray[n2 + n] = Matrix3D.rotation(vector3D.mul(matrix3DArray[n2]), Math.PI);
            ++n2;
        }
        return matrix3DArray;
    }

    static Matrix3D[] getC3_I() {
        if (C3_I == null) {
            double d = (Math.sqrt(5.0) + 1.0) / 2.0;
            int n = 3;
            C3_I = new Matrix3D[n];
            Vector3D vector3D = new Vector3D(0.0, 1.0 / d, d).normalize();
            int n2 = 0;
            while (n2 < n) {
                Symmetry.C3_I[n2] = Matrix3D.rotation(vector3D, (double)(n2 * 2) * Math.PI / 3.0);
                ++n2;
            }
        }
        return C3_I;
    }

    static Matrix3D[] getC3v_I() {
        if (C3v_I == null) {
            double d = (Math.sqrt(5.0) + 1.0) / 2.0;
            Matrix3D matrix3D = new Matrix3D(-1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
            int n = 3;
            C3v_I = new Matrix3D[2 * n];
            Vector3D vector3D = new Vector3D(0.0, 1.0 / d, d).normalize();
            int n2 = 0;
            while (n2 < n) {
                Symmetry.C3v_I[n2] = Matrix3D.rotation(vector3D, (double)(n2 * 2) * Math.PI / 3.0);
                Symmetry.C3v_I[n2 + n] = matrix3D.mul(C3v_I[n2]);
                ++n2;
            }
        }
        return C3v_I;
    }

    static Matrix3D[] getD3d_O() {
        if (D3d_O == null) {
            int n = 3;
            D3d_O = new Matrix3D[4 * n];
            Vector3D vector3D = new Vector3D(1.0, -1.0, 0.0).normalize();
            Vector3D vector3D2 = new Vector3D(1.0, 1.0, 1.0).normalize();
            int n2 = 0;
            while (n2 < n) {
                Symmetry.D3d_O[n2] = Matrix3D.rotation(vector3D2, (double)(n2 * 2) * Math.PI / 3.0);
                Symmetry.D3d_O[n2 + n] = Matrix3D.rotation(vector3D.mul(D3d_O[n2]), Math.PI);
                ++n2;
            }
            Matrix3D matrix3D = new Matrix3D(0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            int n3 = 0;
            while (n3 < 2 * n) {
                Symmetry.D3d_O[2 * n + n3] = matrix3D.mul(D3d_O[n3]);
                ++n3;
            }
        }
        return D3d_O;
    }

    static Matrix3D[] getD3_O() {
        if (D3_O == null) {
            int n = 3;
            Matrix3D[] matrix3DArray = new Matrix3D[2 * n];
            Vector3D vector3D = new Vector3D(1.0, -1.0, 0.0).normalize();
            Vector3D vector3D2 = new Vector3D(1.0, 1.0, 1.0).normalize();
            int n2 = 0;
            while (n2 < n) {
                matrix3DArray[n2] = Matrix3D.rotation(vector3D2, (double)(n2 * 2) * Math.PI / 3.0);
                matrix3DArray[n2 + n] = Matrix3D.rotation(vector3D.mul(matrix3DArray[n2]), Math.PI);
                ++n2;
            }
            D3_O = matrix3DArray;
        }
        return D3_O;
    }

    static Matrix3D[] getC3v_O() {
        if (C3v_O == null) {
            Matrix3D matrix3D = new Matrix3D(0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            int n = 3;
            C3v_O = new Matrix3D[2 * n];
            Vector3D vector3D = new Vector3D(1.0, 1.0, 1.0).normalize();
            int n2 = 0;
            while (n2 < n) {
                Symmetry.C3v_O[n2] = Matrix3D.rotation(vector3D, (double)(n2 * 2) * Math.PI / 3.0);
                Symmetry.C3v_O[n2 + n] = matrix3D.mul(C3v_O[n2]);
                ++n2;
            }
        }
        return C3v_O;
    }

    static Matrix3D[] getC3_O() {
        if (C3_O == null) {
            int n = 3;
            C3_O = new Matrix3D[n];
            Vector3D vector3D = new Vector3D(1.0, 1.0, 1.0).normalize();
            int n2 = 0;
            while (n2 < n) {
                Symmetry.C3_O[n2] = Matrix3D.rotation(vector3D, (double)(n2 * 2) * Math.PI / 3.0);
                ++n2;
            }
        }
        return C3_O;
    }

    static Matrix3D[] getC2_O() {
        if (C2_O == null) {
            int n = 2;
            Matrix3D[] matrix3DArray = new Matrix3D[n];
            Vector3D vector3D = new Vector3D(1.0, 1.0, 0.0).normalize();
            int n2 = 0;
            while (n2 < n) {
                matrix3DArray[n2] = Matrix3D.rotation(vector3D, (double)(n2 * 2) * Math.PI / 2.0);
                ++n2;
            }
            C2_O = matrix3DArray;
        }
        return C2_O;
    }

    static Matrix3D[] getC2v_O() {
        if (C2v_O == null) {
            int n = 2;
            Matrix3D[] matrix3DArray = new Matrix3D[2 * n];
            Vector3D vector3D = new Vector3D(1.0, 1.0, 0.0).normalize();
            Matrix3D matrix3D = new Matrix3D(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, -1.0);
            int n2 = 0;
            while (n2 < n) {
                matrix3DArray[n2] = Matrix3D.rotation(vector3D, (double)(n2 * 2) * Math.PI / 2.0);
                matrix3DArray[n2 + n] = matrix3D.mul(matrix3DArray[n2]);
                ++n2;
            }
            C2v_O = matrix3DArray;
        }
        return C2v_O;
    }

    static Matrix3D[] getD2h_O() {
        if (D2h_O == null) {
            int n = 2;
            Matrix3D[] matrix3DArray = new Matrix3D[4 * n];
            Vector3D vector3D = new Vector3D(1.0, 0.0, 0.0).normalize();
            Vector3D vector3D2 = new Vector3D(0.0, 1.0, 1.0).normalize();
            matrix3DArray[0] = new Matrix3D();
            matrix3DArray[1] = Matrix3D.rotation(vector3D2, Math.PI);
            matrix3DArray[2] = Matrix3D.rotation(vector3D, Math.PI);
            matrix3DArray[3] = Matrix3D.rotation(new Vector3D(0.0, 1.0, -1.0).normalize(), Math.PI);
            Matrix3D matrix3D = new Matrix3D(1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, -1.0, 0.0);
            int n2 = 0;
            while (n2 < 2 * n) {
                matrix3DArray[2 * n + n2] = matrix3D.mul(matrix3DArray[n2]);
                ++n2;
            }
            D2h_O = matrix3DArray;
        }
        return D2h_O;
    }

    static Matrix3D[] getD2_O() {
        if (D2_O == null) {
            Matrix3D[] matrix3DArray = new Matrix3D[4];
            Vector3D vector3D = new Vector3D(1.0, 0.0, 0.0).normalize();
            Vector3D vector3D2 = new Vector3D(0.0, 1.0, 1.0).normalize();
            matrix3DArray[0] = new Matrix3D();
            matrix3DArray[1] = Matrix3D.rotation(vector3D2, Math.PI);
            matrix3DArray[2] = Matrix3D.rotation(vector3D, Math.PI);
            matrix3DArray[3] = Matrix3D.rotation(new Vector3D(0.0, 1.0, -1.0).normalize(), Math.PI);
            D2_O = matrix3DArray;
        }
        return D2_O;
    }

    static Matrix3D[] getDnd(int n) {
        Matrix3D[] matrix3DArray = new Matrix3D[4 * n];
        int n2 = 0;
        while (n2 < n) {
            matrix3DArray[n2] = Matrix3D.rotation(new Vector3D(0.0, 0.0, 1.0), (double)(n2 * 2) * Math.PI / (double)n);
            double d = (double)n2 * Math.PI / (double)n;
            matrix3DArray[n2 + n] = Matrix3D.rotation(new Vector3D(Math.cos(d), Math.sin(d), 0.0), Math.PI);
            ++n2;
        }
        Matrix3D matrix3D = new Matrix3D(1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0);
        Matrix3D matrix3D2 = Matrix3D.rotation(new Vector3D(0.0, 0.0, 1.0), Math.PI / (double)(2 * n));
        Matrix3D matrix3D3 = Matrix3D.rotation(new Vector3D(0.0, 0.0, 1.0), -Math.PI / (double)(2 * n));
        matrix3D = matrix3D2.mul(matrix3D.mul(matrix3D3));
        int n3 = 0;
        while (n3 < 2 * n) {
            matrix3DArray[2 * n + n3] = matrix3D.mul(matrix3DArray[n3]);
            ++n3;
        }
        return matrix3DArray;
    }

    static Matrix3D[] getDnh(int n) {
        Matrix3D[] matrix3DArray = new Matrix3D[4 * n];
        int n2 = 0;
        while (n2 < n) {
            matrix3DArray[n2] = Matrix3D.rotation(new Vector3D(0.0, 0.0, 1.0), (double)(n2 * 2) * Math.PI / (double)n);
            double d = (double)n2 * Math.PI / (double)n;
            matrix3DArray[n2 + n] = Matrix3D.rotation(new Vector3D(Math.cos(d), Math.sin(d), 0.0), Math.PI);
            ++n2;
        }
        Matrix3D matrix3D = new Matrix3D(1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0);
        int n3 = 0;
        while (n3 < 2 * n) {
            matrix3DArray[2 * n + n3] = matrix3D.mul(matrix3DArray[n3]);
            ++n3;
        }
        return matrix3DArray;
    }

    static Matrix3D[] getDn(int n) {
        Matrix3D[] matrix3DArray = new Matrix3D[2 * n];
        int n2 = 0;
        while (n2 < n) {
            matrix3DArray[n2] = Matrix3D.rotation(new Vector3D(0.0, 0.0, 1.0), (double)(n2 * 2) * Math.PI / (double)n);
            double d = (double)n2 * Math.PI / (double)n;
            matrix3DArray[n2 + n] = Matrix3D.rotation(new Vector3D(Math.cos(d), Math.sin(d), 0.0), Math.PI);
            ++n2;
        }
        return matrix3DArray;
    }

    static Matrix3D[] getCn(int n) {
        Matrix3D[] matrix3DArray = new Matrix3D[n];
        int n2 = 0;
        while (n2 < n) {
            matrix3DArray[n2] = Matrix3D.rotation(new Vector3D(0.0, 0.0, 1.0), (double)(n2 * 2) * Math.PI / (double)n);
            ++n2;
        }
        return matrix3DArray;
    }

    static Matrix3D[] getCnv(int n) {
        Matrix3D[] matrix3DArray = new Matrix3D[2 * n];
        int n2 = 0;
        while (n2 < n) {
            matrix3DArray[n2] = Matrix3D.rotation(new Vector3D(0.0, 0.0, 1.0), (double)(n2 * 2) * Math.PI / (double)n);
            ++n2;
        }
        Matrix3D matrix3D = new Matrix3D(1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0);
        int n3 = 0;
        while (n3 < n) {
            matrix3DArray[n + n3] = matrix3D.mul(matrix3DArray[n3]);
            ++n3;
        }
        return matrix3DArray;
    }

    static Matrix3D[] getCnh(int n) {
        Matrix3D[] matrix3DArray = new Matrix3D[2 * n];
        int n2 = 0;
        while (n2 < n) {
            matrix3DArray[n2] = Matrix3D.rotation(new Vector3D(0.0, 0.0, 1.0), (double)(n2 * 2) * Math.PI / (double)n);
            ++n2;
        }
        Matrix3D matrix3D = new Matrix3D(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, -1.0);
        int n3 = 0;
        while (n3 < n) {
            matrix3DArray[n + n3] = matrix3D.mul(matrix3DArray[n3]);
            ++n3;
        }
        return matrix3DArray;
    }

    static Matrix3D[] getSn(int n) {
        Matrix3D[] matrix3DArray = new Matrix3D[n];
        Matrix3D matrix3D = new Matrix3D();
        matrix3D = Matrix3D.rotation(new Vector3D(0.0, 0.0, 1.0), Math.PI * 2 / (double)n);
        Matrix3D matrix3D2 = new Matrix3D(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, -1.0);
        matrix3D = matrix3D2.mul(matrix3D);
        matrix3DArray[0] = new Matrix3D();
        int n2 = 1;
        while (n2 < n) {
            matrix3DArray[n2] = matrix3D.mul(matrix3DArray[n2 - 1]);
            ++n2;
        }
        return matrix3DArray;
    }

    static Matrix3D[] getS6_O() {
        if (S6_O == null) {
            Matrix3D matrix3D;
            int n = 6;
            S6_O = new Matrix3D[n];
            Vector3D vector3D = new Vector3D(1.0, 1.0, 1.0).normalize();
            Matrix3D matrix3D2 = Matrix3D.rotation(vector3D, Math.PI * 2 / (double)n);
            Matrix3D matrix3D3 = Matrix3D.reflection(vector3D);
            Symmetry.S6_O[0] = matrix3D = matrix3D3.mul(matrix3D2);
            int n2 = 1;
            while (n2 < n) {
                Symmetry.S6_O[n2] = matrix3D.mul(S6_O[n2 - 1]);
                ++n2;
            }
        }
        return S6_O;
    }

    static Matrix3D[] getS10_I() {
        double d = (Math.sqrt(5.0) + 1.0) / 2.0;
        if (S10_I == null) {
            Matrix3D matrix3D;
            int n = 10;
            S10_I = new Matrix3D[n];
            Vector3D vector3D = new Vector3D(0.0, d, 1.0).normalize();
            Matrix3D matrix3D2 = Matrix3D.rotation(vector3D, Math.PI * 2 / (double)n);
            Matrix3D matrix3D3 = Matrix3D.reflection(vector3D);
            Symmetry.S10_I[0] = matrix3D = matrix3D3.mul(matrix3D2);
            int n2 = 1;
            while (n2 < n) {
                Symmetry.S10_I[n2] = matrix3D.mul(S10_I[n2 - 1]);
                ++n2;
            }
        }
        return S10_I;
    }

    static Matrix3D[] getS6_I() {
        double d = (Math.sqrt(5.0) + 1.0) / 2.0;
        double d2 = 1.0 / d;
        if (S6_I == null) {
            Matrix3D matrix3D;
            int n = 6;
            S6_I = new Matrix3D[n];
            Vector3D vector3D = new Vector3D(0.0, d2, d).normalize();
            Matrix3D matrix3D2 = Matrix3D.rotation(vector3D, Math.PI * 2 / (double)n);
            Matrix3D matrix3D3 = Matrix3D.reflection(vector3D);
            Symmetry.S6_I[0] = matrix3D = matrix3D3.mul(matrix3D2);
            int n2 = 1;
            while (n2 < n) {
                Symmetry.S6_I[n2] = matrix3D.mul(S6_I[n2 - 1]);
                ++n2;
            }
        }
        return S6_I;
    }

    static Matrix3D[] getC2_D() {
        int n = 2;
        Matrix3D[] matrix3DArray = new Matrix3D[n];
        int n2 = 0;
        while (n2 < n) {
            matrix3DArray[n2] = Matrix3D.rotation(new Vector3D(1.0, 0.0, 0.0), (double)(n2 * 2) * Math.PI / (double)n);
            ++n2;
        }
        return matrix3DArray;
    }

    static Matrix3D[] getC2v_D() {
        int n = 2;
        Matrix3D[] matrix3DArray = new Matrix3D[2 * n];
        int n2 = 0;
        while (n2 < n) {
            matrix3DArray[n2] = Matrix3D.rotation(new Vector3D(1.0, 0.0, 0.0), (double)(n2 * 2) * Math.PI / (double)n);
            ++n2;
        }
        Matrix3D matrix3D = new Matrix3D(1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0);
        int n3 = 0;
        while (n3 < n) {
            matrix3DArray[n + n3] = matrix3D.mul(matrix3DArray[n3]);
            ++n3;
        }
        return matrix3DArray;
    }

    static Matrix3D[] getC2h_D() {
        int n = 2;
        Matrix3D[] matrix3DArray = new Matrix3D[2 * n];
        int n2 = 0;
        while (n2 < n) {
            matrix3DArray[n2] = Matrix3D.rotation(new Vector3D(1.0, 0.0, 0.0), (double)(n2 * 2) * Math.PI / (double)n);
            ++n2;
        }
        Matrix3D matrix3D = new Matrix3D(-1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        int n3 = 0;
        while (n3 < n) {
            matrix3DArray[n + n3] = matrix3D.mul(matrix3DArray[n3]);
            ++n3;
        }
        return matrix3DArray;
    }

    static Matrix3D[] getCs_Dd(int n) {
        Matrix3D[] matrix3DArray = new Matrix3D[2];
        matrix3DArray[0] = new Matrix3D();
        boolean bl = false;
        double d = n % 2 == 0 ? ((double)bl + 0.5) * Math.PI / (double)n : (double)bl * Math.PI / (double)n;
        matrix3DArray[1] = Matrix3D.reflection(new Vector3D(Math.cos(d), Math.sin(d), 0.0));
        return matrix3DArray;
    }

    static Matrix3D[] getCs_Dh(int n) {
        Matrix3D[] matrix3DArray = new Matrix3D[]{new Matrix3D(), Matrix3D.reflection(new Vector3D(0.0, 1.0, 0.0))};
        return matrix3DArray;
    }

    static Axis[] getAxesO() {
        return axesO;
    }

    static Axis[] getAxesI() {
        return axesI;
    }

    static Axis[] getAxesT() {
        return axesT;
    }

    static void makePlanes_Ih() {
        Vector3D[] vector3DArray = new Vector3D[15];
        vector3DArray[0] = new Vector3D(0.0, 1.0, 0.0);
        vector3DArray[1] = new Vector3D(1.0, 0.0, 0.0);
        double d = (Math.sqrt(5.0) + 1.0) / 2.0;
        Vector3D vector3D = new Vector3D(1.0, 0.0, d).normalize();
        Vector3D vector3D2 = new Vector3D(-1.0, 0.0, d).normalize();
        Vector3D vector3D3 = new Vector3D(d, 0.0, 1.0 / d).normalize();
        Vector3D vector3D4 = new Vector3D(-d, 0.0, 1.0 / d).normalize();
        vector3DArray[2] = vector3DArray[0].rotate(vector3D, -0.6283185307179586);
        vector3DArray[3] = vector3DArray[0].rotate(vector3D2, 0.6283185307179586);
        vector3DArray[4] = vector3DArray[0].rotate(vector3D, -1.2566370614359172);
        vector3DArray[5] = vector3DArray[0].rotate(vector3D2, 1.2566370614359172);
        vector3DArray[6] = vector3DArray[0].rotate(vector3D, -1.8849555921538759);
        vector3DArray[7] = vector3DArray[0].rotate(vector3D2, 1.8849555921538759);
        vector3DArray[8] = vector3DArray[0].rotate(vector3D, -2.5132741228718345);
        vector3DArray[9] = vector3DArray[0].rotate(vector3D2, 2.5132741228718345);
        vector3DArray[10] = vector3DArray[0].rotate(vector3D3, -1.0471975511965976);
        vector3DArray[11] = vector3DArray[0].rotate(vector3D4, 1.0471975511965976);
        vector3DArray[12] = vector3DArray[0].rotate(vector3D3, -2.0943951023931953);
        vector3DArray[13] = vector3DArray[0].rotate(vector3D4, 2.0943951023931953);
        vector3DArray[14] = new Vector3D(0.0, 0.0, 1.0);
        planes_Ih = vector3DArray;
    }

    static void makePlanes_Oh() {
        Vector3D[] vector3DArray = new Vector3D[9];
        vector3DArray = new Vector3D[]{new Vector3D(1.0, 1.0, 0.0), new Vector3D(-1.0, 1.0, 0.0), new Vector3D(1.0, 0.0, 1.0), new Vector3D(1.0, 0.0, -1.0), new Vector3D(0.0, 1.0, 1.0), new Vector3D(0.0, 1.0, -1.0), new Vector3D(1.0, 0.0, 0.0), new Vector3D(0.0, 1.0, 0.0), new Vector3D(0.0, 0.0, 1.0)};
        planes_Oh = vector3DArray;
    }

    static void makePlanes_Td() {
        Vector3D[] vector3DArray = new Vector3D[]{new Vector3D(1.0, 1.0, 0.0), new Vector3D(-1.0, 1.0, 0.0), new Vector3D(1.0, 0.0, 1.0), new Vector3D(1.0, 0.0, -1.0), new Vector3D(0.0, 1.0, 1.0), new Vector3D(0.0, 1.0, -1.0)};
        planes_Td = vector3DArray;
    }

    static void makePlanes_Th() {
        Vector3D[] vector3DArray = new Vector3D[]{new Vector3D(1.0, 0.0, 0.0), new Vector3D(0.0, 1.0, 0.0), new Vector3D(0.0, 0.0, 1.0)};
        planes_Th = vector3DArray;
    }

    public static Plane[] getSymmetryPlanes(String string) {
        Vector3D[] vector3DArray = new Vector3D[]{};
        if (string.equals("Ih") || string.equals("I")) {
            if (planes_Ih == null) {
                Symmetry.makePlanes_Ih();
            }
            vector3DArray = planes_Ih;
        } else if (string.equals("Oh") || string.equals("O")) {
            if (planes_Oh == null) {
                Symmetry.makePlanes_Oh();
            }
            vector3DArray = planes_Oh;
        } else if (string.equals("Td") || string.equals("T")) {
            if (planes_Td == null) {
                Symmetry.makePlanes_Td();
            }
            vector3DArray = planes_Td;
        } else if (string.equals("Th")) {
            if (planes_Th == null) {
                Symmetry.makePlanes_Th();
            }
            vector3DArray = planes_Th;
        }
        Plane[] planeArray = new Plane[vector3DArray.length];
        int n = 0;
        while (n < vector3DArray.length) {
            vector3DArray[n].normalize();
            planeArray[n] = new Plane(vector3DArray[n], 0.0, n);
            ++n;
        }
        return planeArray;
    }

    static Vector3D make_canonical_point_Ih(Vector3D vector3D) {
        if (planes_Ih == null) {
            Symmetry.makePlanes_Ih();
        }
        Vector3D[] vector3DArray = planes_Ih;
        Vector3D vector3D2 = new Vector3D(vector3D.x, vector3D.y, vector3D.z);
        int n = 1;
        if (vector3D2.x < 0.0) {
            n *= -1;
            vector3D2.x = -vector3D2.x;
        }
        if (vector3D2.y < 0.0) {
            n *= -1;
            vector3D2.y = -vector3D2.y;
        }
        if (vector3D2.z < 0.0) {
            n *= -1;
            vector3D2.z = -vector3D2.z;
        }
        double d = vector3D2.dot(vector3DArray[10]);
        double d2 = vector3D2.dot(vector3DArray[6]);
        double d3 = vector3D2.dot(vector3DArray[3]);
        if (d > 0.0 && d2 > 0.0) {
            vector3D2.rotateSet(new Vector3D(1.0, 1.0, 1.0).normalize(), 4.1887902047863905);
        } else if (d2 < 0.0 && d3 > 0.0) {
            vector3D2.rotateSet(new Vector3D(1.0, 1.0, 1.0).normalize(), 2.0943951023931953);
        }
        double d4 = vector3D2.dot(vector3DArray[2]);
        d2 = vector3D2.dot(vector3DArray[6]);
        if (d2 > 0.0) {
            vector3D2.rotateSet(new Vector3D(1.0, 0.0, tau).normalize(), 2.5132741228718345);
        } else if (d4 > 0.0) {
            vector3D2.rotateSet(new Vector3D(1.0, 0.0, tau).normalize(), 1.2566370614359172);
        }
        if (vector3D2.y < 0.0) {
            n *= -1;
            vector3D2.y = -vector3D2.y;
        }
        vector3D2.x *= (double)n;
        return vector3D2;
    }

    static Vector3D make_canonical_point_Oh(Vector3D vector3D) {
        double d;
        Vector3D vector3D2 = new Vector3D(vector3D.x, vector3D.y, vector3D.z);
        int n = 1;
        if (vector3D2.x < 0.0) {
            n *= -1;
            vector3D2.x = -vector3D2.x;
        }
        if (vector3D2.y < 0.0) {
            n *= -1;
            vector3D2.y = -vector3D2.y;
        }
        if (vector3D2.z < 0.0) {
            n *= -1;
            vector3D2.z = -vector3D2.z;
        }
        if (vector3D2.x > vector3D2.z) {
            d = vector3D2.z;
            vector3D2.z = vector3D2.x;
            vector3D2.x = d;
            n *= -1;
        }
        if (vector3D2.y > vector3D2.x) {
            d = vector3D2.y;
            vector3D2.y = vector3D2.x;
            vector3D2.x = d;
            n *= -1;
        }
        if (vector3D2.x > vector3D2.z) {
            d = vector3D2.z;
            vector3D2.z = vector3D2.x;
            vector3D2.x = d;
            n *= -1;
        }
        vector3D2.x *= (double)n;
        return vector3D2;
    }

    static Vector3D make_canonical_point_Td(Vector3D vector3D) {
        double d;
        Vector3D vector3D2 = new Vector3D(vector3D);
        int n = 1;
        if (vector3D2.y > vector3D2.x) {
            d = vector3D2.y;
            vector3D2.y = vector3D2.x;
            vector3D2.x = d;
            n *= -1;
        }
        if (vector3D2.y < -vector3D2.x) {
            d = vector3D2.y;
            vector3D2.y = -vector3D2.x;
            vector3D2.x = -d;
            n *= -1;
        }
        if (vector3D2.z < vector3D2.x) {
            d = vector3D2.z;
            vector3D2.z = vector3D2.x;
            vector3D2.x = d;
            n *= -1;
        }
        if (vector3D2.z < -vector3D2.x) {
            d = vector3D2.z;
            vector3D2.z = -vector3D2.x;
            vector3D2.x = -d;
            n *= -1;
        }
        if (vector3D2.y > vector3D2.x) {
            d = vector3D2.y;
            vector3D2.y = vector3D2.x;
            vector3D2.x = d;
            n *= -1;
        }
        if (vector3D2.y < -vector3D2.x) {
            d = vector3D2.y;
            vector3D2.y = -vector3D2.x;
            vector3D2.x = -d;
            n *= -1;
        }
        if (n < 0) {
            d = vector3D2.y;
            vector3D2.y = vector3D2.x;
            vector3D2.x = d;
        }
        return vector3D2;
    }

    static Vector3D make_canonical_point_Th(Vector3D vector3D) {
        double d;
        Vector3D vector3D2 = new Vector3D(vector3D);
        int n = 1;
        if (vector3D2.x < 0.0) {
            n *= -1;
            vector3D2.x = -vector3D2.x;
        }
        if (vector3D2.y < 0.0) {
            n *= -1;
            vector3D2.y = -vector3D2.y;
        }
        if (vector3D2.z < 0.0) {
            n *= -1;
            vector3D2.z = -vector3D2.z;
        }
        if (vector3D2.z < vector3D2.x) {
            d = vector3D2.x;
            vector3D2.x = vector3D2.y;
            vector3D2.y = vector3D2.z;
            vector3D2.z = d;
        }
        if (vector3D2.z < vector3D2.y) {
            d = vector3D2.x;
            vector3D2.x = vector3D2.z;
            vector3D2.z = vector3D2.y;
            vector3D2.y = d;
        }
        if (vector3D2.z < vector3D2.x) {
            d = vector3D2.x;
            vector3D2.x = vector3D2.y;
            vector3D2.y = vector3D2.z;
            vector3D2.z = d;
        }
        vector3D2.x *= (double)n;
        return vector3D2;
    }

    static boolean test_point_at_plane(Vector3D[] vector3DArray, Vector3D vector3D) {
        int n = 0;
        while (n < vector3DArray.length) {
            double d = vector3DArray[n].dot(vector3D);
            if (d < 0.0) {
                d = -d;
            }
            if (d < TOL) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static int get_handedness(Vector3D vector3D, String string) {
        if (string.equals("O")) {
            if (planes_Oh == null) {
                Symmetry.makePlanes_Oh();
            }
            if (Symmetry.test_point_at_plane(planes_Oh, vector3D)) {
                return 0;
            }
            Vector3D vector3D2 = Symmetry.make_canonical_point_Oh(vector3D);
            if (vector3D2.x < -TOL) {
                return -1;
            }
            if (vector3D2.x > TOL) {
                return 1;
            }
            return 0;
        }
        if (string.equals("I")) {
            if (planes_Ih == null) {
                Symmetry.makePlanes_Ih();
            }
            if (Symmetry.test_point_at_plane(planes_Ih, vector3D)) {
                return 0;
            }
            Vector3D vector3D3 = Symmetry.make_canonical_point_Ih(vector3D);
            if (vector3D3.x < -TOL) {
                return -1;
            }
            if (vector3D3.x > TOL) {
                return 1;
            }
            return 0;
        }
        if (string.equals("Th") || string.equals("T")) {
            Vector3D vector3D4 = Symmetry.make_canonical_point_Ih(vector3D);
            if (vector3D4.x < -TOL) {
                return -1;
            }
            if (vector3D4.x > TOL) {
                return 1;
            }
            return 0;
        }
        if (string.equals("Td")) {
            Vector3D vector3D5 = Symmetry.make_canonical_point_Ih(vector3D);
            if (vector3D5.x - vector3D5.y < -TOL) {
                return -1;
            }
            if (vector3D5.x - vector3D5.y > TOL) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public static String[] getSubgroups(String string) {
        int n = 0;
        while (n < subgroups.length) {
            if (subgroups[n][0][0].equals(string)) {
                return subgroups[n][1];
            }
            ++n;
        }
        return new String[]{string};
    }

    public static String[] getSymmetryNames() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        while (n < allgroups.length) {
            hashtable.put(allgroups[n], allgroups[n]);
            ++n;
        }
        Object[] objectArray = new String[hashtable.size()];
        int n2 = 0;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            objectArray[n2++] = (String)enumeration.nextElement();
        }
        QSort.quickSort(objectArray, 0, objectArray.length - 1, (Comparator)new StringComparator());
        return objectArray;
    }

    public static CanonicalTester getCanonicalTester(String string) {
        if (string.equals("E") || string.equals("C1")) {
            return new Symmetry().new Test_E();
        }
        if (string.equals("O")) {
            return new Symmetry().new Test_O();
        }
        if (string.equals("Oh")) {
            return new Symmetry().new Test_Oh();
        }
        if (string.equals("I")) {
            return new Symmetry().new Test_I();
        }
        if (string.equals("Ih")) {
            return new Symmetry().new Test_Ih();
        }
        if (string.equals("T") || string.equals("Th") || string.equals("Td")) {
            // empty if block
        }
        System.out.println("using fake canonical tester for symmetry [" + string + "]");
        return new Symmetry().new Test_Fake();
    }

    public static Vector3Dsym[] getOrbit(Vector3D vector3D, String string, int n) {
        Object object;
        Matrix3D[] matrix3DArray = Symmetry.getMatrices(string);
        Vector<Vector3Dsym> vector = new Vector<Vector3Dsym>();
        Hashtable<Object[], Object[]> hashtable = new Hashtable<Object[], Object[]>();
        int n2 = 0;
        while (n2 < matrix3DArray.length) {
            object = vector3D.mul(matrix3DArray[n2]);
            if (hashtable.get(object) == null) {
                hashtable.put((Object[])object, (Object[])object);
                vector.addElement(new Vector3Dsym((Vector3D)object, vector3D, matrix3DArray[n2], n));
            }
            ++n2;
        }
        object = new Vector3Dsym[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    static void main(String[] stringArray) {
        String string = "Oh";
        Matrix3D[] matrix3DArray = Symmetry.getMatrices(string);
        CanonicalTester canonicalTester = Symmetry.getCanonicalTester(string);
        Vector3D vector3D = new Vector3D(1.0, 1.0, 1.0);
        Vector3D[] vector3DArray = new Vector3D[matrix3DArray.length];
        int n = 0;
        while (n < vector3DArray.length) {
            vector3DArray[n] = vector3D.mul(matrix3DArray[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < vector3DArray.length) {
            boolean bl = canonicalTester.test(vector3DArray[n2]);
            if (bl) {
                System.out.println("i: " + n2 + " v: " + vector3DArray[n2]);
            }
            ++n2;
        }
    }

    static {
        axesO = new Axis[]{new Axis(new Vector3D(1.0, 0.0, 0.0), 4), new Axis(new Vector3D(0.0, 1.0, 0.0), 4), new Axis(new Vector3D(0.0, 0.0, 1.0), 4), new Axis(new Vector3D(1.0, 1.0, 1.0), 3), new Axis(new Vector3D(-1.0, 1.0, 1.0), 3), new Axis(new Vector3D(1.0, -1.0, 1.0), 3), new Axis(new Vector3D(-1.0, -1.0, 1.0), 3), new Axis(new Vector3D(1.0, 1.0, 0.0), 2), new Axis(new Vector3D(-1.0, 1.0, 0.0), 2), new Axis(new Vector3D(1.0, 0.0, 1.0), 2), new Axis(new Vector3D(-1.0, 0.0, 1.0), 2), new Axis(new Vector3D(0.0, 1.0, 1.0), 2), new Axis(new Vector3D(0.0, -1.0, 1.0), 2)};
        axesT = new Axis[]{new Axis(new Vector3D(1.0, 0.0, 0.0), 2), new Axis(new Vector3D(0.0, 1.0, 0.0), 2), new Axis(new Vector3D(0.0, 0.0, 1.0), 2), new Axis(new Vector3D(1.0, 1.0, 1.0), 3), new Axis(new Vector3D(-1.0, 1.0, 1.0), 3), new Axis(new Vector3D(1.0, -1.0, 1.0), 3), new Axis(new Vector3D(-1.0, -1.0, 1.0), 3)};
        g = (Math.sqrt(5.0) + 1.0) / 2.0;
        g1 = 1.0 / g;
        gg1 = 1.0 + g1;
        gg = 1.0 + g;
        axesI = new Axis[]{new Axis(new Vector3D(0.0, g, 1.0), 5), new Axis(new Vector3D(0.0, g, -1.0), 5), new Axis(new Vector3D(g, 1.0, 0.0), 5), new Axis(new Vector3D(g, -1.0, 0.0), 5), new Axis(new Vector3D(1.0, 0.0, g), 5), new Axis(new Vector3D(-1.0, 0.0, g), 5), new Axis(new Vector3D(g1, g, 0.0), 3), new Axis(new Vector3D(-g1, g, 0.0), 3), new Axis(new Vector3D(g, 0.0, g1), 3), new Axis(new Vector3D(g, 0.0, -g1), 3), new Axis(new Vector3D(0.0, g1, g), 3), new Axis(new Vector3D(0.0, -g1, g), 3), new Axis(new Vector3D(1.0, 1.0, 1.0), 3), new Axis(new Vector3D(1.0, -1.0, 1.0), 3), new Axis(new Vector3D(-1.0, -1.0, 1.0), 3), new Axis(new Vector3D(-1.0, 1.0, 1.0), 3), new Axis(new Vector3D(1.0, 0.0, 0.0), 2), new Axis(new Vector3D(0.0, 1.0, 0.0), 2), new Axis(new Vector3D(0.0, 0.0, 1.0), 2), new Axis(new Vector3D(1.0, gg1, gg), 2), new Axis(new Vector3D(-1.0, gg1, gg), 2), new Axis(new Vector3D(1.0, -gg1, gg), 2), new Axis(new Vector3D(-1.0, -gg1, gg), 2), new Axis(new Vector3D(gg, 1.0, gg1), 2), new Axis(new Vector3D(gg, -1.0, gg1), 2), new Axis(new Vector3D(gg, 1.0, -gg1), 2), new Axis(new Vector3D(gg, -1.0, -gg1), 2), new Axis(new Vector3D(gg1, gg, 1.0), 2), new Axis(new Vector3D(gg1, gg, -1.0), 2), new Axis(new Vector3D(-gg1, gg, 1.0), 2), new Axis(new Vector3D(-gg1, gg, -1.0), 2)};
        tau = (Math.sqrt(5.0) + 1.0) / 2.0;
        symNames = new String[][]{{"T", "[3, 3]+", "A_4", "Tetrahedral"}, {"Td", "[3, 3]", "S_4", "Diploid tetrahedral"}, {"Th", "[3+, 4]", "A_4 x C_2", "Central tetrahedral"}, {"O", "[3, 4]+", "S_4", "Octahedral"}, {"Oh", "[3, 4]", "S_4 x C_2", "Diploid octahedral"}, {"I", "[3, 5]+", "A_5", "Icosahedral"}, {"Ih", "[3, 5]", "A_5 x C_2", "Diploid icosahedral"}, {"C1", "[ ]+", "C_1", "Identity"}, {"Cs", "[ ]", "D_1", "Bilateral"}, {"S2", "[2+, 2+]", "C_2", "Central"}, {"Cn", "[n]+", "C_n", "n-gonal"}, {"Dn", "[n, 2]+", "D_n", "n-dihedral"}, {"Cnv", "[n]", "D_n", "Diploid n-gonal"}, {"S2n", "[2n+, 2+]", "C_2n", "Skew 2n-gonal"}, {"Cnh", "[n+, 2]", "C_n x D_1", "Diploid n-cyclic"}, {"Dnd", "[2n, 2+]", "D_2n", "Diploid skew 2n-gonal"}, {"Dnh", "[n, 2]", "D_n x D_1", "   Diploid n-dihedral"}};
        allgroups = new String[]{"Oh", "Td", "O", "Th", "T", "D6h", "D3h", "C6v", "D6", "C6h", "C3h", "C6", "D3d", "C3v", "D3", "S6", "C3", "D4h", "D2d", "C4v", "D4", "C4h", "S4", "C4", "D2h", "C2v", "D2", "C2h", "Cs", "C2", "Ci", "E", "Ih", "I", "D4d", "D5d", "D6d", "D7d", "D5h", "D7h", "D5", "D7", "C5", "C7", "C5h", "C7h", "C5v", "C7v"};
        subgroups = new String[][][]{{{"Oh"}, {"Oh", "O", "Th", "Td", "T", "D4h", "D4", "C4v", "C4h", "C4", "S4", "D3d(O)", "D3(O)", "S6(O)", "C3v(O)", "C3(O)", "D2h", "D2d", "D2", "C2v", "C2h", "C2", "D2h(O)", "D2(O)", "C2(O)", "Ci", "Cs", "E"}}, {{"Td"}, {"Td", "T", "C3v(O)", "C3(O)", "D2d", "D2", "C2v", "C2", "Ci", "Cs", "E"}}, {{"O"}, {"O", "T", "D4", "C4", "D3(O)", "C3(O)", "D2", "D2(O)", "C2", "C2(O)", "E"}}, {{"Th"}, {"Th", "T", "S6(O)", "C3(O)", "D2d", "D2", "C2v", "C2h", "C2", "Ci", "Cs", "E"}}, {{"T"}, {"T", "C3(O)", "D2", "C2", "E"}}, {{"D6h"}, {"D6h", "D6", "S6", "C6h", "C6v", "C6", "D3d", "D3h", "D3", "C3v", "C3h", "C3", "D2h", "D2", "C2v", "C2h", "C2", "Ci", "Cs", "E", "C2v(D)", "C2h(D)", "C2(D)", "Cs(D6h)"}}, {{"D3h"}, {"D3h", "D3", "C3v", "C3h", "C3", "C2v(D)", "C2(D)", "Cs", "Cs(D3h)", "E"}}, {{"C6v"}, {"C6v", "C6", "C3v", "C3", "C2v", "C2", "Cs(C6v)", "E"}}, {{"D6"}, {"D6", "C6", "D3", "C3", "D2", "C2", "C2(D)", "E"}}, {{"C6h"}, {"C6h", "C6", "S6", "C3h", "C3", "C2h", "C2", "Ci", "Cs", "E"}}, {{"C3h"}, {"C3h", "C3", "Cs", "E"}}, {{"C6"}, {"C6", "C3", "C2", "E"}}, {{"D3d"}, {"S6", "D3d", "D3", "C3v", "C3", "C2h(D)", "C2(D)", "Ci", "Cs(D3d)", "E"}}, {{"C3v"}, {"C3v", "C3", "Cs(C3v)", "E"}}, {{"D3"}, {"D3", "C3", "C2(D)", "E"}}, {{"S6"}, {"S6", "C3", "Ci", "E"}}, {{"C3"}, {"C3", "E"}}, {{"D4h"}, {"D4h", "D4", "C4v", "C4h", "C4", "S4", "D2h", "D2d", "D2", "C2v", "C2h", "C2", "Ci", "Cs", "E", "C2v(D)", "C2h(D)", "C2(D)", "Cs(D4h)"}}, {{"D2d"}, {"D2d", "S4", "D2", "C2v", "C2", "C2(D)", "Cs(D2d)", "E"}}, {{"C4v"}, {"C4v", "C4", "C2v", "C2", "Cs(C4v)", "E"}}, {{"D4"}, {"D4", "C4", "D2", "C2", "C2(D)", "E"}}, {{"C4h"}, {"C4h", "C4", "S4", "C2h", "C2", "Ci", "Cs", "E"}}, {{"S4"}, {"S4", "C2", "E"}}, {{"C4"}, {"C4", "C2", "E"}}, {{"D2h"}, {"D2h", "D2", "C2v", "C2h", "C2", "Ci", "Cs", "E"}}, {{"C2v"}, {"C2v", "C2", "Cs(C2v)", "E"}}, {{"D2"}, {"D2", "C2", "E"}}, {{"C2h"}, {"C2h", "C2", "Ci", "Cs", "E"}}, {{"Cs"}, {"Cs", "E"}}, {{"C2"}, {"C2", "E"}}, {{"Ci"}, {"Ci", "E"}}, {{"E"}, {"E"}}, {{"Ih"}, {"Ih", "I", "Th", "T", "D5d(I)", "D5(I)", "S10(I)", "C5v(I)", "C5(I)", "D3d(I)", "D3(I)", "S6(I)", "C3v(I)", "C3(I)", "D2h", "D2", "C2v", "C2h", "C2", "Ci", "Cs", "E"}}, {{"I"}, {"I", "T", "D5(I)", "C5(I)", "D3(I)", "C3(I)", "D2", "C2", "E"}}, {{"D4d"}, {"D4d", "S8", "D4", "C4v", "C4", "D2", "C2v", "C2", "C2(D)", "Cs(D4d)", "E"}}, {{"S8"}, {"S8", "C4", "C2", "E"}}, {{"D5d"}, {"D5d", "S10", "D5", "C5v", "C5", "C2h(D)", "C2(D)", "Ci", "Cs(D5d)", "E"}}, {{"S10"}, {"S10", "C5", "Ci", "E"}}, {{"D5h"}, {"D5h", "D5", "C5h", "C5v", "C5", "C2v(D)", "C2(D)", "Cs(D5h)", "Cs", "E"}}, {{"D5"}, {"D5", "C5", "C2(D)", "E"}}, {{"C5h"}, {"C5h", "C5", "Cs", "E"}}, {{"C5v"}, {"C5v", "C5", "Cs(C5v)", "E"}}, {{"D6d"}, {"D6d", "S12", "D6", "C6v", "C6", "D3", "C3v", "C3", "S4", "D2", "C2v", "C2", "C2(D)", "Cs(D6d)", "E"}}, {{"S12"}, {"S12", "C6", "C3", "S4", "C2", "E"}}, {{"D7d"}, {"D7d", "S14", "D7", "C7v", "C7", "C2h(D)", "C2(D)", "Ci", "Cs(D7d)", "E"}}, {{"S14"}, {"S14", "C7", "Ci", "E"}}, {{"D7h"}, {"D7h", "D7", "C7h", "C7v", "C7", "C2v(D)", "C2(D)", "Cs(D7h)", "Cs", "E"}}, {{"D7"}, {"D7", "C7", "C2(D)", "E"}}, {{"C7h"}, {"C7h", "C7", "Cs", "E"}}, {{"C7v"}, {"C7v", "C7", "Cs(C7v)", "E"}}};
        gam = (Math.sqrt(5.0) + 1.0) / 2.0;
        TOL = Vector3D.TOL;
    }

    public class Test_Fake
    implements CanonicalTester {
        boolean firstTest = true;

        public boolean test(Vector3D vector3D) {
            if (this.firstTest) {
                this.firstTest = false;
                return true;
            }
            return false;
        }
    }

    public class Test_E
    implements CanonicalTester {
        public boolean test(Vector3D vector3D) {
            return true;
        }
    }

    public class Test_I
    implements CanonicalTester {
        Vector3D norm1 = new Vector3D(1.0, 0.0, gam).cross(new Vector3D(0.0, 1.0 / gam, gam)).normalize();
        Vector3D norm2 = new Vector3D(0.0, -1.0 / gam, gam).cross(new Vector3D(1.0, 0.0, gam)).normalize();

        public boolean test(Vector3D vector3D) {
            if (vector3D.x < -TOL) {
                return false;
            }
            if (this.norm1.dot(vector3D) < -TOL) {
                return false;
            }
            if (vector3D.y > -TOL) {
                return true;
            }
            if (vector3D.x < TOL) {
                return false;
            }
            return !(this.norm2.dot(vector3D) < TOL);
        }
    }

    public class Test_Ih
    implements CanonicalTester {
        Vector3D norm = new Vector3D(1.0, 0.0, gam).cross(new Vector3D(0.0, 1.0 / gam, gam)).normalize();

        public boolean test(Vector3D vector3D) {
            if (vector3D.x < -TOL) {
                return false;
            }
            if (vector3D.y < -TOL) {
                return false;
            }
            return !(this.norm.dot(vector3D) < -TOL);
        }
    }

    public class Test_O
    implements CanonicalTester {
        Vector3D norm1 = new Vector3D(1.0, -1.0, 0.0).normalize();
        Vector3D norm2 = new Vector3D(-1.0, 0.0, 1.0).normalize();
        Vector3D norm3 = new Vector3D(1.0, 1.0, 0.0).normalize();

        public boolean test(Vector3D vector3D) {
            if (this.norm1.dot(vector3D) < -TOL) {
                return false;
            }
            if (this.norm2.dot(vector3D) < -TOL) {
                return false;
            }
            if (vector3D.y > -TOL) {
                return true;
            }
            if (this.norm3.dot(vector3D) < TOL) {
                return false;
            }
            return !(this.norm2.dot(vector3D) < TOL);
        }
    }

    public class Test_Oh
    implements CanonicalTester {
        Vector3D norm1 = new Vector3D(1.0, -1.0, 0.0).normalize();
        Vector3D norm2 = new Vector3D(-1.0, 0.0, 1.0).normalize();

        public boolean test(Vector3D vector3D) {
            if (vector3D.y < -TOL) {
                return false;
            }
            if (this.norm1.dot(vector3D) < -TOL) {
                return false;
            }
            return !(this.norm2.dot(vector3D) < -TOL);
        }
    }

    public static interface CanonicalTester {
        public boolean test(Vector3D var1);
    }
}

