/*
 * Decompiled with CFR 0.152.
 */
package PVS.polyhedra;

import PVS.Utils.EventCallback;
import PVS.Utils.Graphics2D;
import PVS.Utils.GraphicsPS;
import PVS.Utils.PVSObserver;
import PVS.Utils.Point2;
import PVS.Utils.Timeout;
import PVS.Utils.TimeoutCallback;
import PVS.Utils.ViewRect;
import PVS.Utils.Viewport;
import PVS.Utils.WindowUtils;
import PVS.polyhedra.Axis;
import PVS.polyhedra.PolyShape;
import PVS.polyhedra.SFace;
import PVS.polyhedra.Stellation;
import PVS.polyhedra.Vector3D;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Vector;

public class StellationCanvas
extends Panel
implements Runnable {
    PVSObserver observer;
    int maxlevel = -1;
    Point2[][][] levels = null;
    Graphics2D g2d = new Graphics2D();
    double Width = 0.0;
    Point2[][] fpoly = new Point2[0][0];
    Point2[] centers = new Point2[0];
    Point2[][] symLines;
    Point2[] symAxes;
    int[] symAxesOrder;
    SCanvas canvas;
    Checkbox cbSymAxes;
    Checkbox cbSymLines;
    PopupMenu cellSelectionPopup;
    boolean drawSymmetryLines = false;
    boolean drawSymmetryAxes = false;
    double centerX = 0.0;
    double centerY = 0.0;
    double polyDiameter = 1.0;
    int sbMaximum = 100000;
    int sbVisible = 100000;
    Scrollbar sbVertical = new Scrollbar(1, 0, this.sbVisible, 0, this.sbMaximum);
    Scrollbar sbHorizontal = new Scrollbar(0, 0, this.sbVisible, 0, this.sbMaximum);
    double Angle = 0.0;
    static Color[] stepColors = new Color[100];
    EventCallback eventCallback = null;
    Viewport viewport;
    ViewRect screenRectangle;
    int oldWidth = -1;
    int oldHeight = -1;
    Image backImage = null;
    Graphics backGraphics;
    static Color[] axisColor;
    double[][] current_matrix = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
    static double[][] matrix_ccw0;
    static double[][] matrix_ccw1;
    static double[][] matrix_ccw2;
    static double[][] matrix_cw0;
    static double[][] matrix_cw1;
    static double[][] matrix_cw2;
    static double AngleFast;
    static double AngleNormal;
    static double AngleSlow;
    public static final int SUB_SUPPORTING_CELLS = 0;
    public static final int ADD_SUPPORTING_CELLS = 1;
    public static final int TOGGLE_SUPPORTING_CELLS = 2;
    public static final int TOGGLE_TOP_CELL = 3;
    public static final int TOGGLE_BOTTOM_CELL = 4;
    int oldPolyIndex = -1;
    int menuActionPoly = -1;
    double shiftSpeed = 0.025;
    double zoomSpeed = 1.025;
    Thread thread;
    FileDialog fileDialog;
    String psName = "stellation.ps";
    private static GridBagConstraints gbc;

    public StellationCanvas(SFace[] sFaceArray, SFace[] sFaceArray2, Axis[] axisArray, Vector3D[][] vector3DArray) {
        this.setBackground(Color.white);
        this.setLayout(new GridBagLayout());
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        panel.setBackground(Color.lightGray);
        Button button = new Button("+");
        button.addMouseListener(new ZoomInListener());
        Button button2 = new Button("-");
        button2.addMouseListener(new ZoomOutListener());
        Button button3 = new Button("^");
        button3.addMouseListener(new UpListener());
        Button button4 = new Button("v");
        button4.addMouseListener(new DownListener());
        Button button5 = new Button("<");
        button5.addMouseListener(new LeftListener());
        Button button6 = new Button(">");
        button6.addMouseListener(new RightListener());
        Button button7 = new Button("R");
        button7.addMouseListener(new RotateRightListener());
        Button button8 = new Button("L");
        button8.addMouseListener(new RotateLeftListener());
        this.cbSymLines = new Checkbox("Sym. Lines", this.drawSymmetryLines);
        this.cbSymLines.addItemListener(new SymLinesListener());
        this.cbSymAxes = new Checkbox("Axes", this.drawSymmetryAxes);
        this.cbSymAxes.addItemListener(new SymAxesListener());
        this.sbVertical.addAdjustmentListener(new SBVerticalAdjustmentListener());
        this.sbHorizontal.addAdjustmentListener(new SBHorizontalAdjustmentListener());
        int n = 0;
        WindowUtils.constrain((Container)panel, (Component)this.cbSymLines, n++, 0, 1, 1, 0, 17, 0.0, 0.0);
        WindowUtils.constrain((Container)panel, (Component)this.cbSymAxes, n++, 0, 1, 1, 0, 17, 1.0, 0.0);
        WindowUtils.constrain((Container)panel, (Component)button, n++, 0, 1, 1, 0, 17, 0.0, 0.0);
        WindowUtils.constrain((Container)panel, (Component)button2, n++, 0, 1, 1, 0, 17, 0.0, 0.0);
        WindowUtils.constrain((Container)panel, (Component)button3, n++, 0, 1, 1, 0, 17, 0.0, 0.0);
        WindowUtils.constrain((Container)panel, (Component)button4, n++, 0, 1, 1, 0, 17, 0.0, 0.0);
        WindowUtils.constrain((Container)panel, (Component)button5, n++, 0, 1, 1, 0, 17, 0.0, 0.0);
        WindowUtils.constrain((Container)panel, (Component)button6, n++, 0, 1, 1, 0, 17, 0.0, 0.0);
        WindowUtils.constrain((Container)panel, (Component)button8, n++, 0, 1, 1, 0, 17, 0.0, 0.0);
        WindowUtils.constrain((Container)panel, (Component)button7, n++, 0, 1, 1, 0, 17, 0.0, 0.0);
        this.canvas = new SCanvas();
        WindowUtils.constrain((Container)this, (Component)panel, 0, 0, 2, 1, 2, 17, 1.0, 0.0);
        WindowUtils.constrain((Container)this, (Component)this.canvas, 0, 1, 1, 1, 1, 10, 1.0, 1.0);
        WindowUtils.constrain((Container)this, (Component)this.sbVertical, 1, 1, 1, 1, 3, 10, 0.0, 1.0);
        WindowUtils.constrain((Container)this, (Component)this.sbHorizontal, 0, 2, 1, 1, 2, 10, 1.0, 0.0);
        this.cellSelectionPopup = this.makeCellSelectionPopup();
        this.canvas.add(this.cellSelectionPopup);
        this.setFaces(sFaceArray, sFaceArray2, axisArray, vector3DArray);
        this.canvas.addMouseListener(new CanvasMouseListener());
        this.canvas.addMouseMotionListener(new CanvasMouseMotionListener());
        this.canvas.addKeyListener(new KeyListenerClass());
        this.init();
    }

    public void init() {
        this.findWidth();
        this.buildCenters();
        this.canvas.repaint();
    }

    public void addObserver(PVSObserver pVSObserver) {
        this.observer = pVSObserver;
    }

    static Color getColor(int n) {
        n = n < 0 ? -1 : n;
        return stepColors[n % 100];
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 300);
    }

    public void setFaces(SFace[] sFaceArray) {
        this.maxlevel = -1;
        int n = 0;
        while (n < sFaceArray.length) {
            if (sFaceArray[n].layer > this.maxlevel) {
                this.maxlevel = sFaceArray[n].layer;
            }
            ++n;
        }
        int[] nArray = new int[this.maxlevel + 1];
        int n2 = 0;
        while (n2 < sFaceArray.length) {
            int n3 = sFaceArray[n2].layer;
            nArray[n3] = nArray[n3] + 1;
            ++n2;
        }
        this.levels = new Point2[this.maxlevel + 1][][];
        int n4 = 0;
        while (n4 < nArray.length) {
            this.levels[n4] = new Point2[nArray[n4]][];
            ++n4;
        }
        int[] nArray2 = new int[this.maxlevel + 1];
        int n5 = 0;
        while (n5 < sFaceArray.length) {
            int n6 = sFaceArray[n5].layer;
            Point2[] point2Array = new Point2[sFaceArray[n5].vertices.length];
            this.transform(sFaceArray[n5].vertices, point2Array);
            int n7 = n6;
            int n8 = nArray2[n7];
            nArray2[n7] = n8 + 1;
            this.levels[n6][n8] = point2Array;
            ++n5;
        }
        this.initCurrentMatrix();
        this.rotate(this.current_matrix);
        this.canvas.repaint();
    }

    public void setFaces(SFace[] sFaceArray, SFace[] sFaceArray2, Axis[] axisArray, Vector3D[][] vector3DArray) {
        Point2[] point2Array;
        int n;
        this.maxlevel = -1;
        int n2 = 0;
        while (n2 < sFaceArray.length) {
            if (sFaceArray[n2].layer > this.maxlevel) {
                this.maxlevel = sFaceArray[n2].layer;
            }
            ++n2;
        }
        int[] nArray = new int[this.maxlevel + 1];
        int n3 = 0;
        while (n3 < sFaceArray.length) {
            int n4 = sFaceArray[n3].layer;
            nArray[n4] = nArray[n4] + 1;
            ++n3;
        }
        this.levels = new Point2[this.maxlevel + 1][][];
        int n5 = 0;
        while (n5 < nArray.length) {
            this.levels[n5] = new Point2[nArray[n5]][];
            ++n5;
        }
        int[] nArray2 = new int[this.maxlevel + 1];
        int n6 = 0;
        while (n6 < sFaceArray.length) {
            n = sFaceArray[n6].layer;
            point2Array = new Point2[sFaceArray[n6].vertices.length];
            this.transform(sFaceArray[n6].vertices, point2Array);
            int n7 = n;
            int n8 = nArray2[n7];
            nArray2[n7] = n8 + 1;
            this.levels[n][n8] = point2Array;
            ++n6;
        }
        this.fpoly = new Point2[sFaceArray2.length][];
        n = 0;
        while (n < sFaceArray2.length) {
            point2Array = new Point2[sFaceArray2[n].vertices.length];
            this.transform(sFaceArray2[n].vertices, point2Array);
            this.fpoly[n] = point2Array;
            ++n;
        }
        if (axisArray != null) {
            this.symAxes = new Point2[axisArray.length];
            this.symAxesOrder = new int[axisArray.length];
            int n9 = 0;
            while (n9 < axisArray.length) {
                if (axisArray[n9] != null) {
                    this.symAxes[n9] = new Point2(axisArray[n9].vector.x, axisArray[n9].vector.y);
                    this.symAxesOrder[n9] = axisArray[n9].order;
                }
                ++n9;
            }
        }
        if (vector3DArray != null) {
            this.symLines = new Point2[vector3DArray.length][];
            int n10 = 0;
            while (n10 < vector3DArray.length) {
                if (vector3DArray[n10] != null) {
                    this.symLines[n10] = new Point2[]{new Point2(vector3DArray[n10][0].x, vector3DArray[n10][0].y), new Point2(vector3DArray[n10][1].x, vector3DArray[n10][1].y)};
                }
                ++n10;
            }
        }
        this.initCurrentMatrix();
        this.rotate(this.current_matrix);
        this.buildCenters();
        this.canvas.repaint();
    }

    void initCurrentMatrix() {
        double d = this.Angle;
        this.current_matrix[0][0] = Math.cos(d);
        this.current_matrix[1][1] = Math.cos(d);
        this.current_matrix[0][1] = Math.sin(d);
        this.current_matrix[1][0] = -Math.sin(d);
    }

    void findWidth() {
        double d = 0.0;
        int n = 0;
        while (n < this.fpoly.length) {
            Point2[] point2Array = this.fpoly[n];
            int n2 = 0;
            while (n2 < point2Array.length) {
                Point2 point2 = point2Array[n2];
                double d2 = point2.length2();
                if (d2 > d) {
                    d = d2;
                }
                ++n2;
            }
            ++n;
        }
        this.Width = this.polyDiameter = 2.0 * Math.sqrt(d);
        this.centerX = 0.0;
        this.centerY = 0.0;
    }

    void buildCenters() {
        this.centers = new Point2[this.fpoly.length];
        int n = 0;
        while (n < this.fpoly.length) {
            Point2[] point2Array = this.fpoly[n];
            Point2 point2 = new Point2(0.0, 0.0);
            int n2 = 0;
            while (n2 < point2Array.length) {
                point2.addSet(point2Array[n2]);
                ++n2;
            }
            point2.mulSet(1.0 / (double)point2Array.length);
            this.centers[n] = point2;
            ++n;
        }
    }

    void transform(Vector3D[] vector3DArray, Point2[] point2Array) {
        int n = 0;
        while (n < vector3DArray.length) {
            Vector3D vector3D = vector3DArray[n];
            point2Array[n] = new Point2(vector3D.x, vector3D.y);
            ++n;
        }
    }

    public void paintCanvas(Graphics graphics) {
        Dimension dimension = this.canvas.getSize();
        if (dimension.width == 0) {
            return;
        }
        this.paintCanvas(graphics, dimension.width, dimension.height);
        if (this.eventCallback != null) {
            EventCallback eventCallback = this.eventCallback;
            this.eventCallback = null;
            eventCallback.processEventCallback(null, null);
        }
        this.oldPolyIndex = -1;
    }

    public void paintCanvas(Graphics graphics, int n, int n2) {
        if (n != this.oldWidth || n2 != this.oldHeight || this.backImage == null) {
            this.oldWidth = n;
            this.oldHeight = n2;
            this.backImage = this.createImage(n, n2);
            this.backGraphics = this.backImage.getGraphics();
        }
        this.backGraphics.setColor(Color.white);
        this.backGraphics.fillRect(0, 0, n, n2);
        this.drawContent(this.backGraphics, n, n2);
        graphics.drawImage(this.backImage, 0, 0, this);
        this.adjustScrollbars();
    }

    public void drawContent(Graphics graphics, int n, int n2) {
        this.g2d.setGraphics(graphics);
        this.initViewport(n, n2);
        this.drawContent(this.g2d);
    }

    public Vector getRenderingShapes() {
        int n;
        GeneralPath generalPath;
        Vector<PolyShape> vector = new Vector<PolyShape>();
        int n2 = 0;
        while (n2 < this.levels.length) {
            generalPath = new GeneralPath();
            Point2[][] point2Array = this.levels[n2];
            if (point2Array.length != 0) {
                n = 0;
                while (n < point2Array.length) {
                    generalPath.moveTo((float)point2Array[n][0].x, (float)point2Array[n][0].y);
                    int n3 = 1;
                    while (n3 < point2Array[n].length) {
                        generalPath.lineTo((float)point2Array[n][n3].x, (float)point2Array[n][n3].y);
                        ++n3;
                    }
                    generalPath.lineTo((float)point2Array[n][0].x, (float)point2Array[n][0].y);
                    ++n;
                }
                generalPath.closePath();
                vector.addElement(new PolyShape(generalPath, 0, StellationCanvas.getColor(n2)));
            }
            ++n2;
        }
        generalPath = new GeneralPath();
        int n4 = 0;
        while (n4 < this.fpoly.length) {
            generalPath.moveTo((float)this.fpoly[n4][0].x, (float)this.fpoly[n4][0].y);
            n = 1;
            while (n < this.fpoly[n4].length) {
                generalPath.lineTo((float)this.fpoly[n4][n].x, (float)this.fpoly[n4][n].y);
                ++n;
            }
            generalPath.lineTo((float)this.fpoly[n4][0].x, (float)this.fpoly[n4][0].y);
            ++n4;
        }
        generalPath.closePath();
        vector.addElement(new PolyShape(generalPath, 1, Color.black));
        return vector;
    }

    void initViewport(int n, int n2) {
        int n3 = n > n2 ? n2 : n;
        int n4 = 4;
        double d = this.Width * (double)(n - 2 * n4) / (double)(n3 - 2 * n4);
        double d2 = this.Width * (double)(n2 - 2 * n4) / (double)(n3 - 2 * n4);
        this.g2d.setViewport(new Viewport(this.centerX - d / 2.0, this.centerY + d2 / 2.0, this.centerX + d / 2.0, this.centerY - d2 / 2.0));
        this.g2d.setScreenRectangle(new ViewRect(n4, n4, n - n4, n2 - n4));
    }

    public void drawSelectionPoly(Graphics graphics, int n) {
        this.g2d.setGraphics(graphics);
        this.g2d.fillPolygon(this.fpoly[n]);
    }

    public void drawContent(Graphics2D graphics2D) {
        int n;
        if (this.levels == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.levels.length) {
            graphics2D.setColor(StellationCanvas.getColor(n2));
            Point2[][] point2Array = this.levels[n2];
            n = 0;
            while (n < point2Array.length) {
                graphics2D.fillPolygon(point2Array[n]);
                ++n;
            }
            ++n2;
        }
        if (this.drawSymmetryLines) {
            graphics2D.setColor(Color.gray);
        } else {
            graphics2D.setColor(Color.black);
        }
        int n3 = 0;
        while (n3 < this.fpoly.length) {
            graphics2D.drawPolygon(this.fpoly[n3]);
            ++n3;
        }
        if (this.drawSymmetryLines) {
            graphics2D.setColor(Color.black);
            if (this.symLines != null) {
                n = 0;
                while (n < this.symLines.length) {
                    if (this.symLines[n] != null) {
                        graphics2D.drawLine(this.symLines[n][0].x, this.symLines[n][0].y, this.symLines[n][1].x, this.symLines[n][1].y);
                    }
                    ++n;
                }
            }
        }
        if (this.drawSymmetryAxes && this.symAxes != null) {
            n = 0;
            while (n < this.symAxes.length) {
                if (this.symAxes[n] != null) {
                    this.drawAxis(graphics2D, this.symAxes[n], this.symAxesOrder[n]);
                }
                ++n;
            }
        }
    }

    void drawAxis(Graphics2D graphics2D, Point2 point2, int n) {
        int n2 = (int)(graphics2D.x2screen(point2.x) + 0.5);
        int n3 = (int)(graphics2D.y2screen(point2.y) + 0.5);
        int n4 = 4;
        graphics2D.setColor(axisColor[n]);
        graphics2D.getGraphics().fillOval(n2 - n4, n3 - n4, 2 * n4, 2 * n4 + 1);
    }

    void adjustScrollbars() {
        this.sbVisible = (int)((double)this.sbMaximum * this.Width / this.polyDiameter);
        this.sbVertical.setVisibleAmount(this.sbVisible);
        int n = (int)((double)(this.sbMaximum - this.sbVisible) * 0.5 * (1.0 + 2.0 * this.centerY / this.polyDiameter));
        this.sbVertical.setValue(n);
        int n2 = (int)((double)(this.sbMaximum - this.sbVisible) * (0.01 * this.Width / this.polyDiameter));
        if (n2 < 1) {
            n2 = 1;
        }
        this.sbVertical.setUnitIncrement(n2);
        this.sbHorizontal.setUnitIncrement(n2);
        this.sbVertical.setBlockIncrement(n2 * 50);
        this.sbHorizontal.setBlockIncrement(n2 * 50);
        int n3 = (int)((double)(this.sbMaximum - this.sbVisible) * 0.5 * (1.0 - 2.0 * this.centerX / this.polyDiameter));
        this.sbHorizontal.setVisibleAmount(this.sbVisible);
        this.sbHorizontal.setValue(n3);
    }

    void rotate(double[][] dArray) {
        Object object;
        double d = dArray[0][0];
        double d2 = dArray[0][1];
        double d3 = dArray[1][0];
        double d4 = dArray[1][1];
        int n = 0;
        while (n < this.levels.length) {
            Point2[][] point2Array = this.levels[n];
            int n2 = 0;
            while (n2 < point2Array.length) {
                object = point2Array[n2];
                int n3 = 0;
                while (n3 < ((Point2[])object).length) {
                    Point2 point2 = object[n3];
                    double d5 = d * point2.x + d2 * point2.y;
                    point2.y = d3 * point2.x + d4 * point2.y;
                    point2.x = d5;
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        int n4 = 0;
        while (n4 < this.fpoly.length) {
            Point2[] point2Array = this.fpoly[n4];
            int n5 = 0;
            while (n5 < point2Array.length) {
                Point2 point2 = point2Array[n5];
                double d6 = d * point2.x + d2 * point2.y;
                point2.y = d3 * point2.x + d4 * point2.y;
                point2.x = d6;
                ++n5;
            }
            ++n4;
        }
        int n6 = 0;
        while (n6 < this.symLines.length) {
            if (this.symLines[n6] != null) {
                object = this.symLines[n6][0];
                double d7 = d * object.x + d2 * object.y;
                object.y = d3 * object.x + d4 * object.y;
                object.x = d7;
                object = this.symLines[n6][1];
                d7 = d * object.x + d2 * object.y;
                object.y = d3 * object.x + d4 * object.y;
                object.x = d7;
            }
            ++n6;
        }
        if (this.symAxes != null) {
            int n7 = 0;
            while (n7 < this.symAxes.length) {
                if (this.symAxes[n7] != null) {
                    Point2 point2 = this.symAxes[n7];
                    double d8 = d * point2.x + d2 * point2.y;
                    point2.y = d3 * point2.x + d4 * point2.y;
                    point2.x = d8;
                }
                ++n7;
            }
        }
    }

    void rotate_matrix(double[][] dArray) {
        double d = dArray[0][0];
        double d2 = dArray[0][1];
        double d3 = dArray[1][0];
        double d4 = dArray[1][1];
        double d5 = this.current_matrix[0][0];
        double d6 = this.current_matrix[0][1];
        double d7 = this.current_matrix[1][0];
        double d8 = this.current_matrix[1][1];
        this.current_matrix[0][0] = d * d5 + d2 * d7;
        this.current_matrix[0][1] = d * d6 + d2 * d8;
        this.current_matrix[1][0] = d3 * d5 + d4 * d7;
        this.current_matrix[1][1] = d3 * d6 + d4 * d8;
    }

    PopupMenu makeCellSelectionPopup() {
        PopupMenu popupMenu = new PopupMenu("Select Cell");
        MenuItem menuItem = new MenuItem("toggle bottom cell     (Click)");
        menuItem.addActionListener(new ToggleBottomCellAction());
        popupMenu.add(menuItem);
        menuItem = new MenuItem("toggle top cell          (Alt+Click)");
        menuItem.addActionListener(new ToggleTopCellAction());
        popupMenu.add(menuItem);
        menuItem = new MenuItem("toggle supp. cells    (Ctrl+Click)");
        menuItem.addActionListener(new ToggleSupportingCellsAction());
        popupMenu.add(menuItem);
        menuItem = new MenuItem("add supp. cells        (Shift+Click) ");
        menuItem.addActionListener(new AddSupportingCellsAction());
        popupMenu.add(menuItem);
        menuItem = new MenuItem("subtract supp. cells (Ctrl+Shift+Click) ");
        menuItem.addActionListener(new SubSupportingCellsAction());
        popupMenu.add(menuItem);
        return popupMenu;
    }

    public void zoomIn() {
        this.Width /= this.zoomSpeed;
        this.canvas.repaint();
    }

    public void zoomIn(double d) {
        this.Width /= d;
        this.canvas.repaint();
    }

    public void zoomOut() {
        this.Width *= this.zoomSpeed;
        this.canvas.repaint();
    }

    public void zoomOut(double d) {
        this.Width *= d;
        this.canvas.repaint();
    }

    public void shiftLeft() {
        this.centerX += this.Width * this.shiftSpeed;
        this.canvas.repaint();
    }

    public void shiftRight() {
        this.centerX -= this.Width * this.shiftSpeed;
        this.canvas.repaint();
    }

    public void shiftUp() {
        this.centerY -= this.Width * this.shiftSpeed;
        this.canvas.repaint();
    }

    public void shiftDown() {
        this.centerY += this.Width * this.shiftSpeed;
        this.canvas.repaint();
    }

    int findPoly(Point2 point2) {
        if (this.oldPolyIndex >= 0 && this.oldPolyIndex < this.fpoly.length && StellationCanvas.isInsidePolygon(this.fpoly[this.oldPolyIndex], point2)) {
            return this.oldPolyIndex;
        }
        int n = 0;
        while (n < this.fpoly.length) {
            if (StellationCanvas.isInsidePolygon(this.fpoly[n], point2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Frame getFrame() {
        Container container = this;
        while (container != null) {
            if (!((container = container.getParent()) instanceof Frame)) continue;
            return (Frame)container;
        }
        return null;
    }

    public void run() {
        try {
            Object object;
            OutputStream outputStream = null;
            try {
                if (this.fileDialog == null) {
                    this.fileDialog = new FileDialog(WindowUtils.getFrame(this), this.psName, 1);
                }
                this.fileDialog.show();
                if (this.fileDialog.getFile() == null) {
                    return;
                }
                this.psName = this.fileDialog.getFile();
                object = this.fileDialog.getDirectory();
                String string = (String)object + this.psName;
                File file = new File(string);
                outputStream = new FileOutputStream(file);
                Stellation.Out.println("printing diagram to file " + string);
            }
            catch (Exception exception) {
                outputStream = System.out;
                System.out.println("---------start of PS");
                Stellation.Out.println("printing diagram to java console");
            }
            object = new GraphicsPS(outputStream, this.getGraphics());
            this.paintCanvas((Graphics)object, ((GraphicsPS)object).getWidth(), ((GraphicsPS)object).getHeight());
            ((GraphicsPS)object).flush();
            if (outputStream != System.out) {
                ((OutputStream)outputStream).close();
            } else {
                System.out.println("---------end of PS");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void doPrint() {
        if (this.thread == null || this.thread.isAlive()) {
            // empty if block
        }
        this.thread = new Thread(this);
        this.thread.setPriority(1);
        this.thread.start();
    }

    static double MIN(double d, double d2) {
        return d < d2 ? d : d2;
    }

    static double MAX(double d, double d2) {
        return d > d2 ? d : d2;
    }

    static boolean isInsidePolygon(Point2[] point2Array, Point2 point2) {
        int n = 0;
        Point2 point22 = point2Array[point2Array.length - 1];
        int n2 = 0;
        while (n2 < point2Array.length) {
            Point2 point23 = point2Array[n2];
            if (point2.y > StellationCanvas.MIN(point22.y, point23.y) && point2.y <= StellationCanvas.MAX(point22.y, point23.y) && point2.x <= StellationCanvas.MAX(point22.x, point23.x) && point22.y != point23.y) {
                double d = (point2.y - point22.y) * (point23.x - point22.x) / (point23.y - point22.y) + point22.x;
                if (point22.x == point23.x || point2.x <= d) {
                    ++n;
                }
            }
            point22 = point23;
            ++n2;
        }
        return n % 2 != 0;
    }

    static {
        float f = 0.0f;
        int n = 0;
        while (n < stepColors.length) {
            StellationCanvas.stepColors[n] = Color.getHSBColor(f, 0.5f, 1.0f);
            if ((f += 0.1534f) > 1.0f) {
                f = (float)((double)f - 1.0);
            }
            ++n;
        }
        axisColor = new Color[]{Color.gray, Color.gray, new Color(200, 0, 200), new Color(0, 0, 250), new Color(0, 200, 250), new Color(50, 250, 50)};
        matrix_ccw0 = new double[2][2];
        matrix_ccw1 = new double[2][2];
        matrix_ccw2 = new double[2][2];
        matrix_cw0 = new double[2][2];
        matrix_cw1 = new double[2][2];
        matrix_cw2 = new double[2][2];
        AngleFast = 0.17453292519943295;
        AngleNormal = Math.PI / 180;
        AngleSlow = 0.0017453292519943296;
        double d = AngleNormal;
        StellationCanvas.matrix_ccw1[0][0] = Math.cos(d);
        StellationCanvas.matrix_ccw1[1][1] = Math.cos(d);
        StellationCanvas.matrix_ccw1[0][1] = -Math.sin(d);
        StellationCanvas.matrix_ccw1[1][0] = Math.sin(d);
        StellationCanvas.matrix_cw1[0][0] = Math.cos(d);
        StellationCanvas.matrix_cw1[1][1] = Math.cos(d);
        StellationCanvas.matrix_cw1[0][1] = Math.sin(d);
        StellationCanvas.matrix_cw1[1][0] = -Math.sin(d);
        d = AngleSlow;
        StellationCanvas.matrix_ccw0[0][0] = Math.cos(d);
        StellationCanvas.matrix_ccw0[1][1] = Math.cos(d);
        StellationCanvas.matrix_ccw0[0][1] = -Math.sin(d);
        StellationCanvas.matrix_ccw0[1][0] = Math.sin(d);
        StellationCanvas.matrix_cw0[0][0] = Math.cos(d);
        StellationCanvas.matrix_cw0[1][1] = Math.cos(d);
        StellationCanvas.matrix_cw0[0][1] = Math.sin(d);
        StellationCanvas.matrix_cw0[1][0] = -Math.sin(d);
        d = AngleFast;
        StellationCanvas.matrix_ccw2[0][0] = Math.cos(d);
        StellationCanvas.matrix_ccw2[1][1] = Math.cos(d);
        StellationCanvas.matrix_ccw2[0][1] = -Math.sin(d);
        StellationCanvas.matrix_ccw2[1][0] = Math.sin(d);
        StellationCanvas.matrix_cw2[0][0] = Math.cos(d);
        StellationCanvas.matrix_cw2[1][1] = Math.cos(d);
        StellationCanvas.matrix_cw2[0][1] = Math.sin(d);
        StellationCanvas.matrix_cw2[1][0] = -Math.sin(d);
        gbc = new GridBagConstraints();
    }

    class SBVerticalAdjustmentListener
    implements AdjustmentListener {
        SBVerticalAdjustmentListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            int n = adjustmentEvent.getValue();
            StellationCanvas.this.centerY = 0.5 * StellationCanvas.this.polyDiameter * (2.0 * (double)n / (double)(StellationCanvas.this.sbMaximum - StellationCanvas.this.sbVisible) - 1.0);
            StellationCanvas.this.canvas.repaint();
        }
    }

    class SBHorizontalAdjustmentListener
    implements AdjustmentListener {
        SBHorizontalAdjustmentListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            int n = adjustmentEvent.getValue();
            StellationCanvas.this.centerX = 0.5 * StellationCanvas.this.polyDiameter * (1.0 - 2.0 * (double)n / (double)(StellationCanvas.this.sbMaximum - StellationCanvas.this.sbVisible));
            StellationCanvas.this.canvas.repaint();
        }
    }

    class RotateRightListener
    extends MouseAdapter
    implements EventCallback,
    TimeoutCallback {
        boolean mouseDown = false;
        Timeout timeout;
        int rotationSpeed = 0;

        RotateRightListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseDown = true;
            this.rotationSpeed = mouseEvent.isShiftDown() ? 2 : (mouseEvent.isControlDown() ? 0 : 1);
            this.doRotation();
            this.timeout = new Timeout(300L, this, null);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseDown = false;
            StellationCanvas.this.eventCallback = null;
            this.timeout.stop();
        }

        public void timeoutCallback(Object object) {
            if (this.mouseDown) {
                StellationCanvas.this.eventCallback = this;
                this.doRotation();
            }
        }

        public void processEventCallback(Object object, Object object2) {
            if (this.mouseDown) {
                StellationCanvas.this.eventCallback = this;
                this.doRotation();
            }
        }

        void doRotation() {
            switch (this.rotationSpeed) {
                case 2: {
                    StellationCanvas.this.rotate(matrix_cw2);
                    StellationCanvas.this.Angle += AngleFast;
                    break;
                }
                case 0: {
                    StellationCanvas.this.rotate(matrix_cw0);
                    StellationCanvas.this.Angle += AngleSlow;
                    break;
                }
                case 1: {
                    StellationCanvas.this.rotate(matrix_cw1);
                    StellationCanvas.this.Angle += AngleNormal;
                }
            }
            StellationCanvas.this.canvas.repaint();
        }
    }

    class RotateLeftListener
    extends MouseAdapter
    implements EventCallback,
    TimeoutCallback {
        boolean mouseDown = false;
        Timeout timeout;
        int rotationSpeed = 0;

        RotateLeftListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseDown = true;
            this.rotationSpeed = mouseEvent.isShiftDown() ? 2 : (mouseEvent.isControlDown() ? 0 : 1);
            this.doRotation();
            this.timeout = new Timeout(300L, this, null);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseDown = false;
            StellationCanvas.this.eventCallback = null;
            this.timeout.stop();
        }

        public void timeoutCallback(Object object) {
            if (this.mouseDown) {
                StellationCanvas.this.eventCallback = this;
                this.doRotation();
            }
        }

        public void processEventCallback(Object object, Object object2) {
            if (this.mouseDown) {
                StellationCanvas.this.eventCallback = this;
                this.doRotation();
            }
        }

        void doRotation() {
            switch (this.rotationSpeed) {
                case 2: {
                    StellationCanvas.this.rotate(matrix_ccw2);
                    StellationCanvas.this.Angle -= AngleFast;
                    break;
                }
                case 0: {
                    StellationCanvas.this.rotate(matrix_ccw0);
                    StellationCanvas.this.Angle -= AngleSlow;
                    break;
                }
                case 1: {
                    StellationCanvas.this.rotate(matrix_ccw1);
                    StellationCanvas.this.Angle -= AngleNormal;
                }
            }
            StellationCanvas.this.canvas.repaint();
        }
    }

    class RightListener
    extends MouseAdapter
    implements EventCallback,
    TimeoutCallback {
        boolean mouseDown = false;
        Timeout timeout;

        RightListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseDown = true;
            StellationCanvas.this.shiftRight();
            this.timeout = new Timeout(300L, this, null);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseDown = false;
            StellationCanvas.this.eventCallback = null;
            this.timeout.stop();
        }

        public void timeoutCallback(Object object) {
            if (this.mouseDown) {
                StellationCanvas.this.eventCallback = this;
                StellationCanvas.this.shiftRight();
            }
        }

        public void processEventCallback(Object object, Object object2) {
            if (this.mouseDown) {
                StellationCanvas.this.eventCallback = this;
                StellationCanvas.this.shiftRight();
            }
        }
    }

    class LeftListener
    extends MouseAdapter
    implements EventCallback,
    TimeoutCallback {
        boolean mouseDown = false;
        Timeout timeout;

        LeftListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseDown = true;
            StellationCanvas.this.shiftLeft();
            this.timeout = new Timeout(300L, this, null);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseDown = false;
            StellationCanvas.this.eventCallback = null;
            this.timeout.stop();
        }

        public void timeoutCallback(Object object) {
            if (this.mouseDown) {
                StellationCanvas.this.eventCallback = this;
                StellationCanvas.this.shiftLeft();
            }
        }

        public void processEventCallback(Object object, Object object2) {
            if (this.mouseDown) {
                StellationCanvas.this.eventCallback = this;
                StellationCanvas.this.shiftLeft();
            }
        }
    }

    class DownListener
    extends MouseAdapter
    implements EventCallback,
    TimeoutCallback {
        boolean mouseDown = false;
        Timeout timeout;

        DownListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseDown = true;
            StellationCanvas.this.shiftDown();
            this.timeout = new Timeout(300L, this, null);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseDown = false;
            StellationCanvas.this.eventCallback = null;
            this.timeout.stop();
        }

        public void timeoutCallback(Object object) {
            if (this.mouseDown) {
                StellationCanvas.this.eventCallback = this;
                StellationCanvas.this.shiftDown();
            }
        }

        public void processEventCallback(Object object, Object object2) {
            if (this.mouseDown) {
                StellationCanvas.this.eventCallback = this;
                StellationCanvas.this.shiftDown();
            }
        }
    }

    class UpListener
    extends MouseAdapter
    implements EventCallback,
    TimeoutCallback {
        boolean mouseDown = false;
        Timeout timeout;

        UpListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseDown = true;
            StellationCanvas.this.shiftUp();
            this.timeout = new Timeout(300L, this, null);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseDown = false;
            StellationCanvas.this.eventCallback = null;
            this.timeout.stop();
        }

        public void timeoutCallback(Object object) {
            if (this.mouseDown) {
                StellationCanvas.this.eventCallback = this;
                StellationCanvas.this.shiftUp();
            }
        }

        public void processEventCallback(Object object, Object object2) {
            if (this.mouseDown) {
                StellationCanvas.this.eventCallback = this;
                StellationCanvas.this.shiftUp();
            }
        }
    }

    class ZoomOutListener
    extends MouseAdapter
    implements EventCallback,
    TimeoutCallback {
        boolean mouseDown = false;
        Timeout timeout;

        ZoomOutListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseDown = true;
            StellationCanvas.this.zoomOut();
            this.timeout = new Timeout(300L, this, null);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseDown = false;
            StellationCanvas.this.eventCallback = null;
            this.timeout.stop();
        }

        public void timeoutCallback(Object object) {
            if (this.mouseDown) {
                StellationCanvas.this.eventCallback = this;
                StellationCanvas.this.zoomOut();
            }
        }

        public void processEventCallback(Object object, Object object2) {
            if (this.mouseDown) {
                StellationCanvas.this.eventCallback = this;
                StellationCanvas.this.zoomOut();
            }
        }
    }

    class ZoomInListener
    extends MouseAdapter
    implements EventCallback,
    TimeoutCallback {
        boolean mouseDown = false;
        Timeout timeout;

        ZoomInListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseDown = true;
            StellationCanvas.this.zoomIn();
            this.timeout = new Timeout(300L, this, null);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseDown = false;
            StellationCanvas.this.eventCallback = null;
            this.timeout.stop();
        }

        public void processEventCallback(Object object, Object object2) {
            if (this.mouseDown) {
                StellationCanvas.this.eventCallback = this;
                StellationCanvas.this.zoomIn();
            }
        }

        public void timeoutCallback(Object object) {
            if (this.mouseDown) {
                StellationCanvas.this.eventCallback = this;
                StellationCanvas.this.zoomIn();
            }
        }
    }

    class SymAxesListener
    implements ItemListener {
        SymAxesListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            StellationCanvas.this.drawSymmetryAxes = itemEvent.getStateChange() == 1;
            StellationCanvas.this.canvas.repaint();
        }
    }

    class SymLinesListener
    implements ItemListener {
        SymLinesListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            StellationCanvas.this.drawSymmetryLines = itemEvent.getStateChange() == 1;
            StellationCanvas.this.canvas.repaint();
        }
    }

    class SCanvas
    extends Canvas {
        SCanvas() {
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            StellationCanvas.this.paintCanvas(graphics);
        }

        public Dimension getPreferredSize() {
            return new Dimension(300, 300);
        }
    }

    class KeyListenerClass
    extends KeyAdapter {
        KeyListenerClass() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            switch (keyEvent.getKeyChar()) {
                case 'P': 
                case 'p': {
                    StellationCanvas.this.doPrint();
                }
            }
        }
    }

    class CanvasMouseListener
    extends MouseAdapter {
        CanvasMouseListener() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n;
            if ((mouseEvent.getModifiers() & 4) == 0) {
                return;
            }
            int n2 = mouseEvent.getX();
            Point2 point2 = StellationCanvas.this.g2d.screen2world(n2, n = mouseEvent.getY());
            int n3 = StellationCanvas.this.findPoly(point2);
            if (n3 < 0) {
                return;
            }
            StellationCanvas.this.menuActionPoly = n3;
            StellationCanvas.this.cellSelectionPopup.show(StellationCanvas.this.canvas, n2, n);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point2 point2;
            int n;
            if ((mouseEvent.getModifiers() & 0x10) == 0) {
                return;
            }
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            if (StellationCanvas.this.observer != null && (n = StellationCanvas.this.findPoly(point2 = StellationCanvas.this.g2d.screen2world(n2, n3))) >= 0) {
                int[] nArray = new int[2];
                nArray[0] = n;
                nArray[1] = (mouseEvent.getModifiers() & 2) != 0 ? ((mouseEvent.getModifiers() & 1) != 0 ? 0 : 2) : ((mouseEvent.getModifiers() & 1) != 0 ? 1 : ((mouseEvent.getModifiers() & 8) != 0 ? 3 : 4));
                StellationCanvas.this.observer.update(this, nArray);
            }
        }
    }

    class CanvasMouseMotionListener
    extends MouseMotionAdapter {
        CanvasMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    class ToggleBottomCellAction
    implements ActionListener {
        ToggleBottomCellAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (StellationCanvas.this.menuActionPoly >= 0) {
                int[] nArray = new int[]{StellationCanvas.this.menuActionPoly, 4};
                StellationCanvas.this.observer.update(this, nArray);
            }
        }
    }

    class ToggleTopCellAction
    implements ActionListener {
        ToggleTopCellAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (StellationCanvas.this.menuActionPoly >= 0) {
                int[] nArray = new int[]{StellationCanvas.this.menuActionPoly, 3};
                StellationCanvas.this.observer.update(this, nArray);
            }
        }
    }

    class ToggleSupportingCellsAction
    implements ActionListener {
        ToggleSupportingCellsAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (StellationCanvas.this.menuActionPoly >= 0) {
                int[] nArray = new int[]{StellationCanvas.this.menuActionPoly, 2};
                StellationCanvas.this.observer.update(this, nArray);
            }
        }
    }

    class AddSupportingCellsAction
    implements ActionListener {
        AddSupportingCellsAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (StellationCanvas.this.menuActionPoly >= 0) {
                int[] nArray = new int[]{StellationCanvas.this.menuActionPoly, 1};
                StellationCanvas.this.observer.update(this, nArray);
            }
        }
    }

    class SubSupportingCellsAction
    implements ActionListener {
        SubSupportingCellsAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (StellationCanvas.this.oldPolyIndex >= 0) {
                int[] nArray = new int[]{StellationCanvas.this.oldPolyIndex, 0};
                StellationCanvas.this.observer.update(this, nArray);
            }
        }
    }
}

