/*
 * Decompiled with CFR 0.152.
 */
package PVS.polyhedra;

import PVS.Utils.Comparator;
import PVS.Utils.FastHashtable;
import PVS.Utils.IntegerComparator;
import PVS.Utils.QSort;
import PVS.Utils.WindowOutputStream;
import PVS.polyhedra.Axis;
import PVS.polyhedra.DoubleIndex;
import PVS.polyhedra.FEdge;
import PVS.polyhedra.Matrix3D;
import PVS.polyhedra.Plane;
import PVS.polyhedra.Polyhedron;
import PVS.polyhedra.SCell;
import PVS.polyhedra.SEdge;
import PVS.polyhedra.SFace;
import PVS.polyhedra.SSCell;
import PVS.polyhedra.SVertex;
import PVS.polyhedra.StellationCanvas;
import PVS.polyhedra.Symmetry;
import PVS.polyhedra.Vector3D;
import PVS.polyhedra.Vector3Dsym;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class Stellation {
    public static PrintStream Out = System.out;
    public SFace[][] faces;
    public Plane[] planes;
    private Vector3D[] canonicalVectors;
    private Vector3Dsym[] planeVectors;
    public int maxlayer = 0;
    int negCellCount = 0;
    static double[] fval = new double[1000];
    static final double THRESHOLD = 1.0E-7;
    static double FACTOR = 5000.0;
    static double MAXVERTEX = 2000.0;
    double maxRadius = 0.0;

    public Stellation(Polyhedron polyhedron, int n) {
        this.faces = this.makeStellationFaces(polyhedron, n);
        this.maxlayer = Stellation.findMaxLayer(this.faces);
    }

    public Stellation(Vector3D[] vector3DArray, int n) {
        this.faces = this.makeStellationFaces(vector3DArray, n);
        this.maxlayer = Stellation.findMaxLayer(this.faces);
    }

    public Stellation(Vector3D[] vector3DArray, String string, int n) {
        int n2;
        Object object;
        int n3;
        Object object2;
        int n4;
        Object object3;
        int n5;
        this.canonicalVectors = vector3DArray;
        int n6 = vector3DArray.length;
        int n7 = 0;
        Vector3Dsym[][] vector3DsymArrayArray = new Vector3Dsym[n6][];
        int n8 = 0;
        while (n8 < n6) {
            vector3DsymArrayArray[n8] = Symmetry.getOrbit(vector3DArray[n8], string, n8);
            n7 += vector3DsymArrayArray[n8].length;
            ++n8;
        }
        Vector3Dsym[] vector3DsymArray = new Vector3Dsym[n7];
        this.planeVectors = vector3DsymArray;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n6) {
            vector3DsymArray[n9++] = vector3DsymArrayArray[n10][0];
            ++n10;
        }
        int n11 = 0;
        while (n11 < n6) {
            n5 = 1;
            while (n5 < vector3DsymArrayArray[n11].length) {
                vector3DsymArray[n9++] = vector3DsymArrayArray[n11][n5];
                ++n5;
            }
            ++n11;
        }
        Out.print("found ");
        if (n6 > 1) {
            n5 = 0;
            while (n5 < n6) {
                Out.print(vector3DsymArrayArray[n5].length);
                if (n5 < n6 - 1) {
                    Out.print("+");
                }
                ++n5;
            }
            Out.print(" = ");
        }
        Out.println(vector3DsymArray.length + " different vectors");
        this.planes = new Plane[vector3DsymArray.length];
        n5 = 0;
        while (n5 < vector3DsymArray.length) {
            object3 = new Vector3D(vector3DsymArray[n5].x, vector3DsymArray[n5].y, vector3DsymArray[n5].z);
            double d = ((Vector3D)object3).length();
            ((Vector3D)object3).normalize();
            this.planes[n5] = new Plane((Vector3D)object3, d, n5);
            ++n5;
        }
        Out.println("intersections... ");
        object3 = new FastHashtable();
        int n12 = 0;
        int n13 = 0;
        double d = 0.0;
        int n14 = 0;
        while (n14 < vector3DArray.length) {
            int n15 = n14 + 1;
            while (n15 < this.planes.length) {
                n4 = n15 + 1;
                while (n4 < this.planes.length) {
                    object2 = Plane.intersect(this.planes[n14], this.planes[n15], this.planes[n4]);
                    if (object2 == null) {
                        ++n12;
                    } else {
                        double d2 = ((Vector3D)object2).length();
                        if (d2 > 100000.0) {
                            ++n12;
                        } else {
                            ++n13;
                            if (((FastHashtable)object3).get(object2) == null) {
                                ((FastHashtable)object3).put(object2, object2);
                            }
                            if (d2 > d) {
                                d = d2;
                            }
                        }
                    }
                    ++n4;
                }
                ++n15;
            }
            ++n14;
        }
        Out.println("done: " + n13 + " no intersection: " + n12);
        Out.println("unique vertices: " + ((FastHashtable)object3).size());
        Out.println("max radius: " + d);
        Out.println("planes: " + this.planes.length);
        this.planes = this.planes;
        DoubleIndex[] doubleIndexArray = new DoubleIndex[this.planes.length];
        n4 = 0;
        while (n4 < doubleIndexArray.length) {
            doubleIndexArray[n4] = new DoubleIndex(0.0, n4);
            ++n4;
        }
        object2 = new FastHashtable();
        this.faces = new SFace[this.planes.length][];
        int n16 = 0;
        while (n16 < n6) {
            Out.print(n16);
            Out.flush();
            Stellation.sortPlanes(doubleIndexArray, this.planes, this.planes[n16]);
            Vector<SFace> vector = new Vector<SFace>();
            vector.addElement(Stellation.makeSeedFace(this.planes[n16], n16));
            n3 = 0;
            while (n3 < this.planes.length) {
                if (doubleIndexArray[n3].index != n16) {
                    Stellation.intersectFacesWithPlane(vector, this.planes[doubleIndexArray[n3].index], (FastHashtable)object2, n16, n);
                }
                ++n3;
            }
            this.faces[n16] = Stellation.cleanFaces(vector);
            Out.print("(" + this.faces[n16].length + ") ");
            ++n16;
        }
        object2 = new FastHashtable();
        int n17 = 0;
        while (n17 < n6) {
            n3 = 0;
            while (n3 < this.faces[n17].length) {
                object = this.faces[n17][n3];
                n2 = 0;
                while (n2 < ((SFace)object).vertices.length) {
                    ((FastHashtable)object2).put(((SFace)object).vertices[n2], ((SFace)object).vertices[n2]);
                    ++n2;
                }
                ++n3;
            }
            ++n17;
        }
        Out.println();
        Out.println("vertices: ");
        n3 = n6;
        while (n3 < vector3DsymArray.length) {
            object = vector3DsymArray[n3];
            n2 = ((Vector3Dsym)object).index;
            this.faces[n3] = this.transformFace(this.faces[n2], ((Vector3Dsym)object).matrix, (FastHashtable)object2, this.planes[n3]);
            Out.print(" " + ((FastHashtable)object2).size());
            Out.flush();
            if ((n3 + 1) % 10 == 0) {
                Out.println();
            }
            ++n3;
        }
        Out.println("\ndone");
        d = 0.0;
        object = ((FastHashtable)object2).elements();
        while (object.hasMoreElements()) {
            Vector3D vector3D = (Vector3D)object.nextElement();
            double d3 = vector3D.length();
            if (!(d3 > d)) continue;
            d = d3;
        }
        Out.println("vertices: " + ((FastHashtable)object2).size());
        Out.println("facets: " + this.faces[0].length * this.faces.length);
        Out.println("max radius: " + d);
        this.maxlayer = Stellation.findMaxLayer(this.faces);
    }

    SFace[] transformFace(SFace[] sFaceArray, Matrix3D matrix3D, FastHashtable fastHashtable, Plane plane) {
        SFace[] sFaceArray2 = new SFace[sFaceArray.length];
        Vector<Object> vector = new Vector<Object>();
        double d = matrix3D.getDeterminant();
        int n = 0;
        while (n < sFaceArray.length) {
            Object object;
            SFace sFace = sFaceArray[n];
            int n2 = sFace.vertices.length;
            int n3 = 0;
            while (n3 < n2) {
                object = sFace.vertices[n3].mul(matrix3D);
                Vector3D vector3D = (Vector3D)fastHashtable.get(object);
                if (vector3D == null) {
                    fastHashtable.put(object, object);
                    vector.addElement(object);
                } else {
                    vector.addElement(vector3D);
                }
                ++n3;
            }
            object = new Vector3D[vector.size()];
            vector.copyInto((Object[])object);
            if (d < 0.0) {
                int n4 = 0;
                while (n4 < ((Object[])object).length / 2) {
                    Object object2 = object[n4];
                    object[n4] = object[((Object[])object).length - 1 - n4];
                    object[((Object[])object).length - 1 - n4] = object2;
                    ++n4;
                }
            }
            sFaceArray2[n] = new SFace((Vector3D[])object, plane, sFace.layer);
            vector.removeAllElements();
            ++n;
        }
        return sFaceArray2;
    }

    public Polyhedron getPolyhedron(Vector vector, int[][] nArray) {
        SSCell[] sSCellArray = this.getStellation(vector, nArray);
        return this.getPolyhedron(sSCellArray);
    }

    public SFace[][] getFaces() {
        return this.faces;
    }

    public Polyhedron getPolyhedron(int n) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.faces.length) {
            int n6 = 0;
            while (n6 < this.faces[n5].length) {
                if (this.faces[n5][n6].layer == n) {
                    ++n4;
                }
                ++n6;
            }
            ++n5;
        }
        Polyhedron polyhedron = new Polyhedron();
        polyhedron.ifaces = new int[n4][];
        n4 = 0;
        Vector vector = new Vector();
        FastHashtable fastHashtable = new FastHashtable();
        int n7 = 0;
        while (n7 < this.faces.length) {
            n3 = 0;
            while (n3 < this.faces[n7].length) {
                if (this.faces[n7][n3].layer == n) {
                    int[] nArray = new int[this.faces[n7][n3].vertices.length];
                    int n8 = 0;
                    while (n8 < nArray.length) {
                        nArray[n8] = this.findIndex(fastHashtable, vector, this.faces[n7][n3].vertices[n8]);
                        ++n8;
                    }
                    n2 = 0;
                    int n9 = 0;
                    while (n9 < nArray.length) {
                        if (nArray[(n9 + 1) % nArray.length] != nArray[n9]) {
                            ++n2;
                        }
                        ++n9;
                    }
                    if (n2 == 0) {
                        polyhedron.ifaces[n4] = null;
                    } else if (n2 != nArray.length) {
                        int[] nArray2 = new int[n2];
                        n2 = 0;
                        int n10 = 0;
                        while (n10 < nArray.length) {
                            if (nArray[(n10 + 1) % nArray.length] != nArray[n10]) {
                                nArray2[n2++] = nArray[n10];
                            }
                            ++n10;
                        }
                        polyhedron.ifaces[n4] = nArray2;
                    } else {
                        polyhedron.ifaces[n4] = nArray;
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n7;
        }
        n3 = 0;
        int n11 = 0;
        while (n11 < polyhedron.ifaces.length) {
            if (polyhedron.ifaces[n11] != null) {
                ++n3;
            }
            ++n11;
        }
        if (n3 != polyhedron.ifaces.length) {
            int[][] nArrayArray = new int[n3][];
            n3 = 0;
            n2 = 0;
            while (n2 < polyhedron.ifaces.length) {
                if (polyhedron.ifaces[n2] != null) {
                    nArrayArray[n3++] = polyhedron.ifaces[n2];
                }
                ++n2;
            }
            polyhedron.ifaces = nArrayArray;
        }
        polyhedron.vertices = new Vector3D[vector.size()];
        vector.copyInto(polyhedron.vertices);
        return polyhedron;
    }

    public Polyhedron getPolyhedron(SSCell sSCell) {
        Object object;
        int n = 0;
        int n2 = 0;
        while (n2 < sSCell.cells.length) {
            object = sSCell.cells[n2];
            n += ((SCell)object).top.length;
            n += ((SCell)object).bottom.length;
            ++n2;
        }
        object = new Polyhedron();
        ((Polyhedron)object).ifaces = new int[n][];
        ((Polyhedron)object).icolor = new int[n];
        n = 0;
        FastHashtable fastHashtable = new FastHashtable();
        Vector<Vector3D> vector = new Vector<Vector3D>();
        int n3 = 0;
        while (n3 < sSCell.cells.length) {
            Object object2;
            SCell sCell = sSCell.cells[n3];
            int n4 = 0;
            while (n4 < sCell.top.length) {
                SFace sFace = sCell.top[n4];
                object2 = new int[sFace.vertices.length];
                int n5 = 0;
                while (n5 < sFace.vertices.length) {
                    Integer n6 = (Integer)fastHashtable.get(sFace.vertices[n5]);
                    if (n6 == null) {
                        n6 = new Integer(vector.size());
                        fastHashtable.put(n6, sFace.vertices[n5]);
                        vector.addElement(sFace.vertices[n5]);
                    }
                    object2[n5] = n6;
                    ++n5;
                }
                ((Polyhedron)object).ifaces[n] = object2;
                ((Polyhedron)object).icolor[n] = 1;
                ++n;
                ++n4;
            }
            int n7 = 0;
            while (n7 < sCell.bottom.length) {
                object2 = sCell.bottom[n7];
                int[] nArray = new int[object2.vertices.length];
                int n8 = 0;
                while (n8 < object2.vertices.length) {
                    Integer n9 = (Integer)fastHashtable.get(object2.vertices[n8]);
                    if (n9 == null) {
                        n9 = new Integer(vector.size());
                        fastHashtable.put(n9, object2.vertices[n8]);
                        vector.addElement(object2.vertices[n8]);
                    }
                    nArray[nArray.length - 1 - n8] = n9;
                    ++n8;
                }
                ((Polyhedron)object).ifaces[n] = nArray;
                ((Polyhedron)object).icolor[n] = 0;
                ++n;
                ++n7;
            }
            ++n3;
        }
        ((Polyhedron)object).colors = Stellation.makeTopBottomColors();
        ((Polyhedron)object).vertices = new Vector3D[vector.size()];
        vector.copyInto(((Polyhedron)object).vertices);
        return object;
    }

    FastHashtable getAllFacets(SSCell[] sSCellArray) {
        FastHashtable fastHashtable = new FastHashtable();
        Integer n = new Integer(1);
        Integer n2 = new Integer(-1);
        int n3 = 0;
        while (n3 < sSCellArray.length) {
            SSCell sSCell = sSCellArray[n3];
            int n4 = 0;
            while (n4 < sSCell.cells.length) {
                Object object;
                SCell sCell = sSCell.cells[n4];
                int n5 = 0;
                while (n5 < sCell.top.length) {
                    SFace sFace = sCell.top[n5];
                    object = (Integer)fastHashtable.get(sFace);
                    if (object == null) {
                        fastHashtable.put(sFace, n);
                    } else if (object == n2) {
                        fastHashtable.remove(sFace);
                    } else {
                        Out.println("duplicate face in stellation!");
                    }
                    ++n5;
                }
                int n6 = 0;
                while (n6 < sCell.bottom.length) {
                    object = sCell.bottom[n6];
                    Integer n7 = (Integer)fastHashtable.get(object);
                    if (n7 == null) {
                        fastHashtable.put(object, n2);
                    } else if (n7 == n) {
                        fastHashtable.remove(object);
                    } else {
                        Out.println("duplicate face in stellation!");
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n3;
        }
        return fastHashtable;
    }

    public Polyhedron getPolyhedron_new(SSCell[] sSCellArray) {
        Object object;
        Object object2;
        Polyhedron polyhedron = new Polyhedron();
        FastHashtable fastHashtable = this.getAllFacets(sSCellArray);
        FastHashtable[] fastHashtableArray = new FastHashtable[this.planes.length];
        FastHashtable[] fastHashtableArray2 = new FastHashtable[this.planes.length];
        int n = 0;
        while (n < fastHashtableArray.length) {
            fastHashtableArray[n] = new FastHashtable();
            fastHashtableArray2[n] = new FastHashtable();
            ++n;
        }
        Enumeration enumeration = fastHashtable.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (SFace)enumeration.nextElement();
            object = (Integer)fastHashtable.get(object2);
            if ((Integer)object > 0) {
                fastHashtableArray[((SFace)object2).getPlaneIndex()].put(object2, object2);
                continue;
            }
            fastHashtableArray2[((SFace)object2).getPlaneIndex()].put(object2, object2);
        }
        object2 = new Vector[fastHashtableArray.length];
        object = new Vector[fastHashtableArray.length];
        int n2 = 0;
        while (n2 < fastHashtableArray.length) {
            Out.print("plane: " + n2);
            Out.print(" top: " + fastHashtableArray[n2].size());
            Out.println("  bottom: " + fastHashtableArray2[n2].size());
            object2[n2] = this.findFacetsClusters(fastHashtableArray[n2]);
            object[n2] = this.findFacetsClusters(fastHashtableArray2[n2]);
            ++n2;
        }
        return polyhedron;
    }

    Vector findFacetsClusters(FastHashtable fastHashtable) {
        Object object;
        Vector<Vector> vector = new Vector<Vector>();
        FastHashtable fastHashtable2 = new FastHashtable();
        Enumeration enumeration = fastHashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (SFace)enumeration.nextElement();
        }
        while (fastHashtable.size() > 0) {
            object = fastHashtable.keys();
            if (!object.hasMoreElements()) break;
            SFace sFace = (SFace)object.nextElement();
            vector.addElement(this.buildCluster(sFace, fastHashtable, fastHashtable2, new Vector()));
        }
        return vector;
    }

    Vector buildCluster(SFace sFace, FastHashtable fastHashtable, FastHashtable fastHashtable2, Vector vector) {
        return vector;
    }

    public Polyhedron getPolyhedron(SSCell[] sSCellArray) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        Object object5;
        Object object6;
        FastHashtable fastHashtable = new FastHashtable();
        Integer n2 = new Integer(1);
        Integer n3 = new Integer(-1);
        Polyhedron polyhedron = new Polyhedron();
        int n4 = 0;
        while (n4 < sSCellArray.length) {
            object6 = sSCellArray[n4];
            int n5 = 0;
            while (n5 < ((SSCell)object6).cells.length) {
                object5 = ((SSCell)object6).cells[n5];
                n = 0;
                while (n < ((SCell)object5).top.length) {
                    SFace sFace = ((SCell)object5).top[n];
                    object4 = (Integer)fastHashtable.get(sFace);
                    if (object4 == null) {
                        fastHashtable.put(sFace, n2);
                    } else if (object4 == n3) {
                        fastHashtable.remove(sFace);
                    } else {
                        Out.println("duplicate face in stellation!");
                    }
                    ++n;
                }
                int n6 = 0;
                while (n6 < ((SCell)object5).bottom.length) {
                    object4 = ((SCell)object5).bottom[n6];
                    object3 = (Integer)fastHashtable.get(object4);
                    if (object3 == null) {
                        fastHashtable.put(object4, n3);
                    } else if (object3 == n2) {
                        fastHashtable.remove(object4);
                    } else {
                        Out.println("duplicate face in stellation!");
                    }
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        polyhedron.ifaces = new int[fastHashtable.size()][];
        polyhedron.icolor = new int[fastHashtable.size()];
        object6 = new Vector();
        FastHashtable fastHashtable2 = new FastHashtable();
        object5 = new FastHashtable();
        n = 0;
        Enumeration enumeration = fastHashtable.keys();
        while (enumeration.hasMoreElements()) {
            object4 = (SFace)enumeration.nextElement();
            object3 = new int[((SFace)object4).vertices.length];
            object2 = (Integer)fastHashtable.get(object4);
            int n7 = 0;
            while (n7 < ((SFace)object4).vertices.length) {
                object = (Integer)fastHashtable2.get(((SFace)object4).vertices[n7]);
                if (object == null) {
                    object = new Integer(((Vector)object6).size());
                    fastHashtable2.put(((SFace)object4).vertices[n7], object);
                    ((Vector)object6).addElement(((SFace)object4).vertices[n7]);
                }
                if (object2 == n2) {
                    object3[n7] = (Integer)object;
                } else {
                    object3[((Object)object3).length - 1 - n7] = (Integer)object;
                }
                ++n7;
            }
            object = (Integer)fastHashtable2.get(((SFace)object4).vertices[((SFace)object4).vertices.length - 1]);
            int n8 = 0;
            while (n8 < ((SFace)object4).vertices.length) {
                Integer n9 = (Integer)fastHashtable2.get(((SFace)object4).vertices[n8]);
                FEdge fEdge = new FEdge((Integer)object, n9, ((SFace)object4).getPlaneIndex() * (Integer)object2);
                if (((FastHashtable)object5).get(fEdge) != null) {
                    ((FastHashtable)object5).remove(fEdge);
                } else {
                    ((FastHashtable)object5).put(fEdge, fEdge);
                }
                object = n9;
                ++n8;
            }
            polyhedron.icolor[n] = object2 == n2 ? 1 : 0;
            polyhedron.ifaces[n] = (int[])object3;
            ++n;
        }
        polyhedron.colors = Stellation.makeTopBottomColors();
        polyhedron.vertices = new Vector3D[((Vector)object6).size()];
        ((Vector)object6).copyInto(polyhedron.vertices);
        object4 = new FastHashtable();
        object3 = ((FastHashtable)object5).keys();
        while (object3.hasMoreElements()) {
            object2 = (FEdge)object3.nextElement();
            SEdge sEdge = new SEdge(((FEdge)object2).v1, ((FEdge)object2).v2);
            ((FastHashtable)object4).put(sEdge, sEdge);
        }
        polyhedron.edges = new int[((FastHashtable)object4).size()][2];
        int n10 = 0;
        Enumeration enumeration2 = ((FastHashtable)object4).keys();
        while (enumeration2.hasMoreElements()) {
            object = (SEdge)enumeration2.nextElement();
            polyhedron.edges[n10][0] = ((SEdge)object).v1;
            polyhedron.edges[n10][1] = ((SEdge)object).v2;
            ++n10;
        }
        return polyhedron;
    }

    void joinEdgesToFaces(FastHashtable fastHashtable) {
        Object object;
        int n = this.faces.length;
        Vector[] vectorArray = new Vector[n * 2];
        int n2 = 0;
        while (n2 < vectorArray.length) {
            vectorArray[n2] = new Vector();
            ++n2;
        }
        Enumeration enumeration = fastHashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (FEdge)enumeration.nextElement();
            if (object.index < 0) {
                vectorArray[-object.index + n].addElement(object);
                continue;
            }
            vectorArray[object.index].addElement(object);
        }
        object = new Vector[vectorArray.length];
        int n3 = 0;
        while (n3 < vectorArray.length) {
            object[n3] = this.makeChains(vectorArray[n3]);
            ++n3;
        }
        int n4 = 0;
        while (n4 < ((Vector[])object).length) {
            Out.print("face index: " + n4 + ":");
            int n5 = 0;
            while (n5 < object[n4].size()) {
                Out.print("[");
                Vector vector = (Vector)object[n4].elementAt(n5);
                FEdge fEdge = null;
                int n6 = 0;
                while (n6 < vector.size()) {
                    fEdge = (FEdge)vector.elementAt(n6);
                    Out.print(fEdge.v1 + " ");
                    ++n6;
                }
                if (fEdge != null) {
                    Out.print(fEdge.v2);
                }
                Out.print("]");
                ++n5;
            }
            Out.println();
            ++n4;
        }
    }

    Vector makeChains(Vector vector) {
        Object object;
        Vector<Vector> vector2 = new Vector<Vector>();
        FastHashtable fastHashtable = new FastHashtable();
        Vector<Object> vector3 = new Vector<Object>();
        int n = 0;
        while (n < vector.size()) {
            FEdge fEdge = (FEdge)vector.elementAt(n);
            object = fastHashtable.get(new Integer(fEdge.v1));
            if (object != null) {
                vector3.addElement(object);
            } else {
                fastHashtable.put(new Integer(fEdge.v1), fEdge);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector3.size()) {
            vector2.addElement(this.makeChainFromSeed((FEdge)vector3.elementAt(n2), fastHashtable));
            ++n2;
        }
        while ((object = fastHashtable.keys()).hasMoreElements()) {
            Integer n3 = (Integer)object.nextElement();
            FEdge fEdge = (FEdge)fastHashtable.get(n3);
            fastHashtable.remove(n3);
            vector2.addElement(this.makeChainFromSeed(fEdge, fastHashtable));
        }
        return vector2;
    }

    Vector makeChainFromSeed(FEdge fEdge, FastHashtable fastHashtable) {
        Integer n;
        FEdge fEdge2;
        Vector<FEdge> vector = new Vector<FEdge>();
        vector.addElement(fEdge);
        FEdge fEdge3 = fEdge;
        while ((fEdge2 = (FEdge)fastHashtable.get(n = new Integer(fEdge3.v2))) != null) {
            vector.addElement(fEdge2);
            fastHashtable.remove(n);
            if (fEdge2.v2 == fEdge.v1) break;
            fEdge3 = fEdge2;
        }
        return vector;
    }

    public static Vector3D intersect(Plane plane, Vector3D vector3D) {
        double d = plane.v.dot(vector3D);
        if (Math.abs(d) < 1.0E-10) {
            return null;
        }
        return vector3D.mul(plane.d / d);
    }

    public static Vector3D[] intersect(Plane plane, Plane plane2, double d) {
        double d2 = 0.001;
        Vector3D vector3D = plane.v.cross(plane2.v);
        Vector3D vector3D2 = vector3D.cross(plane.v);
        double d3 = vector3D2.dot(plane2.v);
        if (Math.abs(d3) < d2) {
            return null;
        }
        double d4 = (plane2.d - plane.d * plane2.v.dot(plane.v)) / d3;
        Vector3D vector3D3 = vector3D2.mul(d4).add(plane.v.mul(plane.d));
        double d5 = d * d + 1.0 - vector3D3.dot(vector3D3);
        if (d5 <= 0.0) {
            return null;
        }
        Vector3D[] vector3DArray = new Vector3D[2];
        double d6 = Math.sqrt(d5 / vector3D.dot(vector3D));
        vector3DArray[0] = vector3D3.add(vector3D.mul(d6));
        vector3DArray[1] = vector3D3.add(vector3D.mul(-d6));
        return vector3DArray;
    }

    static Color[] makeTopBottomColors() {
        Color[] colorArray = new Color[2];
        colorArray[1] = new Color(216, 216, 25);
        colorArray[0] = new Color(242, 102, 51);
        return colorArray;
    }

    int findIndex(FastHashtable fastHashtable, Vector vector, Vector3D vector3D) {
        Integer n = (Integer)fastHashtable.get(vector3D);
        int n2 = 0;
        if (n == null) {
            Integer n3 = new Integer(vector.size());
            fastHashtable.put(vector3D, n3);
            vector.addElement(vector3D);
            n2 = n3;
        } else {
            n2 = n;
        }
        return n2;
    }

    static int findIndex(Vector vector, Vector3D vector3D) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (vector3D.equals((Vector3D)vector.elementAt(n2))) {
                return n2;
            }
            ++n2;
        }
        vector.addElement(vector3D);
        return n;
    }

    public static Plane getPlane(Polyhedron polyhedron, int n) {
        int[] nArray = polyhedron.ifaces[n];
        Vector3D vector3D = polyhedron.vertices[nArray[0]];
        Vector3D vector3D2 = polyhedron.vertices[nArray[1]];
        Vector3D vector3D3 = polyhedron.vertices[nArray[2]];
        Vector3D vector3D4 = vector3D3.sub(vector3D2).cross(vector3D.sub(vector3D2));
        vector3D4.normalize();
        double d = vector3D4.dot(vector3D2);
        return new Plane(vector3D4, d, n);
    }

    public SFace[][] makeStellationFaces(Vector3D[] vector3DArray, int n) {
        Plane[] planeArray = new Plane[vector3DArray.length];
        int n2 = 0;
        while (n2 < vector3DArray.length) {
            Vector3D vector3D = new Vector3D(vector3DArray[n2]);
            double d = vector3D.length();
            vector3D.normalize();
            planeArray[n2] = new Plane(vector3D, d, n2);
            ++n2;
        }
        return this.makeStellationFaces(planeArray, n);
    }

    public SFace[][] makeStellationFaces(Plane[] planeArray, int n) {
        int n2;
        Out.println("planes: " + planeArray.length);
        this.planes = planeArray;
        DoubleIndex[] doubleIndexArray = new DoubleIndex[planeArray.length];
        int n3 = 0;
        while (n3 < doubleIndexArray.length) {
            doubleIndexArray[n3] = new DoubleIndex(0.0, n3);
            ++n3;
        }
        FastHashtable fastHashtable = new FastHashtable();
        SFace[][] sFaceArray = new SFace[planeArray.length][];
        int n4 = 0;
        while (n4 < planeArray.length) {
            Out.print(n4);
            Out.flush();
            Stellation.sortPlanes(doubleIndexArray, planeArray, planeArray[n4]);
            Vector<SFace> vector = new Vector<SFace>();
            vector.addElement(Stellation.makeSeedFace(planeArray[n4], n4));
            n2 = 0;
            while (n2 < planeArray.length) {
                if (doubleIndexArray[n2].index != n4) {
                    Stellation.intersectFacesWithPlane(vector, planeArray[doubleIndexArray[n2].index], fastHashtable, n4, n);
                }
                ++n2;
            }
            sFaceArray[n4] = Stellation.cleanFaces(vector);
            Out.print("(" + sFaceArray[n4].length + ") ");
            if ((n4 + 1) % 10 == 0) {
                Out.println("");
            }
            ++n4;
        }
        fastHashtable = new FastHashtable();
        int n5 = 0;
        while (n5 < sFaceArray.length) {
            n2 = 0;
            while (n2 < sFaceArray[n5].length) {
                SFace sFace = sFaceArray[n5][n2];
                int n6 = 0;
                while (n6 < sFace.vertices.length) {
                    fastHashtable.put(sFace.vertices[n6], sFace.vertices[n6]);
                    ++n6;
                }
                ++n2;
            }
            ++n5;
        }
        Out.println("vertices found: " + fastHashtable.size());
        return sFaceArray;
    }

    SFace[][] makeStellationFaces(Polyhedron polyhedron, int n) {
        Plane[] planeArray = new Plane[polyhedron.ifaces.length];
        int n2 = 0;
        while (n2 < polyhedron.ifaces.length) {
            planeArray[n2] = Stellation.getPlane(polyhedron, n2);
            ++n2;
        }
        return this.makeStellationFaces(planeArray, n);
    }

    static void sortPlanes(DoubleIndex[] doubleIndexArray, Plane[] planeArray, Plane plane) {
        int n = 0;
        while (n < doubleIndexArray.length) {
            doubleIndexArray[n].value = -plane.v.dot(planeArray[doubleIndexArray[n].index].v);
            ++n;
        }
        QSort.quickSort(doubleIndexArray, 0, doubleIndexArray.length - 1, (Comparator)doubleIndexArray[0]);
    }

    static void intersectFacesWithPlane(Vector vector, Plane plane, FastHashtable fastHashtable, int n, int n2) {
        double d = plane.d;
        int n3 = vector.size();
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            int n6 = 0;
            int n7 = 0;
            SFace sFace = (SFace)vector.elementAt(n4);
            int n8 = 0;
            while (n8 < sFace.vertices.length) {
                if (sFace.vertices[n8] == null) {
                    Out.println("\nnull pointer!!!!!!");
                    n5 = 0;
                    while (n5 < sFace.vertices.length) {
                        Out.print(sFace.vertices[n5]);
                        ++n5;
                    }
                } else {
                    Stellation.fval[n8] = sFace.vertices[n8].dot(plane.v) - d;
                    if (fval[n8] < 1.0E-7) {
                        ++n7;
                    } else {
                        ++n6;
                    }
                }
                ++n8;
            }
            if (n7 == 0) {
                ++sFace.layer;
            } else if (n6 != 0) {
                n5 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = sFace.vertices.length;
                while (fval[n9] < 1.0E-7) {
                    ++n9;
                    n9 %= n12;
                }
                n10 = (n9 + 1) % n12;
                while (fval[n10] >= 1.0E-7) {
                    n9 = n10++;
                    n10 %= n12;
                }
                n5 = n10;
                n11 = (n5 + 1) % n12;
                while (fval[n11] < 1.0E-7) {
                    n5 = n11++;
                    n11 %= n12;
                }
                int n13 = n10;
                Vector3D[] vector3DArray = new Vector3D[n7 + 2];
                Vector3D[] vector3DArray2 = new Vector3D[n6 + 2];
                int n14 = 0;
                while (fval[n13] < 1.0E-7) {
                    vector3DArray[n14++] = sFace.vertices[n13];
                    ++n13;
                    n13 %= n12;
                }
                Vector3D vector3D = Stellation.findVertex(fastHashtable, Stellation.interpolate(sFace.vertices[n5], sFace.vertices[n11], fval[n5], fval[n11]));
                Vector3D vector3D2 = Stellation.findVertex(fastHashtable, Stellation.interpolate(sFace.vertices[n9], sFace.vertices[n10], fval[n9], fval[n10]));
                vector3DArray[n14++] = vector3D;
                vector3DArray[n14++] = vector3D2;
                n14 = 0;
                vector3DArray2[n14++] = vector3D2;
                vector3DArray2[n14++] = vector3D;
                int n15 = n11;
                while (fval[n15] >= 1.0E-7) {
                    vector3DArray2[n14++] = sFace.vertices[n15];
                    ++n15;
                    n15 %= n12;
                }
                SFace sFace2 = new SFace(vector3DArray2, sFace.getPlane());
                sFace2.layer = sFace.layer + 1;
                sFace.vertices = vector3DArray;
                if (n2 < 0 || sFace2.layer < n2) {
                    vector.addElement(sFace2);
                }
            }
            ++n4;
        }
    }

    static Vector3D findVertex(FastHashtable fastHashtable, Vector3D vector3D) {
        Vector3D vector3D2 = (Vector3D)fastHashtable.get(vector3D);
        if (vector3D2 != null) {
            return vector3D2;
        }
        fastHashtable.put(vector3D, vector3D);
        return vector3D;
    }

    static Vector3D interpolate(Vector3D vector3D, Vector3D vector3D2, double d, double d2) {
        double d3 = d2 - d;
        if (d3 == 0.0) {
            Out.println("t1 == t2");
            return new Vector3D(vector3D);
        }
        return new Vector3D(vector3D.x * (d2 /= d3) - vector3D2.x * (d /= d3), vector3D.y * d2 - vector3D2.y * d, vector3D.z * d2 - vector3D2.z * d);
    }

    static SFace makeSeedFace(Polyhedron polyhedron, int n, Plane plane) {
        Vector3D vector3D = new Vector3D(0.0, 0.0, 0.0);
        int[] nArray = polyhedron.ifaces[n];
        int n2 = 0;
        while (n2 < nArray.length) {
            vector3D.addSet(polyhedron.vertices[nArray[n2]]);
            ++n2;
        }
        vector3D.mulSet(1.0 / (double)nArray.length);
        Vector3D[] vector3DArray = new Vector3D[nArray.length];
        int n3 = 0;
        while (n3 < nArray.length) {
            vector3DArray[n3] = new Vector3D();
            vector3DArray[n3].set(polyhedron.vertices[nArray[n3]]).subSet(vector3D).mulSet(FACTOR).addSet(vector3D);
            ++n3;
        }
        return new SFace(vector3DArray, plane);
    }

    static SFace makeSeedFace(Plane plane, int n) {
        int n2 = 4;
        Vector3D[] vector3DArray = new Vector3D[n2];
        Vector3D vector3D = new Vector3D(plane.v);
        vector3D.normalize();
        Vector3D vector3D2 = new Vector3D(1.0, 0.0, 0.0);
        Vector3D vector3D3 = vector3D2.cross(vector3D);
        if (vector3D3.length2() < 1.0E-4) {
            vector3D2 = new Vector3D(0.0, 1.0, 0.0);
            vector3D3 = vector3D2.cross(vector3D);
        }
        vector3D3.normalize();
        Vector3D vector3D4 = vector3D.cross(vector3D3);
        Vector3D vector3D5 = plane.v.mul(plane.d);
        int n3 = 0;
        while (n3 < n2) {
            Vector3D vector3D6 = vector3D3.mul(FACTOR * Math.cos(Math.PI * 2 * (double)n3 / (double)n2));
            Vector3D vector3D7 = vector3D4.mul(FACTOR * Math.sin(Math.PI * 2 * (double)n3 / (double)n2));
            vector3DArray[n3] = vector3D5.add(vector3D6.add(vector3D7));
            ++n3;
        }
        return new SFace(vector3DArray, plane);
    }

    static SFace[] cleanFaces(Vector vector) {
        Object object;
        int[] nArray = new int[vector.size()];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            object = (SFace)vector.elementAt(n2);
            if (Stellation.getLongestVertex(((SFace)object).vertices) < MAXVERTEX) {
                ((SFace)object).cleanVertices();
                if (((SFace)object).vertices.length > 2) {
                    nArray[n2] = 1;
                    ++n;
                }
            }
            ++n2;
        }
        object = new SFace[n];
        n = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] != 0) {
                object[n] = (SFace)vector.elementAt(n3);
                ++n;
            }
            ++n3;
        }
        return object;
    }

    static double getLongestVertex(Vector3D[] vector3DArray) {
        double d = 0.0;
        int n = 0;
        while (n < vector3DArray.length) {
            double d2 = vector3DArray[n].length();
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    static int findMaxLayer(SFace[] sFaceArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < sFaceArray.length) {
            SFace sFace = sFaceArray[n2];
            if (sFace.layer > n) {
                n = sFace.layer;
            }
            ++n2;
        }
        return n;
    }

    static int findMaxLayer(SFace[][] sFaceArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < sFaceArray.length) {
            int n3 = Stellation.findMaxLayer(sFaceArray[n2]);
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    static void intersectCells(Vector vector, Plane plane) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            SCell sCell = Stellation.intersectCell((SCell)vector.elementAt(n2), plane);
            if (sCell != null) {
                vector.addElement(sCell);
            }
            ++n2;
        }
    }

    static SCell intersectCell(SCell sCell, Plane plane) {
        SFace sFace;
        Vector vector = new Vector();
        Vector<SFace> vector2 = new Vector<SFace>();
        Vector<SFace> vector3 = new Vector<SFace>();
        int n = 0;
        while (n < sCell.top.length) {
            sFace = Stellation.intersectFace(sCell.top[n], plane, vector);
            if (sFace != null) {
                vector2.addElement(sFace);
            }
            ++n;
        }
        if (vector.size() > 0) {
            sFace = new SFace(Stellation.arrangeEdges(vector), plane);
            vector3.addElement(sFace);
            Vector3D[] vector3DArray = new Vector3D[sFace.vertices.length];
            int n2 = 0;
            while (n2 < sFace.vertices.length) {
                vector3DArray[vector3DArray.length - 1 - n2] = sFace.vertices[n2];
                ++n2;
            }
            vector2.addElement(new SFace(vector3DArray, plane));
        }
        return null;
    }

    static SFace intersectFace(SFace sFace, Plane plane, Vector vector) {
        return null;
    }

    static Vector3D[] arrangeEdges(Vector vector) {
        return null;
    }

    static int countVertices(SFace[][] sFaceArray) {
        FastHashtable fastHashtable = new FastHashtable();
        int n = 0;
        while (n < sFaceArray.length) {
            int n2 = 0;
            while (n2 < sFaceArray[n].length) {
                Vector3D[] vector3DArray = sFaceArray[n][n2].vertices;
                int n3 = 0;
                while (n3 < vector3DArray.length) {
                    fastHashtable.put(vector3DArray[n3], vector3DArray[n3]);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return fastHashtable.size();
    }

    static SFace[][][] makeLayers(SFace[][] sFaceArray) {
        int n = Stellation.findMaxLayer(sFaceArray) + 1;
        SFace[][][] sFaceArray2 = new SFace[n][][];
        int n2 = 0;
        while (n2 < n) {
            sFaceArray2[n2] = new SFace[sFaceArray.length][];
            ++n2;
        }
        int n3 = 0;
        while (n3 < sFaceArray.length) {
            SFace[] sFaceArray3 = sFaceArray[n3];
            int[] nArray = new int[n];
            int n4 = 0;
            while (n4 < sFaceArray3.length) {
                int n5 = sFaceArray3[n4].layer;
                nArray[n5] = nArray[n5] + 1;
                ++n4;
            }
            int n6 = 0;
            while (n6 < n) {
                sFaceArray2[n6][n3] = new SFace[nArray[n6]];
                nArray[n6] = 0;
                ++n6;
            }
            int n7 = 0;
            while (n7 < sFaceArray3.length) {
                sFaceArray2[sFaceArray3[n7].layer][n3][nArray[sFaceArray3[n7].layer]] = sFaceArray3[n7];
                int n8 = sFaceArray3[n7].layer;
                nArray[n8] = nArray[n8] + 1;
                ++n7;
            }
            ++n3;
        }
        return sFaceArray2;
    }

    static FastHashtable makeFaceTable(SFace[][] sFaceArray) {
        FastHashtable fastHashtable = new FastHashtable();
        int n = 0;
        while (n < sFaceArray.length) {
            SFace[] sFaceArray2 = sFaceArray[n];
            int n2 = 0;
            while (n2 < sFaceArray2.length) {
                fastHashtable.put(sFaceArray2[n2], sFaceArray2[n2]);
                ++n2;
            }
            ++n;
        }
        return fastHashtable;
    }

    static FastHashtable makeFaceTableCanon(SFace[][] sFaceArray, int n) {
        FastHashtable fastHashtable = new FastHashtable();
        int n2 = 0;
        while (n2 < n) {
            SFace[] sFaceArray2 = sFaceArray[n2];
            int n3 = 0;
            while (n3 < sFaceArray2.length) {
                fastHashtable.put(sFaceArray2[n3], sFaceArray2[n3]);
                ++n3;
            }
            ++n2;
        }
        return fastHashtable;
    }

    static FastHashtable makeVertexTable(SFace[][] sFaceArray) {
        FastHashtable fastHashtable = new FastHashtable();
        int n = 0;
        while (n < sFaceArray.length) {
            SFace[] sFaceArray2 = sFaceArray[n];
            int n2 = 0;
            while (n2 < sFaceArray2.length) {
                SFace sFace = sFaceArray2[n2];
                Vector3D[] vector3DArray = sFace.vertices;
                int n3 = 0;
                while (n3 < vector3DArray.length) {
                    SVertex sVertex = (SVertex)fastHashtable.get(vector3DArray[n3]);
                    if (sVertex == null) {
                        sVertex = new SVertex(vector3DArray[n3]);
                        fastHashtable.put(vector3DArray[n3], sVertex);
                    }
                    sVertex.addFace(sFace);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return fastHashtable;
    }

    Vector makeCellsFromFaceCells(Vector vector, Matrix3D[] matrix3DArray, FastHashtable fastHashtable, FastHashtable fastHashtable2) {
        Object object;
        Object object2;
        FastHashtable fastHashtable3 = new FastHashtable(vector.size() * this.planes.length);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (SCell)enumeration.nextElement();
            fastHashtable3.put(((SCell)object2).getCenter(), object2);
        }
        object2 = vector.elements();
        while (object2.hasMoreElements()) {
            object = (SCell)object2.nextElement();
            int n = 1;
            while (n < matrix3DArray.length) {
                Vector3D vector3D = ((SCell)object).getCenter();
                Vector3D vector3D2 = vector3D.mul(matrix3DArray[n]);
                if (fastHashtable3.get(vector3D2) == null) {
                    SCell sCell = ((SCell)object).getTransformedCopy(matrix3DArray[n], fastHashtable, fastHashtable2);
                    fastHashtable3.put(sCell.getCenter(), sCell);
                }
                ++n;
            }
        }
        object = new Vector(fastHashtable3.size());
        Enumeration enumeration2 = fastHashtable3.elements();
        while (enumeration2.hasMoreElements()) {
            ((Vector)object).addElement(enumeration2.nextElement());
        }
        return object;
    }

    public Vector makeCells2(String string, String string2, int n) {
        Object object;
        int n2;
        int n3;
        SFace[][][] sFaceArray = Stellation.makeLayers(this.faces);
        FastHashtable[] fastHashtableArray = new FastHashtable[sFaceArray.length];
        int n4 = 0;
        while (n4 < fastHashtableArray.length) {
            fastHashtableArray[n4] = new FastHashtable();
            n3 = 0;
            while (n3 < sFaceArray[n4].length) {
                n2 = 0;
                while (n2 < sFaceArray[n4][n3].length) {
                    object = sFaceArray[n4][n3][n2];
                    fastHashtableArray[n4].put(((SFace)object).getCenter(), object);
                    ++n2;
                }
                ++n3;
            }
            ++n4;
        }
        n3 = 0;
        n2 = 0;
        object = new Vector();
        int n5 = sFaceArray.length;
        Out.println("\nLayers: " + sFaceArray.length);
        if (n < sFaceArray.length) {
            n5 = n;
            Out.println("layer limit: " + n);
        }
        Matrix3D[] matrix3DArray = Symmetry.getMatrices(string);
        int n6 = 0;
        while (n6 < n5) {
            Vector vector;
            Vector vector2;
            if (n6 == 0) {
                vector2 = this.makeCellsFromLayers2(new SFace[0][0], sFaceArray[0], 0);
                vector = this.makeCellsFromFaceCells(vector2, matrix3DArray, new FastHashtable(), fastHashtableArray[0]);
            } else {
                vector2 = this.makeCellsFromLayers2(sFaceArray[n6 - 1], sFaceArray[n6], n6);
                vector = this.makeCellsFromFaceCells(vector2, matrix3DArray, fastHashtableArray[n6 - 1], fastHashtableArray[n6]);
            }
            n3 += vector2.size();
            Out.print("layer: " + n6 + " cells: " + vector2.size());
            Vector vector3 = Stellation.makeSymmetricalCells(vector, string, string2);
            ((Vector)object).addElement(vector3);
            Out.print(" scell: " + vector3.size() + ": ( ");
            n2 += vector3.size();
            double d = 0.0;
            int n7 = 0;
            while (n7 < vector3.size()) {
                SSCell sSCell = (SSCell)vector3.elementAt(n7);
                Out.print(sSCell.cells.length + ".");
                Out.print(sSCell.getNFacets() + ".");
                Out.print(sSCell.getNVertices() + " ");
                d += sSCell.getVolume();
                ++n7;
            }
            Out.println(") Vol: " + d);
            ++n6;
        }
        Out.println(n3 + " cells " + this.negCellCount + " neg cells");
        Out.println(n2 + " scells");
        return object;
    }

    public Vector makeCells(String string, String string2, int n) {
        Vector vector;
        SFace[][][] sFaceArray = Stellation.makeLayers(this.faces);
        int n2 = 0;
        int n3 = 0;
        Vector<Vector> vector2 = new Vector<Vector>();
        int n4 = sFaceArray.length;
        Out.println("\nLayers: " + sFaceArray.length);
        if (n < sFaceArray.length) {
            n4 = n;
            Out.println("layer limit: " + n);
        }
        int n5 = 0;
        while (n5 < n4) {
            Vector vector3 = n5 == 0 ? this.makeCellsFromLayers(new SFace[0][0], sFaceArray[n5], n5) : this.makeCellsFromLayers(sFaceArray[n5 - 1], sFaceArray[n5], n5);
            n2 += vector3.size();
            Out.print("layer: " + n5 + " cells: " + vector3.size());
            vector = Stellation.makeSymmetricalCells(vector3, string, string2);
            vector2.addElement(vector);
            Out.print(" scell: " + vector.size() + ": ( ");
            n3 += vector.size();
            double d = 0.0;
            int n6 = 0;
            while (n6 < vector.size()) {
                SSCell sSCell = (SSCell)vector.elementAt(n6);
                Out.print(sSCell.cells.length + ".");
                Out.print(sSCell.getNFacets() + ".");
                Out.print(sSCell.getNVertices() + " ");
                d += sSCell.getVolume();
                ++n6;
            }
            Out.println(") Vol: " + d);
            ++n5;
        }
        Out.println(n2 + " cells " + this.negCellCount + " neg cells");
        Out.println(n3 + " scells");
        int n7 = 0;
        while (n7 < vector2.size()) {
            vector = (Vector)vector2.elementAt(n7);
            int n8 = 0;
            while (n8 < vector.size() - 1) {
                SSCell sSCell;
                SSCell sSCell2 = (SSCell)vector.elementAt(n8);
                if (sSCell2.strictCompare(sSCell2, sSCell = (SSCell)vector.elementAt(n8 + 1)) == 0) {
                    Out.println("#" + n7 + "(" + n8 + "):" + n7 + "(" + (n8 + 1) + ")" + sSCell2.getInfo() + sSCell.getInfo());
                }
                ++n8;
            }
            ++n7;
        }
        Stellation.makeConnectivityGraph(vector2);
        return vector2;
    }

    Vector makeCellsFromLayers2(SFace[][] sFaceArray, SFace[][] sFaceArray2, int n) {
        FastHashtable fastHashtable = Stellation.makeFaceTableCanon(sFaceArray2, this.canonicalVectors.length);
        FastHashtable fastHashtable2 = Stellation.makeFaceTable(sFaceArray2);
        FastHashtable fastHashtable3 = Stellation.makeFaceTable(sFaceArray);
        FastHashtable fastHashtable4 = Stellation.makeVertexTable(sFaceArray2);
        FastHashtable fastHashtable5 = Stellation.makeVertexTable(sFaceArray);
        Vector<SCell> vector = new Vector<SCell>();
        while (fastHashtable.size() > 0) {
            Object object;
            Object object2;
            SFace sFace;
            Object object3;
            SFace sFace2 = (SFace)fastHashtable.elements().nextElement();
            fastHashtable.remove(sFace2);
            fastHashtable2.remove(sFace2);
            FastHashtable fastHashtable6 = new FastHashtable();
            FastHashtable fastHashtable7 = new FastHashtable();
            FastHashtable fastHashtable8 = new FastHashtable();
            int n2 = 0;
            while (n2 < sFace2.vertices.length) {
                object3 = sFace2.vertices[n2];
                fastHashtable6.put(object3, object3);
                Stellation.findAdjacentFaces(fastHashtable2, (Vector3D)object3, fastHashtable7, fastHashtable4);
                Stellation.findAdjacentFaces(fastHashtable3, (Vector3D)object3, fastHashtable8, fastHashtable5);
                ++n2;
            }
            object3 = new Vector<SFace>();
            ((Vector)object3).addElement(sFace2);
            while ((sFace = Stellation.findAdjacentFace(fastHashtable7, (Vector)object3, 1)) != null) {
                ((Vector)object3).addElement(sFace);
                fastHashtable2.remove(sFace);
                fastHashtable.remove(sFace);
                fastHashtable7.remove(sFace);
                int n3 = 0;
                while (n3 < sFace.vertices.length) {
                    object2 = sFace.vertices[n3];
                    if (fastHashtable6.get(object2) == null) {
                        Stellation.findAdjacentFaces(fastHashtable2, (Vector3D)object2, fastHashtable7, fastHashtable4);
                        Stellation.findAdjacentFaces(fastHashtable3, (Vector3D)object2, fastHashtable8, fastHashtable5);
                        fastHashtable6.put(object2, object2);
                    }
                    ++n3;
                }
            }
            Vector<SFace> vector2 = new Vector<SFace>();
            while ((sFace = Stellation.findAdjacentFace(fastHashtable8, (Vector)object3, -1)) != null) {
                vector2.addElement(sFace);
                fastHashtable3.remove(sFace);
                fastHashtable8.remove(sFace);
                int n4 = 0;
                while (n4 < sFace.vertices.length) {
                    object = sFace.vertices[n4];
                    if (fastHashtable6.get(object) == null) {
                        Stellation.findAdjacentFaces(fastHashtable3, (Vector3D)object, fastHashtable8, fastHashtable5);
                        fastHashtable6.put(object, object);
                    }
                    ++n4;
                }
            }
            object2 = new SFace[((Vector)object3).size()];
            ((Vector)object3).copyInto((Object[])object2);
            object = new SFace[vector2.size()];
            vector2.copyInto((Object[])object);
            SCell sCell = new SCell((SFace[])object2, (SFace[])object, n);
            if (sCell.getVolume() > 0.0) {
                vector.addElement(sCell);
                continue;
            }
            ++this.negCellCount;
        }
        return vector;
    }

    Vector makeCellsFromLayers(SFace[][] sFaceArray, SFace[][] sFaceArray2, int n) {
        FastHashtable fastHashtable = Stellation.makeFaceTable(sFaceArray2);
        FastHashtable fastHashtable2 = Stellation.makeFaceTable(sFaceArray);
        FastHashtable fastHashtable3 = Stellation.makeVertexTable(sFaceArray2);
        FastHashtable fastHashtable4 = Stellation.makeVertexTable(sFaceArray);
        Vector<SCell> vector = new Vector<SCell>();
        while (fastHashtable.size() > 0) {
            Object object;
            Object object2;
            SFace sFace;
            Object object3;
            SFace sFace2 = (SFace)fastHashtable.elements().nextElement();
            fastHashtable.remove(sFace2);
            FastHashtable fastHashtable5 = new FastHashtable();
            FastHashtable fastHashtable6 = new FastHashtable();
            FastHashtable fastHashtable7 = new FastHashtable();
            int n2 = 0;
            while (n2 < sFace2.vertices.length) {
                object3 = sFace2.vertices[n2];
                fastHashtable5.put(object3, object3);
                Stellation.findAdjacentFaces(fastHashtable, (Vector3D)object3, fastHashtable6, fastHashtable3);
                Stellation.findAdjacentFaces(fastHashtable2, (Vector3D)object3, fastHashtable7, fastHashtable4);
                ++n2;
            }
            object3 = new Vector<SFace>();
            ((Vector)object3).addElement(sFace2);
            while ((sFace = Stellation.findAdjacentFace(fastHashtable6, (Vector)object3, 1)) != null) {
                ((Vector)object3).addElement(sFace);
                fastHashtable.remove(sFace);
                fastHashtable6.remove(sFace);
                int n3 = 0;
                while (n3 < sFace.vertices.length) {
                    object2 = sFace.vertices[n3];
                    if (fastHashtable5.get(object2) == null) {
                        Stellation.findAdjacentFaces(fastHashtable, (Vector3D)object2, fastHashtable6, fastHashtable3);
                        Stellation.findAdjacentFaces(fastHashtable2, (Vector3D)object2, fastHashtable7, fastHashtable4);
                        fastHashtable5.put(object2, object2);
                    }
                    ++n3;
                }
            }
            Vector<SFace> vector2 = new Vector<SFace>();
            while ((sFace = Stellation.findAdjacentFace(fastHashtable7, (Vector)object3, -1)) != null) {
                vector2.addElement(sFace);
                fastHashtable2.remove(sFace);
                fastHashtable7.remove(sFace);
                int n4 = 0;
                while (n4 < sFace.vertices.length) {
                    object = sFace.vertices[n4];
                    if (fastHashtable5.get(object) == null) {
                        Stellation.findAdjacentFaces(fastHashtable2, (Vector3D)object, fastHashtable7, fastHashtable4);
                        fastHashtable5.put(object, object);
                    }
                    ++n4;
                }
            }
            object2 = new SFace[((Vector)object3).size()];
            ((Vector)object3).copyInto((Object[])object2);
            object = new SFace[vector2.size()];
            vector2.copyInto((Object[])object);
            SCell sCell = new SCell((SFace[])object2, (SFace[])object, n);
            if (sCell.getVolume() > 0.0) {
                vector.addElement(sCell);
                continue;
            }
            ++this.negCellCount;
        }
        return vector;
    }

    static void findAdjacentFaces(FastHashtable fastHashtable, Vector3D vector3D, FastHashtable fastHashtable2, FastHashtable fastHashtable3) {
        SVertex sVertex = (SVertex)fastHashtable3.get(vector3D);
        if (sVertex == null) {
            return;
        }
        Vector vector = sVertex.faces;
        int n = 0;
        while (n < vector.size()) {
            SFace sFace = (SFace)vector.elementAt(n);
            if (fastHashtable.get(sFace) != null) {
                fastHashtable2.put(sFace, sFace);
            }
            ++n;
        }
    }

    static SFace findAdjacentFace(FastHashtable fastHashtable, Vector vector, int n) {
        int n2 = 0;
        while (n2 < vector.size()) {
            SFace sFace = (SFace)vector.elementAt(n2);
            Plane plane = sFace.getPlane();
            Vector3D vector3D = plane.v;
            double d = plane.d;
            Enumeration enumeration = fastHashtable.elements();
            while (enumeration.hasMoreElements()) {
                SFace sFace2 = (SFace)enumeration.nextElement();
                if (!(vector3D.dot(sFace2.getCenter()) - d < 0.0) || !sFace2.adjacent(sFace, n)) continue;
                return sFace2;
            }
            ++n2;
        }
        return null;
    }

    public static Vector makeSymmetricalSubCells(SSCell sSCell, String string) {
        Vector<Object> vector = new Vector<Object>();
        SCell[] sCellArray = sSCell.cells;
        FastHashtable fastHashtable = new FastHashtable();
        int n = 0;
        while (n < sCellArray.length) {
            fastHashtable.put(sCellArray[n].getCenter(), sCellArray[n]);
            ++n;
        }
        Matrix3D[] matrix3DArray = Symmetry.getMatrices(string);
        while (fastHashtable.size() > 0) {
            Object object;
            Vector<SCell> vector2 = new Vector<SCell>();
            SCell sCell = (SCell)fastHashtable.elements().nextElement();
            vector2.addElement(sCell);
            fastHashtable.remove(sCell.getCenter());
            Vector3D vector3D = sCell.getCenter();
            int n2 = 0;
            while (n2 < matrix3DArray.length) {
                object = vector3D.mul(matrix3DArray[n2]);
                SCell sCell2 = (SCell)fastHashtable.get(object);
                if (sCell2 != null) {
                    fastHashtable.remove(object);
                    vector2.addElement(sCell2);
                }
                ++n2;
            }
            object = new SSCell(vector2, string);
            ((SSCell)object).setSuperCell(sSCell);
            vector.addElement(object);
        }
        if (vector.size() > 0) {
            QSort.quickSort(vector, 0, vector.size() - 1, (Comparator)((SSCell)vector.elementAt(0)));
        }
        return vector;
    }

    static Vector makeSymmetricalCells(Vector vector, String string, String string2) {
        Object object;
        Vector<Object> vector2 = new Vector<Object>();
        FastHashtable fastHashtable = new FastHashtable();
        int n = 0;
        while (n < vector.size()) {
            object = (SCell)vector.elementAt(n);
            fastHashtable.put(((SCell)object).getCenter(), object);
            ++n;
        }
        object = Symmetry.getMatrices(string);
        while (fastHashtable.size() > 0) {
            Object object2;
            Vector<SCell> vector3 = new Vector<SCell>();
            SCell sCell = (SCell)fastHashtable.elements().nextElement();
            vector3.addElement(sCell);
            fastHashtable.remove(sCell.getCenter());
            Vector3D vector3D = sCell.getCenter();
            int n2 = 0;
            while (n2 < ((Object)object).length) {
                object2 = vector3D.mul((Matrix3D)object[n2]);
                SCell sCell2 = (SCell)fastHashtable.get(object2);
                if (sCell2 != null) {
                    fastHashtable.remove(object2);
                    vector3.addElement(sCell2);
                }
                ++n2;
            }
            object2 = new SSCell(vector3, string);
            ((SSCell)object2).makeCanonicalOrder();
            vector2.addElement(object2);
            ((SSCell)object2).setSubCells(Stellation.makeSymmetricalSubCells((SSCell)object2, string2));
        }
        if (vector2.size() > 0) {
            QSort.quickSort(vector2, 0, vector2.size() - 1, (Comparator)((SSCell)vector2.elementAt(0)));
        }
        return vector2;
    }

    public static void makeConnectivityGraph(Vector vector) {
        Object object;
        Out.print("Making Connectivity Graph ...");
        Out.flush();
        int n = 0;
        while (n < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n);
            int n2 = 0;
            while (n2 < vector2.size()) {
                object = (SSCell)vector2.elementAt(n2);
                ((SSCell)object).setIndex(n, n2);
                ((SSCell)object).top.removeAllElements();
                ((SSCell)object).bottom.removeAllElements();
                ((SSCell)object).initTopAndBottom();
                ++n2;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < vector.size() - 1) {
            Vector vector3 = (Vector)vector.elementAt(n3);
            object = (Vector)vector.elementAt(n3 + 1);
            int n4 = 0;
            while (n4 < vector3.size()) {
                SSCell sSCell = (SSCell)vector3.elementAt(n4);
                int n5 = 0;
                while (n5 < ((Vector)object).size()) {
                    SSCell sSCell2 = (SSCell)((Vector)object).elementAt(n5);
                    if (sSCell.isTopAdjacent(sSCell2)) {
                        sSCell2.bottom.addElement(sSCell);
                        sSCell.top.addElement(sSCell2);
                    }
                    ++n5;
                }
                ++n4;
            }
            ++n3;
        }
        Out.println("done");
        Out.flush();
    }

    static Vector getFullSupportedStellations(Vector vector) {
        Vector vector2 = new Vector();
        FastHashtable fastHashtable = new FastHashtable();
        int n = 0;
        while (n < vector.size()) {
            Vector vector3 = (Vector)vector.elementAt(n);
            int n2 = 0;
            while (n2 < vector3.size()) {
                SSCell sSCell = (SSCell)vector3.elementAt(n2);
                fastHashtable.put(sSCell, sSCell);
                ++n2;
            }
            ++n;
        }
        return vector2;
    }

    public static void writeVrmlScene(Vector vector, String string) {
        try {
            Object object;
            String string2 = string + "_cells";
            PrintStream printStream = new PrintStream(new FileOutputStream(string2));
            printStream.print("Roller{\n object[\n DEF TRANSFORM Transform {\n children [\n");
            int n = 0;
            while (n < vector.size()) {
                Vector vector2 = (Vector)vector.elementAt(n);
                int n2 = 0;
                while (n2 < vector2.size()) {
                    object = string + "_" + n + "_" + n2 + ".wrl";
                    printStream.println(" DEF S_" + n + "_" + n2 + " Cell {url \"" + (String)object + "\"}");
                    ++n2;
                }
                ++n;
            }
            printStream.print("]\n}\n]\n}\n");
            printStream.print("Transform {\n translation 7 -2 0\n rotation 1 0 0 -1.57\n");
            printStream.print("scale 0.4 0.4 0.4 \n    children [\n");
            int n3 = 0;
            while (n3 < vector.size()) {
                Vector vector3 = (Vector)vector.elementAt(n3);
                int n4 = 0;
                while (n4 < vector3.size()) {
                    printStream.print("    Transform { translation " + n4 + " 0 " + n3 + " children DEF B_" + n3 + "_" + n4);
                    printStream.print(" RadioButton{shapeRaised USE SR shapePressed USE SP}}\n");
                    ++n4;
                }
                ++n3;
            }
            printStream.print("    ]\n}\n");
            printStream.print("ButtonGroup {\n    buttons [\n");
            int n5 = 0;
            while (n5 < vector.size()) {
                object = (Vector)vector.elementAt(n5);
                int n6 = 0;
                while (n6 < ((Vector)object).size()) {
                    printStream.print(" USE B_" + n5 + "_" + n6);
                    ++n6;
                }
                printStream.print("\n");
                ++n5;
            }
            printStream.print("]\ncells [\n");
            int n7 = 0;
            while (n7 < vector.size()) {
                Vector vector4 = (Vector)vector.elementAt(n7);
                int n8 = 0;
                while (n8 < vector4.size()) {
                    printStream.print(" USE S_" + n7 + "_" + n8);
                    ++n8;
                }
                printStream.print("\n");
                ++n7;
            }
            printStream.print("]\n}\n");
            printStream.print("ROUTE SLIDER.value_changed TO INTERPOLATOR.set_fraction\n");
            printStream.print("ROUTE INTERPOLATOR.value_changed TO TRANSFORM.set_scale\n");
            printStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(Out);
        }
    }

    public void writeCells(Vector vector, String string, String string2) {
        Out.println("writing..");
        int n = 0;
        while (n < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n);
            int n2 = 0;
            while (n2 < vector2.size()) {
                SSCell sSCell = (SSCell)vector2.elementAt(n2);
                Polyhedron polyhedron = this.getPolyhedron(sSCell);
                String string3 = string + "_" + n + "_" + n2 + Polyhedron.getPostfix(string2);
                polyhedron.writeToFile(string3, string2);
                Out.println(string3);
                ++n2;
            }
            ++n;
        }
    }

    public static String makeStellationName(int[][] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2][0] != n) {
                stringBuffer.append(nArray[n2][0]);
                n = nArray[n2][0];
            }
            int n3 = nArray[n2][1];
            int n4 = n3 % 26;
            int n5 = n3 / 26;
            switch (n5) {
                case 0: {
                    stringBuffer.append((char)(97 + n4));
                    break;
                }
                case 1: {
                    stringBuffer.append((char)(65 + n4));
                    break;
                }
                case 2: {
                    stringBuffer.append('_');
                    stringBuffer.append((char)(97 + n4));
                    break;
                }
                case 3: {
                    stringBuffer.append("__");
                    stringBuffer.append((char)(65 + n4));
                    break;
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String makeSFileName(int[][] nArray, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('_');
        stringBuffer.append(Stellation.makeStellationName(nArray));
        stringBuffer.append(Polyhedron.getPostfix(string2));
        return stringBuffer.toString();
    }

    public static int[][][] readStellations(String string) {
        Object object;
        Vector<int[][]> vector = new Vector<int[][]>();
        try {
            String string2;
            object = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                int[][] nArray = Stellation.parseStellationLine(string2);
                if (nArray == null) continue;
                vector.addElement(nArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(Out);
        }
        object = new int[vector.size()][][];
        vector.copyInto((Object[])object);
        return object;
    }

    static int[][] parseStellationLine(String string) {
        System.out.println(string);
        Vector<int[]> vector = new Vector<int[]>();
        int n = 0;
        int n2 = string.length();
        block0: while (n < n2) {
            int n3;
            char c;
            block4: {
                c = string.charAt(n);
                System.out.println(c);
                if (c < '0' || c > '9') break;
                StringBuffer stringBuffer = new StringBuffer();
                n3 = 0;
                do {
                    stringBuffer.append(c);
                    if (++n >= n2) break block4;
                    c = string.charAt(n);
                    System.out.println(c);
                } while (c >= '0' && c <= '9');
                n3 = Integer.parseInt(stringBuffer.toString());
            }
            while (c >= 'a' && c <= 'z') {
                int[] nArray = new int[]{n3, c - 97};
                vector.addElement(nArray);
                if (++n >= n2) continue block0;
                c = string.charAt(n);
                System.out.println(c);
            }
        }
        System.out.println(vector);
        if (vector.size() == 0) {
            return null;
        }
        int[][] nArrayArray = new int[vector.size()][];
        vector.copyInto((Object[])nArrayArray);
        return nArrayArray;
    }

    static int[][] parseStellationLineOld(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " _,\n\r\t");
        Vector<int[]> vector = new Vector<int[]>();
        while (stringTokenizer.hasMoreTokens()) {
            object = new int[2];
            String string2 = stringTokenizer.nextToken();
            if (string2.charAt(0) == '#') break;
            object[0] = Integer.parseInt(string2);
            object[1] = Integer.parseInt(stringTokenizer.nextToken());
            vector.addElement((int[])object);
        }
        if (vector.size() == 0) {
            return null;
        }
        object = new int[vector.size()][];
        vector.copyInto((Object[])object);
        return object;
    }

    public static Vector3D[] readVectors(String string) {
        Vector3D[] vector3DArray = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            if (string.endsWith(".off")) {
                Polyhedron polyhedron = new Polyhedron();
                polyhedron.readOFF(fileInputStream);
                vector3DArray = polyhedron.vertices;
            } else {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
                Vector<Vector3D> vector = new Vector<Vector3D>();
                while (streamTokenizer.nextToken() != -1) {
                    double d = streamTokenizer.nval;
                    if (streamTokenizer.nextToken() == -1) break;
                    double d2 = streamTokenizer.nval;
                    if (streamTokenizer.nextToken() == -1) break;
                    double d3 = streamTokenizer.nval;
                    Vector3D vector3D = new Vector3D(d, d2, d3);
                    if (vector3D.length2() == 0.0) continue;
                    vector.addElement(vector3D);
                }
                int n = vector.size();
                vector3DArray = new Vector3D[n];
                int n2 = 0;
                while (n2 < n) {
                    vector3DArray[n2] = (Vector3D)vector.elementAt(n2);
                    ++n2;
                }
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return vector3DArray;
    }

    static Frame showDiagram(SFace[] sFaceArray, int n) {
        Object object;
        int n2 = -1;
        int n3 = 10000;
        int n4 = 0;
        while (n4 < sFaceArray.length) {
            if (sFaceArray[n4].layer < n3) {
                n2 = n4;
                n3 = sFaceArray[n4].layer;
            }
            ++n4;
        }
        SFace[] sFaceArray2 = null;
        if (n2 != -1) {
            int n5;
            Object object2;
            Object object3;
            sFaceArray2 = new SFace[sFaceArray.length];
            int n6 = 0;
            while (n6 < sFaceArray.length) {
                sFaceArray2[n6] = new SFace(sFaceArray[n6]);
                ++n6;
            }
            object = sFaceArray2[n2];
            Vector3D vector3D = new Vector3D(0.0, 0.0, 0.0);
            int n7 = 0;
            while (n7 < ((SFace)object).vertices.length) {
                vector3D.addSet(((SFace)object).vertices[n7]);
                ++n7;
            }
            vector3D.mulSet(1.0 / (double)((SFace)object).vertices.length);
            int n8 = 0;
            while (n8 < sFaceArray2.length) {
                object3 = sFaceArray2[n8].vertices;
                int n9 = 0;
                while (n9 < ((Vector3D[])object3).length) {
                    object3[n9].subSet(vector3D);
                    ++n9;
                }
                ++n8;
            }
            object3 = new Vector3D(0.0, 1.0, 0.0);
            Vector3D vector3D2 = new Vector3D(0.0, 0.0, 1.0);
            Vector3D[] vector3DArray = ((SFace)object).vertices;
            Vector3D vector3D3 = vector3DArray[1].sub(vector3DArray[0]).cross(vector3DArray[2].sub(vector3DArray[1]));
            vector3D3.normalize();
            int n10 = 0;
            while (n10 < sFaceArray2.length) {
                object2 = sFaceArray2[n10].vertices;
                n5 = 0;
                while (n5 < ((Object)object2).length) {
                    ((Vector3D)object2[n5]).rotateSet(vector3D3, vector3D2);
                    ++n5;
                }
                ++n10;
            }
            object2 = new Vector3D(((SFace)object).vertices[n]);
            ((Vector3D)object2).normalize();
            n5 = 0;
            while (n5 < sFaceArray2.length) {
                Vector3D[] vector3DArray2 = sFaceArray2[n5].vertices;
                int n11 = 0;
                while (n11 < vector3DArray2.length) {
                    vector3DArray2[n11].rotateSet((Vector3D)object2, (Vector3D)object3);
                    ++n11;
                }
                ++n5;
            }
        }
        Frame frame = new Frame("Stellation Diagram");
        object = new StellationCanvas(sFaceArray2, sFaceArray2, null, null);
        frame.add("Center", (Component)object);
        frame.pack();
        frame.show();
        return frame;
    }

    static void rotateFaces(SFace[] sFaceArray, Vector3D vector3D, Vector3D vector3D2) {
        int n = 0;
        while (n < sFaceArray.length) {
            Vector3D[] vector3DArray = sFaceArray[n].vertices;
            int n2 = 0;
            while (n2 < vector3DArray.length) {
                vector3DArray[n2].rotateSet(vector3D, vector3D2);
                ++n2;
            }
            ++n;
        }
    }

    static void translateFaces(SFace[] sFaceArray, Vector3D vector3D) {
        int n = 0;
        while (n < sFaceArray.length) {
            Vector3D[] vector3DArray = sFaceArray[n].vertices;
            int n2 = 0;
            while (n2 < vector3DArray.length) {
                vector3DArray[n2].subSet(vector3D);
                ++n2;
            }
            ++n;
        }
    }

    double getMaxRadius() {
        if (this.maxRadius == 0.0) {
            int n = 0;
            while (n < this.faces.length) {
                int n2 = 0;
                while (n2 < this.faces[n].length) {
                    double d = this.faces[n][n2].getRadius();
                    if (d > this.maxRadius) {
                        this.maxRadius = d;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return this.maxRadius;
    }

    public StellationCanvas showStellationDiagram(Object[][] objectArray, String string, int n, int n2, String string2, StellationCanvas stellationCanvas) {
        Object object;
        Object object2;
        int n3 = 0;
        double d = 1.0E20;
        SFace[] sFaceArray = this.faces[n];
        int n4 = 0;
        while (n4 < sFaceArray.length) {
            double d2 = sFaceArray[n4].getCenter().length2();
            if (d2 < d) {
                d = d2;
                n3 = n4;
            }
            ++n4;
        }
        SFace[] sFaceArray2 = new SFace[objectArray.length];
        int n5 = 0;
        while (n5 < sFaceArray2.length) {
            sFaceArray2[n5] = new SFace((SFace)objectArray[n5][0]);
            sFaceArray2[n5].layer = (Integer)objectArray[n5][1];
            ++n5;
        }
        SFace[] sFaceArray3 = new SFace[sFaceArray.length];
        int n6 = 0;
        while (n6 < sFaceArray.length) {
            sFaceArray3[n6] = new SFace(sFaceArray[n6]);
            ++n6;
        }
        Axis[] axisArray = Symmetry.getAxes(string2);
        Axis[] axisArray2 = new Axis[axisArray.length];
        Plane plane = this.faces[n][0].getPlane();
        int n7 = 0;
        while (n7 < axisArray2.length) {
            object2 = Stellation.intersect(plane, axisArray[n7].vector);
            if (object2 != null) {
                axisArray2[n7] = new Axis((Vector3D)object2, axisArray[n7].order);
            }
            ++n7;
        }
        object2 = Symmetry.getSymmetryPlanes(string2);
        Vector3D[][] vector3DArray = new Vector3D[((Plane[])object2).length][];
        double d3 = this.getMaxRadius();
        int n8 = 0;
        while (n8 < vector3DArray.length) {
            vector3DArray[n8] = Stellation.intersect(plane, object2[n8], d3);
            ++n8;
        }
        SFace sFace = sFaceArray3[n3];
        Vector3D vector3D = sFace.getCenter();
        Stellation.translateFaces(sFaceArray2, vector3D);
        Stellation.translateFaces(sFaceArray3, vector3D);
        int n9 = 0;
        while (n9 < axisArray2.length) {
            if (axisArray2[n9] != null) {
                axisArray2[n9].vector.subSet(vector3D);
            }
            ++n9;
        }
        int n10 = 0;
        while (n10 < vector3DArray.length) {
            if (vector3DArray[n10] != null) {
                vector3DArray[n10][0].subSet(vector3D);
                vector3DArray[n10][1].subSet(vector3D);
            }
            ++n10;
        }
        Vector3D vector3D2 = new Vector3D(0.0, 1.0, 0.0);
        Vector3D vector3D3 = new Vector3D(0.0, 0.0, 1.0);
        Vector3D[] vector3DArray2 = sFace.vertices;
        Vector3D vector3D4 = vector3DArray2[1].sub(vector3DArray2[0]).cross(vector3DArray2[2].sub(vector3DArray2[1]));
        vector3D4.normalize();
        Stellation.rotateFaces(sFaceArray3, vector3D4, vector3D3);
        Stellation.rotateFaces(sFaceArray2, vector3D4, vector3D3);
        int n11 = 0;
        while (n11 < axisArray2.length) {
            if (axisArray2[n11] != null) {
                axisArray2[n11].vector.rotateSet(vector3D4, vector3D3);
            }
            ++n11;
        }
        int n12 = 0;
        while (n12 < vector3DArray.length) {
            if (vector3DArray[n12] != null) {
                vector3DArray[n12][0].rotateSet(vector3D4, vector3D3);
                vector3DArray[n12][1].rotateSet(vector3D4, vector3D3);
            }
            ++n12;
        }
        if (n2 < sFace.vertices.length) {
            object = new Vector3D(sFace.vertices[n2]);
            ((Vector3D)object).normalize();
            Stellation.rotateFaces(sFaceArray2, (Vector3D)object, vector3D2);
            Stellation.rotateFaces(sFaceArray3, (Vector3D)object, vector3D2);
            int n13 = 0;
            while (n13 < axisArray2.length) {
                if (axisArray2[n13] != null) {
                    axisArray2[n13].vector.rotateSet((Vector3D)object, vector3D2);
                }
                ++n13;
            }
            int n14 = 0;
            while (n14 < vector3DArray.length) {
                if (vector3DArray[n14] != null) {
                    vector3DArray[n14][0].rotateSet((Vector3D)object, vector3D2);
                    vector3DArray[n14][1].rotateSet((Vector3D)object, vector3D2);
                }
                ++n14;
            }
        }
        if (stellationCanvas == null) {
            object = new Frame(string);
            stellationCanvas = new StellationCanvas(sFaceArray2, sFaceArray3, axisArray2, vector3DArray);
            ((Container)object).add("Center", stellationCanvas);
            ((Window)object).pack();
            ((Window)object).show();
            ((Container)object).validate();
        } else {
            stellationCanvas.setFaces(sFaceArray2, sFaceArray3, axisArray2, vector3DArray);
            stellationCanvas.getFrame().validate();
        }
        return stellationCanvas;
    }

    public SSCell[] getStellation(Vector vector, int[][] nArray) {
        SSCell[] sSCellArray = new SSCell[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            sSCellArray[n] = (SSCell)((Vector)vector.elementAt(nArray[n][0])).elementAt(nArray[n][1]);
            ++n;
        }
        return sSCellArray;
    }

    public int[] findCell(Vector vector, int n, int n2, int n3) {
        SFace sFace = this.faces[n][n2];
        int n4 = vector.size();
        int n5 = 0;
        while (n5 < n4) {
            Vector vector2 = (Vector)vector.elementAt(n5);
            int n6 = vector2.size();
            int n7 = 0;
            while (n7 < n6) {
                SCell[] sCellArray = ((SSCell)vector2.elementAt((int)n7)).cells;
                int n8 = 0;
                while (n8 < sCellArray.length) {
                    SFace[] sFaceArray = null;
                    sFaceArray = n3 == 1 ? sCellArray[n8].top : sCellArray[n8].bottom;
                    int n9 = 0;
                    while (n9 < sFaceArray.length) {
                        if (sFaceArray[n9] == sFace) {
                            int[] nArray = new int[]{n5, n7};
                            return nArray;
                        }
                        ++n9;
                    }
                    ++n8;
                }
                ++n7;
            }
            ++n5;
        }
        return null;
    }

    public int[] findCell(SSCell[] sSCellArray, Vector3D vector3D, boolean bl) {
        SSCell sSCell = null;
        Vector vector = null;
        SFace sFace = null;
        SCell sCell = null;
        int n = 0;
        block0: while (n < sSCellArray.length) {
            SCell[] sCellArray = sSCellArray[n].cells;
            int n2 = 0;
            while (n2 < sCellArray.length) {
                int n3;
                SFace[] sFaceArray = sCellArray[n2].top;
                if (sFaceArray != null) {
                    n3 = 0;
                    while (n3 < sFaceArray.length) {
                        if (sFaceArray[n3].getCenter().equals(vector3D)) {
                            sSCell = sSCellArray[n];
                            sFace = sFaceArray[n3];
                            vector = sSCell.top;
                            sCell = sFaceArray[n3].cellAbove;
                            break block0;
                        }
                        ++n3;
                    }
                }
                if ((sFaceArray = sCellArray[n2].bottom) != null) {
                    n3 = 0;
                    while (n3 < sFaceArray.length) {
                        if (sFaceArray[n3].getCenter().equals(vector3D)) {
                            sSCell = sSCellArray[n];
                            sFace = sFaceArray[n3];
                            vector = sSCell.bottom;
                            sCell = sFaceArray[n3].cellBelow;
                            break block0;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
        if (sSCell != null) {
            if (bl) {
                int n4 = 0;
                while (n4 < vector.size()) {
                    SSCell sSCell2 = (SSCell)vector.elementAt(n4);
                    if (sSCell2.hasSCell(sCell)) {
                        return new int[]{sSCell2.layer, sSCell2.index};
                    }
                    ++n4;
                }
            } else {
                return new int[]{sSCell.layer, sSCell.index};
            }
        }
        return null;
    }

    public static Object[][] getStellationDiagram(SSCell[] sSCellArray, int n) {
        Object object;
        int n2;
        Object[][] objectArray;
        FastHashtable fastHashtable = new FastHashtable();
        Integer n3 = new Integer(1);
        Integer n4 = new Integer(0);
        int n5 = 0;
        while (n5 < sSCellArray.length) {
            objectArray = sSCellArray[n5];
            n2 = 0;
            while (n2 < objectArray.cells.length) {
                Object object2;
                object = objectArray.cells[n2];
                int n6 = 0;
                while (n6 < ((SCell)object).top.length) {
                    SFace sFace = ((SCell)object).top[n6];
                    if (sFace.getPlaneIndex() == n) {
                        object2 = (Integer)fastHashtable.get(sFace);
                        if (object2 == null) {
                            fastHashtable.put(sFace, n3);
                        } else if (object2 == n4) {
                            fastHashtable.remove(sFace);
                        } else {
                            Out.println("duplicate face in stellation!");
                        }
                    }
                    ++n6;
                }
                int n7 = 0;
                while (n7 < ((SCell)object).bottom.length) {
                    object2 = ((SCell)object).bottom[n7];
                    if (((SFace)object2).getPlaneIndex() == n) {
                        Integer n8 = (Integer)fastHashtable.get(object2);
                        if (n8 == null) {
                            fastHashtable.put(object2, n4);
                        } else if (n8 == n3) {
                            fastHashtable.remove(object2);
                        } else {
                            Out.println("duplicate face in stellation!");
                        }
                    }
                    ++n7;
                }
                ++n2;
            }
            ++n5;
        }
        objectArray = new Object[fastHashtable.size()][2];
        n2 = 0;
        object = fastHashtable.keys();
        while (object.hasMoreElements()) {
            SFace sFace = (SFace)object.nextElement();
            Integer n9 = (Integer)fastHashtable.get(sFace);
            objectArray[n2][0] = sFace;
            objectArray[n2][1] = n9;
            ++n2;
        }
        return objectArray;
    }

    public void showCells(Vector vector, int n, int n2, String string) {
        SSCell[] sSCellArray = new SSCell[1];
        int[][] nArray = new int[1][2];
        int n3 = 0;
        while (n3 < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n3);
            nArray[0][0] = n3;
            int n4 = 0;
            while (n4 < vector2.size()) {
                sSCellArray[0] = (SSCell)vector2.elementAt(n4);
                nArray[0][1] = n4++;
                Object[][] objectArray = Stellation.getStellationDiagram(sSCellArray, n);
                this.showStellationDiagram(objectArray, Stellation.makeStellationName(nArray), n, n2, string, null);
            }
            ++n3;
        }
    }

    public Integer[] getNonEquivalentFaces(String string) {
        Plane plane;
        int n;
        Object[] objectArray;
        Matrix3D[] matrix3DArray = Symmetry.getMatrices(string);
        FastHashtable fastHashtable = new FastHashtable();
        fastHashtable.put(this.faces[0][0].getPlane(), new Integer(0));
        int n2 = 1;
        while (n2 < this.faces.length) {
            objectArray = this.faces[n2][0].getPlane();
            n = 0;
            int n3 = 0;
            while (n3 < matrix3DArray.length) {
                plane = new Plane(objectArray.v.mul(matrix3DArray[n3]), objectArray.d, n3);
                if (fastHashtable.get(plane) != null) {
                    n = 1;
                    break;
                }
                ++n3;
            }
            if (n == 0) {
                fastHashtable.put(objectArray, new Integer(n2));
            }
            ++n2;
        }
        objectArray = new Integer[fastHashtable.size()];
        n = 0;
        Enumeration enumeration = fastHashtable.keys();
        while (enumeration.hasMoreElements()) {
            plane = (Plane)enumeration.nextElement();
            objectArray[n++] = (Integer)fastHashtable.get(plane);
        }
        QSort.quickSort(objectArray, 0, objectArray.length - 1, (Comparator)new IntegerComparator());
        return objectArray;
    }

    static void printHelp(PrintStream printStream) {
        printStream.println("program for polyhedra stellation");
        printStream.println("parameters:");
        printStream.println("-i <input file with polyhedron (OFF format)>");
        printStream.println("-v <input file with vectors>");
        printStream.println("-c  makeCells");
        printStream.println("-C  showCells");
        printStream.println("-o <Vrml2 | POV | OFF> - output type");
        printStream.println("-Oc - write cells ");
        printStream.println("-Ol - write layers ");
        printStream.println("-Of - write polyhedra faces ");
        printStream.println("-Of - write polyhedra edges ");
        printStream.println("-Of - write polyhedra vertices ");
        printStream.println("-Le <end layer> ");
        printStream.println("-Ls <start layer> ");
        printStream.println("-p <prefix of ouput files>");
        printStream.println("-s <file with stellations> (to write specific stellations)");
        printStream.println("-t <max number of intersections>");
        printStream.println("-d  show diagramm");
        printStream.println("-f <face to show diagramm>");
        printStream.println("-u <vertexUp on diagramm>");
        printStream.println("-w print output to window");
        printStream.println("-y <O | Oh | I | Ih | T | Th> symmetry to use");
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        String string = "none";
        String string2 = null;
        String string3 = null;
        String string4 = "s";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string5 = "none";
        String string6 = null;
        int n4 = 0;
        int n5 = 0;
        boolean bl7 = false;
        boolean bl8 = false;
        int n6 = 0;
        while (n6 < stringArray.length) {
            if (stringArray[n6].charAt(0) == '-' || stringArray[n6].charAt(0) == '+') {
                switch (stringArray[n6].charAt(1)) {
                    case 'C': {
                        bl5 = true;
                        break;
                    }
                    case 'c': {
                        bl4 = true;
                        break;
                    }
                    case 'd': {
                        bl3 = true;
                        break;
                    }
                    case 'f': {
                        n5 = Integer.parseInt(stringArray[++n6]);
                        break;
                    }
                    case 'h': {
                        Stellation.printHelp(System.err);
                        break;
                    }
                    case 'i': {
                        string2 = stringArray[++n6];
                        break;
                    }
                    case 'o': {
                        string = stringArray[++n6];
                        break;
                    }
                    case 'O': {
                        switch (stringArray[n6].charAt(2)) {
                            case 'c': {
                                bl7 = true;
                                break;
                            }
                            case 'l': {
                                bl8 = true;
                                break;
                            }
                            case 'f': {
                                Polyhedron.outFaces = stringArray[n6].charAt(0) == '+';
                                break;
                            }
                            case 'e': {
                                Polyhedron.outEdges = stringArray[n6].charAt(0) == '+';
                                break;
                            }
                            case 'v': {
                                Polyhedron.outVertices = stringArray[n6].charAt(0) == '+';
                            }
                        }
                        break;
                    }
                    case 'L': {
                        switch (stringArray[n6].charAt(2)) {
                            case 's': {
                                n = Integer.parseInt(stringArray[++n6]);
                                break;
                            }
                            case 'e': {
                                n2 = Integer.parseInt(stringArray[++n6]);
                            }
                        }
                        break;
                    }
                    case 'p': {
                        string4 = stringArray[++n6];
                        break;
                    }
                    case 's': {
                        string6 = stringArray[++n6];
                        break;
                    }
                    case 't': {
                        n3 = Integer.parseInt(stringArray[++n6]);
                        break;
                    }
                    case 'u': {
                        n4 = Integer.parseInt(stringArray[++n6]);
                        break;
                    }
                    case 'v': {
                        string3 = stringArray[++n6];
                        break;
                    }
                    case 'w': {
                        bl2 = true;
                        break;
                    }
                    case 'y': {
                        string5 = stringArray[++n6];
                    }
                }
            }
            ++n6;
        }
        if (string.equals("Vrml2") || string.equals("OFF") || string.equals("POV")) {
            bl = true;
        }
        if (bl2) {
            Out = new PrintStream(new WindowOutputStream());
        }
        Stellation stellation = null;
        if (string2 != null) {
            object2 = new Polyhedron();
            try {
                object = new FileInputStream(string2);
                object2.readOFF((InputStream)object);
                object2.makeCCW();
                ((FileInputStream)object).close();
            }
            catch (Exception exception) {
                exception.printStackTrace(Out);
                System.exit(-1);
            }
            Out.println(string2 + " read OK");
            Out.flush();
            stellation = new Stellation((Polyhedron)object2, n3);
        } else if (string3 != null) {
            object2 = Stellation.readVectors(string3);
            Out.println(string3 + " read OK");
            Out.flush();
            stellation = new Stellation((Vector3D[])object2, n3);
        } else {
            System.err.println("no input file given");
            System.exit(-1);
        }
        Out.println("\nlayers found: " + stellation.maxlayer);
        Out.flush();
        if (bl7 || bl5 || bl3 || string6 != null) {
            object2 = stellation.makeCells(string5, string5, 1000);
            if (bl7) {
                stellation.writeCells((Vector)object2, string4, string);
                if (string.equals("Vrml2")) {
                    Stellation.writeVrmlScene((Vector)object2, string4);
                }
            }
            if (bl5) {
                stellation.showCells((Vector)object2, n5, n4, string5);
            }
            if (string6 != null) {
                object = Stellation.readStellations(string6);
                System.out.println(object);
                int n7 = 0;
                while (n7 < ((Object)object).length) {
                    Object object3;
                    if (bl3) {
                        object3 = stellation.getStellation((Vector)object2, (int[][])object[n7]);
                        Object[][] objectArray = Stellation.getStellationDiagram((SSCell[])object3, n5);
                        stellation.showStellationDiagram(objectArray, Stellation.makeStellationName((int[][])object[n7]), n5, n4, string5, null);
                    }
                    if (bl) {
                        object3 = stellation.getPolyhedron((Vector)object2, (int[][])object[n7]);
                        ((Polyhedron)object3).writeToFile(Stellation.makeSFileName((int[][])object[n7], string4, string), string);
                    }
                    ++n7;
                }
            }
        }
        if (bl8) {
            if (n2 < 0) {
                n2 = stellation.maxlayer;
            }
            int n8 = n;
            while (n8 <= n2) {
                Out.print(n8);
                Out.flush();
                boolean bl9 = false;
                Polyhedron polyhedron = stellation.getPolyhedron(n8);
                polyhedron.generateRandomColors(polyhedron.paintFacesByArea());
                Polyhedron.outColor = true;
                Out.print(".");
                Out.flush();
                polyhedron.writeToFile(Polyhedron.makeFileName(string4, string, n8, stellation.maxlayer), string);
                ++n8;
            }
        }
    }

    class OrientedEdge {
        int v1;
        int v2;

        OrientedEdge(int n, int n2) {
            this.v1 = n;
            this.v2 = n2;
        }

        public int hashCode() {
            return this.v1 + 119 * this.v2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SEdge)) {
                return false;
            }
            SEdge sEdge = (SEdge)object;
            return sEdge.v1 == this.v1 && sEdge.v2 == this.v2;
        }
    }
}

