/*
 * Decompiled with CFR 0.152.
 */
package PVS.polyhedra;

import PVS.Utils.Comparator;
import PVS.Utils.FastHashtable;
import PVS.Utils.Fmt;
import PVS.Utils.QSort;
import PVS.polyhedra.Matrix3D;
import PVS.polyhedra.SCell;
import PVS.polyhedra.SCellIndex;
import PVS.polyhedra.SFace;
import PVS.polyhedra.Symmetry;
import PVS.polyhedra.Vector3D;
import java.util.Hashtable;
import java.util.Vector;

public class SSCell
implements Comparator {
    public Vector top = new Vector();
    public Vector bottom = new Vector();
    public SCell[] cells;
    public SSCell[] subCells = null;
    public SSCell superCell = null;
    int handedness = 0;
    private FastHashtable ttop = new FastHashtable();
    private boolean isTopBottomInitialized = false;
    public int layer;
    public int index;
    String symmetry;
    double volume = 0.0;
    double area = 0.0;
    int nVertices = 0;
    int nComponents = 0;
    SCellIndex sCellIndex = null;
    static double TOL = 1.0E-4;

    public SSCell(Vector vector, String string) {
        this.cells = new SCell[vector.size()];
        vector.copyInto(this.cells);
        this.symmetry = string;
        QSort.quickSort(this.cells, 0, this.cells.length - 1, (Comparator)this.cells[0]);
        this.initHandedness();
    }

    void initTopAndBottom() {
        if (this.isTopBottomInitialized) {
            return;
        }
        this.isTopBottomInitialized = true;
        int n = 0;
        while (n < this.cells.length) {
            SFace[] sFaceArray = this.cells[n].top;
            int n2 = 0;
            while (n2 < sFaceArray.length) {
                SCell sCell = sFaceArray[n2].cellAbove;
                if (sCell != null) {
                    this.ttop.put(sCell, sCell);
                }
                ++n2;
            }
            ++n;
        }
    }

    boolean isTopAdjacentCell(SCell sCell) {
        Object object = this.ttop.get(sCell);
        return object != null;
    }

    void initHandedness() {
        if (this.cells.length > 0) {
            this.handedness = Symmetry.get_handedness(this.cells[0].getCenter(), this.symmetry);
        }
    }

    boolean isTopAdjacent(SSCell sSCell) {
        int n = 0;
        while (n < sSCell.cells.length) {
            if (this.isTopAdjacentCell(sSCell.cells[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public double getVolume() {
        if (this.volume == 0.0) {
            int n = 0;
            while (n < this.cells.length) {
                this.volume += this.cells[n].getVolume();
                ++n;
            }
        }
        return this.volume;
    }

    public double getArea() {
        if (this.area == 0.0) {
            int n = 0;
            while (n < this.cells.length) {
                this.area += this.cells[n].getArea();
                ++n;
            }
        }
        return this.area;
    }

    public int getCellsCount() {
        return this.cells.length;
    }

    public void setIndex(int n, int n2) {
        this.layer = n;
        this.index = n2;
    }

    public int getNFacets() {
        return this.cells[0].top.length + this.cells[0].bottom.length;
    }

    public int getNtopFacets() {
        return this.cells[0].top.length;
    }

    public int getNVertices() {
        if (this.nVertices != 0) {
            return this.nVertices;
        }
        this.countComponents();
        return this.nVertices;
    }

    public int getNComponent() {
        if (this.nComponents != 0) {
            return this.nComponents;
        }
        this.countComponents();
        return this.nComponents;
    }

    void countComponents() {
        Hashtable<Vector3D, SCell> hashtable = new Hashtable<Vector3D, SCell>();
        int n = 0;
        while (n < this.cells.length) {
            SCell sCell = this.cells[n];
            int n2 = 0;
            while (n2 < sCell.top.length) {
                SFace sFace = sCell.top[n2];
                int n3 = 0;
                while (n3 < sFace.vertices.length) {
                    hashtable.put(sFace.vertices[n3], sCell);
                    ++n3;
                }
                ++n2;
            }
            int n4 = 0;
            while (n4 < sCell.bottom.length) {
                SFace sFace = sCell.bottom[n4];
                int n5 = 0;
                while (n5 < sFace.vertices.length) {
                    hashtable.put(sFace.vertices[n5], sCell);
                    ++n5;
                }
                ++n4;
            }
            ++n;
        }
        this.nVertices = hashtable.size();
        this.nComponents = 1;
    }

    public SCellIndex getSCellIndex() {
        if (this.sCellIndex != null) {
            return this.sCellIndex;
        }
        Object[] objectArray = new SCellIndex[this.cells.length];
        int n = 0;
        while (n < objectArray.length) {
            SCell sCell = this.cells[n];
            int[] nArray = new int[sCell.top.length + sCell.bottom.length];
            int n2 = 0;
            int n3 = 0;
            while (n3 < sCell.top.length) {
                nArray[n2++] = sCell.top[n3].getPlaneIndex();
                ++n3;
            }
            int n4 = 0;
            while (n4 < sCell.bottom.length) {
                nArray[n2++] = sCell.bottom[n4].getPlaneIndex();
                ++n4;
            }
            objectArray[n] = new SCellIndex(nArray);
            ++n;
        }
        QSort.quickSort(objectArray, 0, objectArray.length - 1, (Comparator)objectArray[0]);
        this.sCellIndex = objectArray[0];
        return this.sCellIndex;
    }

    public int getHandedness() {
        return this.handedness;
    }

    public int old_compare(Object object, Object object2) {
        SSCell sSCell = (SSCell)object;
        SSCell sSCell2 = (SSCell)object2;
        double d = sSCell.getVolume();
        double d2 = sSCell2.getVolume();
        double d3 = d2 - d;
        if (d3 < -TOL) {
            return -1;
        }
        if (d3 > TOL) {
            return 1;
        }
        d3 = sSCell2.getArea() - sSCell.getArea();
        if (d3 < -TOL) {
            return -1;
        }
        if (d3 > TOL) {
            return 1;
        }
        if (sSCell.handedness != 0 && sSCell2.handedness != 0) {
            return -sSCell2.handedness + sSCell.handedness;
        }
        if (sSCell.handedness == 0 && sSCell2.handedness != 0) {
            return -1;
        }
        if (sSCell2.handedness == 0 && sSCell.handedness != 0) {
            return 1;
        }
        return 0;
    }

    public void setSubCells(Vector vector) {
        this.subCells = new SSCell[vector.size()];
        vector.copyInto(this.subCells);
        int n = 0;
        while (n < this.subCells.length) {
            this.subCells[n].superCell = this;
            ++n;
        }
    }

    public int strictCompare(SSCell sSCell, SSCell sSCell2) {
        int n = sSCell.cells.length - sSCell2.cells.length;
        if (n != 0) {
            return n;
        }
        int n2 = 0;
        while (n2 < sSCell.cells.length) {
            int n3 = sSCell.cells[n2].getIndex() - sSCell2.cells[n2].getIndex();
            if (n3 != 0) {
                return n3;
            }
            ++n2;
        }
        SCell sCell = sSCell.cells[0];
        SCell sCell2 = sSCell2.cells[0];
        int n4 = sSCell.getNFacets() - sSCell2.getNFacets();
        if (n4 != 0) {
            return n4;
        }
        int n5 = sSCell.getNVertices() - sSCell2.getNVertices();
        if (n5 != 0) {
            return n5;
        }
        return 0;
    }

    public int compare(Object object, Object object2) {
        SSCell sSCell = (SSCell)object;
        SSCell sSCell2 = (SSCell)object2;
        int n = this.strictCompare(sSCell, sSCell2);
        if (n != 0) {
            return n;
        }
        return sSCell.getVolume() - sSCell2.getVolume() < 0.0 ? -1 : 1;
    }

    public void makeCanonicalOrder() {
        Object object;
        Symmetry.CanonicalTester canonicalTester = Symmetry.getCanonicalTester(this.symmetry);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.cells.length) {
            object = this.cells[n3].getCenter();
            if (canonicalTester.test((Vector3D)object)) {
                ++n2;
                n = n3;
            }
            ++n3;
        }
        if (n2 != 1) {
            System.out.print("!");
        }
        object = new Hashtable();
        int n4 = 0;
        while (n4 < this.cells.length) {
            if (n4 != n) {
                ((Hashtable)object).put(this.cells[n4].getCenter(), this.cells[n4]);
            }
            ++n4;
        }
        Matrix3D[] matrix3DArray = Symmetry.getMatrices(this.symmetry);
        this.cells[n].setIndex(0);
        Vector3D vector3D = this.cells[n].getCenter();
        int n5 = 1;
        while (n5 < matrix3DArray.length) {
            Vector3D vector3D2 = vector3D.mul(matrix3DArray[n5]);
            SCell sCell = (SCell)((Hashtable)object).get(vector3D2);
            if (sCell != null) {
                sCell.setIndex(n5);
            }
            ++n5;
        }
        QSort.quickSort(this.cells, 0, this.cells.length - 1, (Comparator)this.cells[0]);
    }

    public void printIndices() {
        int n = 0;
        while (n < this.cells.length) {
            System.out.print(this.cells[n].getIndex());
            System.out.print(" ");
            ++n;
        }
        System.out.println();
    }

    public String getIndices() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        int n = 0;
        while (n < this.cells.length) {
            stringBuffer.append(this.cells[n].getIndex());
            if (n < this.cells.length - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public String getInfo() {
        return "[" + this.getNFacets() + "," + this.getNVertices() + "," + Fmt.fmt(this.getVolume(), 6, 8) + "]";
    }

    public void setSuperCell(SSCell sSCell) {
        this.superCell = sSCell;
    }

    public boolean hasSCell(SCell sCell) {
        int n = 0;
        while (n < this.cells.length) {
            if (this.cells[n] == sCell) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

