/*
 * Decompiled with CFR 0.152.
 */
package PVS.polyhedra;

import PVS.polyhedra.Plane;
import PVS.polyhedra.SCell;
import PVS.polyhedra.Vector3D;

public class SFace {
    public SCell cellAbove;
    public SCell cellBelow;
    int layer = 0;
    Vector3D[] vertices = null;
    private Plane plane;
    Vector3D center = null;
    Vector3D area = null;

    public SFace(Vector3D[] vector3DArray, Plane plane) {
        this.vertices = vector3DArray;
        this.plane = plane;
    }

    public SFace(Vector3D[] vector3DArray, Plane plane, int n) {
        this.vertices = vector3DArray;
        this.plane = plane;
        this.layer = n;
    }

    public SFace(SFace sFace) {
        this.layer = sFace.layer;
        this.vertices = new Vector3D[sFace.vertices.length];
        int n = 0;
        while (n < this.vertices.length) {
            this.vertices[n] = new Vector3D(sFace.vertices[n]);
            ++n;
        }
    }

    public Vector3D getCenter() {
        if (this.center == null) {
            this.center = new Vector3D(this.vertices[0]);
            int n = 1;
            while (n < this.vertices.length) {
                this.center.addSet(this.vertices[n]);
                ++n;
            }
            this.center.mulSet(1.0 / (double)this.vertices.length);
        }
        return this.center;
    }

    public boolean adjacent(SFace sFace, int n) {
        int n2 = sFace.vertices.length;
        int n3 = this.vertices.length;
        int n4 = 0;
        while (n4 < n3) {
            Vector3D vector3D = this.vertices[n4];
            int n5 = 0;
            while (n5 < n2) {
                if (vector3D == sFace.vertices[n5]) {
                    return this.vertices[(n4 + 1) % n3] == sFace.vertices[(n5 - n + n2) % n2] || this.vertices[(n4 - 1 + n3) % n3] == sFace.vertices[(n5 + n + n2) % n2];
                }
                ++n5;
            }
            ++n4;
        }
        return false;
    }

    public void cleanVertices() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.vertices.length) {
            if (this.vertices[(n2 + 1) % this.vertices.length] != this.vertices[n2]) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            this.vertices = new Vector3D[0];
        } else if (n != this.vertices.length) {
            Vector3D[] vector3DArray = new Vector3D[n];
            n = 0;
            int n3 = 0;
            while (n3 < this.vertices.length) {
                if (this.vertices[(n3 + 1) % this.vertices.length] != this.vertices[n3]) {
                    vector3DArray[n++] = this.vertices[n3];
                }
                ++n3;
            }
            this.vertices = vector3DArray;
        }
    }

    public Vector3D getArea() {
        if (this.area == null) {
            this.area = new Vector3D(0.0, 0.0, 0.0);
            int n = this.vertices.length;
            int n2 = 0;
            while (n2 < n) {
                this.area.addSet(this.vertices[n2].cross(this.vertices[(n2 + 1) % n]));
                ++n2;
            }
            this.area.mulSet(0.5);
        }
        return this.area;
    }

    public int getLayer() {
        return this.layer;
    }

    public Plane getPlane() {
        return this.plane;
    }

    public int getPlaneIndex() {
        return this.plane.index;
    }

    public double getRadius() {
        double d = 0.0;
        if (this.vertices != null) {
            int n = 0;
            while (n < this.vertices.length) {
                double d2 = this.vertices[n].length2();
                if (d2 > d) {
                    d = d2;
                }
                ++n;
            }
        }
        return Math.sqrt(d);
    }

    public int hashCode() {
        return this.getCenter().hashCode();
    }

    public void printVertices() {
        int n = 0;
        while (n < this.vertices.length) {
            System.out.print(this.vertices[n] + " ");
            ++n;
        }
        System.out.println();
    }
}

