/*
 * Decompiled with CFR 0.152.
 */
package PVS.polyhedra;

import PVS.Utils.Comparator;
import PVS.Utils.FastHashtable;
import PVS.polyhedra.Matrix3D;
import PVS.polyhedra.SFace;
import PVS.polyhedra.Vector3D;

public class SCell
implements Comparator {
    SFace[] top = null;
    SFace[] bottom = null;
    int layer;
    private int index = -1;
    Vector3D center;
    double vol = 0.0;
    double area = 0.0;

    SCell(SFace[] sFaceArray, SFace[] sFaceArray2, int n) {
        this.top = sFaceArray;
        this.bottom = sFaceArray2;
        this.layer = n;
        int n2 = 0;
        while (n2 < this.top.length) {
            this.top[n2].cellBelow = this;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.bottom.length) {
            this.bottom[n3].cellAbove = this;
            ++n3;
        }
    }

    Vector3D getCenter() {
        if (this.center == null) {
            this.center = new Vector3D(this.top[0].getCenter());
            int n = 1;
            while (n < this.top.length) {
                this.center.addSet(this.top[n].getCenter());
                ++n;
            }
            int n2 = 0;
            while (n2 < this.bottom.length) {
                this.center.addSet(this.bottom[n2].getCenter());
                ++n2;
            }
            this.center.mulSet(1.0 / (double)(this.top.length + this.bottom.length));
        }
        return this.center;
    }

    double getVolume() {
        if (this.vol != 0.0) {
            return this.vol;
        }
        double d = 0.0;
        int n = 0;
        while (n < this.top.length) {
            d += this.top[n].vertices[0].dot(this.top[n].getArea());
            ++n;
        }
        int n2 = 0;
        while (n2 < this.bottom.length) {
            d -= this.bottom[n2].vertices[0].dot(this.bottom[n2].getArea());
            ++n2;
        }
        this.vol = d / 3.0;
        return this.vol;
    }

    double getArea() {
        if (this.area == 0.0) {
            int n = 0;
            while (n < this.top.length) {
                this.area += this.top[n].getArea().length();
                ++n;
            }
            int n2 = 0;
            while (n2 < this.bottom.length) {
                this.area += this.bottom[n2].getArea().length();
                ++n2;
            }
        }
        return this.area;
    }

    public void setIndex(int n) {
        if (this.index < 0) {
            this.index = n;
            return;
        }
        if (n < this.index) {
            this.index = n;
        }
    }

    public int getIndex() {
        return this.index;
    }

    SCell getTransformedCopy(Matrix3D matrix3D, FastHashtable fastHashtable, FastHashtable fastHashtable2) {
        SFace[] sFaceArray = new SFace[this.top.length];
        SFace[] sFaceArray2 = new SFace[this.bottom.length];
        int n = 0;
        while (n < this.top.length) {
            SFace sFace = (SFace)fastHashtable2.get(this.top[n].getCenter().mul(matrix3D));
            if (sFace == null) {
                System.out.println("! no top facet in SCell.getTransformedCopy()");
            }
            sFaceArray[n] = sFace;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.bottom.length) {
            SFace sFace = (SFace)fastHashtable.get(this.bottom[n2].getCenter().mul(matrix3D));
            if (sFace == null) {
                System.out.println("! no bottom facet in SCell.getTransformedCopy()");
            }
            sFaceArray2[n2] = sFace;
            ++n2;
        }
        return new SCell(sFaceArray, sFaceArray2, this.layer);
    }

    public int compare(Object object, Object object2) {
        SCell sCell = (SCell)object;
        SCell sCell2 = (SCell)object2;
        return sCell.index - sCell2.index;
    }
}

