/*
 * Decompiled with CFR 0.152.
 */
package PVS.polyhedra;

import PVS.Utils.Comparator;
import PVS.Utils.DoubleComparator;
import PVS.Utils.Fmt;
import PVS.Utils.QSort;
import PVS.polyhedra.Vector3D;
import PVS.polyhedra.VectorIndex;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import java.util.Vector;

public class Polyhedron {
    public Vector3D[] vertices = new Vector3D[0];
    public int[][] ifaces = new int[0][0];
    public Color[] colors = new Color[0];
    public int[] icolor = new int[0];
    public int[][] edges = new int[0][0];
    public String[] description;
    public static boolean Debug = false;
    public static double tolerance = 1.0E-6;
    public static PrintStream Out = System.out;
    public static boolean outFaces = true;
    public static boolean outEdges = false;
    public static boolean outVertices = false;
    public static boolean outColor = true;
    static final String DXFHeader = "0\nSECTION\n2\nHEADER\n9\n$ACADVER\n1\nAC1009\n0\nENDSEC\n0\nSECTION\n2\nTABLES\n0\nTABLE\n2\nLAYER\n70\n0\n0\nLAYER\n2\npoly\n6\nCONTINUOUS\n0\nENDTAB\n0\nENDSEC\n0\nSECTION\n2\nBLOCKS\n0\nENDSEC\n0\nSECTION\n2\nENTITIES\n";
    static final String DXFTail = "0\nENDSEC\n0\nEOF\n";
    static String zeroes = "00000000000";
    static final String[] VRMLEdge = new String[]{"Background {skyColor 1 1 1}", "PROTO Edge [", "field SFVec3f start 0 -1 0", "field SFVec3f end   0  1 0", "field SFFloat radius 0.01", "exposedField SFNode appearance Appearance {", "    material Material{", "\tdiffuseColor 0.6 0.4 0.4", "    }", "}", "]{", "    DEF TRANSFORM Transform{", "\tchildren [", "\tDEF CYLINDER Shape{ ", "\t    geometry Cylinder{}", "\t    appearance IS appearance", "\t}", "\t]", "    }    ", "   Script {", "\tdirectOutput TRUE", "\tfield SFVec3f start IS start", "\tfield SFVec3f end IS end", "\tfield SFFloat radius IS radius", "\tfield SFNode cylinder USE CYLINDER", "\tfield SFNode transform USE TRANSFORM", "\turl [\"javascript:", "\tfunction initialize(){", "\t    transform.set_rotation = new SFRotation(", "                            new SFVec3f(0,1,0),start.subtract(end));", "\t    transform.set_translation = start.add(end).multiply(0.5);", "\t    var len = start.subtract(end).length();", "\t    cylinder.set_geometry = ", "\t    Browser.createVrmlFromString(", "\t    'Cylinder { radius '", "\t          +radius + ' height '+len+\t    ", "\t    '}'", "\t    )[0];", "\t}\t", "\t\"]", "   }", "}"};
    static final String[] POVStart = new String[]{"#version 3.1", "global_settings", "{", "  assumed_gamma 1.0", "}", "camera", "{", "  location  <0.01, 0.01, -3.0>", "  direction 1.5*z", "  right     4/3*x", "  look_at   <0.0, 0.0,  0.0>", "}", "background { color red 1 green 1 blue 1 }", "light_source{ <0, 10, -10> color rgb <1,0,0> }", "light_source { <7, -5, -10> color rgb <0,1,0>}", "light_source { <-7, -5, -10> color rgb <0,0,1> }", "#declare FinF = finish {reflection 0 ambient 0.2 diffuse 0.8 phong 0.1 metallic 0}", "#declare TextureE = texture{", "  pigment {color rgb <0.1,0.1,0.1>}", "  finish {reflection 0 ambient 0.1  diffuse 0.5 phong 1.0}", "}", "#declare TextureF = texture{pigment{color rgb <1 1 1>}finish{FinF}}", "#declare RadiusE = 0.01;", "// stat of polyhedron ", "#declare Polyhedron = union {"};
    static final String[] POVEnd = new String[]{"}", "// end of polyhedron ", "object { Polyhedron ", "scale 1/PolyRadius", "rotate <0 0 0> ", "no_shadow", "}"};
    static final double MINAREA = 0.001;

    public void setDescription(String[] stringArray) {
        this.description = stringArray;
    }

    public void makeCCW() {
        int n = 0;
        while (n < this.ifaces.length) {
            Vector3D vector3D = new Vector3D(0.0, 0.0, 0.0);
            int[] nArray = this.ifaces[n];
            int n2 = 0;
            while (n2 < nArray.length) {
                vector3D.addSet(this.vertices[nArray[n2]]);
                ++n2;
            }
            vector3D.mulSet(1.0 / (double)nArray.length);
            if (this.vertices[nArray[0]].cross(this.vertices[nArray[1]]).dot(vector3D) < 0.0) {
                int n3 = 0;
                while (n3 < nArray.length / 2) {
                    int n4 = nArray[n3];
                    nArray[n3] = nArray[nArray.length - 1 - n3];
                    nArray[nArray.length - 1 - n3] = n4;
                    ++n3;
                }
            }
            ++n;
        }
    }

    public Color getColor(int n) {
        if (this.icolor != null) {
            return this.colors[this.icolor[n]];
        }
        return Color.lightGray;
    }

    public void setColor(Color color) {
        this.colors = new Color[1];
        this.colors[0] = color;
        int n = this.ifaces.length;
        if (this.icolor == null || this.icolor.length < n) {
            this.icolor = new int[n];
        }
        int n2 = 0;
        while (n2 < n) {
            this.icolor[n2] = 0;
            ++n2;
        }
    }

    public int getColorIndex(int n) {
        return 0;
    }

    int findOffColorIndex(Vector vector, int n) {
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = (Integer)vector.elementAt(n3);
            if (n4 - n == 0) {
                return n3;
            }
            ++n3;
        }
        vector.addElement(new Integer(n));
        return vector.size() - 1;
    }

    public void readOFF(InputStream inputStream) {
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.commentChar(35);
            if (streamTokenizer.nextToken() != -3 || !streamTokenizer.sval.equals("OFF")) {
                throw new IOException("wrong header in OFF stream");
            }
            while (streamTokenizer.nextToken() != -2) {
            }
            n = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            n2 = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            n3 = (int)streamTokenizer.nval;
            this.vertices = new Vector3D[n];
            int n4 = 0;
            while (n4 < n) {
                streamTokenizer.nextToken();
                double d = streamTokenizer.nval;
                streamTokenizer.nextToken();
                double d2 = streamTokenizer.nval;
                streamTokenizer.nextToken();
                double d3 = streamTokenizer.nval;
                this.vertices[n4] = new Vector3D(d, d2, d3);
                ++n4;
            }
            this.ifaces = new int[n2][];
            this.icolor = new int[n2];
            n4 = 0;
            int n5 = 0;
            Vector vector = new Vector();
            streamTokenizer.eolIsSignificant(true);
            while (n4 < n2) {
                while (streamTokenizer.nextToken() != -2) {
                }
                int n6 = (int)streamTokenizer.nval;
                int[] nArray = new int[n6];
                this.ifaces[n4] = nArray;
                int n7 = 0;
                while (n7 < n6) {
                    streamTokenizer.nextToken();
                    nArray[n7] = (int)streamTokenizer.nval;
                    ++n7;
                }
                n5 = 0;
                int n8 = 0;
                while (n8 < 3) {
                    if (streamTokenizer.nextToken() != -2) break;
                    n5 <<= 8;
                    int n9 = streamTokenizer.nval <= 1.0 ? (int)(255.0 * streamTokenizer.nval) : (int)streamTokenizer.nval;
                    n5 |= n9 & 0xFF;
                    ++n8;
                }
                this.icolor[n4] = this.findOffColorIndex(vector, n5);
                ++n4;
                while (streamTokenizer.nextToken() != 10) {
                }
            }
            this.colors = new Color[vector.size()];
            int n10 = 0;
            while (n10 < this.colors.length) {
                this.colors[n10] = new Color((Integer)vector.elementAt(n10));
                ++n10;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void writeOFF(OutputStream outputStream) {
        int n;
        PrintStream printStream = new PrintStream(outputStream);
        printStream.println("OFF");
        if (this.description != null) {
            n = 0;
            while (n < this.description.length) {
                printStream.print("#");
                printStream.println(this.description[n]);
                ++n;
            }
        }
        printStream.print(this.vertices.length);
        printStream.print(" ");
        printStream.print(this.ifaces.length);
        printStream.print(" ");
        if (this.edges != null) {
            printStream.println(this.edges.length);
        } else {
            printStream.println(0);
        }
        n = 0;
        while (n < this.vertices.length) {
            Vector3D vector3D = this.vertices[n];
            printStream.print(Fmt.fmt(Polyhedron.chop(vector3D.x), 18, 15));
            printStream.print(" ");
            printStream.print(Fmt.fmt(Polyhedron.chop(vector3D.y), 18, 15));
            printStream.print(" ");
            printStream.println(Fmt.fmt(Polyhedron.chop(vector3D.z), 18, 15));
            ++n;
        }
        int n2 = 0;
        while (n2 < this.ifaces.length) {
            int[] nArray = this.ifaces[n2];
            printStream.print(nArray.length);
            printStream.print(" ");
            int n3 = 0;
            while (n3 < nArray.length) {
                printStream.print(nArray[n3]);
                printStream.print(" ");
                ++n3;
            }
            Color color = this.getColor(n2);
            printStream.print(color.getRed());
            printStream.print(" ");
            printStream.print(color.getGreen());
            printStream.print(" ");
            printStream.println(color.getBlue());
            ++n2;
        }
    }

    private void writeDXFTriangle(PrintStream printStream, Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        printStream.print("0\n3DFACE\n8\n0\n");
        printStream.print("10\n");
        printStream.print(Polyhedron.chop(vector3D.x));
        printStream.print("\n20\n");
        printStream.print(Polyhedron.chop(vector3D.y));
        printStream.print("\n30\n");
        printStream.print(Polyhedron.chop(vector3D.z));
        printStream.print("\n11\n");
        printStream.print(Polyhedron.chop(vector3D2.x));
        printStream.print("\n21\n");
        printStream.print(Polyhedron.chop(vector3D2.y));
        printStream.print("\n31\n");
        printStream.print(Polyhedron.chop(vector3D2.z));
        printStream.print("\n12\n");
        printStream.print(Polyhedron.chop(vector3D3.x));
        printStream.print("\n22\n");
        printStream.print(Polyhedron.chop(vector3D3.y));
        printStream.print("\n32\n");
        printStream.print(Polyhedron.chop(vector3D3.z));
        printStream.print("\n13\n");
        printStream.print(Polyhedron.chop(vector3D.x));
        printStream.print("\n23\n");
        printStream.print(Polyhedron.chop(vector3D.y));
        printStream.print("\n33\n");
        printStream.print(Polyhedron.chop(vector3D.z));
        printStream.print("\n");
    }

    private void writeDXFQuadrangle(PrintStream printStream, Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4) {
        printStream.print("0\n3DFACE\n8\n0\n");
        printStream.print("10\n");
        printStream.print(Polyhedron.chop(vector3D.x));
        printStream.print("\n20\n");
        printStream.print(Polyhedron.chop(vector3D.y));
        printStream.print("\n30\n");
        printStream.print(Polyhedron.chop(vector3D.z));
        printStream.print("\n11\n");
        printStream.print(Polyhedron.chop(vector3D2.x));
        printStream.print("\n21\n");
        printStream.print(Polyhedron.chop(vector3D2.y));
        printStream.print("\n31\n");
        printStream.print(Polyhedron.chop(vector3D2.z));
        printStream.print("\n12\n");
        printStream.print(Polyhedron.chop(vector3D3.x));
        printStream.print("\n22\n");
        printStream.print(Polyhedron.chop(vector3D3.y));
        printStream.print("\n32\n");
        printStream.print(Polyhedron.chop(vector3D3.z));
        printStream.print("\n13\n");
        printStream.print(Polyhedron.chop(vector3D4.x));
        printStream.print("\n23\n");
        printStream.print(Polyhedron.chop(vector3D4.y));
        printStream.print("\n33\n");
        printStream.print(Polyhedron.chop(vector3D4.z));
        printStream.print("\n");
    }

    private void writeDXFFace(PrintStream printStream, int[] nArray) {
        if (nArray.length == 3) {
            this.writeDXFTriangle(printStream, this.vertices[nArray[0]], this.vertices[nArray[1]], this.vertices[nArray[2]]);
        } else if (nArray.length == 4) {
            this.writeDXFQuadrangle(printStream, this.vertices[nArray[0]], this.vertices[nArray[1]], this.vertices[nArray[2]], this.vertices[nArray[3]]);
        } else if (nArray.length > 4) {
            this.writeDXFQuadrangle(printStream, this.vertices[nArray[0]], this.vertices[nArray[1]], this.vertices[nArray[2]], this.vertices[nArray[3]]);
            int n = 4;
            while (n < nArray.length) {
                this.writeDXFTriangle(printStream, this.vertices[nArray[0]], this.vertices[nArray[n - 1]], this.vertices[nArray[n]]);
                ++n;
            }
        }
    }

    public void writeDXF(OutputStream outputStream) {
        int n;
        PrintStream printStream = new PrintStream(outputStream);
        if (this.description != null) {
            n = 0;
            while (n < this.description.length) {
                printStream.print("999\n");
                printStream.print(this.description[n] + "\n");
                ++n;
            }
        }
        printStream.print(DXFHeader);
        n = 0;
        while (n < this.ifaces.length) {
            this.writeDXFFace(printStream, this.ifaces[n]);
            ++n;
        }
        printStream.print(DXFTail);
    }

    public float[][] getCoordinates() {
        float[][] fArray = new float[this.vertices.length][3];
        int n = this.vertices.length;
        int n2 = 0;
        while (n2 < n) {
            this.vertices[n2].getCoord(fArray[n2]);
            ++n2;
        }
        return fArray;
    }

    public void generateRandomColors(int n) {
        this.colors = new Color[n];
        float f = (float)Math.random();
        int n2 = 0;
        while (n2 < n) {
            this.colors[n2] = Color.getHSBColor(f, 0.5f, 0.9f);
            if ((f += 1.0f / (float)n) > 1.0f) {
                f -= 1.0f;
            }
            ++n2;
        }
    }

    double faceArea(int n) {
        Vector3D vector3D = new Vector3D();
        int[] nArray = this.ifaces[n];
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < nArray.length) {
            vector3D.addSet(this.vertices[nArray[n3]].cross(this.vertices[nArray[(n3 + 1) % n2]]));
            ++n3;
        }
        vector3D.mulSet(0.5);
        return vector3D.length();
    }

    int findAreaColorIndex(Vector vector, double d) {
        int n = 0;
        while (n < vector.size()) {
            double d2 = (Double)vector.elementAt(n);
            if (Math.abs(d2 - d) < 0.001) {
                return n;
            }
            ++n;
        }
        vector.addElement(new Double(d));
        return vector.size() - 1;
    }

    public int paintFacesByArea() {
        Vector vector = new Vector();
        this.icolor = new int[this.ifaces.length];
        int n = 0;
        while (n < this.ifaces.length) {
            this.icolor[n] = this.findAreaColorIndex(vector, this.faceArea(n));
            ++n;
        }
        QSort.quickSort(vector, 0, vector.size() - 1, (Comparator)new DoubleComparator());
        int n2 = 0;
        while (n2 < this.ifaces.length) {
            this.icolor[n2] = this.findAreaColorIndex(vector, this.faceArea(n2));
            ++n2;
        }
        return vector.size();
    }

    int countIndex() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.ifaces.length) {
            n += this.ifaces[n2].length + 1;
            ++n2;
        }
        return n;
    }

    float[][] getVrmlColors() {
        if (this.colors != null) {
            float[][] fArray = new float[this.colors.length][3];
            int n = 0;
            while (n < fArray.length) {
                Color color = this.colors[n];
                fArray[n][0] = (float)((double)color.getRed() / 255.0);
                fArray[n][1] = (float)((double)color.getGreen() / 255.0);
                fArray[n][2] = (float)((double)color.getBlue() / 255.0);
                ++n;
            }
            return fArray;
        }
        return null;
    }

    public String getVrmlString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        this.writeVrml(printStream);
        return byteArrayOutputStream.toString();
    }

    public void writeVrml(PrintStream printStream) {
        int n;
        printStream.print("#VRML V2.0 utf8\n");
        if (this.description != null) {
            n = 0;
            while (n < this.description.length) {
                printStream.print("#");
                printStream.println(this.description[n]);
                ++n;
            }
        }
        printStream.print("NavigationInfo {\n\ttype \"EXAMINE\"\n\theadlight TRUE\n}\n");
        if (outEdges) {
            n = 0;
            while (n < VRMLEdge.length) {
                printStream.println(VRMLEdge[n]);
                ++n;
            }
        }
        printStream.print("PROTO Piece [\n]{\nGroup {\n children [\n");
        if (outFaces) {
            this.writeVRMLIndexedFaceSet(printStream);
        }
        if (outEdges) {
            n = 0;
            while (n < this.edges.length) {
                printStream.print("Edge{start ");
                Vector3D vector3D = this.vertices[this.edges[n][0]];
                printStream.print(Fmt.fmt(Polyhedron.chop(vector3D.x), 8, 6));
                printStream.print(" ");
                printStream.print(Fmt.fmt(Polyhedron.chop(vector3D.y), 8, 6));
                printStream.print(" ");
                printStream.print(Fmt.fmt(Polyhedron.chop(vector3D.z), 8, 6));
                printStream.print(" ");
                printStream.print("end ");
                vector3D = this.vertices[this.edges[n][1]];
                printStream.print(Fmt.fmt(Polyhedron.chop(vector3D.x), 8, 6));
                printStream.print(" ");
                printStream.print(Fmt.fmt(Polyhedron.chop(vector3D.y), 8, 6));
                printStream.print(" ");
                printStream.print(Fmt.fmt(Polyhedron.chop(vector3D.z), 8, 6));
                printStream.print(" ");
                printStream.print("}\n");
                ++n;
            }
        }
        printStream.print("]\n}\n}\n");
        printStream.print("Piece{}\n");
    }

    void writeVRMLIndexedFaceSet(PrintStream printStream) {
        printStream.println("Shape {");
        printStream.println("  geometry IndexedFaceSet {");
        printStream.println("    solid TRUE");
        printStream.println("    creaseAngle 0");
        printStream.println("    coord Coordinate {");
        printStream.println("      point[");
        int n = 0;
        while (n < this.vertices.length) {
            printStream.print("      ");
            printStream.print(Fmt.fmt(Polyhedron.chop(this.vertices[n].x), 8, 6));
            printStream.print(" ");
            printStream.print(Fmt.fmt(Polyhedron.chop(this.vertices[n].y), 8, 6));
            printStream.print(" ");
            printStream.print(Fmt.fmt(Polyhedron.chop(this.vertices[n].z), 8, 6));
            printStream.println("");
            ++n;
        }
        printStream.println("      ]");
        printStream.println("    }");
        printStream.println("    coordIndex [");
        int n2 = 0;
        while (n2 < this.ifaces.length) {
            printStream.print("      ");
            int n3 = 0;
            while (n3 < this.ifaces[n2].length) {
                printStream.print(this.ifaces[n2][n3]);
                printStream.print(" ");
                ++n3;
            }
            printStream.println("-1");
            ++n2;
        }
        printStream.println("    ]");
        printStream.println("  }");
        printStream.println("  appearance Appearance {");
        printStream.println("    material Material{");
        printStream.println("      diffuseColor 0.3 0.5 0.9");
        printStream.println("    }");
        printStream.println("  }");
        printStream.println("}");
    }

    static double chop(double d) {
        if (d > -tolerance && d < tolerance) {
            return 0.0;
        }
        return d;
    }

    public void printVertices(PrintStream printStream) {
        int n = this.vertices.length;
        int n2 = 0;
        while (n2 < n) {
            printStream.print(Fmt.fmt(Polyhedron.chop(this.vertices[n2].x), 18, 15));
            printStream.print(" ");
            printStream.print(Fmt.fmt(Polyhedron.chop(this.vertices[n2].y), 18, 15));
            printStream.print(" ");
            printStream.println(Fmt.fmt(Polyhedron.chop(this.vertices[n2].z), 18, 15));
            ++n2;
        }
    }

    public void printFaceCenters(PrintStream printStream) {
    }

    public void printEdges(PrintStream printStream) {
    }

    public void printEdgeCenters(PrintStream printStream) {
    }

    public void writePOV(PrintStream printStream) {
        int n;
        int[] nArray;
        int n2;
        if (this.description != null) {
            n2 = 0;
            while (n2 < this.description.length) {
                printStream.print("// ");
                printStream.println(this.description[n2]);
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < POVStart.length) {
            printStream.println(POVStart[n2]);
            ++n2;
        }
        printStream.print("#declare PolyRadius = ");
        printStream.println(this.getRadius() + ";");
        int n3 = this.vertices.length;
        int n4 = 0;
        while (n4 < n3) {
            printStream.print("#declare V");
            printStream.print(n4);
            printStream.print(" = <");
            Vector3D vector3D = this.vertices[n4];
            printStream.print(Fmt.fmt(Polyhedron.chop(vector3D.x), 18, 16));
            printStream.print(",");
            printStream.print(Fmt.fmt(Polyhedron.chop(vector3D.y), 18, 16));
            printStream.print(",");
            printStream.print(Fmt.fmt(Polyhedron.chop(vector3D.z), 18, 16));
            printStream.println(">;");
            ++n4;
        }
        if (outFaces) {
            int n5 = 0;
            while (n5 < this.ifaces.length) {
                printStream.print("polygon {");
                nArray = this.ifaces[n5];
                printStream.print(nArray.length + 1);
                printStream.print(",");
                n = 0;
                while (n < nArray.length) {
                    printStream.print("V");
                    printStream.print(nArray[n]);
                    printStream.print(",");
                    ++n;
                }
                printStream.print("V");
                printStream.print(nArray[0]);
                printStream.println(" texture{TextureF}}");
                ++n5;
            }
        }
        if (outEdges) {
            if (this.edges.length == 0) {
                int n6 = 0;
                while (n6 < this.ifaces.length) {
                    nArray = this.ifaces[n6];
                    n = 0;
                    while (n < nArray.length) {
                        printStream.print("cylinder{V");
                        printStream.print(nArray[n]);
                        printStream.print(",V");
                        printStream.print(nArray[(n + 1) % nArray.length]);
                        printStream.println(",RadiusE open texture {TextureE}}");
                        ++n;
                    }
                    ++n6;
                }
            } else {
                int n7 = 0;
                while (n7 < this.edges.length) {
                    printStream.print("cylinder{V");
                    printStream.print(this.edges[n7][0]);
                    printStream.print(",V");
                    printStream.print(this.edges[n7][1]);
                    printStream.println(",RadiusE open texture {TextureE}}");
                    ++n7;
                }
            }
        }
        int n8 = 0;
        while (n8 < POVEnd.length) {
            printStream.println(POVEnd[n8]);
            ++n8;
        }
    }

    int findVertex(Vector vector, Vector3D vector3D) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (((Vector3D)vector.elementAt(n2)).equals(vector3D)) {
                return n2;
            }
            ++n2;
        }
        vector.addElement(vector3D);
        return n;
    }

    void clearDoubleVertices() {
        Vector3D[] vector3DArray = this.vertices;
        Vector vector = new Vector();
        int[] nArray = new int[this.vertices.length];
        int n = 0;
        while (n < this.vertices.length) {
            nArray[n] = this.findVertex(vector, vector3DArray[n]);
            ++n;
        }
        this.vertices = new Vector3D[vector.size()];
        vector.copyInto(this.vertices);
        int n2 = 0;
        while (n2 < this.ifaces.length) {
            int[] nArray2 = this.ifaces[n2];
            int n3 = 0;
            while (n3 < nArray2.length) {
                nArray2[n3] = nArray[nArray2[n3]];
                ++n3;
            }
            ++n2;
        }
    }

    public double getRadius() {
        double d = 0.0;
        int n = 0;
        while (n < this.vertices.length) {
            double d2 = this.vertices[n].length2();
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return Math.sqrt(d);
    }

    void addPoly(Polyhedron polyhedron) {
        int n;
        Object object;
        int n2;
        int[] nArray;
        Object object2;
        if (this.vertices == null) {
            this.vertices = polyhedron.vertices;
            this.ifaces = polyhedron.ifaces;
            this.colors = polyhedron.colors;
            this.icolor = polyhedron.icolor;
            this.clearDoubleVertices();
            return;
        }
        Vector3D[] vector3DArray = this.vertices;
        int n3 = vector3DArray.length;
        int n4 = polyhedron.vertices.length;
        int[] nArray2 = new int[n4];
        Vector<Vector3D> vector = new Vector<Vector3D>();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        int n5 = 0;
        while (n5 < this.vertices.length) {
            VectorIndex vectorIndex = new VectorIndex(n5, this.vertices[n5]);
            hashtable.put(vectorIndex, vectorIndex);
            ++n5;
        }
        int n6 = 0;
        while (n6 < n4) {
            Vector3D vector3D = polyhedron.vertices[n6];
            object2 = new VectorIndex(n6, vector3D);
            VectorIndex vectorIndex = (VectorIndex)hashtable.get(object2);
            if (vectorIndex == null) {
                ((VectorIndex)object2).index = this.vertices.length + vector.size();
                hashtable.put(object2, object2);
                vector.addElement(vector3D);
                nArray2[n6] = ((VectorIndex)object2).index;
            } else {
                nArray2[n6] = vectorIndex.index;
            }
            ++n6;
        }
        this.vertices = new Vector3D[vector3DArray.length + vector.size()];
        System.arraycopy(vector3DArray, 0, this.vertices, 0, vector3DArray.length);
        int n7 = 0;
        while (n7 < vector.size()) {
            this.vertices[n7 + n3] = (Vector3D)vector.elementAt(n7);
            ++n7;
        }
        object2 = this.ifaces;
        this.ifaces = new int[((Object)object2).length + polyhedron.ifaces.length][];
        System.arraycopy(object2, 0, this.ifaces, 0, ((Object)object2).length);
        System.arraycopy(polyhedron.ifaces, 0, this.ifaces, ((Object)object2).length, polyhedron.ifaces.length);
        int n8 = ((Object)object2).length;
        while (n8 < this.ifaces.length) {
            nArray = this.ifaces[n8];
            n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2] = nArray2[nArray[n2]];
                ++n2;
            }
            ++n8;
        }
        nArray = new int[polyhedron.colors.length];
        n2 = 0;
        while (n2 < polyhedron.colors.length) {
            block12: {
                object = polyhedron.colors[n2];
                n = this.colors.length - 1;
                while (n >= 0) {
                    if (this.colors[n].equals(object)) {
                        nArray[n2] = n;
                        break block12;
                    }
                    --n;
                }
                Color[] colorArray = new Color[this.colors.length + 1];
                System.arraycopy(this.colors, 0, colorArray, 0, this.colors.length);
                colorArray[this.colors.length] = object;
                nArray[n2] = this.colors.length;
                this.colors = colorArray;
            }
            ++n2;
        }
        object = this.icolor;
        this.icolor = new int[((int[])object).length + polyhedron.icolor.length];
        System.arraycopy(object, 0, this.icolor, 0, ((int[])object).length);
        System.arraycopy(polyhedron.icolor, 0, this.icolor, ((int[])object).length, polyhedron.icolor.length);
        n = ((int[])object).length;
        while (n < this.icolor.length) {
            this.icolor[n] = nArray[this.icolor[n]];
            ++n;
        }
    }

    static void writeToFile(Polyhedron polyhedron, String string, String string2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            if (string2.equals("Vrml2")) {
                polyhedron.writeVrml(printStream);
            } else if (string2.equals("POV")) {
                polyhedron.writePOV(printStream);
            } else if (string2.equals("OFF")) {
                polyhedron.writeOFF(printStream);
            }
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(Out);
        }
    }

    public void writeToFile(String string, String string2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            if (string2.equals("Vrml2")) {
                this.writeVrml(printStream);
            } else if (string2.equals("POV")) {
                this.writePOV(printStream);
            } else if (string2.equals("OFF")) {
                this.writeOFF(printStream);
            }
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(Out);
        }
    }

    static String getPostfix(String string) {
        if (string.equals("Vrml2")) {
            return ".wrl";
        }
        if (string.equals("OFF")) {
            return ".off";
        }
        if (string.equals("POV")) {
            return ".inc";
        }
        return "";
    }

    public static String makeFileName(String string, String string2, int n, int n2) {
        String string3 = Polyhedron.getPostfix(string2);
        String string4 = "";
        if (n2 > 0) {
            string4 = Integer.toString(n2, 10);
            String string5 = Integer.toString(n, 10);
            int n3 = string4.length() - string5.length();
            return string + zeroes.substring(0, n3) + string5 + string3;
        }
        return string + Integer.toString(n, 10) + string3;
    }

    double getArea(int[] nArray) {
        Vector3D vector3D = new Vector3D(0.0, 0.0, 0.0);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            vector3D.addSet(this.vertices[nArray[n2]].cross(this.vertices[nArray[(n2 + 1) % n]]));
            ++n2;
        }
        vector3D.mulSet(0.5);
        return vector3D.length();
    }

    boolean isCollinerar(int[] nArray) {
        double d = this.getArea(nArray);
        return d < 0.001;
    }
}

