/*
 * Decompiled with CFR 0.152.
 */
package PVS.polyhedra;

import Jama.Matrix;
import PVS.Utils.Fmt;
import PVS.polyhedra.Vector3D;

public class Plane {
    public Vector3D v;
    public double d;
    public int index;
    static Vector3D direction = new Vector3D(3.1415926, Math.E, 1.718281828459045);
    static final double TOLERANCE = 1.0E-10;
    static double TOL = 1.0E-10;

    public Plane(Vector3D vector3D, double d, int n) {
        this.d = d;
        this.v = vector3D;
        this.index = n;
    }

    public Plane(Vector3D vector3D, double d) {
        this(vector3D, d, 0);
    }

    public Plane(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        this(vector3D, vector3D2, vector3D3, 0);
    }

    public Plane(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, int n) {
        this.index = n;
        Vector3D vector3D4 = vector3D3.sub(vector3D2).cross(vector3D.sub(vector3D2));
        vector3D4.normalize();
        double d = vector3D4.dot(vector3D2);
        this.v = vector3D4;
        this.d = d;
        if (this.d < -1.0E-10) {
            this.d = -this.d;
            this.v.x = -this.v.x;
            this.v.y = -this.v.y;
            this.v.z = -this.v.z;
        } else if (this.d < 1.0E-10) {
            this.d = 0.0;
            if (this.v.dot(direction) < 0.0) {
                this.v.x = -this.v.x;
                this.v.y = -this.v.y;
                this.v.z = -this.v.z;
            }
        }
    }

    public int hashCode() {
        int n = (int)(3345.563 * this.v.x) + (int)(4345.891 * this.v.y) + (int)(7341.678 * this.v.z) + (int)(4134.178 * this.d);
        return n;
    }

    public boolean equals(Object object) {
        double d;
        double d2;
        double d3;
        if (object == this) {
            return true;
        }
        Plane plane = (Plane)object;
        double d4 = this.v.x - plane.v.x;
        if (d4 < 0.0) {
            d4 = -d4;
        }
        if ((d3 = this.v.y - plane.v.y) < 0.0) {
            d3 = -d3;
        }
        if ((d2 = this.v.z - plane.v.z) < 0.0) {
            d2 = -d2;
        }
        if ((d = this.d - plane.d) < 0.0) {
            d = -d;
        }
        return d4 < 1.0E-10 && d3 < 1.0E-10 && d2 < 1.0E-10 && d < 1.0E-10;
    }

    static double chop(double d) {
        if (d < TOL && d > -TOL) {
            return 0.0;
        }
        return d;
    }

    public String toString() {
        return "{" + Fmt.fmt(Plane.chop(this.v.x), 8, 5) + " " + Fmt.fmt(Plane.chop(this.v.y), 8, 5) + " " + Fmt.fmt(Plane.chop(this.v.z), 8, 5) + " " + Fmt.fmt(Plane.chop(this.d), 8, 5) + "}";
    }

    double distance(double d, double d2, double d3) {
        return d * this.v.x + d2 * this.v.y + d3 * this.v.z - this.d;
    }

    static Vector3D intersect(Plane plane, Plane plane2, Plane plane3) {
        try {
            double[][] dArrayArray = new double[][]{{plane.v.x, plane.v.y, plane.v.z}, {plane2.v.x, plane2.v.y, plane2.v.z}, {plane3.v.x, plane3.v.y, plane3.v.z}};
            double[][] dArrayArray2 = new double[][]{{plane.d}, {plane2.d}, {plane3.d}};
            Matrix matrix = new Matrix(dArrayArray);
            Matrix matrix2 = new Matrix(dArrayArray2);
            Matrix matrix3 = matrix.solve(matrix2);
            double[][] dArray = matrix3.getArray();
            return new Vector3D(dArray[0][0], dArray[1][0], dArray[2][0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static Plane getRandomPlane() {
        return new Plane(new Vector3D(Math.random(), Math.random(), Math.random()).normalize(), Math.random(), 0);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < 100000) {
            Plane plane;
            Plane plane2;
            Plane plane3 = Plane.getRandomPlane();
            Vector3D vector3D = Plane.intersect(plane3, plane2 = Plane.getRandomPlane(), plane = Plane.getRandomPlane());
            if (vector3D == null) {
                ++n;
            } else {
                double d3 = plane3.distance(vector3D.x, vector3D.y, vector3D.z);
                double d4 = plane2.distance(vector3D.x, vector3D.y, vector3D.z);
                double d5 = plane.distance(vector3D.x, vector3D.y, vector3D.z);
                double d6 = Math.abs(d3) + Math.abs(d4) + Math.abs(d5);
                if (d6 > d) {
                    d = d6;
                    d2 = vector3D.length();
                }
            }
            ++n2;
        }
        System.out.println("no intersection: " + n);
        System.out.println("maxerr: " + d);
        System.out.println("maxrad: " + d2);
    }
}

