/*
 * Decompiled with CFR 0.152.
 */
package PVS.polyhedra;

import PVS.polyhedra.Vector3D;

public class Matrix3D {
    public double[][] m = new double[3][3];
    private double determinant = 0.0;
    private boolean isDeterminantInitialized = false;

    public Matrix3D() {
        this.m[2][2] = 1.0;
        this.m[1][1] = 1.0;
        this.m[0][0] = 1.0;
    }

    public Matrix3D(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.m[0][0] = d;
        this.m[0][1] = d2;
        this.m[0][2] = d3;
        this.m[1][0] = d4;
        this.m[1][1] = d5;
        this.m[1][2] = d6;
        this.m[2][0] = d7;
        this.m[2][1] = d8;
        this.m[2][2] = d9;
    }

    public Matrix3D(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        this.m[0][0] = vector3D.x;
        this.m[0][1] = vector3D2.x;
        this.m[0][2] = vector3D3.x;
        this.m[1][0] = vector3D.y;
        this.m[1][1] = vector3D2.y;
        this.m[1][2] = vector3D3.y;
        this.m[2][0] = vector3D.z;
        this.m[2][1] = vector3D2.z;
        this.m[2][2] = vector3D3.z;
    }

    public static Matrix3D reflection(Vector3D vector3D) {
        return new Matrix3D(new Vector3D(1.0, 0.0, 0.0).reflect(vector3D, 0.0), new Vector3D(0.0, 1.0, 0.0).reflect(vector3D, 0.0), new Vector3D(0.0, 0.0, 1.0).reflect(vector3D, 0.0));
    }

    public static Matrix3D rotation(Vector3D vector3D, double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = 1.0 - d2;
        vector3D.normalize();
        double d5 = vector3D.x;
        double d6 = vector3D.y;
        double d7 = vector3D.z;
        return new Matrix3D(d4 * d5 * d5 + d2, d4 * d5 * d6 - d3 * d7, d4 * d5 * d7 + d3 * d6, d4 * d5 * d6 + d3 * d7, d4 * d6 * d6 + d2, d4 * d6 * d7 - d3 * d5, d4 * d5 * d7 - d3 * d6, d4 * d6 * d7 + d3 * d5, d4 * d7 * d7 + d2);
    }

    public Matrix3D mul(Matrix3D matrix3D) {
        double[][] dArray = matrix3D.m;
        return new Matrix3D(this.m[0][0] * dArray[0][0] + this.m[0][1] * dArray[1][0] + this.m[0][2] * dArray[2][0], this.m[0][0] * dArray[0][1] + this.m[0][1] * dArray[1][1] + this.m[0][2] * dArray[2][1], this.m[0][0] * dArray[0][2] + this.m[0][1] * dArray[1][2] + this.m[0][2] * dArray[2][2], this.m[1][0] * dArray[0][0] + this.m[1][1] * dArray[1][0] + this.m[1][2] * dArray[2][0], this.m[1][0] * dArray[0][1] + this.m[1][1] * dArray[1][1] + this.m[1][2] * dArray[2][1], this.m[1][0] * dArray[0][2] + this.m[1][1] * dArray[1][2] + this.m[1][2] * dArray[2][2], this.m[2][0] * dArray[0][0] + this.m[2][1] * dArray[1][0] + this.m[2][2] * dArray[2][0], this.m[2][0] * dArray[0][1] + this.m[2][1] * dArray[1][1] + this.m[2][2] * dArray[2][1], this.m[2][0] * dArray[0][2] + this.m[2][1] * dArray[1][2] + this.m[2][2] * dArray[2][2]);
    }

    public double getDeterminant() {
        if (this.isDeterminantInitialized) {
            return this.determinant;
        }
        this.isDeterminantInitialized = true;
        this.determinant = this.m[0][0] * (this.m[1][1] * this.m[2][2] - this.m[1][2] * this.m[2][1]) - this.m[1][0] * (this.m[0][1] * this.m[2][2] - this.m[2][1] * this.m[0][2]) + this.m[2][0] * (this.m[0][1] * this.m[1][2] - this.m[1][1] * this.m[0][2]);
        return this.determinant;
    }
}

