/*
 * Decompiled with CFR 0.152.
 */
package PVS.g3d;

import PVS.Utils.Fmt;

public class Vec3 {
    public double x;
    public double y;
    public double z;
    static double TOL = 1.0E-10;
    static final double tolerance = 1.0E-6;

    public Vec3() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Vec3(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public static double dot(Vec3 vec3, Vec3 vec32) {
        return vec3.x * vec32.x + vec3.y * vec32.y + vec3.z * vec32.z;
    }

    public double dot(Vec3 vec3) {
        return this.x * vec3.x + this.y * vec3.y + this.z * vec3.z;
    }

    public static Vec3 cross(Vec3 vec3, Vec3 vec32) {
        return new Vec3(vec3.y * vec32.z - vec3.z * vec32.y, vec3.z * vec32.x - vec3.x * vec32.z, vec3.x * vec32.y - vec3.y * vec32.x);
    }

    public Vec3 cross(Vec3 vec3) {
        double d = this.y * vec3.z - this.z * vec3.y;
        double d2 = this.z * vec3.x - this.x * vec3.z;
        double d3 = this.x * vec3.y - this.y * vec3.x;
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Vec3 add(Vec3 vec3) {
        this.x += vec3.x;
        this.y += vec3.y;
        this.z += vec3.z;
        return this;
    }

    public Vec3 mul(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    public double normalize() {
        double d = this.length();
        this.x /= d;
        this.y /= d;
        this.z /= d;
        return d;
    }

    public double length() {
        return Math.sqrt(this.length2());
    }

    public double length2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    static double chop(double d) {
        if (d < TOL && d > -TOL) {
            return 0.0;
        }
        return d;
    }

    public String toString() {
        return "{" + Fmt.fmt(Vec3.chop(this.x), 8, 5) + " " + Fmt.fmt(Vec3.chop(this.y), 8, 5) + " " + Fmt.fmt(Vec3.chop(this.z), 8, 5) + "}";
    }

    public int hashCode() {
        int n = (int)(331345.563 * this.x) + (int)(412345.891 * this.y) + (int)(71341.678 * this.z);
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        Vec3 vec3 = (Vec3)object;
        double d = vec3.x - this.x;
        double d2 = vec3.y - this.y;
        double d3 = vec3.z - this.z;
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d3 < 0.0) {
            d3 = -d3;
        }
        return d < 1.0E-6 && d2 < 1.0E-6 && d3 < 1.0E-6;
    }
}

