/*
 * Decompiled with CFR 0.152.
 */
package PVS.g3d;

import PVS.Utils.FastHashtable;
import PVS.Utils.FastVector;
import PVS.Utils.Fmt;
import PVS.g3d.Canvas3D;
import PVS.g3d.Face;
import PVS.g3d.Model3D;
import PVS.g3d.Vec3;
import PVS.polyhedra.Vector3D;
import java.awt.Color;
import java.awt.Graphics;

public class Stellation3D
extends Model3D {
    Vec3[] planes;
    Vec3[] tplanes;
    int[] index1;
    int[] index2;
    int[] index3;
    int[] sortedFaces;
    byte[][] facePlaneDist;
    double[] zcompOld;
    Color[] colors;
    private static final double Z_EMPTY = 1.23454567456E20;
    private static final double EPS = 1.0E-6;

    public Stellation3D(double[] dArray, int[][] nArray, int[][] nArray2, Color[] colorArray, int[] nArray3, String string, Vector3D[] vector3DArray) {
        super(dArray, nArray, nArray2, colorArray, nArray3);
        this.planes = new Vec3[vector3DArray.length];
        this.tplanes = new Vec3[vector3DArray.length];
        this.zcompOld = new double[vector3DArray.length];
        int n = 0;
        while (n < vector3DArray.length) {
            this.planes[n] = new Vec3(vector3DArray[n].x, vector3DArray[n].y, vector3DArray[n].z);
            this.tplanes[n] = new Vec3();
            this.zcompOld[n] = 1.23454567456E20;
            ++n;
        }
        this.initFacePlaneDist();
        this.index1 = new int[this.face.length];
        int n2 = 0;
        while (n2 < this.index1.length) {
            this.index1[n2] = n2;
            ++n2;
        }
        this.index2 = new int[this.face.length];
        this.index3 = new int[this.face.length];
    }

    private void initFacePlaneDist() {
        int n = 0;
        while (n < this.nfaces) {
            Face face = this.face[n];
            int n2 = face.nverts;
            int[] nArray = face.index;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray[n3];
                d += this.vert[n4];
                d2 += this.vert[n4 + 1];
                d3 += this.vert[n4 + 2];
                ++n3;
            }
            face.center = new Vec3(d / (double)face.nverts, d2 / (double)face.nverts, d3 / (double)face.nverts);
            face.findex = n++;
        }
        this.facePlaneDist = new byte[this.planes.length][this.face.length];
        int n5 = 0;
        while (n5 < this.planes.length) {
            Vec3 vec3 = this.planes[n5];
            int n6 = 0;
            while (n6 < this.face.length) {
                Vec3 vec32 = this.face[n6].center;
                double d = Vec3.dot(vec3, vec32) - vec3.length2();
                if (d < -1.0E-6) {
                    this.facePlaneDist[n5][n6] = -1;
                } else if (d > 1.0E-6) {
                    this.facePlaneDist[n5][n6] = 1;
                }
                ++n6;
            }
            ++n5;
        }
    }

    void init() {
        this.findex = new int[this.nfaces];
        int n = 0;
        while (n < this.nfaces) {
            this.findex[n] = n;
            ++n;
        }
        this.gr = new Color[this.nfaces];
        FastHashtable fastHashtable = new FastHashtable();
        FastVector fastVector = new FastVector();
        FastVector fastVector2 = new FastVector();
        int n2 = 0;
        while (n2 < this.nfaces) {
            Face face = this.face[n2];
            int n3 = face.nverts;
            int[] nArray = face.index;
            if (nArray.length >= 3) {
                int n4 = nArray[0];
                int n5 = nArray[1];
                int n6 = nArray[2];
                Vec3 vec3 = new Vec3(this.vert[n5] - this.vert[n4], this.vert[n5 + 1] - this.vert[n4 + 1], this.vert[n5 + 2] - this.vert[n4 + 2]);
                Vec3 vec32 = new Vec3(this.vert[n6] - this.vert[n5], this.vert[n6 + 1] - this.vert[n5 + 1], this.vert[n6 + 2] - this.vert[n5 + 2]);
                Vec3 vec33 = Vec3.cross(vec32, vec3);
                vec33.normalize();
                Object object = fastHashtable.get(vec33);
                if (object == null) {
                    this.face[n2].nindex = fastVector.size();
                    fastHashtable.put(vec33, new Integer(this.face[n2].nindex));
                    fastVector.addElement(vec33);
                    Vec3 vec34 = new Vec3();
                    fastVector2.addElement(vec34);
                } else {
                    this.face[n2].nindex = (Integer)object;
                }
            }
            this.gr[n2] = new Color(this.face[n2].cr, this.face[n2].cg, this.face[n2].cb);
            ++n2;
        }
        this.normals = new Vec3[fastVector.size()];
        fastVector.copyInto(this.normals);
        this.tnormals = new Vec3[fastVector2.size()];
        fastVector2.copyInto(this.tnormals);
        this.colors = new Color[fastVector2.size()];
    }

    public void setCanvas(Canvas3D canvas3D) {
        super.setCanvas(canvas3D);
        if (canvas3D.canvas != null) {
            // empty if block
        }
    }

    public void clearCanvas(Canvas3D canvas3D) {
        if (canvas3D.canvas != null) {
            // empty if block
        }
    }

    public void paint(Graphics graphics) {
        this.paintSlow(graphics);
    }

    void paintSlow(Graphics graphics) {
        int n;
        if (this.canvas != null) {
            if (this.canvas.displayType == 1 || this.canvas.displayType == 2) {
                this.drawAnaglyph = true;
                this.light = this.light_anaglyph;
                this.light_color = this.light_color_anaglyph;
            } else {
                this.drawAnaglyph = false;
                this.light = this.light_normal;
                this.light_color = this.light_color_normal;
            }
        }
        if (this.vert == null || this.nverts <= 0) {
            return;
        }
        this.transform();
        int n2 = 0;
        while (n2 < this.nfaces) {
            this.face[n2].zdepth = 0.0;
            Face face = this.face[n2];
            n = face.nverts;
            int[] nArray = face.index;
            int n3 = 0;
            while (n3 < n) {
                face.zdepth += (double)this.tvert[nArray[n3] + 2];
                ++n3;
            }
            face.zdepth /= (double)face.nverts;
            ++n2;
        }
        this.card_shuffle();
        int n4 = 0;
        while (n4 < this.colors.length) {
            if (this.tnormals[n4].z > 0.0) {
                this.colors[n4] = this.makeColor(Color.white, this.tnormals[n4]);
            }
            ++n4;
        }
        n = 0;
        while (n < this.nfaces) {
            int n5 = 0;
            Face face = this.face[this.sortedFaces[n]];
            int n6 = face.nindex;
            if (this.tnormals[n6] == null || !(this.tnormals[face.nindex].z <= 0.0) || !this.canvas.drawFaces) {
                int n7 = face.nverts;
                int[] nArray = face.index;
                int n8 = 0;
                while (n8 < n7) {
                    int n9 = nArray[n8];
                    this.vx[n8] = this.tvert[n9];
                    this.vy[n8] = this.tvert[n9 + 1];
                    ++n8;
                }
                if (this.canvas.drawFaces) {
                    if (n7 >= 3) {
                        graphics.setColor(this.colors[n6]);
                        graphics.fillPolygon(this.vx, this.vy, n7);
                    } else {
                        graphics.setColor(Color.black);
                        graphics.drawLine(this.vx[0], this.vy[0], this.vx[1], this.vy[1]);
                    }
                }
                if (this.canvas.drawLines) {
                    graphics.setColor(this.drawAnaglyph && !this.canvas.drawFaces ? Color.white : Color.black);
                    --n7;
                    n5 = 0;
                    while (n5 < n7) {
                        graphics.drawLine(this.vx[n5], this.vy[n5], this.vx[n5 + 1], this.vy[n5 + 1]);
                        ++n5;
                    }
                    graphics.drawLine(this.vx[n5], this.vy[n5], this.vx[0], this.vy[0]);
                }
            }
            ++n;
        }
    }

    void card_shuffle() {
        this.sortedFaces = this.index1;
        if (!this.canvas.drawFaces) {
            return;
        }
        this.sortedFaces = this.index1;
        int n = 0;
        while (n < this.planes.length) {
            int n2;
            int n3;
            double d;
            int[] nArray = this.index1;
            int[] nArray2 = this.index2;
            int[] nArray3 = this.index3;
            int n4 = 0;
            int n5 = 0;
            this.zcompOld[n] = d = this.tplanes[n].z;
            int n6 = 0;
            while (n6 < nArray.length) {
                n3 = nArray[n6];
                n2 = this.facePlaneDist[n][nArray[n6]];
                if ((double)n2 * d > 1.0E-4) {
                    nArray2[n4] = n3;
                    ++n4;
                } else {
                    nArray3[n5] = n3;
                    ++n5;
                }
                ++n6;
            }
            n3 = 0;
            n2 = 0;
            while (n2 < n4) {
                nArray[n3++] = nArray2[n2];
                ++n2;
            }
            int n7 = 0;
            while (n7 < n5) {
                nArray[n3++] = nArray3[n7];
                ++n7;
            }
            ++n;
        }
        this.sortedFaces = this.index1;
    }

    void printFaces(Face[] faceArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            System.out.print(Fmt.fmt(faceArray[n2].findex, 3));
            ++n2;
        }
    }

    boolean isFaceInFront(int n, Face face) {
        Vec3 vec3 = this.planes[n];
        Vec3 vec32 = face.center;
        double d = (Vec3.dot(vec3, vec32) - vec3.length2()) * this.tplanes[n].z;
        return d > 0.0;
    }

    double getFrontDistance(int n, Face face) {
        Vec3 vec3 = this.planes[n];
        Vec3 vec32 = face.center;
        double d = (Vec3.dot(vec3, vec32) - vec3.length2()) * this.tplanes[n].z;
        return d;
    }

    public void transform() {
        super.transform();
        this.mat.transform(this.planes, this.tplanes, this.planes.length);
    }

    int findFaceAtPoint(int n, int n2) {
        if (this.sortedFaces == null || this.face == null) {
            return -1;
        }
        int n3 = this.nfaces - 1;
        while (n3 >= 0) {
            Face face = this.face[this.sortedFaces[n3]];
            int n4 = face.nindex;
            if (this.tnormals[n4] == null || !(this.tnormals[face.nindex].z <= 0.0)) {
                int n5 = face.nverts;
                int[] nArray = face.index;
                int n6 = 0;
                while (n6 < n5) {
                    int n7 = nArray[n6];
                    this.vx[n6] = this.tvert[n7];
                    this.vy[n6] = this.tvert[n7 + 1];
                    ++n6;
                }
                if (Stellation3D.isInsidePolygon(this.vx, this.vy, n5, n, n2)) {
                    return face.findex;
                }
            }
            --n3;
        }
        return -1;
    }

    static double MIN(double d, double d2) {
        return d < d2 ? d : d2;
    }

    static double MAX(double d, double d2) {
        return d > d2 ? d : d2;
    }

    static boolean isInsidePolygon(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = nArray[n - 1];
        int n6 = nArray2[n - 1];
        int n7 = 0;
        while (n7 < n) {
            int n8 = nArray[n7];
            int n9 = nArray2[n7];
            if ((double)n3 > Stellation3D.MIN(n6, n9) && (double)n3 <= Stellation3D.MAX(n6, n9) && (double)n2 <= Stellation3D.MAX(n5, n8) && n6 != n9) {
                int n10 = (n3 - n6) * (n8 - n5) / (n9 - n6) + n5;
                if (n5 == n8 || n2 <= n10) {
                    ++n4;
                }
            }
            n5 = n8;
            n6 = n9;
            ++n7;
        }
        return n4 % 2 != 0;
    }

    public Vector3D getFacePlane(int n) {
        Face face = this.face[n];
        int n2 = face.index[0];
        int n3 = face.index[1];
        int n4 = face.index[2];
        Vector3D vector3D = new Vector3D(this.vert[n2], this.vert[n2 + 1], this.vert[n2 + 2]);
        Vector3D vector3D2 = new Vector3D(this.vert[n3], this.vert[n3 + 1], this.vert[n3 + 2]);
        Vector3D vector3D3 = new Vector3D(this.vert[n4], this.vert[n4 + 1], this.vert[n4 + 2]);
        Vector3D vector3D4 = vector3D3.sub(vector3D2).cross(vector3D.sub(vector3D2));
        vector3D4.normalize();
        double d = vector3D4.dot(vector3D2);
        return vector3D4.mul(d);
    }
}

