/*
 * Decompiled with CFR 0.152.
 */
package PVS.g3d;

import PVS.g3d.Canvas3D;
import PVS.g3d.Face;
import PVS.g3d.Matrix3D;
import PVS.g3d.Vec3;
import java.awt.Color;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;

public class Model3D {
    Face[] face;
    boolean transformed;
    boolean gothead;
    Matrix3D mat;
    public double xmin;
    public double xmax;
    public double ymin;
    public double ymax;
    public double zmin;
    public double zmax;
    double[] vert = null;
    int nverts = 0;
    int nfaces = 0;
    int nedges = 0;
    int[] vx;
    int[] vy;
    int[] tvert;
    int[] findex;
    Color[] gr = null;
    final int MAX_VERTS = 20;
    Vec3[] normals;
    Vec3[] tnormals;
    Vec3[] light;
    Color[] light_color;
    Vec3[] light_normal = new Vec3[]{new Vec3(10.0, 0.0, 10.0), new Vec3(10.0, 10.0, 10.0), new Vec3(0.0, 10.0, 10.0)};
    Color[] light_color_normal = new Color[]{new Color(225, 0, 0), new Color(0, 225, 0), new Color(0, 0, 225)};
    Vec3[] light_anaglyph = new Vec3[]{new Vec3(10.0, 10.0, 10.0), new Vec3(-10.0, 5.0, 10.0)};
    Color[] light_color_anaglyph = new Color[]{new Color(150, 150, 150), new Color(150, 150, 150)};
    double ambient = 0.25;
    boolean drawAnaglyph = false;
    Canvas3D canvas;
    static final double CHOP = 1.0E-10;

    public Model3D() {
        this.mat = new Matrix3D();
        this.vx = new int[20];
        this.vy = new int[20];
        int n = 0;
        while (n < this.light_normal.length) {
            this.light_normal[n].normalize();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.light_anaglyph.length) {
            this.light_anaglyph[n2].normalize();
            ++n2;
        }
        this.light = this.light_normal;
        this.light_color = this.light_color_normal;
    }

    double chop(double d) {
        if (d < -1.0E-10) {
            return d;
        }
        if (d > 1.0E-10) {
            return d;
        }
        return 0.0;
    }

    public Model3D(double[] dArray, int[][] nArray, int[][] nArray2, Color[] colorArray, int[] nArray3, String string) {
        this(dArray, nArray, nArray2, colorArray, nArray3);
    }

    public Model3D(double[] dArray, int[][] nArray, int[][] nArray2, Color[] colorArray, int[] nArray3) {
        this();
        this.vert = dArray;
        this.face = new Face[nArray.length + nArray2.length];
        int n = 0;
        while (n < nArray.length) {
            Face face = new Face();
            face.nverts = nArray[n].length;
            face.index = nArray[n];
            Color color = colorArray[nArray3[n]];
            face.cr = color.getRed();
            face.cg = color.getGreen();
            face.cb = color.getBlue();
            this.face[n] = face;
            ++n;
        }
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < nArray2.length) {
            Face face;
            this.face[n3 + n2] = face = new Face(nArray2[n3], 0, 0, 0);
            ++n3;
        }
        this.nverts = this.vert.length / 3;
        this.nfaces = this.face.length;
        this.init();
    }

    public Model3D(URL uRL) {
        this();
        try {
            this.readObject(uRL.openStream());
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public Model3D(InputStream inputStream) {
        this();
        try {
            this.readObject(inputStream);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public void setCanvas(Canvas3D canvas3D) {
        this.canvas = canvas3D;
    }

    public void clearCanvas(Canvas3D canvas3D) {
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    public void readObject(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        this.gothead = false;
        block13: while (!this.gothead) {
            int n = 0;
            block14: do {
                switch (n == 0 ? streamTokenizer.nextToken() : n) {
                    default: {
                        break;
                    }
                    case 10: {
                        n = -2;
                        continue block14;
                    }
                    case -3: {
                        if ("OFF".equals(streamTokenizer.sval)) {
                            this.nverts = 0;
                            this.nfaces = 0;
                            this.nedges = 0;
                            while (streamTokenizer.nextToken() == 10) {
                            }
                            if (streamTokenizer.ttype != -2) {
                                throw new IOException("Can't read OFF file");
                            }
                            this.nverts = (int)streamTokenizer.nval;
                            if (streamTokenizer.nextToken() != -2) {
                                throw new IOException("Can't read OFF file");
                            }
                            this.nfaces = (int)streamTokenizer.nval;
                            if (streamTokenizer.nextToken() != -2) {
                                throw new IOException("Can't read OFF file");
                            }
                            this.nedges = (int)streamTokenizer.nval;
                            this.gothead = true;
                        }
                    }
                    case -2: {
                        continue block13;
                    }
                }
                break block13;
            } while (true);
        }
        this.vert = new double[this.nverts * 3];
        this.face = new Face[this.nfaces];
        int n = 0;
        int n2 = 0;
        block16: while (n < this.nverts) {
            switch (streamTokenizer.nextToken()) {
                default: {
                    break;
                }
                case 10: {
                    if (n2 <= 2) continue block16;
                    n2 = 0;
                    ++n;
                    break;
                }
                case -2: {
                    if (n2 >= 3) continue block16;
                    this.vert[n * 3 + n2] = streamTokenizer.nval;
                    ++n2;
                }
            }
        }
        n = 0;
        n2 = 0;
        boolean bl = false;
        while (n < this.nfaces) {
            switch (streamTokenizer.nextToken()) {
                default: {
                    break;
                }
                case 10: {
                    if (bl) {
                        ++n;
                    }
                    bl = false;
                    break;
                }
                case -2: {
                    if (!bl) {
                        this.face[n] = new Face();
                        this.face[n].numVerts((int)streamTokenizer.nval);
                        bl = true;
                        n2 = 0;
                        break;
                    }
                    if (n2 < this.face[n].nverts) {
                        this.face[n].index[n2] = 3 * (int)streamTokenizer.nval;
                        ++n2;
                        break;
                    }
                    this.face[n].cr = 255;
                    this.face[n].cg = 255;
                    this.face[n].cb = 255;
                    double d = streamTokenizer.nval;
                    if (d <= 1.0) {
                        d *= 255.0;
                    }
                    this.face[n].cr = (int)d;
                    if (streamTokenizer.nextToken() != 10) {
                        d = streamTokenizer.nval;
                        if (d <= 1.0) {
                            d *= 255.0;
                        }
                        this.face[n].cg = (int)d;
                        if (streamTokenizer.nextToken() != 10) {
                            d = streamTokenizer.nval;
                            if (d <= 1.0) {
                                d *= 255.0;
                            }
                            this.face[n].cb = (int)d;
                            break;
                        }
                        this.face[n].cr = 255;
                        this.face[n].cg = 255;
                        this.face[n].cb = 255;
                        ++n;
                        bl = false;
                        break;
                    }
                    this.face[n].cr = 255;
                    this.face[n].cg = 255;
                    this.face[n].cb = 255;
                    ++n;
                    bl = false;
                }
            }
        }
        this.init();
    }

    void init() {
        this.normals = new Vec3[this.nfaces];
        this.tnormals = new Vec3[this.nfaces];
        this.findex = new int[this.nfaces];
        int n = 0;
        while (n < this.nfaces) {
            this.findex[n] = n;
            ++n;
        }
        this.gr = new Color[this.nfaces];
        int n2 = 0;
        while (n2 < this.nfaces) {
            Face face = this.face[n2];
            int n3 = face.nverts;
            int[] nArray = face.index;
            if (nArray.length >= 3) {
                int n4 = nArray[0];
                int n5 = nArray[1];
                int n6 = nArray[2];
                Vec3 vec3 = new Vec3(this.vert[n5] - this.vert[n4], this.vert[n5 + 1] - this.vert[n4 + 1], this.vert[n5 + 2] - this.vert[n4 + 2]);
                Vec3 vec32 = new Vec3(this.vert[n6] - this.vert[n5], this.vert[n6 + 1] - this.vert[n5 + 1], this.vert[n6 + 2] - this.vert[n5 + 2]);
                Vec3 vec33 = Vec3.cross(vec32, vec3);
                vec33.normalize();
                this.normals[n2] = vec33;
                this.tnormals[n2] = new Vec3();
                this.face[n2].nindex = n2;
                this.face[n2].findex = n2;
            } else {
                this.normals[n2] = null;
                this.tnormals[n2] = null;
            }
            this.gr[n2] = new Color(this.face[n2].cr, this.face[n2].cg, this.face[n2].cb);
            ++n2;
        }
    }

    public void transform() {
        if (this.transformed || this.nverts <= 0) {
            return;
        }
        if (this.tvert == null) {
            this.tvert = new int[this.nverts * 3];
        }
        this.mat.transform(this.vert, this.tvert, this.nverts);
        this.mat.transform(this.normals, this.tnormals, this.normals.length);
        int n = 0;
        while (n < this.tnormals.length) {
            if (this.tnormals[n] != null) {
                this.tnormals[n].normalize();
            }
            ++n;
        }
        this.transformed = true;
    }

    void qs(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        double d = this.face[this.findex[(n + n2) / 2]].zdepth;
        while (true) {
            if (this.face[this.findex[n3]].zdepth > d && n3 < n2) {
                ++n3;
                continue;
            }
            while (d > this.face[this.findex[n4]].zdepth && n4 > n) {
                --n4;
            }
            if (n3 <= n4) {
                int n5 = this.findex[n3];
                this.findex[n3] = this.findex[n4];
                this.findex[n4] = n5;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            this.qs(n, n4);
        }
        if (n3 < n2) {
            this.qs(n3, n2);
        }
    }

    public Color makeColor(Color color, Vec3 vec3) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = 50;
        int n5 = 50;
        int n6 = 50;
        int n7 = 0;
        while (n7 < this.light.length) {
            double d = Vec3.dot(this.light[n7], vec3);
            if (!(d < 0.0)) {
                double d2 = 1.0 - d;
                n4 = (int)((double)n4 + d * (double)this.light_color[n7].getRed());
                n5 = (int)((double)n5 + d * (double)this.light_color[n7].getGreen());
                n6 = (int)((double)n6 + d * (double)this.light_color[n7].getBlue());
            }
            ++n7;
        }
        return new Color(Math.min(255, n4), Math.min(255, n5), Math.min(255, n6));
    }

    public void paint(Graphics graphics) {
        int n;
        if (this.canvas != null) {
            if (this.canvas.displayType == 1 || this.canvas.displayType == 2) {
                this.drawAnaglyph = true;
                this.light = this.light_anaglyph;
                this.light_color = this.light_color_anaglyph;
            } else {
                this.drawAnaglyph = false;
                this.light = this.light_normal;
                this.light_color = this.light_color_normal;
            }
        }
        if (this.vert == null || this.nverts <= 0) {
            return;
        }
        this.transform();
        int n2 = 0;
        while (n2 < this.nfaces) {
            this.face[n2].zdepth = 0.0;
            Face face = this.face[n2];
            n = face.nverts;
            int[] nArray = face.index;
            int n3 = 0;
            while (n3 < n) {
                face.zdepth += (double)this.tvert[nArray[n3] + 2];
                ++n3;
            }
            face.zdepth /= (double)face.nverts;
            ++n2;
        }
        this.qs(0, this.nfaces - 1);
        int n4 = 0;
        while (n4 < this.nfaces) {
            n = this.findex[n4];
            if (this.tnormals[n] == null || !(this.tnormals[n].z < 0.0) || !this.canvas.drawFaces) {
                int n5 = 0;
                Face face = this.face[n];
                int n6 = face.nverts;
                int[] nArray = face.index;
                int n7 = 0;
                while (n7 < n6) {
                    int n8 = nArray[n7];
                    this.vx[n7] = this.tvert[n8];
                    this.vy[n7] = this.tvert[n8 + 1];
                    ++n7;
                }
                if (this.canvas.drawFaces) {
                    if (n6 >= 3) {
                        Color color = this.makeColor(this.gr[n], this.tnormals[n]);
                        graphics.setColor(color);
                        graphics.fillPolygon(this.vx, this.vy, n6);
                    } else {
                        graphics.setColor(Color.black);
                        graphics.drawLine(this.vx[0], this.vy[0], this.vx[1], this.vy[1]);
                    }
                }
                if (this.canvas.drawLines) {
                    graphics.setColor(this.drawAnaglyph && !this.canvas.drawFaces ? Color.white : Color.black);
                    --n6;
                    n5 = 0;
                    while (n5 < n6) {
                        graphics.drawLine(this.vx[n5], this.vy[n5], this.vx[n5 + 1], this.vy[n5 + 1]);
                        ++n5;
                    }
                    graphics.drawLine(this.vx[n5], this.vy[n5], this.vx[0], this.vy[0]);
                }
            }
            ++n4;
        }
    }

    void findBB() {
        double d;
        double d2;
        double d3;
        if (this.nverts <= 0) {
            return;
        }
        double[] dArray = this.vert;
        double d4 = d3 = dArray[0];
        double d5 = d2 = dArray[1];
        double d6 = d = dArray[2];
        int n = this.nverts * 3;
        while ((n -= 3) > 0) {
            double d7;
            double d8;
            double d9 = dArray[n];
            if (d9 < d3) {
                d3 = d9;
            }
            if (d9 > d4) {
                d4 = d9;
            }
            if ((d8 = dArray[n + 1]) < d2) {
                d2 = d8;
            }
            if (d8 > d5) {
                d5 = d8;
            }
            if ((d7 = dArray[n + 2]) < d) {
                d = d7;
            }
            if (!(d7 > d6)) continue;
            d6 = d7;
        }
        this.xmax = d4;
        this.xmin = d3;
        this.ymax = d5;
        this.ymin = d2;
        this.zmax = d6;
        this.zmin = d;
    }

    public Model3D getCopy() {
        return null;
    }
}

