/*
 * Decompiled with CFR 0.152.
 */
package PVS.g3d;

import PVS.g3d.Vec3;

public class Matrix3D {
    double xx;
    double xy;
    double xz;
    double xo;
    double yx;
    double yy;
    double yz;
    double yo;
    double zx;
    double zy;
    double zz;
    double zo;
    static final double pi = Math.PI;

    public Matrix3D() {
        this.xx = 1.0;
        this.yy = 1.0;
        this.zz = 1.0;
    }

    public Matrix3D(Matrix3D matrix3D) {
        this.xx = matrix3D.xx;
        this.xy = matrix3D.xy;
        this.xz = matrix3D.xz;
        this.xo = matrix3D.xo;
        this.yx = matrix3D.yx;
        this.yy = matrix3D.yy;
        this.yz = matrix3D.yz;
        this.yo = matrix3D.yo;
        this.zx = matrix3D.zx;
        this.zy = matrix3D.zy;
        this.zz = matrix3D.zz;
        this.zo = matrix3D.zo;
    }

    public Matrix3D(Vec3 vec3, double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = 1.0 - d2;
        vec3.normalize();
        this.init(new Vec3(d4 * vec3.x * vec3.x + d2, d4 * vec3.x * vec3.y - d3 * vec3.z, d4 * vec3.x * vec3.z + d3 * vec3.y), new Vec3(d4 * vec3.x * vec3.y + d3 * vec3.z, d4 * vec3.y * vec3.y + d2, d4 * vec3.y * vec3.z - d3 * vec3.x), new Vec3(d4 * vec3.x * vec3.z - d3 * vec3.y, d4 * vec3.y * vec3.z + d3 * vec3.x, d4 * vec3.z * vec3.z + d2));
    }

    public Matrix3D(Vec3 vec3, Vec3 vec32, Vec3 vec33) {
        this.init(vec3, vec32, vec33);
    }

    public void scale(double d) {
        this.xx *= d;
        this.xy *= d;
        this.xz *= d;
        this.xo *= d;
        this.yx *= d;
        this.yy *= d;
        this.yz *= d;
        this.yo *= d;
        this.zx *= d;
        this.zy *= d;
        this.zz *= d;
        this.zo *= d;
    }

    public void scale(double d, double d2, double d3) {
        this.xx *= d;
        this.xy *= d;
        this.xz *= d;
        this.xo *= d;
        this.yx *= d2;
        this.yy *= d2;
        this.yz *= d2;
        this.yo *= d2;
        this.zx *= d3;
        this.zy *= d3;
        this.zz *= d3;
        this.zo *= d3;
    }

    void translate(double d, double d2, double d3) {
        this.xo += d;
        this.yo += d2;
        this.zo += d3;
    }

    public void yrot(double d) {
        double d2 = Math.cos(d *= Math.PI / 180);
        double d3 = Math.sin(d);
        double d4 = this.xx * d2 + this.zx * d3;
        double d5 = this.xy * d2 + this.zy * d3;
        double d6 = this.xz * d2 + this.zz * d3;
        double d7 = this.xo * d2 + this.zo * d3;
        double d8 = this.zx * d2 - this.xx * d3;
        double d9 = this.zy * d2 - this.xy * d3;
        double d10 = this.zz * d2 - this.xz * d3;
        double d11 = this.zo * d2 - this.xo * d3;
        this.xo = d7;
        this.xx = d4;
        this.xy = d5;
        this.xz = d6;
        this.zo = d11;
        this.zx = d8;
        this.zy = d9;
        this.zz = d10;
    }

    public void xrot(double d) {
        double d2 = Math.cos(d *= Math.PI / 180);
        double d3 = Math.sin(d);
        double d4 = this.yx * d2 + this.zx * d3;
        double d5 = this.yy * d2 + this.zy * d3;
        double d6 = this.yz * d2 + this.zz * d3;
        double d7 = this.yo * d2 + this.zo * d3;
        double d8 = this.zx * d2 - this.yx * d3;
        double d9 = this.zy * d2 - this.yy * d3;
        double d10 = this.zz * d2 - this.yz * d3;
        double d11 = this.zo * d2 - this.yo * d3;
        this.yo = d7;
        this.yx = d4;
        this.yy = d5;
        this.yz = d6;
        this.zo = d11;
        this.zx = d8;
        this.zy = d9;
        this.zz = d10;
    }

    public void zrot(double d) {
        double d2 = Math.cos(d *= Math.PI / 180);
        double d3 = Math.sin(d);
        double d4 = this.yx * d2 + this.xx * d3;
        double d5 = this.yy * d2 + this.xy * d3;
        double d6 = this.yz * d2 + this.xz * d3;
        double d7 = this.yo * d2 + this.xo * d3;
        double d8 = this.xx * d2 - this.yx * d3;
        double d9 = this.xy * d2 - this.yy * d3;
        double d10 = this.xz * d2 - this.yz * d3;
        double d11 = this.xo * d2 - this.yo * d3;
        this.yo = d7;
        this.yx = d4;
        this.yy = d5;
        this.yz = d6;
        this.xo = d11;
        this.xx = d8;
        this.xy = d9;
        this.xz = d10;
    }

    public Matrix3D mul(Matrix3D matrix3D) {
        double d = this.xx * matrix3D.xx + this.yx * matrix3D.xy + this.zx * matrix3D.xz;
        double d2 = this.xy * matrix3D.xx + this.yy * matrix3D.xy + this.zy * matrix3D.xz;
        double d3 = this.xz * matrix3D.xx + this.yz * matrix3D.xy + this.zz * matrix3D.xz;
        double d4 = this.xo * matrix3D.xx + this.yo * matrix3D.xy + this.zo * matrix3D.xz + matrix3D.xo;
        double d5 = this.xx * matrix3D.yx + this.yx * matrix3D.yy + this.zx * matrix3D.yz;
        double d6 = this.xy * matrix3D.yx + this.yy * matrix3D.yy + this.zy * matrix3D.yz;
        double d7 = this.xz * matrix3D.yx + this.yz * matrix3D.yy + this.zz * matrix3D.yz;
        double d8 = this.xo * matrix3D.yx + this.yo * matrix3D.yy + this.zo * matrix3D.yz + matrix3D.yo;
        double d9 = this.xx * matrix3D.zx + this.yx * matrix3D.zy + this.zx * matrix3D.zz;
        double d10 = this.xy * matrix3D.zx + this.yy * matrix3D.zy + this.zy * matrix3D.zz;
        double d11 = this.xz * matrix3D.zx + this.yz * matrix3D.zy + this.zz * matrix3D.zz;
        double d12 = this.xo * matrix3D.zx + this.yo * matrix3D.zy + this.zo * matrix3D.zz + matrix3D.zo;
        this.xx = d;
        this.xy = d2;
        this.xz = d3;
        this.xo = d4;
        this.yx = d5;
        this.yy = d6;
        this.yz = d7;
        this.yo = d8;
        this.zx = d9;
        this.zy = d10;
        this.zz = d11;
        this.zo = d12;
        return this;
    }

    public void unit() {
        this.xo = 0.0;
        this.xx = 1.0;
        this.xy = 0.0;
        this.xz = 0.0;
        this.yo = 0.0;
        this.yx = 0.0;
        this.yy = 1.0;
        this.yz = 0.0;
        this.zo = 0.0;
        this.zx = 0.0;
        this.zy = 0.0;
        this.zz = 1.0;
    }

    public void unit_flipped() {
        this.xo = 0.0;
        this.xx = 1.0;
        this.xy = 0.0;
        this.xz = 0.0;
        this.yo = 0.0;
        this.yx = 0.0;
        this.yy = -1.0;
        this.yz = 0.0;
        this.zo = 0.0;
        this.zx = 0.0;
        this.zy = 0.0;
        this.zz = -1.0;
    }

    public void init(Vec3 vec3, Vec3 vec32, Vec3 vec33) {
        this.xx = vec3.x;
        this.xy = vec3.y;
        this.xz = vec3.z;
        this.xo = 0.0;
        this.yx = vec32.x;
        this.yy = vec32.y;
        this.yz = vec32.z;
        this.yo = 0.0;
        this.zx = vec33.x;
        this.zy = vec33.y;
        this.zz = vec33.z;
        this.zo = 0.0;
    }

    public void transform(double[] dArray, int[] nArray, int n) {
        double d = this.xx;
        double d2 = this.xy;
        double d3 = this.xz;
        double d4 = this.xo;
        double d5 = this.yx;
        double d6 = this.yy;
        double d7 = this.yz;
        double d8 = this.yo;
        double d9 = this.zx;
        double d10 = this.zy;
        double d11 = this.zz;
        double d12 = this.zo;
        int n2 = n * 3;
        while ((n2 -= 3) >= 0) {
            double d13 = dArray[n2];
            double d14 = dArray[n2 + 1];
            double d15 = dArray[n2 + 2];
            nArray[n2] = (int)(d13 * d + d14 * d2 + d15 * d3 + d4);
            nArray[n2 + 1] = (int)(d13 * d5 + d14 * d6 + d15 * d7 + d8);
            nArray[n2 + 2] = (int)((d13 * d9 + d14 * d10 + d15 * d11 + d12) * 1000000.0);
        }
    }

    public void transform(double[] dArray, double[] dArray2, int n) {
        double d = this.xx;
        double d2 = this.xy;
        double d3 = this.xz;
        double d4 = this.xo;
        double d5 = this.yx;
        double d6 = this.yy;
        double d7 = this.yz;
        double d8 = this.yo;
        double d9 = this.zx;
        double d10 = this.zy;
        double d11 = this.zz;
        double d12 = this.zo;
        int n2 = n * 3;
        while ((n2 -= 3) >= 0) {
            double d13 = dArray[n2];
            double d14 = dArray[n2 + 1];
            double d15 = dArray[n2 + 2];
            dArray2[n2] = d13 * d + d14 * d2 + d15 * d3 + d4;
            dArray2[n2 + 1] = d13 * d5 + d14 * d6 + d15 * d7 + d8;
            dArray2[n2 + 2] = d13 * d9 + d14 * d10 + d15 * d11 + d12;
        }
    }

    public void transform(Vec3[] vec3Array, Vec3[] vec3Array2, int n) {
        double d = this.xx;
        double d2 = this.xy;
        double d3 = this.xz;
        double d4 = this.xo;
        double d5 = this.yx;
        double d6 = this.yy;
        double d7 = this.yz;
        double d8 = this.yo;
        double d9 = this.zx;
        double d10 = this.zy;
        double d11 = this.zz;
        double d12 = this.zo;
        int n2 = n;
        while (--n2 >= 0) {
            if (vec3Array[n2] == null) continue;
            double d13 = vec3Array[n2].x;
            double d14 = vec3Array[n2].y;
            double d15 = vec3Array[n2].z;
            Vec3 vec3 = vec3Array2[n2];
            vec3.x = d13 * d + d14 * d2 + d15 * d3;
            vec3.y = d13 * d5 + d14 * d6 + d15 * d7;
            vec3.z = d13 * d9 + d14 * d10 + d15 * d11;
        }
    }

    public String toString() {
        return "[" + this.xo + "," + this.xx + "," + this.xy + "," + this.xz + ";" + this.yo + "," + this.yx + "," + this.yy + "," + this.yz + ";" + this.zo + "," + this.zx + "," + this.zy + "," + this.zz + "]";
    }
}

