/*
 * Decompiled with CFR 0.152.
 */
package PVS.g3d;

import PVS.Utils.BorderPanel;
import PVS.Utils.DestroyableFrame;
import PVS.Utils.EventCallback;
import PVS.Utils.Fmt;
import PVS.Utils.GraphicsPS;
import PVS.Utils.PVSObserver;
import PVS.Utils.Timeout;
import PVS.Utils.TimeoutCallback;
import PVS.Utils.WindowUtils;
import PVS.g3d.Matrix3D;
import PVS.g3d.Model3D;
import PVS.g3d.Stellation3D;
import PVS.g3d.Vec3;
import PVS.polyhedra.Vector3D;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class Canvas3D
extends Panel
implements Runnable {
    static int preferedWidth = 400;
    static int preferedHeight = 400;
    PVSObserver observer;
    Model3D obj;
    boolean painted = true;
    String objname = null;
    String message = null;
    double xfac = 0.4;
    Matrix3D curMatrix = new Matrix3D();
    Matrix3D tmat = new Matrix3D();
    int prevx;
    int prevy;
    boolean drawLines = true;
    boolean drawFaces = true;
    PopupMenu displayTypePopup;
    Choice chDisplayType;
    String[] displayTypeNames = new String[]{"Normal 3D", "Anaglyph (Red/Blue)", "Anaglyph (Blue/Red)", "Stereo (Parallel)", "Stereo (Crosseyed)"};
    int displayType = 0;
    double anaglyphAngleGrad = 2.0;
    static final int NORMAL = 0;
    static final int ANAGLYPH_RC = 1;
    static final int ANAGLYPH_CR = 2;
    static final int STEREO_PARALLEL = 3;
    static final int STEREO_CROSSED = 4;
    SCanvas canvas;
    public static PrintStream Out = System.out;
    double zoomSpeed = 1.02;
    Graphics gc;
    long prevTime = -1L;
    double spinSpeed = 0.0;
    Vec3 spinAxis = null;
    double spinSpeedCutoff = 0.001;
    Image bbuffer;
    Graphics bgc;
    int Height = -1;
    int Width = -1;
    boolean drawFPS = false;
    long startFPS = 0L;
    long countFPS = 0L;
    double oldStereoWidth = -1.0;
    double oldStereoHeight = -1.0;
    Image imgLeft;
    Image imgRight;
    Graphics graphLeft;
    Graphics graphRight;
    int[] bufferLeft;
    int[] bufferRight;
    MemoryImageSource imgProducer;
    Image combImage;
    EventCallback eventCallback = null;
    boolean mouseDragged = false;
    Thread thread;
    FileDialog fileDialog;
    String psName = "stellation.ps";
    private static GridBagConstraints gbc = new GridBagConstraints();

    public Canvas3D(Model3D model3D) {
        this.obj = model3D;
        this.initUI();
        this.init();
        model3D.setCanvas(this);
    }

    public Canvas3D() {
        this.initUI();
        this.init();
    }

    public void setObserver(PVSObserver pVSObserver) {
        this.observer = pVSObserver;
    }

    public void setModel(Model3D model3D) {
        if (this.obj != null) {
            this.obj.clearCanvas(this);
        }
        this.obj = model3D;
        this.init();
        this.canvas.repaint();
        this.obj.setCanvas(this);
    }

    void initUI() {
        this.setBackground(Color.white);
        this.setLayout(new GridBagLayout());
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        panel.setBackground(Color.lightGray);
        Checkbox checkbox = new Checkbox("Edges", this.drawLines);
        checkbox.addItemListener(new EdgesListener());
        Checkbox checkbox2 = new Checkbox("Faces", this.drawFaces);
        checkbox2.addItemListener(new FacesListener());
        Button button = new Button("Reset");
        button.addActionListener(new ResetListener());
        Button button2 = new Button("+");
        button2.addMouseListener(new ZoomInListener());
        Button button3 = new Button("-");
        button3.addMouseListener(new ZoomOutListener());
        this.chDisplayType = new Choice();
        int n = 0;
        while (n < this.displayTypeNames.length) {
            this.chDisplayType.addItem(this.displayTypeNames[n]);
            ++n;
        }
        this.chDisplayType.select(this.displayType);
        this.chDisplayType.addItemListener(new DisplayTypeListener());
        int n2 = 0;
        WindowUtils.constrain((Container)panel, (Component)checkbox, n2++, 0, 1, 1, 0, 17, 0.0, 0.0);
        WindowUtils.constrain((Container)panel, (Component)checkbox2, n2++, 0, 1, 1, 0, 17, 0.0, 0.0);
        WindowUtils.constrain(panel, this.chDisplayType, n2++, 0, 1, 1, 0, 17, 1.0, 0.0, 0, 0, 0, 4);
        WindowUtils.constrain((Container)panel, (Component)button, n2++, 0, 1, 1, 0, 17, 0.0, 0.0);
        WindowUtils.constrain((Container)panel, (Component)button2, n2++, 0, 1, 1, 0, 17, 0.0, 0.0);
        WindowUtils.constrain((Container)panel, (Component)button3, n2++, 0, 1, 1, 0, 17, 0.0, 0.0);
        this.canvas = new SCanvas();
        WindowUtils.constrain((Container)this, (Component)panel, 0, 0, 1, 1, 2, 17, 1.0, 0.0);
        WindowUtils.constrain((Container)this, (Component)this.canvas, 0, 1, 1, 1, 1, 10, 1.0, 1.0);
        this.canvas.addMouseListener(new MouseListenerClass());
        this.canvas.addMouseMotionListener(new MouseMotionListenerClass());
        this.canvas.addKeyListener(new KeyListenerClass());
    }

    public Dimension getMinimumSize() {
        return new Dimension(preferedWidth / 2, preferedHeight / 2);
    }

    public Dimension getPreferredSize() {
        return new Dimension(preferedWidth, preferedHeight);
    }

    void init() {
        this.obj.findBB();
        double d = this.obj.xmax - this.obj.xmin;
        double d2 = this.obj.ymax - this.obj.ymin;
        double d3 = this.obj.zmax - this.obj.zmin;
        if (d2 > d) {
            d = d2;
        }
        if (d3 > d) {
            d = d3;
        }
        double d4 = 250.0 / d;
        double d5 = 250.0 / d;
    }

    public void zoomIn() {
        this.xfac *= this.zoomSpeed;
        this.canvas.repaint();
    }

    public void zoomOut() {
        this.xfac /= this.zoomSpeed;
        this.canvas.repaint();
    }

    public void paintCanvas(Graphics graphics) {
        switch (this.displayType) {
            case 0: {
                this.drawNormalImage(graphics);
                break;
            }
            case 2: {
                this.drawAnaglyph(graphics, this.anaglyphAngleGrad);
                break;
            }
            case 1: {
                this.drawAnaglyph(graphics, -this.anaglyphAngleGrad);
                break;
            }
            case 3: {
                this.drawStereo(graphics, this.anaglyphAngleGrad);
                break;
            }
            case 4: {
                this.drawStereo(graphics, -this.anaglyphAngleGrad);
            }
        }
        this.mouseDragged = false;
        if (this.eventCallback != null) {
            EventCallback eventCallback = this.eventCallback;
            this.eventCallback = null;
            eventCallback.processEventCallback(null, null);
        }
    }

    void drawFPS(Graphics graphics) {
        ++this.countFPS;
        long l = System.currentTimeMillis() - this.startFPS;
        if (l == 0L) {
            return;
        }
        double d = 0.1 * (double)((int)((double)(10L * this.countFPS) / (0.001 * (double)l)));
        graphics.drawString(Fmt.fmt(d, 6, 3), 0, this.Height - 30);
    }

    void drawNormalImage(Graphics graphics) {
        if (this.bbuffer == null || this.getSize().width != this.Width || this.getSize().height != this.Height) {
            this.Width = this.getSize().width;
            this.Height = this.getSize().height;
            this.bbuffer = this.createImage(this.Width, this.Height);
            this.bgc = this.bbuffer.getGraphics();
        }
        if (this.obj != null) {
            this.paint(this.bgc, this.getSize().width, this.getSize().height);
            if (this.drawFPS) {
                this.drawFPS(this.bgc);
            }
            graphics.drawImage(this.bbuffer, 0, 0, this);
        } else if (this.message != null) {
            graphics.drawString("no data", 3, 20);
        }
    }

    void drawStereo(Graphics graphics, double d) {
        Dimension dimension = this.canvas.getSize();
        if (this.oldStereoWidth != (double)dimension.width || this.oldStereoHeight != (double)dimension.height) {
            this.oldStereoWidth = dimension.width;
            this.oldStereoHeight = dimension.height;
            this.imgLeft = this.createImage(dimension.width / 2, dimension.height);
            this.imgRight = this.createImage(dimension.width / 2, dimension.height);
            this.bbuffer = this.createImage(dimension.width, dimension.height);
            this.graphLeft = this.imgLeft.getGraphics();
            this.graphRight = this.imgRight.getGraphics();
            this.bgc = this.bbuffer.getGraphics();
        }
        this.drawAnaglyph(this.graphRight, dimension.width / 2, dimension.height, d);
        this.drawAnaglyph(this.graphLeft, dimension.width / 2, dimension.height, -d);
        this.bgc.drawImage(this.imgLeft, 0, 0, this);
        this.bgc.drawImage(this.imgRight, dimension.width / 2, 0, this);
        graphics.drawImage(this.bbuffer, 0, 0, this);
    }

    void drawAnaglyph(Graphics graphics, double d) {
        Dimension dimension = this.canvas.getSize();
        if (this.imgLeft == null || this.imgRight == null || this.imgLeft.getWidth(this) != dimension.width || this.imgLeft.getHeight(this) != dimension.height) {
            this.imgLeft = this.createImage(dimension.width, dimension.height);
            this.imgRight = this.createImage(dimension.width, dimension.height);
            this.graphLeft = this.imgLeft.getGraphics();
            this.graphRight = this.imgRight.getGraphics();
            this.bufferLeft = new int[dimension.width * dimension.height];
            this.bufferRight = new int[dimension.width * dimension.height];
            this.imgProducer = new MemoryImageSource(dimension.width, dimension.height, this.bufferLeft, 0, dimension.width);
            this.imgProducer.setAnimated(true);
            this.imgProducer.setFullBufferUpdates(true);
            this.combImage = Toolkit.getDefaultToolkit().createImage(this.imgProducer);
        }
        this.makeAnaglyph(d);
        this.imgProducer.newPixels();
        graphics.drawImage(this.combImage, 0, 0, this);
    }

    void makeAnaglyph(double d) {
        Dimension dimension = this.getSize();
        try {
            this.drawAnaglyph(this.graphRight, dimension.width, dimension.height, d);
            PixelGrabber pixelGrabber = new PixelGrabber(this.imgRight, 0, 0, dimension.width, dimension.height, this.bufferRight, 0, dimension.width);
            pixelGrabber.grabPixels();
            this.drawAnaglyph(this.graphLeft, dimension.width, dimension.height, -d);
            PixelGrabber pixelGrabber2 = new PixelGrabber(this.imgLeft, 0, 0, dimension.width, dimension.height, this.bufferLeft, 0, dimension.width);
            pixelGrabber2.grabPixels();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        int n = 0;
        while (n < this.bufferLeft.length) {
            int n2 = this.bufferLeft[n] & 0xFF;
            this.bufferLeft[n] = 0xFF000000 | (this.bufferRight[n] & 0xFF) << 16 | n2 << 8 | n2;
            ++n;
        }
    }

    public void paint(Graphics graphics, int n, int n2) {
        this.obj.mat.unit_flipped();
        this.obj.mat.mul(this.curMatrix);
        int n3 = n;
        if (n2 < n) {
            n3 = n2;
        }
        double d = this.xfac * (double)n3;
        this.obj.mat.scale(d, d, d);
        this.obj.mat.translate(n / 2, n2 / 2, 0.0);
        this.obj.transformed = false;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n, n2);
        this.obj.paint(graphics);
    }

    public void drawAnaglyph(Graphics graphics, int n, int n2, double d) {
        this.obj.mat.unit_flipped();
        this.obj.mat.mul(this.curMatrix);
        this.obj.mat.translate(0.0, 0.0, Math.abs((this.obj.zmax - this.obj.zmin) / 2.0));
        this.obj.mat.yrot(d);
        int n3 = n;
        if (n2 < n) {
            n3 = n2;
        }
        double d2 = this.xfac * (double)n3;
        this.obj.mat.scale(d2, d2, d2);
        this.obj.mat.translate(n / 2, n2 / 2, 0.0);
        this.obj.transformed = false;
        graphics.setColor(Color.gray);
        graphics.fillRect(0, 0, n, n2);
        this.obj.paint(graphics);
    }

    public static Model3D loadObject(String string) {
        try {
            Model3D model3D = new Model3D(new FileInputStream(string));
            return model3D;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    public void run() {
        try {
            Object object;
            OutputStream outputStream = null;
            try {
                if (this.fileDialog == null) {
                    this.fileDialog = new FileDialog(WindowUtils.getFrame(this), this.psName, 1);
                }
                this.fileDialog.show();
                if (this.fileDialog.getFile() == null) {
                    return;
                }
                this.psName = this.fileDialog.getFile();
                object = this.fileDialog.getDirectory();
                String string = (String)object + this.psName;
                File file = new File(string);
                outputStream = new FileOutputStream(file);
                Out.println("printing 3D model to file " + string);
            }
            catch (Exception exception) {
                outputStream = System.out;
                System.out.println("---------start of PS");
                Out.println("printing 3D model to java console");
            }
            object = new GraphicsPS(outputStream, this.getGraphics());
            this.paint((Graphics)object, ((GraphicsPS)object).getWidth(), ((GraphicsPS)object).getHeight());
            ((GraphicsPS)object).flush();
            if (outputStream != System.out) {
                ((OutputStream)outputStream).close();
            } else {
                System.out.println("---------end of PS");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    void doPrint() {
        this.thread = new Thread(this);
        this.thread.setPriority(1);
        this.thread.start();
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return true;
    }

    static Model3D getTestModel() {
        return new Model3D();
    }

    public static void main(String[] stringArray) {
        DestroyableFrame destroyableFrame = new DestroyableFrame("polyhedra viewer");
        Panel panel = new Panel();
        panel.setBackground(Color.lightGray);
        GridBagLayout gridBagLayout = new GridBagLayout();
        destroyableFrame.setLayout(gridBagLayout);
        panel.setLayout(gridBagLayout);
        int n = (int)Math.sqrt(stringArray.length);
        int n2 = (stringArray.length + n - 1) / n;
        int n3 = 0;
        int n4 = 0;
        block0: while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                if (n3 >= stringArray.length) break block0;
                BorderPanel borderPanel = new BorderPanel();
                borderPanel.setLayout(gridBagLayout);
                borderPanel.setBackground(Color.lightGray);
                WindowUtils.constrain((Container)borderPanel, (Component)new Canvas3D(Canvas3D.loadObject(stringArray[n3])), 0, 0, 1, 1, 1, 10, 1.0, 1.0);
                WindowUtils.constrain((Container)panel, (Component)borderPanel, n5, n4, 1, 1, 1, 10, 1.0, 1.0);
                ++n3;
                ++n5;
            }
            ++n4;
        }
        preferedHeight = preferedWidth = 600 / n2;
        WindowUtils.constrain((Container)destroyableFrame, (Component)panel, 0, 0, 1, 1, 1, 10, 1.0, 1.0);
        destroyableFrame.pack();
        destroyableFrame.show();
    }

    class PopupMenuListener
    implements ActionListener {
        PopupMenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class ResetListener
    implements ActionListener {
        ResetListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Canvas3D.this.eventCallback = null;
            Canvas3D.this.curMatrix.unit();
            Canvas3D.this.canvas.repaint();
        }
    }

    class DisplayTypeListener
    implements ItemListener {
        DisplayTypeListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            int n;
            Canvas3D.this.displayType = n = Canvas3D.this.chDisplayType.getSelectedIndex();
            Canvas3D.this.canvas.repaint();
        }
    }

    class ZoomInListener
    extends MouseAdapter
    implements EventCallback,
    TimeoutCallback {
        boolean mouseDown = false;
        Timeout timeout;

        ZoomInListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseDown = true;
            Canvas3D.this.zoomIn();
            this.timeout = new Timeout(300L, this, null);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseDown = false;
            Canvas3D.this.eventCallback = null;
            this.timeout.stop();
        }

        public void processEventCallback(Object object, Object object2) {
            if (this.mouseDown) {
                Canvas3D.this.eventCallback = this;
                Canvas3D.this.zoomIn();
            }
        }

        public void timeoutCallback(Object object) {
            if (this.mouseDown) {
                Canvas3D.this.eventCallback = this;
                Canvas3D.this.zoomIn();
            }
        }
    }

    class ZoomOutListener
    extends MouseAdapter
    implements EventCallback,
    TimeoutCallback {
        boolean mouseDown = false;
        Timeout timeout;

        ZoomOutListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseDown = true;
            Canvas3D.this.zoomOut();
            this.timeout = new Timeout(300L, this, null);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseDown = false;
            Canvas3D.this.eventCallback = null;
            this.timeout.stop();
        }

        public void timeoutCallback(Object object) {
            if (this.mouseDown) {
                Canvas3D.this.eventCallback = this;
                Canvas3D.this.zoomOut();
            }
        }

        public void processEventCallback(Object object, Object object2) {
            if (this.mouseDown) {
                Canvas3D.this.eventCallback = this;
                Canvas3D.this.zoomOut();
            }
        }
    }

    class FacesListener
    implements ItemListener {
        FacesListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Canvas3D.this.drawFaces = itemEvent.getStateChange() == 1;
            Canvas3D.this.canvas.repaint();
        }
    }

    class EdgesListener
    implements ItemListener {
        EdgesListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Canvas3D.this.drawLines = itemEvent.getStateChange() == 1;
            Canvas3D.this.canvas.repaint();
        }
    }

    class SCanvas
    extends Canvas {
        SCanvas() {
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            Canvas3D.this.paintCanvas(graphics);
        }

        public Dimension getPreferredSize() {
            return new Dimension(300, 300);
        }
    }

    class KeyListenerClass
    extends KeyAdapter {
        KeyListenerClass() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            switch (keyEvent.getKeyChar()) {
                case 'P': 
                case 'p': {
                    Canvas3D.this.doPrint();
                    break;
                }
                case 'E': 
                case 'L': 
                case 'e': 
                case 'l': {
                    Canvas3D.this.drawLines = !Canvas3D.this.drawLines;
                    Canvas3D.this.repaint();
                    break;
                }
                case 'F': 
                case 'f': {
                    Canvas3D.this.drawFaces = !Canvas3D.this.drawFaces;
                    Canvas3D.this.repaint();
                }
            }
        }
    }

    class MouseMotionListenerClass
    extends MouseMotionAdapter {
        MouseMotionListenerClass() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            long l = System.currentTimeMillis();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            double d = n - Canvas3D.this.prevx;
            double d2 = n2 - Canvas3D.this.prevy;
            double d3 = 3.0 * Math.sqrt(d * d + d2 * d2) / (double)Canvas3D.this.getSize().width;
            Canvas3D.this.spinAxis = new Vec3(d2, -d, 0.0);
            Canvas3D.this.spinAxis.normalize();
            Matrix3D matrix3D = new Matrix3D(Canvas3D.this.spinAxis, d3);
            Canvas3D.this.curMatrix.mul(matrix3D);
            Canvas3D.this.mouseDragged = true;
            Canvas3D.this.canvas.repaint();
            double d4 = (double)(l - Canvas3D.this.prevTime) * 0.001;
            if (d4 != 0.0) {
                Canvas3D.this.spinSpeed = 0.2 * d3 / d4 + 0.8 * Canvas3D.this.spinSpeed * Math.exp(-d4 * 10.0);
            }
            Canvas3D.this.prevx = n;
            Canvas3D.this.prevy = n2;
            Canvas3D.this.prevTime = l;
        }
    }

    class MouseListenerClass
    extends MouseAdapter
    implements EventCallback {
        double averageDt = 0.0;

        MouseListenerClass() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (Canvas3D.this.observer != null && (mouseEvent.getModifiers() & 0x10) != 0 && Canvas3D.this.obj instanceof Stellation3D) {
                int n = ((Stellation3D)Canvas3D.this.obj).findFaceAtPoint(mouseEvent.getX(), mouseEvent.getY());
                if (Canvas3D.this.observer != null && n != -1) {
                    Vec3 vec3 = Canvas3D.this.obj.face[n].center;
                    Vector3D vector3D = new Vector3D();
                    if (Canvas3D.this.obj instanceof Stellation3D) {
                        vector3D = ((Stellation3D)Canvas3D.this.obj).getFacePlane(n);
                    }
                    Canvas3D.this.observer.update(Canvas3D.this, new Object[]{new double[]{vec3.x, vec3.y, vec3.z}, new Integer(mouseEvent.getModifiers()), new double[]{vector3D.x, vector3D.y, vector3D.z}});
                }
            }
            if ((mouseEvent.getModifiers() & 0x10) != 0 && (mouseEvent.getModifiers() & (2 | 1 | 8)) == 0) {
                Canvas3D.this.prevx = mouseEvent.getX();
                Canvas3D.this.prevy = mouseEvent.getY();
                Canvas3D.this.spinAxis = null;
                Canvas3D.this.spinSpeed = 0.0;
                Canvas3D.this.prevTime = System.currentTimeMillis();
                Canvas3D.this.eventCallback = null;
                Canvas3D.this.gc = Canvas3D.this.getGraphics();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (Canvas3D.this.spinAxis != null && Canvas3D.this.spinSpeed > Canvas3D.this.spinSpeedCutoff) {
                long l = System.currentTimeMillis();
                if (l - Canvas3D.this.prevTime > 500L) {
                    return;
                }
                Canvas3D.this.eventCallback = this;
                Canvas3D.this.canvas.repaint();
                Canvas3D.this.startFPS = Canvas3D.this.prevTime = l;
                Canvas3D.this.countFPS = 0L;
            }
        }

        public void processEventCallback(Object object, Object object2) {
            if (Canvas3D.this.spinAxis == null) {
                return;
            }
            long l = System.currentTimeMillis();
            long l2 = l - Canvas3D.this.prevTime;
            this.averageDt = 0.8 * this.averageDt + 0.2 * (double)l2 * 0.001;
            Matrix3D matrix3D = new Matrix3D(Canvas3D.this.spinAxis, Canvas3D.this.spinSpeed * this.averageDt);
            Canvas3D.this.curMatrix.mul(matrix3D);
            Canvas3D.this.eventCallback = this;
            Canvas3D.this.prevTime = l;
            Canvas3D.this.canvas.repaint();
        }
    }
}

