/*
 * Decompiled with CFR 0.152.
 */
package PVS.Utils;

import PVS.Utils.Comparator;
import PVS.Utils.DoubleComparator;
import PVS.Utils.FastVector;
import java.util.Vector;

public class QSort {
    public static void quickSort(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        if (n >= n2) {
            return;
        }
        int n5 = (n + n2) / 2;
        if (nArray[n] - nArray[n5] > 0) {
            n4 = nArray[n];
            nArray[n] = nArray[n5];
            nArray[n5] = n4;
        }
        if (nArray[n5] - nArray[n2] > 0) {
            n4 = nArray[n5];
            nArray[n5] = nArray[n2];
            nArray[n2] = n4;
            if (nArray[n] - nArray[n5] > 0) {
                n3 = nArray[n];
                nArray[n] = nArray[n5];
                nArray[n5] = n3;
            }
        }
        if ((n4 = n + 1) >= (n3 = n2 - 1)) {
            return;
        }
        int n6 = nArray[n5];
        while (true) {
            if (nArray[n3] - n6 > 0) {
                --n3;
                continue;
            }
            while (n4 < n3 && nArray[n4] - n6 <= 0) {
                ++n4;
            }
            if (n4 >= n3) break;
            int n7 = nArray[n4];
            nArray[n4] = nArray[n3];
            nArray[n3] = n7;
            --n3;
        }
        QSort.quickSort(nArray, n, n4);
        QSort.quickSort(nArray, n4 + 1, n2);
    }

    public static void quickSort(Object[] objectArray, int n, int n2, Comparator comparator) {
        QSort.sort(objectArray, n, n2 + 1, comparator);
    }

    public static void quickSort(Vector vector, int n, int n2, Comparator comparator) {
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        QSort.sort(objectArray, n, n2 + 1, comparator);
        int n3 = 0;
        while (n3 < vector.size()) {
            vector.setElementAt(objectArray[n3], n3);
            ++n3;
        }
    }

    public static void quickSort(FastVector fastVector, int n, int n2, Comparator comparator) {
        Object[] objectArray = new Object[fastVector.size()];
        fastVector.copyInto(objectArray);
        QSort.sort(objectArray, n, n2 + 1, comparator);
        int n3 = 0;
        while (n3 < fastVector.size()) {
            fastVector.setElementAt(objectArray[n3], n3);
            ++n3;
        }
    }

    public static void sort(Object[] objectArray, int n, int n2, Comparator comparator) {
        QSort.rangeCheck(objectArray.length, n, n2);
        Object[] objectArray2 = (Object[])objectArray.clone();
        QSort.mergeSort(objectArray2, objectArray, n, n2, comparator);
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n, int n2, Comparator comparator) {
        int n3 = n2 - n;
        if (n3 < 7) {
            int n4 = n;
            while (n4 < n2) {
                int n5 = n4;
                while (n5 > n && comparator.compare(objectArray2[n5 - 1], objectArray2[n5]) > 0) {
                    QSort.swap(objectArray2, n5, n5 - 1);
                    --n5;
                }
                ++n4;
            }
            return;
        }
        int n6 = (n + n2) / 2;
        QSort.mergeSort(objectArray2, objectArray, n, n6, comparator);
        QSort.mergeSort(objectArray2, objectArray, n6, n2, comparator);
        if (comparator.compare(objectArray[n6 - 1], objectArray[n6]) <= 0) {
            System.arraycopy(objectArray, n, objectArray2, n, n3);
            return;
        }
        int n7 = n;
        int n8 = n;
        int n9 = n6;
        while (n7 < n2) {
            objectArray2[n7] = n9 >= n2 || n8 < n6 && comparator.compare(objectArray[n8], objectArray[n9]) <= 0 ? objectArray[n8++] : objectArray[n9++];
            ++n7;
        }
    }

    private static void rangeCheck(int n, int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException("fromIndex(" + n2 + ") > toIndex(" + n3 + ")");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n3 > n) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    public static void main(String[] stringArray) {
        int n = 1000;
        if (stringArray.length == 0) {
            System.out.println("usage: java QSort <amount to sort>");
        } else {
            n = Integer.parseInt(stringArray[0]);
        }
        Object[] objectArray = new Double[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = new Double(Math.random());
            ++n2;
        }
        DoubleComparator doubleComparator = new DoubleComparator();
        long l = System.currentTimeMillis();
        QSort.quickSort(objectArray, 0, n - 1, (Comparator)doubleComparator);
        long l2 = System.currentTimeMillis() - l;
        System.out.println("" + n + " numbers was sorted in " + l2 + " milliseconds");
    }
}

