/*
 * Decompiled with CFR 0.152.
 */
package PVS.Utils;

import PVS.Utils.PixelConsumer;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.AttributedCharacterIterator;

public class GraphicsPS
extends Graphics {
    public static final int CLONE = 49;
    protected static final int PAGEHEIGHT = 864;
    protected static final int PAGEWIDTH = 595;
    protected static final int XOFFSET = 5;
    protected static final int YOFFSET = 5;
    protected static final char[] hd = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected static final int charsPerRow = 72;
    protected PrintStream os = System.out;
    protected Color clr = Color.black;
    protected Font font = new Font("Helvetica", 0, 12);
    protected Rectangle clippingRect = new Rectangle(0, 0, 595, 864);
    protected Graphics g;

    public GraphicsPS(OutputStream outputStream, Graphics graphics) {
        this.os = new PrintStream(outputStream);
        this.g = graphics;
        this.emitProlog();
    }

    public GraphicsPS(OutputStream outputStream, Graphics graphics, int n) {
        this.os = new PrintStream(outputStream);
        this.g = graphics;
        if (n != 49) {
            this.emitProlog();
        }
    }

    public Graphics create() {
        GraphicsPS graphicsPS = new GraphicsPS(this.os, this.g, 49);
        graphicsPS.font = this.font;
        graphicsPS.clippingRect = this.clippingRect;
        graphicsPS.clr = this.clr;
        return graphicsPS;
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        Graphics graphics = this.create();
        graphics.translate(n, n2);
        graphics.clipRect(0, 0, n3, n4);
        return graphics;
    }

    public void translate(int n, int n2) {
        this.os.print(n);
        this.os.print(" ");
        this.os.print(-n2);
        this.os.println(" translate");
    }

    public void scale(float f, float f2) {
        this.os.print(f);
        this.os.print(" ");
        this.os.print(f2);
        this.os.println(" scale");
    }

    public Color getColor() {
        return this.clr;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.clr = color;
        }
        this.os.print((double)this.clr.getRed() / 255.0);
        this.os.print(" ");
        this.os.print((double)this.clr.getGreen() / 255.0);
        this.os.print(" ");
        this.os.print((double)this.clr.getBlue() / 255.0);
        this.os.println(" setrgbcolor");
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color color) {
        System.err.println("Warning: GraphicsPS does not support XOR mode");
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font != null) {
            String string;
            this.font = font;
            String string2 = this.font.getName();
            int n = this.font.getStyle();
            if (string2.equals("Symbol")) {
                string = "Symbol";
            } else if (string2.equals("Times")) {
                string = "Times-";
                switch (n) {
                    case 0: {
                        string = string + "Roman";
                        break;
                    }
                    case 1: {
                        string = string + "Bold";
                        break;
                    }
                    case 2: {
                        string = string + "Italic";
                        break;
                    }
                    case 3: {
                        string = string + "BoldItalic";
                    }
                }
            } else if (string2.equals("Helvetica") || string2.equals("Courier")) {
                string = string2;
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        string = string + "-Bold";
                        break;
                    }
                    case 2: {
                        string = string + "-Oblique";
                        break;
                    }
                    case 3: {
                        string = string + "BoldOblique";
                    }
                }
            } else {
                string = "Courier";
            }
            this.os.println("/" + string + " findfont");
            this.os.print(this.font.getSize());
            this.os.println(" scalefont setfont");
        }
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.g.getFontMetrics(font);
    }

    public Rectangle getClipRect() {
        return this.clippingRect;
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clippingRect = new Rectangle(n, n2, n3, n4);
        n2 = this.transformY(n2);
        this.drawLine(n, n2, n + n3, n2);
        this.drawLine(n + n3, n2, n + n3, n2 - n4);
        this.drawLine(n, n2, n, n2 - n4);
        this.os.println("closepath eoclip newpath");
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new RuntimeException("copyArea not supported");
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        n2 = this.transformY(n2);
        n4 = this.transformY(n4);
        this.os.print(n);
        this.os.print(" ");
        this.os.print(n2);
        this.os.print(" m ");
        this.os.print(n3);
        this.os.print(" ");
        this.os.print(n4);
        this.os.println(" l s");
    }

    protected void doRect(int n, int n2, int n3, int n4, boolean bl) {
        n2 = this.transformY(n2);
        this.os.print(n);
        this.os.print(" ");
        this.os.print(n2);
        this.os.println(" m ");
        this.os.print(n + n3);
        this.os.print(" ");
        this.os.print(n2);
        this.os.println(" l ");
        this.os.print(n + n3);
        this.os.print(" ");
        this.os.print(n2 - n4);
        this.os.println(" l ");
        this.os.print(n);
        this.os.print(" ");
        this.os.print(n2 - n4);
        this.os.println(" l ");
        this.os.print(n);
        this.os.print(" ");
        this.os.print(n2);
        this.os.println(" l ");
        if (bl) {
            this.os.println("e");
        } else {
            this.os.println("s");
        }
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.os.println("%fillRect");
        this.doRect(n, n2, n3, n4, true);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.os.println("%drawRect");
        this.doRect(n, n2, n3, n4, false);
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.os.println("%clearRect");
        this.os.println("gsave");
        this.os.println("1 1 1 setrgbcolor");
        this.doRect(n, n2, n3, n4, true);
        this.os.println("grestore");
    }

    private void doRoundRect(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        n2 = this.transformY(n2);
        this.os.print(n + n6);
        this.os.print(" ");
        this.os.print(n2);
        this.os.println(" moveto");
        this.os.print(n + n3);
        this.os.print(" ");
        this.os.print(n2);
        this.os.print(" ");
        this.os.print(n + n3);
        this.os.print(" ");
        this.os.print(n2 - n4);
        this.os.print(" ");
        this.os.print(n6);
        this.os.println(" arcto");
        this.os.println("4 {pop} repeat");
        this.os.print(n + n3);
        this.os.print(" ");
        this.os.print(n2 - n4);
        this.os.print(" ");
        this.os.print(n);
        this.os.print(" ");
        this.os.print(n2 - n4);
        this.os.print(" ");
        this.os.print(n6);
        this.os.println(" arcto");
        this.os.println("4 {pop} repeat");
        this.os.print(n);
        this.os.print(" ");
        this.os.print(n2 - n4);
        this.os.print(" ");
        this.os.print(n);
        this.os.print(" ");
        this.os.print(n2);
        this.os.print(" ");
        this.os.print(n6);
        this.os.println(" arcto");
        this.os.println("4 {pop} repeat");
        this.os.print(n);
        this.os.print(" ");
        this.os.print(n2);
        this.os.print(" ");
        this.os.print(n + n3);
        this.os.print(" ");
        this.os.print(n2);
        this.os.print(" ");
        this.os.print(n6);
        this.os.println(" arcto");
        this.os.println("4 {pop} repeat");
        if (bl) {
            this.os.println("e");
        } else {
            this.os.println("s");
        }
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.os.println("%drawRoundRect");
        this.doRoundRect(n, n2, n3, n4, n5, n6, false);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.os.println("%fillRoundRect");
        this.doRoundRect(n, n2, n3, n4, n5, n6, true);
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.os.println("%draw3DRect");
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        this.setColor(bl ? color2 : color3);
        this.drawLine(n, n2, n, n2 + n4);
        this.drawLine(n + 1, n2, n + n3 - 1, n2);
        this.setColor(bl ? color3 : color2);
        this.drawLine(n + 1, n2 + n4, n + n3, n2 + n4);
        this.drawLine(n + n3, n2, n + n3, n2 + n4);
        this.setColor(color);
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.os.println("%fill3DRect");
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        if (!bl) {
            this.setColor(color3);
        }
        this.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        this.setColor(bl ? color2 : color3);
        this.drawLine(n, n2, n, n2 + n4 - 1);
        this.drawLine(n + 1, n2, n + n3 - 2, n2);
        this.setColor(bl ? color3 : color2);
        this.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        this.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        this.setColor(color);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.os.println("%drawOval");
        this.doArc(n, n2, n3, n4, 0, 360, false);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.os.println("%fillOval");
        this.doArc(n, n2, n3, n4, 0, 360, true);
    }

    private void doArc(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        n2 = this.transformY(n2);
        this.os.println("gsave");
        float f = (float)n + (float)n3 / 2.0f;
        float f2 = (float)n2 - (float)n4 / 2.0f;
        this.os.print(f);
        this.os.print(" ");
        this.os.print(f2);
        this.os.println(" translate");
        float f3 = (float)n4 / (float)n3;
        this.os.print(1.0);
        this.os.print(" ");
        this.os.print(f3);
        this.os.println(" scale");
        if (bl) {
            this.os.println("0 0 moveto");
        }
        float f4 = n5 + n6;
        this.os.print("0 0 ");
        this.os.print((double)n3 / 2.0);
        this.os.print(" ");
        this.os.print(n5);
        this.os.print(" ");
        this.os.print(f4);
        this.os.println(" arc");
        if (bl) {
            this.os.println("closepath e");
        } else {
            this.os.println("s");
        }
        this.os.println("grestore");
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.os.println("%drawArc");
        this.doArc(n, n2, n3, n4, n5, n6, false);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.os.println("%fillArc");
        this.doArc(n, n2, n3, n4, n5, n6, true);
    }

    private void doPoly(int[] nArray, int[] nArray2, int n, boolean bl) {
        if (n < 2) {
            return;
        }
        int[] nArray3 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray3[n2] = this.transformY(nArray2[n2]);
            ++n2;
        }
        this.os.print(nArray[0]);
        this.os.print(" ");
        this.os.print(nArray3[0]);
        this.os.println(" m ");
        n2 = 0;
        while (n2 < n) {
            this.os.print(nArray[n2]);
            this.os.print(" ");
            this.os.print(nArray3[n2]);
            this.os.println(" l ");
            ++n2;
        }
        if (nArray[n - 1] != nArray[0] || nArray3[n - 1] != nArray3[0]) {
            this.os.print(nArray[0]);
            this.os.print(" ");
            this.os.print(nArray3[0]);
            this.os.println(" l ");
        }
        if (bl) {
            this.os.println("e");
        } else {
            this.os.println("s");
        }
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.doPoly(nArray, nArray2, n, false);
    }

    public void drawPolygon(Polygon polygon) {
        this.os.println("%drawPoly");
        this.doPoly(polygon.xpoints, polygon.ypoints, polygon.npoints, false);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.os.println("%fillPoly");
        this.doPoly(nArray, nArray2, n, true);
    }

    public void fillPolygon(Polygon polygon) {
        this.os.println("%fillPoly");
        this.doPoly(polygon.xpoints, polygon.ypoints, polygon.npoints, true);
    }

    public void drawString(String string, int n, int n2) {
        n2 = this.transformY(n2);
        this.os.print(n);
        this.os.print(" ");
        this.os.print(n2);
        this.os.print(" moveto (");
        this.os.print(string);
        this.os.println(") show s");
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.drawString(new String(cArray, n, n2), n3, n4);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        this.drawString(new String(byArray, 0, n, n2), n3, n4);
    }

    public boolean doImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver, Color color) {
        n2 = this.transformY(n2);
        PixelConsumer pixelConsumer = new PixelConsumer(image);
        this.os.println("gsave");
        this.os.println("% build a temporary dictionary");
        this.os.println("20 dict begin");
        this.emitColorImageProlog(pixelConsumer.xdim);
        this.os.println("% lower left corner");
        this.os.print(n);
        this.os.print(" ");
        this.os.print(n2);
        this.os.println(" translate");
        if (n4 == 0 || n3 == 0) {
            n4 = pixelConsumer.ydim;
            n3 = pixelConsumer.xdim;
        }
        this.os.println("% size of image");
        this.os.print(n3);
        this.os.print(" ");
        this.os.print(n4);
        this.os.println(" scale");
        this.os.print(pixelConsumer.xdim);
        this.os.print(" ");
        this.os.print(pixelConsumer.ydim);
        this.os.println(" 8");
        this.os.print("[");
        this.os.print(pixelConsumer.xdim);
        this.os.print(" 0 0 -");
        this.os.print(pixelConsumer.ydim);
        this.os.print(" 0 ");
        this.os.print(0);
        this.os.println("]");
        this.os.println("{currentfile pix readhexstring pop}");
        this.os.println("false 3 colorimage");
        this.os.println("");
        int n5 = 0;
        char[] cArray = new char[73];
        int n6 = 0;
        while (n6 < pixelConsumer.ydim) {
            int n7;
            int n8;
            int n9 = 0;
            ++n5;
            if (color == null) {
                n8 = 0;
                while (n8 < pixelConsumer.xdim) {
                    n7 = pixelConsumer.pix[n8][n6];
                    cArray[n9++] = hd[(n7 & 0xF0) >> 4];
                    cArray[n9++] = hd[n7 & 0xF];
                    cArray[n9++] = hd[(n7 & 0xF000) >> 12];
                    cArray[n9++] = hd[(n7 & 0xF00) >> 8];
                    cArray[n9++] = hd[(n7 & 0xF00000) >> 20];
                    cArray[n9++] = hd[(n7 & 0xF0000) >> 16];
                    if (n9 >= 72) {
                        String string = String.copyValueOf(cArray, 0, n9);
                        this.os.println(string);
                        if (n5 > 5) {
                            try {
                                Thread.sleep(15L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            n5 = 0;
                        }
                        n9 = 0;
                    }
                    ++n8;
                }
            } else {
                System.out.println("%FalseColor");
                n8 = 0;
                while (n8 < pixelConsumer.xdim) {
                    n7 = color.getGreen() << 16 + color.getBlue() << 8 + color.getRed();
                    int n10 = this.clr.getGreen() << 16 + this.clr.getBlue() << 8 + this.clr.getRed();
                    int n11 = pixelConsumer.pix[n8][n6] == 1 ? n10 : n7;
                    cArray[n9++] = hd[n11 & 0xF0];
                    cArray[n9++] = hd[n11 & 0xF];
                    cArray[n9++] = hd[n11 & 0xF000];
                    cArray[n9++] = hd[n11 & 0xF00];
                    cArray[n9++] = hd[n11 & 0xF00000];
                    cArray[n9++] = hd[n11 & 0xF0000];
                    if (n9 >= 72) {
                        String string = String.copyValueOf(cArray, 0, n9);
                        this.os.println(string);
                        if (n5 > 5) {
                            try {
                                Thread.sleep(15L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            n5 = 0;
                        }
                        n9 = 0;
                    }
                    ++n8;
                }
            }
            if (n9 != 0) {
                String string = String.copyValueOf(cArray, 0, n9);
                this.os.println(string);
            }
            ++n6;
        }
        this.os.println("");
        this.os.println("end");
        this.os.println("grestore");
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        this.os.println("%drawImage-1");
        return this.doImage(image, n, n2, 0, 0, imageObserver, null);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this.os.println("%drawImage-2");
        return this.doImage(image, n, n2, n3, n4, imageObserver, null);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        this.os.println("%drawImage-3");
        return this.doImage(image, n, n2, 0, 0, imageObserver, color);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        this.os.println("%drawImage-4");
        return this.doImage(image, n, n2, n3, n4, imageObserver, color);
    }

    public void dispose() {
        this.os.println("%dispose");
        this.os.flush();
    }

    public void finalize() {
        this.dispose();
    }

    public String toString() {
        return this.getClass().getName() + "[font=" + this.getFont() + ",color=" + this.getColor() + "]";
    }

    protected int transformY(int n) {
        return 3456 - n;
    }

    protected void emitProlog() {
        this.os.println("%!Adobe-PS-2.0 Created by GraphicsPS Java PostScript Context");
        this.os.println("% (C)1996 Ernest Friedman-Hill and Sandia National Labs");
        this.os.println("0.25 0.25 scale");
        this.os.println("/m {moveto} bind def");
        this.os.println("/l {lineto} bind def");
        this.os.println("/s {stroke} bind def");
        this.os.println("/e {eofill} bind def");
        this.setFont(this.font);
    }

    protected void emitColorImageProlog(int n) {
        this.os.println("% Color picture stuff, lifted from XV's PS files");
        this.os.println("% define string to hold a scanline's worth of data");
        this.os.print("/pix ");
        this.os.print(n * 3);
        this.os.println(" string def");
        this.os.println("% define space for color conversions");
        this.os.print("/grays ");
        this.os.print(n);
        this.os.println(" string def  % space for gray scale line");
        this.os.println("/npixls 0 def");
        this.os.println("/rgbindx 0 def");
        this.os.println("% define 'colorimage' if it isn't defined");
        this.os.println("%   ('colortogray' and 'mergeprocs' come from xwd2ps");
        this.os.println("%     via xgrab)");
        this.os.println("/colorimage where   % do we know about 'colorimage'?");
        this.os.println("{ pop }           % yes: pop off the 'dict' returned");
        this.os.println("{                 % no:  define one");
        this.os.println("/colortogray {  % define an RGB->I function");
        this.os.println("/rgbdata exch store    % call input 'rgbdata'");
        this.os.println("rgbdata length 3 idiv");
        this.os.println("/npixls exch store");
        this.os.println("/rgbindx 0 store");
        this.os.println("0 1 npixls 1 sub {");
        this.os.println("grays exch");
        this.os.println("rgbdata rgbindx       get 20 mul    % Red");
        this.os.println("rgbdata rgbindx 1 add get 32 mul    % Green");
        this.os.println("rgbdata rgbindx 2 add get 12 mul    % Blue");
        this.os.println("add add 64 idiv      % I = .5G + .31R + .18B");
        this.os.println("put");
        this.os.println("/rgbindx rgbindx 3 add store");
        this.os.println("} for");
        this.os.println("grays 0 npixls getinterval");
        this.os.println("} bind def");
        this.os.println("");
        this.os.println("% Utility procedure for colorimage operator.");
        this.os.println("% This procedure takes two procedures off the");
        this.os.println("% stack and merges them into a single procedure.");
        this.os.println("");
        this.os.println("/mergeprocs { % def");
        this.os.println("dup length");
        this.os.println("3 -1 roll");
        this.os.println("dup");
        this.os.println("length");
        this.os.println("dup");
        this.os.println("5 1 roll");
        this.os.println("3 -1 roll");
        this.os.println("add");
        this.os.println("array cvx");
        this.os.println("dup");
        this.os.println("3 -1 roll");
        this.os.println("0 exch");
        this.os.println("putinterval");
        this.os.println("dup");
        this.os.println("4 2 roll");
        this.os.println("putinterval");
        this.os.println("} bind def");
        this.os.println("");
        this.os.println("/colorimage { % def");
        this.os.println("pop pop     % remove 'false 3' operands");
        this.os.println("{colortogray} mergeprocs");
        this.os.println("image");
        this.os.println("} bind def");
        this.os.println("} ifelse          % end of 'false' case");
    }

    public void gsave() {
        this.os.println("gsave");
    }

    public void grestore() {
        this.os.println("grestore");
    }

    public int getWidth() {
        return 2380;
    }

    public int getHeight() {
        return 3456;
    }

    public void flush() {
        this.os.println("showpage");
        this.os.flush();
    }

    public Shape getClip() {
        return null;
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
    }

    public void setClip(int n, int n2, int n3, int n4) {
    }

    public Rectangle getClipBounds() {
        return null;
    }

    public void setClip(Shape shape) {
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return true;
    }
}

