/*
 * Decompiled with CFR 0.152.
 */
package PVS.Utils;

import PVS.Utils.Point2;
import PVS.Utils.ViewRect;
import PVS.Utils.Viewport;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.util.Vector;

public class Graphics2D {
    Graphics g;
    boolean paintMode = true;
    public Color XORColor = Color.white;
    Viewport viewport;
    ViewRect screenRect;
    protected double scalex = 1.0;
    protected double scaley = 1.0;
    protected double x0 = 0.0;
    protected double y0 = 0.0;
    static double rad2grad = 57.29577951308232;

    public Graphics2D() {
    }

    public Graphics2D(Graphics graphics) {
        this.g = graphics;
    }

    public void setGraphics(Graphics graphics) {
        this.g = graphics;
    }

    public Graphics getGraphics() {
        return this.g;
    }

    public void setViewport(Viewport viewport) {
        this.viewport = viewport;
        this.initTransform();
    }

    public void setScreenRectangle(ViewRect viewRect) {
        this.screenRect = viewRect;
        this.initTransform();
    }

    void initTransform() {
        if (this.viewport != null && this.screenRect != null) {
            this.scalex = (double)(this.screenRect.right - this.screenRect.left) / (this.viewport.right - this.viewport.left);
            this.scaley = (double)(this.screenRect.top - this.screenRect.bottom) / (this.viewport.top - this.viewport.bottom);
            this.x0 = -this.viewport.left + (double)this.screenRect.left / this.scalex;
            this.y0 = -this.viewport.top + (double)this.screenRect.top / this.scaley;
        }
    }

    public void setScale(double d) {
        this.scalex = d;
        this.scaley = d;
    }

    public void setScale(double d, double d2) {
        this.scalex = d;
        this.scaley = d2;
    }

    public void setTranslation(double d, double d2) {
        this.x0 = d;
        this.y0 = d2;
    }

    public void setTranslation(Point2 point2) {
        this.x0 = point2.x;
        this.y0 = point2.y;
    }

    public void translate(Point2 point2) {
        this.x0 += point2.x;
        this.y0 += point2.y;
    }

    public double x2screen(double d) {
        double d2 = this.scalex * (d + this.x0);
        return d2;
    }

    public double y2screen(double d) {
        double d2 = this.scaley * (d + this.y0);
        return d2;
    }

    public Point xy2screen(double d, double d2) {
        return new Point((int)(this.scalex * (d + this.x0)), (int)(this.scaley * (d2 + this.y0)));
    }

    public Point2 screen2world(int n, int n2) {
        return new Point2((double)n / this.scalex - this.x0, (double)n2 / this.scaley - this.y0);
    }

    public void drawString(String string, double d, double d2) {
        this.g.drawString(string, (int)this.x2screen(d), (int)this.y2screen(d2));
    }

    public void drawCyrcle(double d, double d2, double d3) {
        double d4 = this.x2screen(d - d3);
        double d5 = this.y2screen(d2 - d3);
        double d6 = this.x2screen(d + d3) - d4;
        double d7 = this.y2screen(d2 + d3) - d5;
        this.g.drawOval((int)d4, (int)d5, (int)d6, (int)d7);
    }

    public void fillCyrcle(double d, double d2, double d3) {
        double d4 = this.x2screen(d - d3);
        double d5 = this.y2screen(d2 - d3);
        double d6 = this.x2screen(d + d3) - d4;
        double d7 = this.y2screen(d2 + d3) - d5;
        this.g.fillOval((int)d4, (int)d5, (int)d6, (int)d7);
    }

    public boolean drawImage(Image image, double d, double d2, double d3, double d4, ImageObserver imageObserver) {
        Point point = this.xy2screen(d, d2);
        Point point2 = this.xy2screen(d + d3, d2 + d4);
        return this.g.drawImage(image, point.x, point.y, point2.x - point.x, point2.y - point.y, imageObserver);
    }

    private int segmentsInArc(double d, double d2) {
        if (d == 0.0) {
            return 1;
        }
        int n = (int)Math.ceil(Math.abs(d2 * rad2grad / 5.0));
        int n2 = (int)Math.abs(this.x2screen(d)) + 1;
        return Math.min(n, n2);
    }

    public void drawArc(double d, double d2, double d3, double d4, double d5) {
        int n = this.segmentsInArc(d3, d5);
        int n2 = (int)this.x2screen(d + d3 * Math.cos(d4));
        int n3 = (int)this.y2screen(d2 + d3 * Math.sin(d4));
        int n4 = 1;
        while (n4 <= n) {
            double d6 = d4 + (double)n4 * d5 / (double)n;
            int n5 = (int)this.x2screen(d + d3 * Math.cos(d6));
            int n6 = (int)this.y2screen(d2 + d3 * Math.sin(d6));
            this.g.drawLine(n2, n3, n5, n6);
            n2 = n5;
            n3 = n6;
            ++n4;
        }
    }

    public void drawLine(double d, double d2, double d3, double d4) {
        if (this.viewport != null) {
            this.clipLine(d, d2, d3, d4, this.viewport);
        } else {
            this.drawLineNoClip(d, d2, d3, d4);
        }
    }

    public void drawLineNoClip(double d, double d2, double d3, double d4) {
        double d5 = this.x2screen(d);
        double d6 = this.y2screen(d2);
        double d7 = this.x2screen(d3);
        double d8 = this.y2screen(d4);
        this.g.drawLine((int)d5, (int)d6, (int)d7, (int)d8);
    }

    public void setColor(Color color) {
        this.g.setColor(color);
    }

    public void drawRect(double d, double d2, double d3, double d4) {
        double d5 = this.x2screen(d);
        double d6 = this.x2screen(d + d3);
        double d7 = this.y2screen(d2);
        double d8 = this.y2screen(d2 + d4);
        this.g.drawRect((int)(d5 + 0.5), (int)(d7 + 0.5), (int)(d6 - d5 + 0.5), (int)(d8 - d7 + 0.5));
    }

    public void fillRect(double d, double d2, double d3, double d4) {
        double d5 = this.x2screen(d);
        double d6 = this.x2screen(d + d3);
        double d7 = this.y2screen(d2);
        double d8 = this.y2screen(d2 + d4);
        this.g.fillRect((int)(d5 + 0.5), (int)(d7 + 0.5), (int)(d6 - d5 + 0.5), (int)(d8 - d7 + 0.5));
    }

    public void drawControlSquare(double d, double d2, int n) {
        this.g.drawRect((int)this.x2screen(d) - n / 2, (int)this.y2screen(d2) - n / 2, n, n);
    }

    public void fillControlSquare(double d, double d2, int n) {
        this.g.fillRect((int)this.x2screen(d) - n / 2, (int)this.y2screen(d2) - n / 2, n, n);
    }

    public void fillPolygon(Vector vector) {
        int n = vector.size();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            Point2 point2 = (Point2)vector.elementAt(n2);
            nArray[n2] = (int)this.x2screen(point2.x);
            nArray2[n2] = (int)this.y2screen(point2.y);
            ++n2;
        }
        this.g.fillPolygon(nArray, nArray2, n);
    }

    public void drawPolygon(Vector vector) {
        int n = vector.size();
        Point2 point2 = (Point2)vector.elementAt(n - 1);
        double d = point2.x;
        double d2 = point2.y;
        int n2 = 0;
        while (n2 < n) {
            Point2 point22 = (Point2)vector.elementAt(n2);
            double d3 = point22.x;
            double d4 = point22.y;
            this.drawLine(d, d2, d3, d4);
            d = d3;
            d2 = d4;
            ++n2;
        }
    }

    public void drawPolygon(Point2[] point2Array) {
        int n = point2Array.length;
        double d = point2Array[n - 1].x;
        double d2 = point2Array[n - 1].y;
        int n2 = 0;
        while (n2 < n) {
            Point2 point2 = point2Array[n2];
            double d3 = point2.x;
            double d4 = point2.y;
            this.drawLine(d, d2, d3, d4);
            d = d3;
            d2 = d4;
            ++n2;
        }
    }

    public void fillPolygon(Point2[] point2Array) {
        int n = point2Array.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = (int)this.x2screen(point2Array[n2].x);
            nArray2[n2] = (int)this.y2screen(point2Array[n2].y);
            ++n2;
        }
        this.g.fillPolygon(nArray, nArray2, n);
    }

    public void drawPoint(double d, double d2) {
        this.g.fillRect((int)this.x2screen(d), (int)this.y2screen(d2), 1, 1);
    }

    public boolean setPaintMode() {
        boolean bl = this.paintMode;
        this.paintMode = true;
        this.g.setPaintMode();
        return bl;
    }

    public boolean setXORMode(Color color) {
        boolean bl = this.paintMode;
        this.paintMode = false;
        this.g.setXORMode(color);
        this.XORColor = color;
        return bl;
    }

    public boolean setPaintMode(boolean bl) {
        boolean bl2 = this.paintMode;
        if (bl) {
            this.g.setPaintMode();
        } else {
            this.g.setXORMode(this.XORColor);
        }
        this.paintMode = bl;
        return bl2;
    }

    public void clipLine(double d, double d2, double d3, double d4, Viewport viewport) {
        double d5 = viewport.top;
        double d6 = viewport.bottom;
        double d7 = viewport.left;
        double d8 = viewport.right;
        int n = this.outcode(d, d2, d5, d6, d7, d8);
        int n2 = this.outcode(d3, d4, d5, d6, d7, d8);
        int n3 = 0;
        if ((n & n2) == 0) {
            if (n == 0 && n2 == 0) {
                this.drawLineNoClip(d, d2, d3, d4);
            } else {
                boolean bl;
                if (n != 0) {
                    n3 = n;
                    bl = true;
                } else {
                    bl = false;
                    n3 = n2;
                }
                double d9 = 0.0;
                double d10 = 0.0;
                double d11 = 0.0;
                if ((n3 & 2) != 0) {
                    d11 = (d8 - d) / (d3 - d);
                    d9 = d8;
                    d10 = d2 + (d4 - d2) * d11;
                } else if ((n3 & 1) != 0) {
                    d11 = (d7 - d) / (d3 - d);
                    d9 = d7;
                    d10 = d2 + (d4 - d2) * d11;
                } else if ((n3 & 4) != 0) {
                    d11 = (d5 - d2) / (d4 - d2);
                    d9 = d + (d3 - d) * d11;
                    d10 = d5;
                } else if ((n3 & 8) != 0) {
                    d11 = (d6 - d2) / (d4 - d2);
                    d9 = d + (d3 - d) * d11;
                    d10 = d6;
                }
                if (bl) {
                    this.clipLine(d9, d10, d3, d4, viewport);
                } else {
                    this.clipLine(d, d2, d9, d10, viewport);
                }
            }
        }
    }

    public int outcode(double d, double d2, double d3, double d4, double d5, double d6) {
        int n = 0;
        if (d < d5) {
            ++n;
        } else if (d > d6) {
            n += 2;
        }
        if (d2 > d3) {
            n += 4;
        } else if (d2 < d4) {
            n += 8;
        }
        return n;
    }

    public boolean getPaintMode() {
        return this.paintMode;
    }
}

