/*
 * Decompiled with CFR 0.152.
 */
package PVS.Utils;

import java.util.Date;

public class Fmt {
    public static final int ZF = 1;
    public static final int LJ = 2;
    public static final int HX = 4;
    public static final int OC = 8;
    private static final int WN = 16;

    public static String fmt(byte by) {
        return Fmt.fmt(by, 0, 0);
    }

    public static String fmt(byte by, int n) {
        return Fmt.fmt(by, n, 0);
    }

    public static String fmt(byte by, int n, int n2) {
        boolean bl;
        boolean bl2 = (n2 & 4) != 0;
        boolean bl3 = bl = (n2 & 8) != 0;
        if (bl2) {
            return Fmt.fmt(Integer.toString(by & 0xFF, 16), n, n2 | 0x10);
        }
        if (bl) {
            return Fmt.fmt(Integer.toString(by & 0xFF, 8), n, n2 | 0x10);
        }
        return Fmt.fmt(Integer.toString(by & 0xFF), n, n2 | 0x10);
    }

    public static String fmt(short s) {
        return Fmt.fmt(s, 0, 0);
    }

    public static String fmt(short s, int n) {
        return Fmt.fmt(s, n, 0);
    }

    public static String fmt(short s, int n, int n2) {
        boolean bl;
        boolean bl2 = (n2 & 4) != 0;
        boolean bl3 = bl = (n2 & 8) != 0;
        if (bl2) {
            return Fmt.fmt(Integer.toString(s & 0xFFFF, 16), n, n2 | 0x10);
        }
        if (bl) {
            return Fmt.fmt(Integer.toString(s & 0xFFFF, 8), n, n2 | 0x10);
        }
        return Fmt.fmt(Integer.toString(s), n, n2 | 0x10);
    }

    public static String fmt(int n) {
        return Fmt.fmt(n, 0, 0);
    }

    public static String fmt(int n, int n2) {
        return Fmt.fmt(n, n2, 0);
    }

    public static String fmt(int n, int n2, int n3) {
        boolean bl;
        boolean bl2 = (n3 & 4) != 0;
        boolean bl3 = bl = (n3 & 8) != 0;
        if (bl2) {
            return Fmt.fmt(Long.toString((long)n & 0xFFFFFFFFL, 16), n2, n3 | 0x10);
        }
        if (bl) {
            return Fmt.fmt(Long.toString((long)n & 0xFFFFFFFFL, 8), n2, n3 | 0x10);
        }
        return Fmt.fmt(Integer.toString(n), n2, n3 | 0x10);
    }

    public static String fmt(long l) {
        return Fmt.fmt(l, 0, 0);
    }

    public static String fmt(long l, int n) {
        return Fmt.fmt(l, n, 0);
    }

    public static String fmt(long l, int n, int n2) {
        boolean bl;
        boolean bl2 = (n2 & 4) != 0;
        boolean bl3 = bl = (n2 & 8) != 0;
        if (bl2) {
            if ((l & 0xF000000000000000L) != 0L) {
                return Fmt.fmt(Long.toString(l >>> 60, 16) + Long.toString(l & 0xFFFFFFFFFFFFFFFL, 16), n, n2 | 0x10);
            }
            return Fmt.fmt(Long.toString(l, 16), n, n2 | 0x10);
        }
        if (bl) {
            if ((l & Long.MIN_VALUE) != 0L) {
                return Fmt.fmt(Long.toString(l >>> 63, 8) + Long.toString(l & Long.MAX_VALUE, 8), n, n2 | 0x10);
            }
            return Fmt.fmt(Long.toString(l, 8), n, n2 | 0x10);
        }
        return Fmt.fmt(Long.toString(l), n, n2 | 0x10);
    }

    public static String fmt(float f) {
        return Fmt.fmt(f, 0, 0, 0);
    }

    public static String fmt(float f, int n) {
        return Fmt.fmt(f, n, 0, 0);
    }

    public static String fmt(float f, int n, int n2) {
        return Fmt.fmt(f, n, n2, 0);
    }

    public static String fmt(float f, int n, int n2, int n3) {
        if (n2 != 0) {
            return Fmt.fmt(Fmt.sigFigFix(Float.toString(f), n2), n, n3 | 0x10);
        }
        return Fmt.fmt(Float.toString(f), n, n3 | 0x10);
    }

    public static String fmt(double d) {
        return Fmt.fmt(d, 0, 0, 0);
    }

    public static String fmt(double d, int n) {
        return Fmt.fmt(d, n, 0, 0);
    }

    public static String fmt(double d, int n, int n2) {
        return Fmt.fmt(d, n, n2, 0);
    }

    public static String fmt(double d, int n, int n2, int n3) {
        if (n2 != 0) {
            return Fmt.fmt(Fmt.sigFigFix(Fmt.doubleToString(d), n2), n, n3 | 0x10);
        }
        return Fmt.fmt(Fmt.doubleToString(d), n, n3 | 0x10);
    }

    public static String fmt(char c) {
        return Fmt.fmt(c, 0, 0);
    }

    public static String fmt(char c, int n) {
        return Fmt.fmt(c, n, 0);
    }

    public static String fmt(char c, int n, int n2) {
        return Fmt.fmt(new Character(c).toString(), n, n2);
    }

    public static String fmt(Object object) {
        return Fmt.fmt(object, 0, 0);
    }

    public static String fmt(Object object, int n) {
        return Fmt.fmt(object, n, 0);
    }

    public static String fmt(Object object, int n, int n2) {
        return Fmt.fmt(object.toString(), n, n2);
    }

    public static String fmt(String string) {
        return Fmt.fmt(string, 0, 0);
    }

    public static String fmt(String string, int n) {
        return Fmt.fmt(string, n, 0);
    }

    public static String fmt(String string, int n, int n2) {
        boolean bl;
        int n3 = string.length();
        boolean bl2 = (n2 & 1) != 0;
        boolean bl3 = (n2 & 2) != 0;
        boolean bl4 = (n2 & 4) != 0;
        boolean bl5 = (n2 & 8) != 0;
        boolean bl6 = bl = (n2 & 0x10) != 0;
        if ((bl4 || bl5 || bl2) && !bl) {
            throw new InternalError("Acme.Fmt: number flag on a non-number");
        }
        if (bl2 && bl3) {
            throw new InternalError("Acme.Fmt: zero-fill left-justify is silly");
        }
        if (bl4 && bl5) {
            throw new InternalError("Acme.Fmt: can't do both hex and octal");
        }
        if (n3 >= n) {
            return string;
        }
        int n4 = n - n3;
        StringBuffer stringBuffer = new StringBuffer(n4);
        int n5 = 0;
        while (n5 < n4) {
            if (bl2) {
                stringBuffer.append('0');
            } else {
                stringBuffer.append(' ');
            }
            ++n5;
        }
        if (bl3) {
            return string + stringBuffer;
        }
        if (bl2 && string.startsWith("-")) {
            return "-" + stringBuffer + string.substring(1);
        }
        return stringBuffer + string;
    }

    private static String sigFigFix(String string, int n) {
        int n2;
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2;
        String string2;
        String string3;
        String string4;
        String string5;
        if (string.startsWith("-") || string.startsWith("+")) {
            string5 = string.substring(0, 1);
            string4 = string.substring(1);
        } else {
            string5 = "";
            string4 = string;
        }
        int n3 = string4.indexOf(101);
        if (n3 == -1) {
            n3 = string4.indexOf(69);
        }
        if (n3 == -1) {
            string3 = string4;
            string2 = "";
        } else {
            string3 = string4.substring(0, n3);
            string2 = string4.substring(n3);
        }
        int n4 = string3.indexOf(46);
        if (n4 == -1) {
            stringBuffer2 = new StringBuffer(string3);
            stringBuffer = new StringBuffer("");
        } else {
            stringBuffer2 = new StringBuffer(string3.substring(0, n4));
            stringBuffer = new StringBuffer(string3.substring(n4 + 1));
        }
        int n5 = stringBuffer2.length();
        int n6 = stringBuffer.length();
        if ((n5 == 0 || stringBuffer2.equals("0")) && n6 > 0) {
            n5 = 0;
            n2 = 0;
            while (n2 < stringBuffer.length()) {
                if (stringBuffer.charAt(n2) != '0') break;
                --n6;
                ++n2;
            }
        }
        if (n > (n2 = n5 + n6)) {
            int n7 = n2;
            while (n7 < n) {
                stringBuffer.append('0');
                ++n7;
            }
        } else if (n < n2 && n >= n5) {
            stringBuffer.setLength(stringBuffer.length() - (n6 - (n - n5)));
        } else if (n < n5) {
            stringBuffer.setLength(0);
            int n8 = n;
            while (n8 < n5) {
                stringBuffer2.setCharAt(n8, '0');
                ++n8;
            }
        }
        if (stringBuffer.length() == 0) {
            return string5 + stringBuffer2 + string2;
        }
        return string5 + stringBuffer2 + "." + stringBuffer + string2;
    }

    public static String doubleToString(double d) {
        int n;
        int n2;
        String string;
        String string2;
        String string3;
        int n3;
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Inf";
        }
        boolean bl = false;
        if (d < 0.0) {
            bl = true;
            d = -d;
        }
        if ((n3 = (string3 = Double.toString(d)).indexOf(101)) == -1) {
            n3 = string3.indexOf(69);
        }
        if (n3 == -1) {
            string2 = string3;
            string = "";
            n2 = 0;
        } else {
            string2 = string3.substring(0, n3);
            string = string3.substring(n3 + 1);
            n2 = string.startsWith("+") ? Integer.parseInt(string.substring(1)) : Integer.parseInt(string);
        }
        int n4 = string2.indexOf(46);
        String string4 = n4 == -1 ? string2 : string2.substring(0, n4);
        long l = string4.length() == 0 ? 0L : (long)Integer.parseInt(string4);
        StringBuffer stringBuffer = new StringBuffer(string4 + ".");
        double d2 = Math.pow(10.0, n2);
        double d3 = d - (double)l * d2;
        String string5 = "0123456789";
        int n5 = 16 - string4.length();
        int n6 = 0;
        while (n6 < n5) {
            n = (int)(d3 / (d2 /= 10.0));
            if (n < 0) {
                n = 0;
            }
            if (n > 9) {
                n = 9;
            }
            stringBuffer.append(string5.charAt(n));
            d3 -= (double)n * d2;
            ++n6;
        }
        if ((int)(d3 / d2 + 0.5) == 1) {
            n = 1;
            int n7 = stringBuffer.length() - 1;
            while (n7 >= 0) {
                int n8 = string5.indexOf(stringBuffer.charAt(n7));
                if (n8 != -1) {
                    if (++n8 == 10) {
                        stringBuffer.setCharAt(n7, '0');
                    } else {
                        stringBuffer.setCharAt(n7, string5.charAt(n8));
                        n = 0;
                        break;
                    }
                }
                --n7;
            }
            if (n != 0) {
                stringBuffer.append("ROUNDMORE");
            }
        }
        n = stringBuffer.length();
        while (stringBuffer.charAt(n - 1) == '0') {
            stringBuffer.setLength(--n);
        }
        if (stringBuffer.charAt(n - 1) == '.') {
            stringBuffer.setLength(--n);
        }
        return (bl ? "-" : "") + stringBuffer + (string.length() != 0 ? "e" + string : "");
    }

    public static void main(String[] stringArray) {
        System.out.println("Starting tests.");
        Fmt.show(Fmt.fmt("Hello there."));
        Fmt.show(Fmt.fmt(123));
        Fmt.show(Fmt.fmt(123, 10));
        Fmt.show(Fmt.fmt(123, 10, 1));
        Fmt.show(Fmt.fmt(123, 10, 2));
        Fmt.show(Fmt.fmt(-123));
        Fmt.show(Fmt.fmt(-123, 10));
        Fmt.show(Fmt.fmt(-123, 10, 1));
        Fmt.show(Fmt.fmt(-123, 10, 2));
        Fmt.show(Fmt.fmt((byte)-66, 22, 8));
        Fmt.show(Fmt.fmt((short)-17730, 22, 8));
        Fmt.show(Fmt.fmt(-889275714, 22, 8));
        Fmt.show(Fmt.fmt(-2401053089206453570L, 22, 8));
        Fmt.show(Fmt.fmt((byte)-66, 16, 4));
        Fmt.show(Fmt.fmt((short)-17730, 16, 4));
        Fmt.show(Fmt.fmt(-889275714, 16, 4));
        Fmt.show(Fmt.fmt(-2401053089206453570L, 16, 4));
        Fmt.show(Fmt.fmt('c'));
        Fmt.show(Fmt.fmt(new Date()));
        Fmt.show(Fmt.fmt(123.456f));
        Fmt.show(Fmt.fmt(1.23456E17f));
        Fmt.show(Fmt.fmt(123.456f, 0, 8));
        Fmt.show(Fmt.fmt(123.456f, 0, 7));
        Fmt.show(Fmt.fmt(123.456f, 0, 6));
        Fmt.show(Fmt.fmt(123.456f, 0, 5));
        Fmt.show(Fmt.fmt(123.456f, 0, 4));
        Fmt.show(Fmt.fmt(123.456f, 0, 3));
        Fmt.show(Fmt.fmt(123.456f, 0, 2));
        Fmt.show(Fmt.fmt(123.456f, 0, 1));
        Fmt.show(Fmt.fmt(1.23456E17f, 0, 4));
        Fmt.show(Fmt.fmt(-123.456f, 0, 4));
        Fmt.show(Fmt.fmt(-1.23456E17f, 0, 4));
        Fmt.show(Fmt.fmt(123.0f));
        Fmt.show(Fmt.fmt(123.0));
        Fmt.show(Fmt.fmt(1.2345679f));
        Fmt.show(Fmt.fmt(1.2345678901234567));
        Fmt.show(Fmt.fmt(1.234568E18f));
        Fmt.show(Fmt.fmt(1.2345678901234568E18));
        Fmt.show(Fmt.fmt(1.2345679E-21f));
        Fmt.show(Fmt.fmt(1.2345678901234568E-21));
        Fmt.show(Fmt.fmt(12300.0f));
        Fmt.show(Fmt.fmt(12300.0));
        Fmt.show(Fmt.fmt(123000.0f));
        Fmt.show(Fmt.fmt(123000.0));
        Fmt.show(Fmt.fmt(1230000.0f));
        Fmt.show(Fmt.fmt(1230000.0));
        Fmt.show(Fmt.fmt(1.23E7f));
        Fmt.show(Fmt.fmt(1.23E7));
        Fmt.show(Fmt.fmt(Float.NaN));
        Fmt.show(Fmt.fmt(Float.POSITIVE_INFINITY));
        Fmt.show(Fmt.fmt(Float.NEGATIVE_INFINITY));
        Fmt.show(Fmt.fmt(Double.NaN));
        Fmt.show(Fmt.fmt(Double.POSITIVE_INFINITY));
        Fmt.show(Fmt.fmt(Double.NEGATIVE_INFINITY));
        Fmt.show(Fmt.fmt(0.125f));
        Fmt.show(Fmt.fmt(0.125));
        System.out.println("Done with tests.");
    }

    private static void show(String string) {
        System.out.println("#" + string + "#");
    }
}

