/*
 * Decompiled with CFR 0.152.
 */
package PVS.Utils;

import PVS.Utils.HashtableEntry;
import PVS.Utils.HashtableEnumerator;
import java.io.PrintStream;
import java.util.Dictionary;
import java.util.Enumeration;

public class FastHashtable
extends Dictionary
implements Cloneable {
    private HashtableEntry[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    public FastHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new HashtableEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public FastHashtable(int n) {
        this(n, 0.75f);
    }

    public FastHashtable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new HashtableEnumerator(this.table, true);
    }

    public Enumeration elements() {
        return new HashtableEnumerator(this.table, false);
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = hashtableEntryArray.length;
        while (n-- > 0) {
            HashtableEntry hashtableEntry = hashtableEntryArray[n];
            while (hashtableEntry != null) {
                if (hashtableEntry.value.equals(object)) {
                    return true;
                }
                hashtableEntry = hashtableEntry.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(object)) {
                return true;
            }
            hashtableEntry = hashtableEntry.next;
        }
        return false;
    }

    public Object get(Object object) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(object)) {
                return hashtableEntry.value;
            }
            hashtableEntry = hashtableEntry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        HashtableEntry[] hashtableEntryArray = this.table;
        int n2 = n * 2 + 1;
        HashtableEntry[] hashtableEntryArray2 = new HashtableEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = hashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            HashtableEntry hashtableEntry = hashtableEntryArray[n3];
            while (hashtableEntry != null) {
                HashtableEntry hashtableEntry2 = hashtableEntry;
                hashtableEntry = hashtableEntry.next;
                int n4 = (hashtableEntry2.hash & Integer.MAX_VALUE) % n2;
                hashtableEntry2.next = hashtableEntryArray2[n4];
                hashtableEntryArray2[n4] = hashtableEntry2;
            }
        }
    }

    public void printStatistic(PrintStream printStream) {
        int n;
        int n2 = this.table.length;
        printStream.print("hashtable capacity: " + this.table.length + " count: " + this.count);
        int n3 = 0;
        int n4 = n2;
        while (n4-- > 0) {
            n = 0;
            HashtableEntry hashtableEntry = this.table[n4];
            while (hashtableEntry != null) {
                hashtableEntry = hashtableEntry.next;
                ++n;
            }
            if (n <= n3) continue;
            n3 = n;
        }
        n = n3 / 2;
        int n5 = 0;
        int n6 = 0;
        int n7 = n2;
        while (n7-- > 0) {
            int n8 = 0;
            HashtableEntry hashtableEntry = this.table[n7];
            while (hashtableEntry != null) {
                hashtableEntry = hashtableEntry.next;
                ++n8;
            }
            if (n8 > n) {
                ++n5;
            }
            if (n8 <= 3) continue;
            ++n6;
        }
        printStream.println(" maxlength: " + n3 + " halfcount: " + n5 + " n3:" + n6);
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(object)) {
                Object object3 = hashtableEntry.value;
                hashtableEntry.value = object2;
                return object3;
            }
            hashtableEntry = hashtableEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(object, object2);
        }
        HashtableEntry hashtableEntry2 = new HashtableEntry();
        hashtableEntry2.hash = n;
        hashtableEntry2.key = object;
        hashtableEntry2.value = object2;
        hashtableEntry2.next = hashtableEntryArray[n2];
        hashtableEntryArray[n2] = hashtableEntry2;
        ++this.count;
        return null;
    }

    public Object remove(Object object) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        HashtableEntry hashtableEntry2 = null;
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(object)) {
                if (hashtableEntry2 != null) {
                    hashtableEntry2.next = hashtableEntry.next;
                } else {
                    hashtableEntryArray[n2] = hashtableEntry.next;
                }
                --this.count;
                return hashtableEntry.value;
            }
            hashtableEntry2 = hashtableEntry;
            hashtableEntry = hashtableEntry.next;
        }
        return null;
    }

    public void clear() {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = hashtableEntryArray.length;
        while (--n >= 0) {
            hashtableEntryArray[n] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            FastHashtable fastHashtable = (FastHashtable)super.clone();
            fastHashtable.table = new HashtableEntry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                HashtableEntry hashtableEntry = fastHashtable.table[n] = this.table[n] != null ? (HashtableEntry)this.table[n].clone() : null;
            }
            return fastHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        int n2 = 0;
        while (n2 <= n) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

