/*
 * Decompiled with CFR 0.152.
 */
package PVS.Expression;

import PVS.Expression.Expr;
import PVS.Expression.Parser;
import PVS.Expression.Variable;
import PVS.Utils.WindowOutputStream;
import PVS.Utils.WindowUtils;
import PVS.polyhedra.Vector3D;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class VectorCalculator {
    Frame frame;
    static final int MAXVECTORS = 2;
    TextField[] tfVectors = new TextField[2];
    TextArea textArea = new TextArea(24, 80);
    WindowOutputStream winStream;
    PrintStream out;
    TextField tfAngle = new TextField(17);
    Choice cDegree = new Choice();
    Parser parser;
    double angle;
    Vector3D[] vectors = new Vector3D[2];
    static final double EPS = 1.0E-14;
    private static GridBagConstraints gbc = new GridBagConstraints();

    public VectorCalculator() {
        this.makeUI();
    }

    public void show() {
        this.frame.show();
    }

    void makeUI() {
        this.frame = new Frame("Vector Calculator");
        ((Component)this.frame).setBackground(Color.lightGray);
        this.winStream = new WindowOutputStream(this.textArea);
        this.out = new PrintStream(this.winStream);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.frame.setLayout(gridBagLayout);
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        int n = 0;
        while (n < 2) {
            this.tfVectors[n] = new TextField(17);
            WindowUtils.constrain((Container)panel, (Component)new Label("v" + (n + 1)), 0, n, 1, 1, 0, 10, 0.0, 0.0);
            WindowUtils.constrain((Container)panel, (Component)this.tfVectors[n], 1, n, 2, 1, 2, 11, 1.0, 0.0);
            ++n;
        }
        this.cDegree.addItem("degree");
        this.cDegree.addItem("radians");
        WindowUtils.constrain((Container)panel, (Component)new Label("angle"), 0, 3, 1, 1, 2, 11, 0.0, 0.0);
        WindowUtils.constrain((Container)panel, (Component)this.tfAngle, 1, 3, 1, 1, 2, 11, 1.0, 0.0);
        WindowUtils.constrain((Container)panel, (Component)this.cDegree, 2, 3, 1, 1, 0, 17, 0.0, 0.0);
        Panel panel2 = new Panel();
        Button button = new Button("Dot(v1.v2)");
        button.addActionListener(new onDot());
        Button button2 = new Button("Cross(v1, v2)");
        button2.addActionListener(new onCross());
        Button button3 = new Button("Angle(v1, v2)");
        button3.addActionListener(new onAngle());
        Button button4 = new Button("Normalize(v)");
        button4.addActionListener(new onNormal());
        Button button5 = new Button("Rot(v1,v2,angle)");
        button5.addActionListener(new onRotate());
        Button button6 = new Button("Length(v)");
        button6.addActionListener(new onLength());
        Button button7 = new Button("Clear");
        button7.addActionListener(new onClear());
        panel2.setLayout(gridBagLayout);
        int n2 = 0;
        WindowUtils.constrain(panel2, button, n2++, 0, 1, 1, 2, 11, 1.0, 0.0, 3, 3, 3, 3);
        WindowUtils.constrain(panel2, button2, n2++, 0, 1, 1, 2, 11, 1.0, 0.0, 3, 3, 3, 3);
        WindowUtils.constrain(panel2, button3, n2++, 0, 1, 1, 2, 11, 1.0, 0.0, 3, 3, 3, 3);
        WindowUtils.constrain(panel2, button4, n2++, 0, 1, 1, 2, 11, 1.0, 0.0, 3, 3, 3, 3);
        WindowUtils.constrain(panel2, button5, n2++, 0, 1, 1, 2, 11, 1.0, 0.0, 3, 3, 3, 3);
        WindowUtils.constrain(panel2, button6, n2++, 0, 1, 1, 2, 11, 1.0, 0.0, 3, 3, 3, 3);
        WindowUtils.constrain(panel2, button7, n2++, 0, 1, 1, 2, 11, 1.0, 0.0, 3, 3, 3, 3);
        WindowUtils.constrain((Container)this.frame, (Component)panel, 0, 0, 1, 1, 2, 11, 1.0, 0.0);
        WindowUtils.constrain(this.frame, this.textArea, 0, 1, 1, 1, 1, 11, 1.0, 1.0, 3, 6, 3, 0);
        WindowUtils.constrain(this.frame, panel2, 0, 2, 1, 1, 0, 10, 0.0, 0.0, 3, 3, 3, 3);
        this.frame.addWindowListener(new CloseWindowListener());
        this.frame.pack();
        this.frame.validate();
        this.textArea.setEditable(true);
    }

    public double calculate(String string) {
        double d = 0.0;
        try {
            Expr expr = this.parser.parse(string);
            Variable variable = expr.getVariable("g");
            variable.setValue((Math.sqrt(5.0) + 1.0) / 2.0);
            Variable variable2 = expr.getVariable("pi");
            variable2.setValue(Math.PI);
            d = expr.value();
        }
        catch (Exception exception) {
            System.out.println("Exception during calculating " + string);
        }
        return d;
    }

    void getData() {
        Object object;
        this.parser = new Parser();
        int n = 0;
        while (n < 2) {
            String string = this.tfVectors[n].getText();
            object = new StringTokenizer(string, ",");
            int n2 = 0;
            String[] stringArray = new String[3];
            while (((StringTokenizer)object).hasMoreTokens()) {
                stringArray[n2++] = ((StringTokenizer)object).nextToken();
            }
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            if (stringArray[0] != null) {
                d = this.calculate(stringArray[0]);
            }
            if (stringArray[1] != null) {
                d2 = this.calculate(stringArray[1]);
            }
            if (stringArray[2] != null) {
                d3 = this.calculate(stringArray[2]);
            }
            this.vectors[n] = new Vector3D(d, d2, d3);
            this.out.println("v" + (n + 1) + ": " + this.vectors[n].x + ", " + this.vectors[n].y + ", " + this.vectors[n].z);
            ++n;
        }
        boolean bl = this.cDegree.getSelectedIndex() == 0;
        this.angle = 0.0;
        object = this.tfAngle.getText();
        if (((String)object).length() > 0) {
            double d = this.calculate((String)object);
            this.angle = bl ? d * (Math.PI / 180) : d;
        }
        this.out.println("angle:" + this.angle);
    }

    static double round(double d) {
        int n = (int)(d + 0.5);
        if (d < 0.0) {
            --n;
        }
        if (Math.abs((double)n - d) < 1.0E-14) {
            return n;
        }
        return VectorCalculator.chop(d);
    }

    static double chop(double d) {
        if (d < -1.0E-14 || d > 1.0E-14) {
            return d;
        }
        return 0.0;
    }

    static void main(String[] stringArray) {
        new VectorCalculator().show();
    }

    class CloseWindowListener
    extends WindowAdapter {
        CloseWindowListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ((Component)VectorCalculator.this.frame).setVisible(false);
            VectorCalculator.this.frame.dispose();
        }
    }

    class onLength
    implements ActionListener {
        onLength() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VectorCalculator.this.getData();
            VectorCalculator.this.out.println("Length(v1)" + VectorCalculator.round(VectorCalculator.this.vectors[0].length()));
            VectorCalculator.this.out.println("Length(v2)" + VectorCalculator.round(VectorCalculator.this.vectors[1].length()));
        }
    }

    class onClear
    implements ActionListener {
        onClear() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VectorCalculator.this.textArea.setText("");
        }
    }

    class onRotate
    implements ActionListener {
        onRotate() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VectorCalculator.this.getData();
            Vector3D vector3D = VectorCalculator.this.vectors[0].rotate(VectorCalculator.this.vectors[1].normalize(), VectorCalculator.this.angle);
            VectorCalculator.this.out.println("Rotate(v1,v2,angle) = " + VectorCalculator.round(vector3D.x) + ", " + VectorCalculator.round(vector3D.y) + ", " + VectorCalculator.round(vector3D.z));
        }
    }

    class onNormal
    implements ActionListener {
        onNormal() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VectorCalculator.this.getData();
            Vector3D vector3D = VectorCalculator.this.vectors[0].normalize();
            VectorCalculator.this.out.println("Normalize(v1) = " + VectorCalculator.round(vector3D.x) + ", " + VectorCalculator.round(vector3D.y) + ", " + VectorCalculator.round(vector3D.z));
            vector3D = VectorCalculator.this.vectors[1].normalize();
            VectorCalculator.this.out.println("Normalize(v2) = " + VectorCalculator.round(vector3D.x) + ", " + VectorCalculator.round(vector3D.y) + ", " + VectorCalculator.round(vector3D.z));
        }
    }

    class onAngle
    implements ActionListener {
        onAngle() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VectorCalculator.this.getData();
            VectorCalculator.this.vectors[0].normalize();
            VectorCalculator.this.vectors[1].normalize();
            double d = VectorCalculator.this.vectors[0].dot(VectorCalculator.this.vectors[1]);
            double d2 = VectorCalculator.this.vectors[0].cross(VectorCalculator.this.vectors[1]).length();
            double d3 = Math.atan2(d2, d);
            double d4 = (double)((int)(d3 * 1800.0 / Math.PI + 0.5)) / 10.0;
            VectorCalculator.this.out.println("Angle(v1, v2) = " + VectorCalculator.round(d3) + " ( " + d4 + " degree)");
        }
    }

    class onCross
    implements ActionListener {
        onCross() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VectorCalculator.this.getData();
            Vector3D vector3D = VectorCalculator.this.vectors[0].cross(VectorCalculator.this.vectors[1]);
            VectorCalculator.this.out.println("Cross(v1,v2) = " + VectorCalculator.round(vector3D.x) + ", " + VectorCalculator.round(vector3D.y) + ", " + VectorCalculator.round(vector3D.z));
        }
    }

    class onDot
    implements ActionListener {
        onDot() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VectorCalculator.this.getData();
            double d = VectorCalculator.this.vectors[0].dot(VectorCalculator.this.vectors[1]);
            VectorCalculator.this.out.println("Dot(v1,v2) = " + VectorCalculator.round(d));
        }
    }
}

