/*
 * Decompiled with CFR 0.152.
 */
package PVS.Expression;

import PVS.Expression.Expr;
import PVS.Expression.ExprIf;
import PVS.Expression.ExprIfElse;
import PVS.Expression.ExprWhile;
import PVS.Expression.MultilineExpr;
import PVS.Expression.Syntax_error;
import PVS.Expression.UserFunctionData;
import PVS.Expression.Variable;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringBufferInputStream;
import java.util.Hashtable;

public class Parser {
    StreamTokenizer tokens;
    Hashtable variables;
    Hashtable userFunctionTable = new Hashtable();
    String input;
    static final boolean DEBUG = false;
    static String[] procs = new String[]{"abs", "acos", "asin", "atan", "ceil", "cos", "exp", "floor", "log", "round", "sin", "sqrt", "tan"};
    static int[] rators = new int[]{100, 101, 102, 103, 104, 105, 106, 107, 108, 110, 111, 112, 113};
    static String[] procs2 = new String[]{"atan2"};
    static int[] rators2 = new int[]{6};

    public Expr parse(String string) throws Syntax_error {
        this.input = string;
        this.tokens = new StreamTokenizer(new StringBufferInputStream(string));
        this.tokens.ordinaryChar(47);
        this.tokens.ordinaryChar(45);
        this.variables = new Hashtable();
        this.next();
        Expr expr = this.parseMultilineExpr();
        expr.setVariables(this.variables);
        return expr;
    }

    private Variable getVariable(String string) {
        Variable variable = (Variable)this.variables.get(string);
        if (variable == null) {
            variable = new Variable(string);
            this.variables.put(string, variable);
        }
        return variable;
    }

    public void registerFunction(UserFunctionData userFunctionData) {
        this.userFunctionTable.put(userFunctionData.uf.getName(userFunctionData.data), userFunctionData);
    }

    private Expr parseMultilineExpr() throws Syntax_error {
        Expr expr;
        block4: {
            expr = this.parse_expr(0);
            if (this.tokens.ttype == 59) {
                MultilineExpr multilineExpr = new MultilineExpr(expr);
                do {
                    this.next();
                    if (this.tokens.ttype == -1 || this.tokens.ttype == 125 || this.tokens.ttype == 41) {
                        expr = multilineExpr;
                        break block4;
                    }
                    multilineExpr.addExpr(this.parse_expr(0));
                } while (this.tokens.ttype == 59);
                throw new Syntax_error("Sintax error: " + this.input);
            }
            if (this.tokens.ttype != -1) {
                throw new Syntax_error("Sintax error: " + this.input);
            }
        }
        return expr;
    }

    private void next() {
        try {
            this.tokens.nextToken();
        }
        catch (IOException iOException) {
            throw new RuntimeException("I/O error: " + iOException);
        }
    }

    private void expect(int n) throws Syntax_error {
        if (this.tokens.ttype != n) {
            throw new Syntax_error("'" + (char)n + "' expected");
        }
        this.next();
    }

    private Expr parse_expr(int n) throws Syntax_error {
        Expr expr = this.parse_factor();
        block8: while (true) {
            int n2;
            int n3;
            int n4;
            switch (this.tokens.ttype) {
                case 61: {
                    n4 = 5;
                    n3 = 5;
                    n2 = 0;
                    break;
                }
                case 43: {
                    n4 = 10;
                    n3 = 11;
                    n2 = 1;
                    break;
                }
                case 45: {
                    n4 = 10;
                    n3 = 11;
                    n2 = 2;
                    break;
                }
                case 42: {
                    n4 = 20;
                    n3 = 21;
                    n2 = 3;
                    break;
                }
                case 47: {
                    n4 = 20;
                    n3 = 21;
                    n2 = 4;
                    break;
                }
                case 94: {
                    n4 = 30;
                    n3 = 30;
                    n2 = 5;
                    break;
                }
                default: {
                    break block8;
                }
            }
            if (n4 < n) break;
            this.next();
            expr = Expr.make_app2(n2, expr, this.parse_expr(n3));
        }
        return expr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double parseNumber() throws Syntax_error {
        double d = this.tokens.nval;
        this.next();
        if (this.tokens.ttype == -3 && (this.tokens.sval.startsWith("e") || this.tokens.sval.equals("E") || this.tokens.sval.equals("d") || this.tokens.sval.equals("D"))) {
            double d2 = 0.0;
            if (this.tokens.sval.length() == 1) {
                this.next();
                if (this.tokens.ttype == -2) {
                    d2 = this.tokens.nval;
                } else if (this.tokens.ttype == 43) {
                    this.next();
                    if (this.tokens.ttype != -2) throw new Syntax_error("bad number");
                    d2 = this.tokens.nval;
                } else if (this.tokens.ttype == 45) {
                    this.next();
                    if (this.tokens.ttype != -2) throw new Syntax_error("bad number");
                    d2 = -this.tokens.nval;
                }
            } else {
                d2 = Double.valueOf(this.tokens.sval.substring(1));
            }
            d *= Math.pow(10.0, d2);
            return d;
        } else {
            this.tokens.pushBack();
        }
        return d;
    }

    private Expr parse_factor() throws Syntax_error {
        switch (this.tokens.ttype) {
            case -2: {
                Expr expr = Expr.make_literal(this.parseNumber());
                this.next();
                return expr;
            }
            case -3: {
                if (this.tokens.sval.equals("if")) {
                    this.next();
                    this.expect(40);
                    Expr expr = this.parse_expr(0);
                    this.expect(41);
                    this.expect(123);
                    Expr expr2 = this.parseMultilineExpr();
                    this.expect(125);
                    if (this.tokens.ttype == -3 && this.tokens.sval.equals("else")) {
                        this.next();
                        this.expect(123);
                        Expr expr3 = this.parseMultilineExpr();
                        this.expect(125);
                        return new ExprIfElse(expr, expr2, expr3);
                    }
                    return new ExprIf(expr, expr2);
                }
                if (this.tokens.sval.equals("while")) {
                    this.next();
                    this.expect(40);
                    Expr expr = this.parse_expr(0);
                    this.expect(41);
                    this.expect(123);
                    Expr expr4 = this.parseMultilineExpr();
                    this.expect(125);
                    return new ExprWhile(expr, expr4);
                }
                int n = 0;
                while (n < procs.length) {
                    if (procs[n].equals(this.tokens.sval)) {
                        this.next();
                        this.expect(40);
                        Expr expr = this.parse_expr(0);
                        this.expect(41);
                        return Expr.make_app1(rators[n], expr);
                    }
                    ++n;
                }
                int n2 = 0;
                while (n2 < procs2.length) {
                    if (procs2[n2].equals(this.tokens.sval)) {
                        this.next();
                        this.expect(40);
                        Expr expr = this.parse_expr(0);
                        System.out.println(expr);
                        this.expect(44);
                        Expr expr5 = this.parse_expr(0);
                        System.out.println(expr5);
                        this.expect(41);
                        return Expr.make_app2(rators2[n2], expr, expr5);
                    }
                    ++n2;
                }
                UserFunctionData userFunctionData = (UserFunctionData)this.userFunctionTable.get(this.tokens.sval);
                if (userFunctionData != null) {
                    int n3 = userFunctionData.uf.getNumVariables(userFunctionData.data);
                    this.next();
                    Expr[] exprArray = new Expr[n3];
                    this.expect(40);
                    int n4 = 0;
                    while (n4 < n3) {
                        exprArray[n4] = this.parse_expr(0);
                        if (n4 < n3 - 1) {
                            this.expect(44);
                        } else {
                            this.expect(41);
                        }
                        ++n4;
                    }
                    return Expr.make_appUf(userFunctionData, exprArray);
                }
                Expr expr = Expr.make_var_ref(this.getVariable(this.tokens.sval));
                this.next();
                return expr;
            }
            case 40: {
                this.next();
                Expr expr = this.parse_expr(0);
                this.expect(41);
                return expr;
            }
            case 45: {
                this.next();
                return Expr.make_app1(109, this.parse_factor());
            }
        }
        throw new Syntax_error("Expected a factor, but got: " + (char)this.tokens.ttype);
    }
}

