/*
 * Decompiled with CFR 0.152.
 */
package PVS.Expression;

import PVS.Expression.App1;
import PVS.Expression.App2;
import PVS.Expression.AppUf;
import PVS.Expression.Literal;
import PVS.Expression.UserFunctionData;
import PVS.Expression.Var_ref;
import PVS.Expression.Variable;
import java.util.Hashtable;

public abstract class Expr {
    public static final int ASSIGN = 0;
    public static final int ADD = 1;
    public static final int SUB = 2;
    public static final int MUL = 3;
    public static final int DIV = 4;
    public static final int POW = 5;
    public static final int ATAN2 = 6;
    public static final int ABS = 100;
    public static final int ACOS = 101;
    public static final int ASIN = 102;
    public static final int ATAN = 103;
    public static final int CEIL = 104;
    public static final int COS = 105;
    public static final int EXP = 106;
    public static final int FLOOR = 107;
    public static final int LOG = 108;
    public static final int NEG = 109;
    public static final int ROUND = 110;
    public static final int SIN = 111;
    public static final int SQRT = 112;
    public static final int TAN = 113;
    Hashtable variables;

    public abstract double value();

    public static Expr make_literal(double d) {
        return new Literal(d);
    }

    public static Expr make_var_ref(Variable variable) {
        return new Var_ref(variable);
    }

    public static Expr make_app1(int n, Expr expr) {
        App1 app1 = new App1(n, expr);
        return expr instanceof Literal ? new Literal(((Expr)app1).value()) : app1;
    }

    public static Expr make_app2(int n, Expr expr, Expr expr2) {
        App2 app2 = new App2(n, expr, expr2);
        return expr instanceof Literal && expr2 instanceof Literal ? new Literal(((Expr)app2).value()) : app2;
    }

    public static Expr make_appUf(UserFunctionData userFunctionData, Expr[] exprArray) {
        AppUf appUf = new AppUf(userFunctionData, exprArray);
        return appUf;
    }

    void setVariables(Hashtable hashtable) {
        this.variables = hashtable;
    }

    public Variable getVariable(String string) {
        Variable variable = (Variable)this.variables.get(string);
        if (variable == null) {
            variable = new Variable(string);
            this.variables.put(string, variable);
        }
        return variable;
    }
}

